#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-analytics-statistic-slice-event.json
#
# Do not edit this file manually!
#

from delphixpy.v1_4_2.web.objects.TypedObject import TypedObject
from delphixpy.v1_4_2 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class StatisticSliceEvent(TypedObject):
    """
    *(extends* :py:class:`v1_4_2.web.vo.TypedObject` *)* A set of events
    affecting a particular analytics slice's collection.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("StatisticSliceEvent", True)
        self._event_type = (self.__undef__, True)
        self._timestamp = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._event_type = (data.get("eventType", obj.__undef__), dirty)
        if obj._event_type[0] is not None and obj._event_type[0] is not obj.__undef__:
            assert isinstance(obj._event_type[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._event_type[0], type(obj._event_type[0])))
            assert obj._event_type[0] in ['RUNNING', 'PAUSED'], "Expected enum ['RUNNING', 'PAUSED'] but got %s" % obj._event_type[0]
            common.validate_format(obj._event_type[0], "None", None, None)
        obj._timestamp = (data.get("timestamp", obj.__undef__), dirty)
        if obj._timestamp[0] is not None and obj._timestamp[0] is not obj.__undef__:
            assert isinstance(obj._timestamp[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._timestamp[0], type(obj._timestamp[0])))
            common.validate_format(obj._timestamp[0], "date", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "event_type" == "type" or (self.event_type is not self.__undef__ and (not (dirty and not self._event_type[1]))):
            dct["eventType"] = dictify(self.event_type)
        if "timestamp" == "type" or (self.timestamp is not self.__undef__ and (not (dirty and not self._timestamp[1]))):
            dct["timestamp"] = dictify(self.timestamp)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._event_type = (self._event_type[0], True)
        self._timestamp = (self._timestamp[0], True)

    def is_dirty(self):
        return any([self._event_type[1], self._timestamp[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, StatisticSliceEvent):
            return False
        return super().__eq__(other) and \
               self.event_type == other.event_type and \
               self.timestamp == other.timestamp

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def event_type(self):
        """
        The type of event that occurred. Reflects the state of the slice after
        the event. *(permitted values: RUNNING, PAUSED)*

        :rtype: ``str``
        """
        return self._event_type[0]

    @event_type.setter
    def event_type(self, value):
        self._event_type = (value, True)

    @property
    def timestamp(self):
        """
        The time the event occurred.

        :rtype: ``str``
        """
        return self._timestamp[0]

    @timestamp.setter
    def timestamp(self, value):
        self._timestamp = (value, True)

