#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-toolkit-virtual-source.json
#
# Do not edit this file manually!
#

from delphixpy.v1_5_0.web.objects.TypedObject import TypedObject
from delphixpy.v1_5_0 import factory
from delphixpy.v1_5_0 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class ToolkitVirtualSource(TypedObject):
    """
    *(extends* :py:class:`v1_5_0.web.vo.TypedObject` *)* A virtual source
    definition for toolkits.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("ToolkitVirtualSource", True)
        self._initialize = (self.__undef__, True)
        self._parameters = (self.__undef__, True)
        self._post_snapshot = (self.__undef__, True)
        self._pre_snapshot = (self.__undef__, True)
        self._provision = (self.__undef__, True)
        self._start = (self.__undef__, True)
        self._status_script = (self.__undef__, True)
        self._stop = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._initialize = (data.get("initialize", obj.__undef__), dirty)
        if obj._initialize[0] is not None and obj._initialize[0] is not obj.__undef__:
            assert isinstance(obj._initialize[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._initialize[0], type(obj._initialize[0])))
            common.validate_format(obj._initialize[0], "None", None, None)
        if "parameters" not in data:
            raise ValueError("Missing required property \"parameters\".")
        obj._parameters = []
        for item in data.get("parameters") or []:
            obj._parameters.append(factory.create_object(item))
            factory.validate_type(obj._parameters[-1], "ToolkitParameter")
        obj._parameters = (obj._parameters, dirty)
        if "postSnapshot" not in data:
            raise ValueError("Missing required property \"postSnapshot\".")
        obj._post_snapshot = (data.get("postSnapshot", obj.__undef__), dirty)
        if obj._post_snapshot[0] is not None and obj._post_snapshot[0] is not obj.__undef__:
            assert isinstance(obj._post_snapshot[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._post_snapshot[0], type(obj._post_snapshot[0])))
            common.validate_format(obj._post_snapshot[0], "None", None, None)
        if "preSnapshot" not in data:
            raise ValueError("Missing required property \"preSnapshot\".")
        obj._pre_snapshot = (data.get("preSnapshot", obj.__undef__), dirty)
        if obj._pre_snapshot[0] is not None and obj._pre_snapshot[0] is not obj.__undef__:
            assert isinstance(obj._pre_snapshot[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._pre_snapshot[0], type(obj._pre_snapshot[0])))
            common.validate_format(obj._pre_snapshot[0], "None", None, None)
        if "provision" not in data:
            raise ValueError("Missing required property \"provision\".")
        obj._provision = (data.get("provision", obj.__undef__), dirty)
        if obj._provision[0] is not None and obj._provision[0] is not obj.__undef__:
            assert isinstance(obj._provision[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._provision[0], type(obj._provision[0])))
            common.validate_format(obj._provision[0], "None", None, None)
        if "start" not in data:
            raise ValueError("Missing required property \"start\".")
        obj._start = (data.get("start", obj.__undef__), dirty)
        if obj._start[0] is not None and obj._start[0] is not obj.__undef__:
            assert isinstance(obj._start[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._start[0], type(obj._start[0])))
            common.validate_format(obj._start[0], "None", None, None)
        obj._status_script = (data.get("statusScript", obj.__undef__), dirty)
        if obj._status_script[0] is not None and obj._status_script[0] is not obj.__undef__:
            assert isinstance(obj._status_script[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._status_script[0], type(obj._status_script[0])))
            common.validate_format(obj._status_script[0], "None", None, None)
        if "stop" not in data:
            raise ValueError("Missing required property \"stop\".")
        obj._stop = (data.get("stop", obj.__undef__), dirty)
        if obj._stop[0] is not None and obj._stop[0] is not obj.__undef__:
            assert isinstance(obj._stop[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._stop[0], type(obj._stop[0])))
            common.validate_format(obj._stop[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "initialize" == "type" or (self.initialize is not self.__undef__ and (not (dirty and not self._initialize[1]))):
            dct["initialize"] = dictify(self.initialize)
        if "parameters" == "type" or (self.parameters is not self.__undef__ and (not (dirty and not self._parameters[1]) or self.is_dirty_list(self.parameters, self._parameters) or belongs_to_parent)):
            dct["parameters"] = dictify(self.parameters, prop_is_list_or_vo=True)
        if "post_snapshot" == "type" or (self.post_snapshot is not self.__undef__ and (not (dirty and not self._post_snapshot[1]) or self.is_dirty_list(self.post_snapshot, self._post_snapshot) or belongs_to_parent)):
            dct["postSnapshot"] = dictify(self.post_snapshot)
        if "pre_snapshot" == "type" or (self.pre_snapshot is not self.__undef__ and (not (dirty and not self._pre_snapshot[1]) or self.is_dirty_list(self.pre_snapshot, self._pre_snapshot) or belongs_to_parent)):
            dct["preSnapshot"] = dictify(self.pre_snapshot)
        if "provision" == "type" or (self.provision is not self.__undef__ and (not (dirty and not self._provision[1]) or self.is_dirty_list(self.provision, self._provision) or belongs_to_parent)):
            dct["provision"] = dictify(self.provision)
        if "start" == "type" or (self.start is not self.__undef__ and (not (dirty and not self._start[1]) or self.is_dirty_list(self.start, self._start) or belongs_to_parent)):
            dct["start"] = dictify(self.start)
        if "status_script" == "type" or (self.status_script is not self.__undef__ and (not (dirty and not self._status_script[1]))):
            dct["statusScript"] = dictify(self.status_script)
        if "stop" == "type" or (self.stop is not self.__undef__ and (not (dirty and not self._stop[1]) or self.is_dirty_list(self.stop, self._stop) or belongs_to_parent)):
            dct["stop"] = dictify(self.stop)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._initialize = (self._initialize[0], True)
        self._parameters = (self._parameters[0], True)
        self._post_snapshot = (self._post_snapshot[0], True)
        self._pre_snapshot = (self._pre_snapshot[0], True)
        self._provision = (self._provision[0], True)
        self._start = (self._start[0], True)
        self._status_script = (self._status_script[0], True)
        self._stop = (self._stop[0], True)

    def is_dirty(self):
        return any([self._initialize[1], self._parameters[1], self._post_snapshot[1], self._pre_snapshot[1], self._provision[1], self._start[1], self._status_script[1], self._stop[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, ToolkitVirtualSource):
            return False
        return super().__eq__(other) and \
               self.initialize == other.initialize and \
               self.parameters == other.parameters and \
               self.post_snapshot == other.post_snapshot and \
               self.pre_snapshot == other.pre_snapshot and \
               self.provision == other.provision and \
               self.start == other.start and \
               self.status_script == other.status_script and \
               self.stop == other.stop

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def initialize(self):
        """
        A workflow script to run when creating an empty application.

        :rtype: ``str``
        """
        return self._initialize[0]

    @initialize.setter
    def initialize(self, value):
        self._initialize = (value, True)

    @property
    def parameters(self):
        """
        Dynamic parameters the user must enter as input when provisioning a
        virtual copy of this type.

        :rtype: ``list`` of :py:class:`v1_5_0.web.vo.ToolkitParameter`
        """
        return self._parameters[0]

    @parameters.setter
    def parameters(self, value):
        self._parameters = (value, True)

    @property
    def post_snapshot(self):
        """
        A workflow script to run after taking a snapshot of a virtual copy of
        the application.

        :rtype: ``str``
        """
        return self._post_snapshot[0]

    @post_snapshot.setter
    def post_snapshot(self, value):
        self._post_snapshot = (value, True)

    @property
    def pre_snapshot(self):
        """
        A workflow script to run before taking a snapshot of a virtual copy of
        the application.

        :rtype: ``str``
        """
        return self._pre_snapshot[0]

    @pre_snapshot.setter
    def pre_snapshot(self, value):
        self._pre_snapshot = (value, True)

    @property
    def provision(self):
        """
        A workflow script run when provisioning a virtual copy of the
        application.

        :rtype: ``str``
        """
        return self._provision[0]

    @provision.setter
    def provision(self, value):
        self._provision = (value, True)

    @property
    def start(self):
        """
        A workflow script to run when starting a virtual copy of the
        application.

        :rtype: ``str``
        """
        return self._start[0]

    @start.setter
    def start(self, value):
        self._start = (value, True)

    @property
    def status_script(self):
        """
        The script to run to determine if a virtual copy of the application is
        running. The script should exit with exit code of 0 if the application
        is running, 128 if the application is not running, and any other exit
        code if the script encounters an unexpected error. The script is passed
        the provision parameters as input.

        :rtype: ``str``
        """
        return self._status_script[0]

    @status_script.setter
    def status_script(self, value):
        self._status_script = (value, True)

    @property
    def stop(self):
        """
        A workflow script to run when stopping a virtual copy of the
        application.

        :rtype: ``str``
        """
        return self._stop[0]

    @stop.setter
    def stop(self, value):
        self._stop = (value, True)

