#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-pgsql-link-parameters.json
#
# Do not edit this file manually!
#

from delphixpy.v1_5_1.web.objects.LinkParameters import LinkParameters
from delphixpy.v1_5_1 import factory
from delphixpy.v1_5_1 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class PgSQLLinkParameters(LinkParameters):
    """
    *(extends* :py:class:`v1_5_1.web.vo.LinkParameters` *)* PostgreSQL specific
    parameters for a link request.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("PgSQLLinkParameters", True)
        self._connection_database = (self.__undef__, True)
        self._container = (self.__undef__, True)
        self._db_credentials = (self.__undef__, True)
        self._db_user = (self.__undef__, True)
        self._ppt_host_user = (self.__undef__, True)
        self._ppt_repository = (self.__undef__, True)
        self._source = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._connection_database = (data.get("connectionDatabase", obj.__undef__), dirty)
        if obj._connection_database[0] is not None and obj._connection_database[0] is not obj.__undef__:
            assert isinstance(obj._connection_database[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._connection_database[0], type(obj._connection_database[0])))
            common.validate_format(obj._connection_database[0], "None", None, 256)
        if "container" not in data:
            raise ValueError("Missing required property \"container\".")
        if "container" in data and data["container"] is not None:
            obj._container = (factory.create_object(data["container"], "PgSQLDatabaseContainer"), dirty)
            factory.validate_type(obj._container[0], "PgSQLDatabaseContainer")
        else:
            obj._container = (obj.__undef__, dirty)
        if "dbCredentials" in data and data["dbCredentials"] is not None:
            obj._db_credentials = (factory.create_object(data["dbCredentials"], "PasswordCredential"), dirty)
            factory.validate_type(obj._db_credentials[0], "PasswordCredential")
        else:
            obj._db_credentials = (obj.__undef__, dirty)
        if "dbUser" not in data:
            raise ValueError("Missing required property \"dbUser\".")
        obj._db_user = (data.get("dbUser", obj.__undef__), dirty)
        if obj._db_user[0] is not None and obj._db_user[0] is not obj.__undef__:
            assert isinstance(obj._db_user[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._db_user[0], type(obj._db_user[0])))
            common.validate_format(obj._db_user[0], "None", None, None)
        obj._ppt_host_user = (data.get("pptHostUser", obj.__undef__), dirty)
        if obj._ppt_host_user[0] is not None and obj._ppt_host_user[0] is not obj.__undef__:
            assert isinstance(obj._ppt_host_user[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._ppt_host_user[0], type(obj._ppt_host_user[0])))
            common.validate_format(obj._ppt_host_user[0], "objectReference", None, None)
        if "pptRepository" not in data:
            raise ValueError("Missing required property \"pptRepository\".")
        obj._ppt_repository = (data.get("pptRepository", obj.__undef__), dirty)
        if obj._ppt_repository[0] is not None and obj._ppt_repository[0] is not obj.__undef__:
            assert isinstance(obj._ppt_repository[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._ppt_repository[0], type(obj._ppt_repository[0])))
            common.validate_format(obj._ppt_repository[0], "objectReference", None, None)
        if "source" not in data:
            raise ValueError("Missing required property \"source\".")
        if "source" in data and data["source"] is not None:
            obj._source = (factory.create_object(data["source"], "PgSQLLinkedSource"), dirty)
            factory.validate_type(obj._source[0], "PgSQLLinkedSource")
        else:
            obj._source = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "connection_database" == "type" or (self.connection_database is not self.__undef__ and (not (dirty and not self._connection_database[1]) or self.is_dirty_list(self.connection_database, self._connection_database) or belongs_to_parent)):
            dct["connectionDatabase"] = dictify(self.connection_database)
        elif belongs_to_parent and self.connection_database is self.__undef__:
            dct["connectionDatabase"] = "postgres"
        if "container" == "type" or (self.container is not self.__undef__ and (not (dirty and not self._container[1]) or self.is_dirty_list(self.container, self._container) or belongs_to_parent)):
            dct["container"] = dictify(self.container, prop_is_list_or_vo=True)
        if "db_credentials" == "type" or (self.db_credentials is not self.__undef__ and (not (dirty and not self._db_credentials[1]) or self.is_dirty_list(self.db_credentials, self._db_credentials) or belongs_to_parent)):
            dct["dbCredentials"] = dictify(self.db_credentials, prop_is_list_or_vo=True)
        if "db_user" == "type" or (self.db_user is not self.__undef__ and (not (dirty and not self._db_user[1]) or self.is_dirty_list(self.db_user, self._db_user) or belongs_to_parent)):
            dct["dbUser"] = dictify(self.db_user)
        if "ppt_host_user" == "type" or (self.ppt_host_user is not self.__undef__ and (not (dirty and not self._ppt_host_user[1]) or self.is_dirty_list(self.ppt_host_user, self._ppt_host_user) or belongs_to_parent)):
            dct["pptHostUser"] = dictify(self.ppt_host_user)
        if "ppt_repository" == "type" or (self.ppt_repository is not self.__undef__ and (not (dirty and not self._ppt_repository[1]) or self.is_dirty_list(self.ppt_repository, self._ppt_repository) or belongs_to_parent)):
            dct["pptRepository"] = dictify(self.ppt_repository)
        if "source" == "type" or (self.source is not self.__undef__ and (not (dirty and not self._source[1]) or self.is_dirty_list(self.source, self._source) or belongs_to_parent)):
            dct["source"] = dictify(self.source, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._connection_database = (self._connection_database[0], True)
        self._container = (self._container[0], True)
        self._db_credentials = (self._db_credentials[0], True)
        self._db_user = (self._db_user[0], True)
        self._ppt_host_user = (self._ppt_host_user[0], True)
        self._ppt_repository = (self._ppt_repository[0], True)
        self._source = (self._source[0], True)

    def is_dirty(self):
        return any([self._connection_database[1], self._container[1], self._db_credentials[1], self._db_user[1], self._ppt_host_user[1], self._ppt_repository[1], self._source[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, PgSQLLinkParameters):
            return False
        return super().__eq__(other) and \
               self.connection_database == other.connection_database and \
               self.container == other.container and \
               self.db_credentials == other.db_credentials and \
               self.db_user == other.db_user and \
               self.ppt_host_user == other.ppt_host_user and \
               self.ppt_repository == other.ppt_repository and \
               self.source == other.source

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def connection_database(self):
        """
        *(default value: postgres)* The database that must be used to run SQL
        queries against this cluster.

        :rtype: ``str``
        """
        return self._connection_database[0]

    @connection_database.setter
    def connection_database(self, value):
        self._connection_database = (value, True)

    @property
    def container(self):
        """
        Container to create as part of the linking process.

        :rtype: :py:class:`v1_5_1.web.vo.PgSQLDatabaseContainer`
        """
        return self._container[0]

    @container.setter
    def container(self, value):
        self._container = (value, True)

    @property
    def db_credentials(self):
        """
        The credential of the database cluster user.

        :rtype: :py:class:`v1_5_1.web.vo.PasswordCredential`
        """
        return self._db_credentials[0]

    @db_credentials.setter
    def db_credentials(self, value):
        self._db_credentials = (value, True)

    @property
    def db_user(self):
        """
        The username of the database cluster user.

        :rtype: ``str``
        """
        return self._db_user[0]

    @db_user.setter
    def db_user(self, value):
        self._db_user = (value, True)

    @property
    def ppt_host_user(self):
        """
        Information about the host OS user on the PPT host to use for linking.

        :rtype: ``str``
        """
        return self._ppt_host_user[0]

    @ppt_host_user.setter
    def ppt_host_user(self, value):
        self._ppt_host_user = (value, True)

    @property
    def ppt_repository(self):
        """
        The Postgres installation on the PPT environment that will be used for
        pre-provisioning.

        :rtype: ``str``
        """
        return self._ppt_repository[0]

    @ppt_repository.setter
    def ppt_repository(self, value):
        self._ppt_repository = (value, True)

    @property
    def source(self):
        """
        Source to link the container to. This must reference an existing linked
        source config.

        :rtype: :py:class:`v1_5_1.web.vo.PgSQLLinkedSource`
        """
        return self._source[0]

    @source.setter
    def source(self, value):
        self._source = (value, True)

