#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-replicationspec.json
#
# Do not edit this file manually!
#

from delphixpy.v1_5_1.web.objects.UserObject import UserObject
from delphixpy.v1_5_1 import factory
from delphixpy.v1_5_1 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class ReplicationSpec(UserObject):
    """
    *(extends* :py:class:`v1_5_1.web.vo.UserObject` *)* Replication setup.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("ReplicationSpec", True)
        self._bandwidth_limit = (self.__undef__, True)
        self._compressed = (self.__undef__, True)
        self._description = (self.__undef__, True)
        self._enabled = (self.__undef__, True)
        self._encrypted = (self.__undef__, True)
        self._number_of_connections = (self.__undef__, True)
        self._objects = (self.__undef__, True)
        self._runtime = (self.__undef__, True)
        self._schedule = (self.__undef__, True)
        self._tag = (self.__undef__, True)
        self._target_credential = (self.__undef__, True)
        self._target_host = (self.__undef__, True)
        self._target_port = (self.__undef__, True)
        self._target_principal = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._bandwidth_limit = (data.get("bandwidthLimit", obj.__undef__), dirty)
        if obj._bandwidth_limit[0] is not None and obj._bandwidth_limit[0] is not obj.__undef__:
            assert isinstance(obj._bandwidth_limit[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._bandwidth_limit[0], type(obj._bandwidth_limit[0])))
            common.validate_format(obj._bandwidth_limit[0], "None", None, None)
        obj._compressed = (data.get("compressed", obj.__undef__), dirty)
        if obj._compressed[0] is not None and obj._compressed[0] is not obj.__undef__:
            assert isinstance(obj._compressed[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._compressed[0], type(obj._compressed[0])))
            common.validate_format(obj._compressed[0], "None", None, None)
        obj._description = (data.get("description", obj.__undef__), dirty)
        if obj._description[0] is not None and obj._description[0] is not obj.__undef__:
            assert isinstance(obj._description[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._description[0], type(obj._description[0])))
            common.validate_format(obj._description[0], "None", None, 4096)
        obj._enabled = (data.get("enabled", obj.__undef__), dirty)
        if obj._enabled[0] is not None and obj._enabled[0] is not obj.__undef__:
            assert isinstance(obj._enabled[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._enabled[0], type(obj._enabled[0])))
            common.validate_format(obj._enabled[0], "None", None, None)
        obj._encrypted = (data.get("encrypted", obj.__undef__), dirty)
        if obj._encrypted[0] is not None and obj._encrypted[0] is not obj.__undef__:
            assert isinstance(obj._encrypted[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._encrypted[0], type(obj._encrypted[0])))
            common.validate_format(obj._encrypted[0], "None", None, None)
        obj._number_of_connections = (data.get("numberOfConnections", obj.__undef__), dirty)
        if obj._number_of_connections[0] is not None and obj._number_of_connections[0] is not obj.__undef__:
            assert isinstance(obj._number_of_connections[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._number_of_connections[0], type(obj._number_of_connections[0])))
            common.validate_format(obj._number_of_connections[0], "None", None, None)
        obj._objects = []
        for item in data.get("objects") or []:
            assert isinstance(item, str), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "objectReference", None, None)
            obj._objects.append(item)
        obj._objects = (obj._objects, dirty)
        if "runtime" in data and data["runtime"] is not None:
            obj._runtime = (factory.create_object(data["runtime"], "ReplicationSpecRuntime"), dirty)
            factory.validate_type(obj._runtime[0], "ReplicationSpecRuntime")
        else:
            obj._runtime = (obj.__undef__, dirty)
        obj._schedule = (data.get("schedule", obj.__undef__), dirty)
        if obj._schedule[0] is not None and obj._schedule[0] is not obj.__undef__:
            assert isinstance(obj._schedule[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._schedule[0], type(obj._schedule[0])))
            common.validate_format(obj._schedule[0], "None", 1, 256)
        obj._tag = (data.get("tag", obj.__undef__), dirty)
        if obj._tag[0] is not None and obj._tag[0] is not obj.__undef__:
            assert isinstance(obj._tag[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._tag[0], type(obj._tag[0])))
            common.validate_format(obj._tag[0], "None", 1, 256)
        if "targetCredential" in data and data["targetCredential"] is not None:
            obj._target_credential = (factory.create_object(data["targetCredential"], "PasswordCredential"), dirty)
            factory.validate_type(obj._target_credential[0], "PasswordCredential")
        else:
            obj._target_credential = (obj.__undef__, dirty)
        obj._target_host = (data.get("targetHost", obj.__undef__), dirty)
        if obj._target_host[0] is not None and obj._target_host[0] is not obj.__undef__:
            assert isinstance(obj._target_host[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._target_host[0], type(obj._target_host[0])))
            common.validate_format(obj._target_host[0], "host", None, None)
        obj._target_port = (data.get("targetPort", obj.__undef__), dirty)
        if obj._target_port[0] is not None and obj._target_port[0] is not obj.__undef__:
            assert isinstance(obj._target_port[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._target_port[0], type(obj._target_port[0])))
            common.validate_format(obj._target_port[0], "None", None, None)
        obj._target_principal = (data.get("targetPrincipal", obj.__undef__), dirty)
        if obj._target_principal[0] is not None and obj._target_principal[0] is not obj.__undef__:
            assert isinstance(obj._target_principal[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._target_principal[0], type(obj._target_principal[0])))
            common.validate_format(obj._target_principal[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "bandwidth_limit" == "type" or (self.bandwidth_limit is not self.__undef__ and (not (dirty and not self._bandwidth_limit[1]) or self.is_dirty_list(self.bandwidth_limit, self._bandwidth_limit) or belongs_to_parent)):
            dct["bandwidthLimit"] = dictify(self.bandwidth_limit)
        elif belongs_to_parent and self.bandwidth_limit is self.__undef__:
            dct["bandwidthLimit"] = 0
        if "compressed" == "type" or (self.compressed is not self.__undef__ and (not (dirty and not self._compressed[1]) or self.is_dirty_list(self.compressed, self._compressed) or belongs_to_parent)):
            dct["compressed"] = dictify(self.compressed)
        elif belongs_to_parent and self.compressed is self.__undef__:
            dct["compressed"] = True
        if "description" == "type" or (self.description is not self.__undef__ and (not (dirty and not self._description[1]) or self.is_dirty_list(self.description, self._description) or belongs_to_parent)):
            dct["description"] = dictify(self.description)
        if "enabled" == "type" or (self.enabled is not self.__undef__ and (not (dirty and not self._enabled[1]) or self.is_dirty_list(self.enabled, self._enabled) or belongs_to_parent)):
            dct["enabled"] = dictify(self.enabled)
        elif belongs_to_parent and self.enabled is self.__undef__:
            dct["enabled"] = False
        if "encrypted" == "type" or (self.encrypted is not self.__undef__ and (not (dirty and not self._encrypted[1]) or self.is_dirty_list(self.encrypted, self._encrypted) or belongs_to_parent)):
            dct["encrypted"] = dictify(self.encrypted)
        elif belongs_to_parent and self.encrypted is self.__undef__:
            dct["encrypted"] = False
        if "number_of_connections" == "type" or (self.number_of_connections is not self.__undef__ and (not (dirty and not self._number_of_connections[1]) or self.is_dirty_list(self.number_of_connections, self._number_of_connections) or belongs_to_parent)):
            dct["numberOfConnections"] = dictify(self.number_of_connections)
        elif belongs_to_parent and self.number_of_connections is self.__undef__:
            dct["numberOfConnections"] = 1
        if "objects" == "type" or (self.objects is not self.__undef__ and (not (dirty and not self._objects[1]) or self.is_dirty_list(self.objects, self._objects) or belongs_to_parent)):
            dct["objects"] = dictify(self.objects, prop_is_list_or_vo=True)
        if "runtime" == "type" or (self.runtime is not self.__undef__ and (not (dirty and not self._runtime[1]))):
            dct["runtime"] = dictify(self.runtime)
        if "schedule" == "type" or (self.schedule is not self.__undef__ and (not (dirty and not self._schedule[1]) or self.is_dirty_list(self.schedule, self._schedule) or belongs_to_parent)):
            dct["schedule"] = dictify(self.schedule)
        if "tag" == "type" or (self.tag is not self.__undef__ and (not (dirty and not self._tag[1]))):
            dct["tag"] = dictify(self.tag)
        if "target_credential" == "type" or (self.target_credential is not self.__undef__ and (not (dirty and not self._target_credential[1]) or self.is_dirty_list(self.target_credential, self._target_credential) or belongs_to_parent)):
            dct["targetCredential"] = dictify(self.target_credential, prop_is_list_or_vo=True)
        if "target_host" == "type" or (self.target_host is not self.__undef__ and (not (dirty and not self._target_host[1]) or self.is_dirty_list(self.target_host, self._target_host) or belongs_to_parent)):
            dct["targetHost"] = dictify(self.target_host)
        if "target_port" == "type" or (self.target_port is not self.__undef__ and (not (dirty and not self._target_port[1]) or self.is_dirty_list(self.target_port, self._target_port) or belongs_to_parent)):
            dct["targetPort"] = dictify(self.target_port)
        elif belongs_to_parent and self.target_port is self.__undef__:
            dct["targetPort"] = 8415
        if "target_principal" == "type" or (self.target_principal is not self.__undef__ and (not (dirty and not self._target_principal[1]) or self.is_dirty_list(self.target_principal, self._target_principal) or belongs_to_parent)):
            dct["targetPrincipal"] = dictify(self.target_principal)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._bandwidth_limit = (self._bandwidth_limit[0], True)
        self._compressed = (self._compressed[0], True)
        self._description = (self._description[0], True)
        self._enabled = (self._enabled[0], True)
        self._encrypted = (self._encrypted[0], True)
        self._number_of_connections = (self._number_of_connections[0], True)
        self._objects = (self._objects[0], True)
        self._runtime = (self._runtime[0], True)
        self._schedule = (self._schedule[0], True)
        self._tag = (self._tag[0], True)
        self._target_credential = (self._target_credential[0], True)
        self._target_host = (self._target_host[0], True)
        self._target_port = (self._target_port[0], True)
        self._target_principal = (self._target_principal[0], True)

    def is_dirty(self):
        return any([self._bandwidth_limit[1], self._compressed[1], self._description[1], self._enabled[1], self._encrypted[1], self._number_of_connections[1], self._objects[1], self._runtime[1], self._schedule[1], self._tag[1], self._target_credential[1], self._target_host[1], self._target_port[1], self._target_principal[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, ReplicationSpec):
            return False
        return super().__eq__(other) and \
               self.bandwidth_limit == other.bandwidth_limit and \
               self.compressed == other.compressed and \
               self.description == other.description and \
               self.enabled == other.enabled and \
               self.encrypted == other.encrypted and \
               self.number_of_connections == other.number_of_connections and \
               self.objects == other.objects and \
               self.runtime == other.runtime and \
               self.schedule == other.schedule and \
               self.tag == other.tag and \
               self.target_credential == other.target_credential and \
               self.target_host == other.target_host and \
               self.target_port == other.target_port and \
               self.target_principal == other.target_principal

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def bandwidth_limit(self):
        """
        Bandwidth limit (MB/s) for replication network traffic. A value of 0
        means no limit.

        :rtype: ``int``
        """
        return self._bandwidth_limit[0]

    @bandwidth_limit.setter
    def bandwidth_limit(self, value):
        self._bandwidth_limit = (value, True)

    @property
    def compressed(self):
        """
        *(default value: True)* Compress replication network traffic.

        :rtype: ``bool``
        """
        return self._compressed[0]

    @compressed.setter
    def compressed(self, value):
        self._compressed = (value, True)

    @property
    def description(self):
        """
        Description of this replication spec.

        :rtype: ``str``
        """
        return self._description[0]

    @description.setter
    def description(self, value):
        self._description = (value, True)

    @property
    def enabled(self):
        """
        Indication whether the replication spec schedule is enabled or not.

        :rtype: ``bool``
        """
        return self._enabled[0]

    @enabled.setter
    def enabled(self, value):
        self._enabled = (value, True)

    @property
    def encrypted(self):
        """
        Encrypt replication network traffic.

        :rtype: ``bool``
        """
        return self._encrypted[0]

    @encrypted.setter
    def encrypted(self, value):
        self._encrypted = (value, True)

    @property
    def number_of_connections(self):
        """
        *(default value: 1)* Total number of transport connections to use.

        :rtype: ``int``
        """
        return self._number_of_connections[0]

    @number_of_connections.setter
    def number_of_connections(self, value):
        self._number_of_connections = (value, True)

    @property
    def objects(self):
        """
        Objects to replicate, in canonical object reference form.

        :rtype: ``list`` of ``str``
        """
        return self._objects[0]

    @objects.setter
    def objects(self, value):
        self._objects = (value, True)

    @property
    def runtime(self):
        """
        Runtime properties of this replication spec.

        :rtype: :py:class:`v1_5_1.web.vo.ReplicationSpecRuntime`
        """
        return self._runtime[0]

    @runtime.setter
    def runtime(self, value):
        self._runtime = (value, True)

    @property
    def schedule(self):
        """
        Replication schedule in the form of a quartz-formatted string.

        :rtype: ``str``
        """
        return self._schedule[0]

    @schedule.setter
    def schedule(self, value):
        self._schedule = (value, True)

    @property
    def tag(self):
        """
        Globally unique identifier for this replication spec.

        :rtype: ``str``
        """
        return self._tag[0]

    @tag.setter
    def tag(self, value):
        self._tag = (value, True)

    @property
    def target_credential(self):
        """
        Credential used to authenticate to the replication target host.

        :rtype: :py:class:`v1_5_1.web.vo.PasswordCredential`
        """
        return self._target_credential[0]

    @target_credential.setter
    def target_credential(self, value):
        self._target_credential = (value, True)

    @property
    def target_host(self):
        """
        Replication target host address.

        :rtype: ``str``
        """
        return self._target_host[0]

    @target_host.setter
    def target_host(self, value):
        self._target_host = (value, True)

    @property
    def target_port(self):
        """
        *(default value: 8415)* Target TCP port number for the Delphix Session
        Protocol.

        :rtype: ``int``
        """
        return self._target_port[0]

    @target_port.setter
    def target_port(self, value):
        self._target_port = (value, True)

    @property
    def target_principal(self):
        """
        Principal name used to authenticate to the replication target host.

        :rtype: ``str``
        """
        return self._target_principal[0]

    @target_principal.setter
    def target_principal(self, value):
        self._target_principal = (value, True)

