#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-toolkit-linked-staged-source.json
#
# Do not edit this file manually!
#

from delphixpy.v1_5_1.web.objects.ToolkitLinkedSource import ToolkitLinkedSource
from delphixpy.v1_5_1 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class ToolkitLinkedStagedSource(ToolkitLinkedSource):
    """
    *(extends* :py:class:`v1_5_1.web.vo.ToolkitLinkedSource` *)* A linked
    staged source definition for toolkits.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("ToolkitLinkedStagedSource", True)
        self._post_snapshot = (self.__undef__, True)
        self._pre_snapshot = (self.__undef__, True)
        self._resync = (self.__undef__, True)
        self._start_staging = (self.__undef__, True)
        self._status_script = (self.__undef__, True)
        self._stop_staging = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "postSnapshot" not in data:
            raise ValueError("Missing required property \"postSnapshot\".")
        obj._post_snapshot = (data.get("postSnapshot", obj.__undef__), dirty)
        if obj._post_snapshot[0] is not None and obj._post_snapshot[0] is not obj.__undef__:
            assert isinstance(obj._post_snapshot[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._post_snapshot[0], type(obj._post_snapshot[0])))
            common.validate_format(obj._post_snapshot[0], "None", None, None)
        if "preSnapshot" not in data:
            raise ValueError("Missing required property \"preSnapshot\".")
        obj._pre_snapshot = (data.get("preSnapshot", obj.__undef__), dirty)
        if obj._pre_snapshot[0] is not None and obj._pre_snapshot[0] is not obj.__undef__:
            assert isinstance(obj._pre_snapshot[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._pre_snapshot[0], type(obj._pre_snapshot[0])))
            common.validate_format(obj._pre_snapshot[0], "None", None, None)
        if "resync" not in data:
            raise ValueError("Missing required property \"resync\".")
        obj._resync = (data.get("resync", obj.__undef__), dirty)
        if obj._resync[0] is not None and obj._resync[0] is not obj.__undef__:
            assert isinstance(obj._resync[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._resync[0], type(obj._resync[0])))
            common.validate_format(obj._resync[0], "None", None, None)
        if "startStaging" not in data:
            raise ValueError("Missing required property \"startStaging\".")
        obj._start_staging = (data.get("startStaging", obj.__undef__), dirty)
        if obj._start_staging[0] is not None and obj._start_staging[0] is not obj.__undef__:
            assert isinstance(obj._start_staging[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._start_staging[0], type(obj._start_staging[0])))
            common.validate_format(obj._start_staging[0], "None", None, None)
        obj._status_script = (data.get("statusScript", obj.__undef__), dirty)
        if obj._status_script[0] is not None and obj._status_script[0] is not obj.__undef__:
            assert isinstance(obj._status_script[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._status_script[0], type(obj._status_script[0])))
            common.validate_format(obj._status_script[0], "None", None, None)
        if "stopStaging" not in data:
            raise ValueError("Missing required property \"stopStaging\".")
        obj._stop_staging = (data.get("stopStaging", obj.__undef__), dirty)
        if obj._stop_staging[0] is not None and obj._stop_staging[0] is not obj.__undef__:
            assert isinstance(obj._stop_staging[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._stop_staging[0], type(obj._stop_staging[0])))
            common.validate_format(obj._stop_staging[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "post_snapshot" == "type" or (self.post_snapshot is not self.__undef__ and (not (dirty and not self._post_snapshot[1]) or self.is_dirty_list(self.post_snapshot, self._post_snapshot) or belongs_to_parent)):
            dct["postSnapshot"] = dictify(self.post_snapshot)
        if "pre_snapshot" == "type" or (self.pre_snapshot is not self.__undef__ and (not (dirty and not self._pre_snapshot[1]) or self.is_dirty_list(self.pre_snapshot, self._pre_snapshot) or belongs_to_parent)):
            dct["preSnapshot"] = dictify(self.pre_snapshot)
        if "resync" == "type" or (self.resync is not self.__undef__ and (not (dirty and not self._resync[1]) or self.is_dirty_list(self.resync, self._resync) or belongs_to_parent)):
            dct["resync"] = dictify(self.resync)
        if "start_staging" == "type" or (self.start_staging is not self.__undef__ and (not (dirty and not self._start_staging[1]) or self.is_dirty_list(self.start_staging, self._start_staging) or belongs_to_parent)):
            dct["startStaging"] = dictify(self.start_staging)
        if "status_script" == "type" or (self.status_script is not self.__undef__ and (not (dirty and not self._status_script[1]))):
            dct["statusScript"] = dictify(self.status_script)
        if "stop_staging" == "type" or (self.stop_staging is not self.__undef__ and (not (dirty and not self._stop_staging[1]) or self.is_dirty_list(self.stop_staging, self._stop_staging) or belongs_to_parent)):
            dct["stopStaging"] = dictify(self.stop_staging)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._post_snapshot = (self._post_snapshot[0], True)
        self._pre_snapshot = (self._pre_snapshot[0], True)
        self._resync = (self._resync[0], True)
        self._start_staging = (self._start_staging[0], True)
        self._status_script = (self._status_script[0], True)
        self._stop_staging = (self._stop_staging[0], True)

    def is_dirty(self):
        return any([self._post_snapshot[1], self._pre_snapshot[1], self._resync[1], self._start_staging[1], self._status_script[1], self._stop_staging[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, ToolkitLinkedStagedSource):
            return False
        return super().__eq__(other) and \
               self.post_snapshot == other.post_snapshot and \
               self.pre_snapshot == other.pre_snapshot and \
               self.resync == other.resync and \
               self.start_staging == other.start_staging and \
               self.status_script == other.status_script and \
               self.stop_staging == other.stop_staging

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def post_snapshot(self):
        """
        A workflow script to run immediately after snapshotting the staged
        source.

        :rtype: ``str``
        """
        return self._post_snapshot[0]

    @post_snapshot.setter
    def post_snapshot(self, value):
        self._post_snapshot = (value, True)

    @property
    def pre_snapshot(self):
        """
        A workflow script to run just prior to snapshotting the staged source.

        :rtype: ``str``
        """
        return self._pre_snapshot[0]

    @pre_snapshot.setter
    def pre_snapshot(self, value):
        self._pre_snapshot = (value, True)

    @property
    def resync(self):
        """
        A workflow script that builds the staging instance from production.

        :rtype: ``str``
        """
        return self._resync[0]

    @resync.setter
    def resync(self, value):
        self._resync = (value, True)

    @property
    def start_staging(self):
        """
        A workflow script that start the staged source. The staged files will
        be mounted and available.

        :rtype: ``str``
        """
        return self._start_staging[0]

    @start_staging.setter
    def start_staging(self, value):
        self._start_staging = (value, True)

    @property
    def status_script(self):
        """
        A script run on the staging host to determine if the staging instance
        is configured to receive data from the dSource. The script should exit
        with an exit status of 0 if data reception is correctly configured and
        available. The script should exit with an exit status of 128 if the
        staging instance is not configured to receive data. Any other exit
        status implies the script encountered an unexpected state or error. If
        no status script is supplied, the dSource will always be in an active
        state while enabled.

        :rtype: ``str``
        """
        return self._status_script[0]

    @status_script.setter
    def status_script(self, value):
        self._status_script = (value, True)

    @property
    def stop_staging(self):
        """
        A workflow script that stop the staged source. The staged files will be
        mounted and available. Upon completion of this workflow, the staged
        files will be unmounted.

        :rtype: ``str``
        """
        return self._stop_staging[0]

    @stop_staging.setter
    def stop_staging(self, value):
        self._stop_staging = (value, True)

