#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-pgsql-ident-entry.json
#
# Do not edit this file manually!
#

from delphixpy.v1_5_2.web.objects.TypedObject import TypedObject
from delphixpy.v1_5_2 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class PgSQLIdentEntry(TypedObject):
    """
    *(extends* :py:class:`v1_5_2.web.vo.TypedObject` *)* An entry in the
    PostgreSQL username map file (pg_ident.conf).
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("PgSQLIdentEntry", True)
        self._database_username = (self.__undef__, True)
        self._map_name = (self.__undef__, True)
        self._system_username = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._database_username = (data.get("databaseUsername", obj.__undef__), dirty)
        if obj._database_username[0] is not None and obj._database_username[0] is not obj.__undef__:
            assert isinstance(obj._database_username[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._database_username[0], type(obj._database_username[0])))
            common.validate_format(obj._database_username[0], "None", None, 63)
        obj._map_name = (data.get("mapName", obj.__undef__), dirty)
        if obj._map_name[0] is not None and obj._map_name[0] is not obj.__undef__:
            assert isinstance(obj._map_name[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._map_name[0], type(obj._map_name[0])))
            common.validate_format(obj._map_name[0], "None", None, None)
        obj._system_username = (data.get("systemUsername", obj.__undef__), dirty)
        if obj._system_username[0] is not None and obj._system_username[0] is not obj.__undef__:
            assert isinstance(obj._system_username[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._system_username[0], type(obj._system_username[0])))
            common.validate_format(obj._system_username[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "database_username" == "type" or (self.database_username is not self.__undef__ and (not (dirty and not self._database_username[1]) or self.is_dirty_list(self.database_username, self._database_username) or belongs_to_parent)):
            dct["databaseUsername"] = dictify(self.database_username)
        if "map_name" == "type" or (self.map_name is not self.__undef__ and (not (dirty and not self._map_name[1]) or self.is_dirty_list(self.map_name, self._map_name) or belongs_to_parent)):
            dct["mapName"] = dictify(self.map_name)
        if "system_username" == "type" or (self.system_username is not self.__undef__ and (not (dirty and not self._system_username[1]) or self.is_dirty_list(self.system_username, self._system_username) or belongs_to_parent)):
            dct["systemUsername"] = dictify(self.system_username)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._database_username = (self._database_username[0], True)
        self._map_name = (self._map_name[0], True)
        self._system_username = (self._system_username[0], True)

    def is_dirty(self):
        return any([self._database_username[1], self._map_name[1], self._system_username[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, PgSQLIdentEntry):
            return False
        return super().__eq__(other) and \
               self.database_username == other.database_username and \
               self.map_name == other.map_name and \
               self.system_username == other.system_username

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def database_username(self):
        """
        The database username this entry matches.

        :rtype: ``str``
        """
        return self._database_username[0]

    @database_username.setter
    def database_username(self, value):
        self._database_username = (value, True)

    @property
    def map_name(self):
        """
        The name of the map to which this entry belongs (used to refer to the
        map in pg_hba.conf).

        :rtype: ``str``
        """
        return self._map_name[0]

    @map_name.setter
    def map_name(self, value):
        self._map_name = (value, True)

    @property
    def system_username(self):
        """
        The operating system username this entry matches.

        :rtype: ``str``
        """
        return self._system_username[0]

    @system_username.setter
    def system_username(self, value):
        self._system_username = (value, True)

