#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-toolkit-parameter.json
#
# Do not edit this file manually!
#

from delphixpy.v1_6_0.web.objects.TypedObject import TypedObject
from delphixpy.v1_6_0 import factory
from delphixpy.v1_6_0 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class ToolkitParameter(TypedObject):
    """
    *(extends* :py:class:`v1_6_0.web.vo.TypedObject` *)* Specifies input
    parameters to operations on toolkits.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("ToolkitParameter", True)
        self._default = (self.__undef__, True)
        self._parameter = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "default" not in data:
            raise ValueError("Missing required property \"default\".")
        obj._default = (data.get("default", obj.__undef__), dirty)
        if obj._default[0] is not None and obj._default[0] is not obj.__undef__:
            assert isinstance(obj._default[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._default[0], type(obj._default[0])))
            common.validate_format(obj._default[0], "None", None, None)
        if "parameter" not in data:
            raise ValueError("Missing required property \"parameter\".")
        if "parameter" in data and data["parameter"] is not None:
            obj._parameter = (factory.create_object(data["parameter"], "DynamicParameter"), dirty)
            factory.validate_type(obj._parameter[0], "DynamicParameter")
        else:
            obj._parameter = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "default" == "type" or (self.default is not self.__undef__ and (not (dirty and not self._default[1]) or self.is_dirty_list(self.default, self._default) or belongs_to_parent)):
            dct["default"] = dictify(self.default)
        if "parameter" == "type" or (self.parameter is not self.__undef__ and (not (dirty and not self._parameter[1]) or self.is_dirty_list(self.parameter, self._parameter) or belongs_to_parent)):
            dct["parameter"] = dictify(self.parameter, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._default = (self._default[0], True)
        self._parameter = (self._parameter[0], True)

    def is_dirty(self):
        return any([self._default[1], self._parameter[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, ToolkitParameter):
            return False
        return super().__eq__(other) and \
               self.default == other.default and \
               self.parameter == other.parameter

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def default(self):
        """
        The default value for this input. This value must pass validation as
        the dynamic parameter type given for this parameter.

        :rtype: ``str``
        """
        return self._default[0]

    @default.setter
    def default(self, value):
        self._default = (value, True)

    @property
    def parameter(self):
        """
        The dynamic parameter to give to clients when requesting input.

        :rtype: :py:class:`v1_6_0.web.vo.DynamicParameter`
        """
        return self._parameter[0]

    @parameter.setter
    def parameter(self, value):
        self._parameter = (value, True)

