#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-oracle-base-link-parameters.json
#
# Do not edit this file manually!
#

from delphixpy.v1_7_1.web.objects.LinkParameters import LinkParameters
from delphixpy.v1_7_1 import factory
from delphixpy.v1_7_1 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class OracleBaseLinkParameters(LinkParameters):
    """
    *(extends* :py:class:`v1_7_1.web.vo.LinkParameters` *)* Represents common
    parameters to link all Oracle databases.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("OracleBaseLinkParameters", True)
        self._container = (self.__undef__, True)
        self._db_credentials = (self.__undef__, True)
        self._db_user = (self.__undef__, True)
        self._double_sync = (self.__undef__, True)
        self._environment_user = (self.__undef__, True)
        self._link_now = (self.__undef__, True)
        self._skip_space_check = (self.__undef__, True)
        self._source = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "container" not in data:
            raise ValueError("Missing required property \"container\".")
        if "container" in data and data["container"] is not None:
            obj._container = (factory.create_object(data["container"], "OracleDatabaseContainer"), dirty)
            factory.validate_type(obj._container[0], "OracleDatabaseContainer")
        else:
            obj._container = (obj.__undef__, dirty)
        if "dbCredentials" not in data:
            raise ValueError("Missing required property \"dbCredentials\".")
        if "dbCredentials" in data and data["dbCredentials"] is not None:
            obj._db_credentials = (factory.create_object(data["dbCredentials"], "PasswordCredential"), dirty)
            factory.validate_type(obj._db_credentials[0], "PasswordCredential")
        else:
            obj._db_credentials = (obj.__undef__, dirty)
        if "dbUser" not in data:
            raise ValueError("Missing required property \"dbUser\".")
        obj._db_user = (data.get("dbUser", obj.__undef__), dirty)
        if obj._db_user[0] is not None and obj._db_user[0] is not obj.__undef__:
            assert isinstance(obj._db_user[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._db_user[0], type(obj._db_user[0])))
            common.validate_format(obj._db_user[0], "None", None, None)
        obj._double_sync = (data.get("doubleSync", obj.__undef__), dirty)
        if obj._double_sync[0] is not None and obj._double_sync[0] is not obj.__undef__:
            assert isinstance(obj._double_sync[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._double_sync[0], type(obj._double_sync[0])))
            common.validate_format(obj._double_sync[0], "None", None, None)
        if "environmentUser" not in data:
            raise ValueError("Missing required property \"environmentUser\".")
        obj._environment_user = (data.get("environmentUser", obj.__undef__), dirty)
        if obj._environment_user[0] is not None and obj._environment_user[0] is not obj.__undef__:
            assert isinstance(obj._environment_user[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._environment_user[0], type(obj._environment_user[0])))
            common.validate_format(obj._environment_user[0], "objectReference", None, None)
        obj._link_now = (data.get("linkNow", obj.__undef__), dirty)
        if obj._link_now[0] is not None and obj._link_now[0] is not obj.__undef__:
            assert isinstance(obj._link_now[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._link_now[0], type(obj._link_now[0])))
            common.validate_format(obj._link_now[0], "None", None, None)
        obj._skip_space_check = (data.get("skipSpaceCheck", obj.__undef__), dirty)
        if obj._skip_space_check[0] is not None and obj._skip_space_check[0] is not obj.__undef__:
            assert isinstance(obj._skip_space_check[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._skip_space_check[0], type(obj._skip_space_check[0])))
            common.validate_format(obj._skip_space_check[0], "None", None, None)
        if "source" not in data:
            raise ValueError("Missing required property \"source\".")
        if "source" in data and data["source"] is not None:
            obj._source = (factory.create_object(data["source"], "OracleLinkedSource"), dirty)
            factory.validate_type(obj._source[0], "OracleLinkedSource")
        else:
            obj._source = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "container" == "type" or (self.container is not self.__undef__ and (not (dirty and not self._container[1]) or self.is_dirty_list(self.container, self._container) or belongs_to_parent)):
            dct["container"] = dictify(self.container, prop_is_list_or_vo=True)
        if "db_credentials" == "type" or (self.db_credentials is not self.__undef__ and (not (dirty and not self._db_credentials[1]) or self.is_dirty_list(self.db_credentials, self._db_credentials) or belongs_to_parent)):
            dct["dbCredentials"] = dictify(self.db_credentials, prop_is_list_or_vo=True)
        if "db_user" == "type" or (self.db_user is not self.__undef__ and (not (dirty and not self._db_user[1]) or self.is_dirty_list(self.db_user, self._db_user) or belongs_to_parent)):
            dct["dbUser"] = dictify(self.db_user)
        if "double_sync" == "type" or (self.double_sync is not self.__undef__ and (not (dirty and not self._double_sync[1]) or self.is_dirty_list(self.double_sync, self._double_sync) or belongs_to_parent)):
            dct["doubleSync"] = dictify(self.double_sync)
        elif belongs_to_parent and self.double_sync is self.__undef__:
            dct["doubleSync"] = False
        if "environment_user" == "type" or (self.environment_user is not self.__undef__ and (not (dirty and not self._environment_user[1]) or self.is_dirty_list(self.environment_user, self._environment_user) or belongs_to_parent)):
            dct["environmentUser"] = dictify(self.environment_user)
        if "link_now" == "type" or (self.link_now is not self.__undef__ and (not (dirty and not self._link_now[1]) or self.is_dirty_list(self.link_now, self._link_now) or belongs_to_parent)):
            dct["linkNow"] = dictify(self.link_now)
        elif belongs_to_parent and self.link_now is self.__undef__:
            dct["linkNow"] = False
        if "skip_space_check" == "type" or (self.skip_space_check is not self.__undef__ and (not (dirty and not self._skip_space_check[1]) or self.is_dirty_list(self.skip_space_check, self._skip_space_check) or belongs_to_parent)):
            dct["skipSpaceCheck"] = dictify(self.skip_space_check)
        elif belongs_to_parent and self.skip_space_check is self.__undef__:
            dct["skipSpaceCheck"] = False
        if "source" == "type" or (self.source is not self.__undef__ and (not (dirty and not self._source[1]) or self.is_dirty_list(self.source, self._source) or belongs_to_parent)):
            dct["source"] = dictify(self.source, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._container = (self._container[0], True)
        self._db_credentials = (self._db_credentials[0], True)
        self._db_user = (self._db_user[0], True)
        self._double_sync = (self._double_sync[0], True)
        self._environment_user = (self._environment_user[0], True)
        self._link_now = (self._link_now[0], True)
        self._skip_space_check = (self._skip_space_check[0], True)
        self._source = (self._source[0], True)

    def is_dirty(self):
        return any([self._container[1], self._db_credentials[1], self._db_user[1], self._double_sync[1], self._environment_user[1], self._link_now[1], self._skip_space_check[1], self._source[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, OracleBaseLinkParameters):
            return False
        return super().__eq__(other) and \
               self.container == other.container and \
               self.db_credentials == other.db_credentials and \
               self.db_user == other.db_user and \
               self.double_sync == other.double_sync and \
               self.environment_user == other.environment_user and \
               self.link_now == other.link_now and \
               self.skip_space_check == other.skip_space_check and \
               self.source == other.source

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def container(self):
        """
        Container to create as part of the linking process.

        :rtype: :py:class:`v1_7_1.web.vo.OracleDatabaseContainer`
        """
        return self._container[0]

    @container.setter
    def container(self, value):
        self._container = (value, True)

    @property
    def db_credentials(self):
        """
        The password for the DB user.

        :rtype: :py:class:`v1_7_1.web.vo.PasswordCredential`
        """
        return self._db_credentials[0]

    @db_credentials.setter
    def db_credentials(self, value):
        self._db_credentials = (value, True)

    @property
    def db_user(self):
        """
        The name of the DB user.

        :rtype: ``str``
        """
        return self._db_user[0]

    @db_user.setter
    def db_user(self, value):
        self._db_user = (value, True)

    @property
    def double_sync(self):
        """
        True if two SnapSyncs should be performed in immediate succession to
        reduce the number of logs required to provision the snapshot. This may
        significantly reduce the time necessary to provision from a snapshot.

        :rtype: ``bool``
        """
        return self._double_sync[0]

    @double_sync.setter
    def double_sync(self, value):
        self._double_sync = (value, True)

    @property
    def environment_user(self):
        """
        Information about the OS user to use for linking.

        :rtype: ``str``
        """
        return self._environment_user[0]

    @environment_user.setter
    def environment_user(self, value):
        self._environment_user = (value, True)

    @property
    def link_now(self):
        """
        True if initial load should be done immediately.

        :rtype: ``bool``
        """
        return self._link_now[0]

    @link_now.setter
    def link_now(self, value):
        self._link_now = (value, True)

    @property
    def skip_space_check(self):
        """
        Skip check that tests if there is enough space available to store the
        database in the Delphix Engine. The Delphix Engine estimates how much
        space a database will occupy after compression and prevents SnapSync if
        insufficient space is available. This safeguard can be overridden using
        this option. This may be useful when linking highly compressible
        databases.

        :rtype: ``bool``
        """
        return self._skip_space_check[0]

    @skip_space_check.setter
    def skip_space_check(self, value):
        self._skip_space_check = (value, True)

    @property
    def source(self):
        """
        Source to link the container to. This must reference an existing linked
        source config.

        :rtype: :py:class:`v1_7_1.web.vo.OracleLinkedSource`
        """
        return self._source[0]

    @source.setter
    def source(self, value):
        self._source = (value, True)

