#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-credential-update-parameters.json
#
# Do not edit this file manually!
#

from delphixpy.v1_8_1.web.objects.TypedObject import TypedObject
from delphixpy.v1_8_1 import factory
from delphixpy.v1_8_1 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class CredentialUpdateParameters(TypedObject):
    """
    *(extends* :py:class:`v1_8_1.web.vo.TypedObject` *)* Parameters to update a
    Delphix user's password.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("CredentialUpdateParameters", True)
        self._new_credential = (self.__undef__, True)
        self._old_credential = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "newCredential" in data and data["newCredential"] is not None:
            obj._new_credential = (factory.create_object(data["newCredential"], "PasswordCredential"), dirty)
            factory.validate_type(obj._new_credential[0], "PasswordCredential")
        else:
            obj._new_credential = (obj.__undef__, dirty)
        if "oldCredential" in data and data["oldCredential"] is not None:
            obj._old_credential = (factory.create_object(data["oldCredential"], "PasswordCredential"), dirty)
            factory.validate_type(obj._old_credential[0], "PasswordCredential")
        else:
            obj._old_credential = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "new_credential" == "type" or (self.new_credential is not self.__undef__ and (not (dirty and not self._new_credential[1]) or self.is_dirty_list(self.new_credential, self._new_credential) or belongs_to_parent)):
            dct["newCredential"] = dictify(self.new_credential, prop_is_list_or_vo=True)
        if "old_credential" == "type" or (self.old_credential is not self.__undef__ and (not (dirty and not self._old_credential[1]) or self.is_dirty_list(self.old_credential, self._old_credential) or belongs_to_parent)):
            dct["oldCredential"] = dictify(self.old_credential, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._new_credential = (self._new_credential[0], True)
        self._old_credential = (self._old_credential[0], True)

    def is_dirty(self):
        return any([self._new_credential[1], self._old_credential[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, CredentialUpdateParameters):
            return False
        return super().__eq__(other) and \
               self.new_credential == other.new_credential and \
               self.old_credential == other.old_credential

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def new_credential(self):
        """
        The new credentials.

        :rtype: :py:class:`v1_8_1.web.vo.PasswordCredential`
        """
        return self._new_credential[0]

    @new_credential.setter
    def new_credential(self, value):
        self._new_credential = (value, True)

    @property
    def old_credential(self):
        """
        The old credentials.

        :rtype: :py:class:`v1_8_1.web.vo.PasswordCredential`
        """
        return self._old_credential[0]

    @old_credential.setter
    def old_credential(self, value):
        self._old_credential = (value, True)

