#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#
# Do not edit this file manually!
#

from delphixpy.v1_8_1.web.objects.SourceOperation import SourceOperation
from delphixpy.v1_8_1 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class RunMaskingJobOnSourceOperation(SourceOperation):
    """
    *(extends* :py:class:`v1_8_1.web.vo.SourceOperation` *)* An operation that
    runs a Masking Job on the local Delphix Masking Engine instance.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("RunMaskingJobOnSourceOperation", True)
        self._application_id = (self.__undef__, True)
        self._masking_job_id = (self.__undef__, True)
        self._name = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._application_id = (data.get("applicationId", obj.__undef__), dirty)
        if obj._application_id[0] is not None and obj._application_id[0] is not obj.__undef__:
            assert isinstance(obj._application_id[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._application_id[0], type(obj._application_id[0])))
            common.validate_format(obj._application_id[0], "None", None, None)
        obj._masking_job_id = (data.get("maskingJobId", obj.__undef__), dirty)
        if obj._masking_job_id[0] is not None and obj._masking_job_id[0] is not obj.__undef__:
            assert isinstance(obj._masking_job_id[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._masking_job_id[0], type(obj._masking_job_id[0])))
            common.validate_format(obj._masking_job_id[0], "None", None, None)
        obj._name = (data.get("name", obj.__undef__), dirty)
        if obj._name[0] is not None and obj._name[0] is not obj.__undef__:
            assert isinstance(obj._name[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._name[0], type(obj._name[0])))
            common.validate_format(obj._name[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "application_id" == "type" or (self.application_id is not self.__undef__ and (not (dirty and not self._application_id[1]) or self.is_dirty_list(self.application_id, self._application_id) or belongs_to_parent)):
            dct["applicationId"] = dictify(self.application_id)
        if "masking_job_id" == "type" or (self.masking_job_id is not self.__undef__ and (not (dirty and not self._masking_job_id[1]) or self.is_dirty_list(self.masking_job_id, self._masking_job_id) or belongs_to_parent)):
            dct["maskingJobId"] = dictify(self.masking_job_id)
        if "name" == "type" or (self.name is not self.__undef__ and (not (dirty and not self._name[1]) or self.is_dirty_list(self.name, self._name) or belongs_to_parent)):
            dct["name"] = dictify(self.name)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._application_id = (self._application_id[0], True)
        self._masking_job_id = (self._masking_job_id[0], True)
        self._name = (self._name[0], True)

    def is_dirty(self):
        return any([self._application_id[1], self._masking_job_id[1], self._name[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, RunMaskingJobOnSourceOperation):
            return False
        return super().__eq__(other) and \
               self.application_id == other.application_id and \
               self.masking_job_id == other.masking_job_id and \
               self.name == other.name

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def application_id(self):
        """
        The application ID of the Masking Job to be executed.

        :rtype: ``str``
        """
        return self._application_id[0]

    @application_id.setter
    def application_id(self, value):
        self._application_id = (value, True)

    @property
    def masking_job_id(self):
        """
        The Masking Job ID of the Masking Job to be executed.

        :rtype: ``str``
        """
        return self._masking_job_id[0]

    @masking_job_id.setter
    def masking_job_id(self, value):
        self._masking_job_id = (value, True)

    @property
    def name(self):
        """
        The name of the Masking Job to be executed.

        :rtype: ``str``
        """
        return self._name[0]

    @name.setter
    def name(self, value):
        self._name = (value, True)

