#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-http-connector-config.json
#
# Do not edit this file manually!
#

from delphixpy.v1_8_2.web.objects.TypedObject import TypedObject
from delphixpy.v1_8_2 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class HttpConnectorConfig(TypedObject):
    """
    *(extends* :py:class:`v1_8_2.web.vo.TypedObject` *)* Configuration for the
    HTTP and HTTPS connector of this application.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("HttpConnectorConfig", True)
        self._tls_versions = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._tls_versions = []
        for item in data.get("tlsVersions") or []:
            assert isinstance(item, str), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            assert item in ['SSLv3', 'TLSv1', 'TLSv1_1', 'TLSv1_2'], "Expected enum ['SSLv3', 'TLSv1', 'TLSv1_1', 'TLSv1_2'] but got %s" % item
            common.validate_format(item, "None", None, None)
            obj._tls_versions.append(item)
        obj._tls_versions = (obj._tls_versions, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "tls_versions" == "type" or (self.tls_versions is not self.__undef__ and (not (dirty and not self._tls_versions[1]) or self.is_dirty_list(self.tls_versions, self._tls_versions) or belongs_to_parent)):
            dct["tlsVersions"] = dictify(self.tls_versions, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._tls_versions = (self._tls_versions[0], True)

    def is_dirty(self):
        return any([self._tls_versions[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, HttpConnectorConfig):
            return False
        return super().__eq__(other) and \
               self.tls_versions == other.tls_versions

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def tls_versions(self):
        """
        Version of TLS (transport layer security) enabled on this appliance.

        :rtype: ``list`` of ``str``
        """
        return self._tls_versions[0]

    @tls_versions.setter
    def tls_versions(self, value):
        self._tls_versions = (value, True)

