#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-connectivity-jdbc.json
#
# Do not edit this file manually!
#

from delphixpy.v1_9_2.web.objects.TypedObject import TypedObject
from delphixpy.v1_9_2 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class JDBCConnectivity(TypedObject):
    """
    *(extends* :py:class:`v1_9_2.web.vo.TypedObject` *)* Mechanism to test JDBC
    connectivity of arbitrary databases.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("JDBCConnectivity", True)
        self._url = (self.__undef__, True)
        self._user = (self.__undef__, True)
        self._password = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "url" not in data:
            raise ValueError("Missing required property \"url\".")
        obj._url = (data.get("url", obj.__undef__), dirty)
        if obj._url[0] is not None and obj._url[0] is not obj.__undef__:
            assert isinstance(obj._url[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._url[0], type(obj._url[0])))
            common.validate_format(obj._url[0], "oracleJDBCConnectionString", None, None)
        if "user" not in data:
            raise ValueError("Missing required property \"user\".")
        obj._user = (data.get("user", obj.__undef__), dirty)
        if obj._user[0] is not None and obj._user[0] is not obj.__undef__:
            assert isinstance(obj._user[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._user[0], type(obj._user[0])))
            common.validate_format(obj._user[0], "None", None, None)
        if "password" not in data:
            raise ValueError("Missing required property \"password\".")
        obj._password = (data.get("password", obj.__undef__), dirty)
        if obj._password[0] is not None and obj._password[0] is not obj.__undef__:
            assert isinstance(obj._password[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._password[0], type(obj._password[0])))
            common.validate_format(obj._password[0], "password", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "url" == "type" or (self.url is not self.__undef__ and (not (dirty and not self._url[1]) or self.is_dirty_list(self.url, self._url) or belongs_to_parent)):
            dct["url"] = dictify(self.url)
        if "user" == "type" or (self.user is not self.__undef__ and (not (dirty and not self._user[1]) or self.is_dirty_list(self.user, self._user) or belongs_to_parent)):
            dct["user"] = dictify(self.user)
        if "password" == "type" or (self.password is not self.__undef__ and (not (dirty and not self._password[1]) or self.is_dirty_list(self.password, self._password) or belongs_to_parent)):
            dct["password"] = dictify(self.password)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._url = (self._url[0], True)
        self._user = (self._user[0], True)
        self._password = (self._password[0], True)

    def is_dirty(self):
        return any([self._url[1], self._user[1], self._password[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, JDBCConnectivity):
            return False
        return super().__eq__(other) and \
               self.url == other.url and \
               self.user == other.user and \
               self.password == other.password

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def url(self):
        """
        JDBC connection URL.

        :rtype: ``str``
        """
        return self._url[0]

    @url.setter
    def url(self, value):
        self._url = (value, True)

    @property
    def user(self):
        """
        Database username.

        :rtype: ``str``
        """
        return self._user[0]

    @user.setter
    def user(self, value):
        self._user = (value, True)

    @property
    def password(self):
        """
        Database password.

        :rtype: ``str``
        """
        return self._password[0]

    @password.setter
    def password(self, value):
        self._password = (value, True)

