#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#
# Do not edit this file manually!
#

from delphixpy.web.objects.TypedObject import TypedObject
from delphixpy import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class ApiObjectExtraAttributes(TypedObject):
    """
    *(extends* :py:class:`delphixpy.web.vo.TypedObject` *)* Extra attributes
    requested for an API type.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("ApiObjectExtraAttributes", True)
        self._api_type = (self.__undef__, True)
        self._attributes = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        if "apiType" not in data:
            raise ValueError("Missing required property \"apiType\".")
        obj._api_type = (data.get("apiType", obj.__undef__), dirty)
        if obj._api_type[0] is not None and obj._api_type[0] is not obj.__undef__:
            assert isinstance(obj._api_type[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._api_type[0], type(obj._api_type[0])))
            common.validate_format(obj._api_type[0], "None", None, None)
        if "attributes" not in data:
            raise ValueError("Missing required property \"attributes\".")
        obj._attributes = []
        for item in data.get("attributes") or []:
            assert isinstance(item, str), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._attributes.append(item)
        obj._attributes = (obj._attributes, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "api_type" == "type" or (self.api_type is not self.__undef__ and (not (dirty and not self._api_type[1]) or self.is_dirty_list(self.api_type, self._api_type) or belongs_to_parent)):
            dct["apiType"] = dictify(self.api_type)
        if "attributes" == "type" or (self.attributes is not self.__undef__ and (not (dirty and not self._attributes[1]) or self.is_dirty_list(self.attributes, self._attributes) or belongs_to_parent)):
            dct["attributes"] = dictify(self.attributes, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._api_type = (self._api_type[0], True)
        self._attributes = (self._attributes[0], True)

    def is_dirty(self):
        return any([self._api_type[1], self._attributes[1]])

    def is_dirty_list(self, prop_name, private_var):
        if isinstance(prop_name, list) and prop_name and hasattr(prop_name[0], 'type'):
            for item in prop_name:
                if isinstance(item, list):
                    if self.is_dirty_list(item) or item.is_dirty():
                        return True
                elif item.is_dirty():
                    return True
        else:
            return private_var[1]
        return False

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, ApiObjectExtraAttributes):
            return False
        return super().__eq__(other) and \
               self.api_type == other.api_type and \
               self.attributes == other.attributes

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def api_type(self):
        """
        API type for which extra attributes are requested.

        :rtype: ``str``
        """
        return self._api_type[0]

    @api_type.setter
    def api_type(self, value):
        self._api_type = (value, True)

    @property
    def attributes(self):
        """
        Names of extra attributes requested.

        :rtype: ``list`` of ``str``
        """
        return self._attributes[0]

    @attributes.setter
    def attributes(self, value):
        self._attributes = (value, True)

