#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

"""
Package "service.nfs.encryption"
"""
from delphixpy import response_validator

def get(engine):
    """
    Retrieve the specified NfsEncryptionConfig object.

    :param engine: The Delphix Engine
    :type engine: :py:class:`delphixpy.delphix_engine.DelphixEngine`
    :rtype: :py:class:`delphixpy.web.vo.NfsEncryptionConfig`
    """
    url = "/resources/json/delphix/service/nfs/encryption"
    response = engine.get(url)
    result = response_validator.validate(response, engine)
    raw_result = getattr(engine, 'raw_result', False)
    return response_validator.parse_result(result, undef_enabled=True, return_types=['NfsEncryptionConfig'], returns_list=False, raw_result=raw_result)

def set(engine, nfs_encryption_config=None):
    """
    Update the specified NfsEncryptionConfig object.

    :param engine: The Delphix Engine
    :type engine: :py:class:`delphixpy.delphix_engine.DelphixEngine`
    :param nfs_encryption_config: Payload object.
    :type nfs_encryption_config:
        :py:class:`delphixpy.web.vo.NfsEncryptionConfig`
    """
    url = "/resources/json/delphix/service/nfs/encryption"
    response = engine.post(url, nfs_encryption_config.to_dict(dirty=True) if nfs_encryption_config else None)
    result = response_validator.validate(response, engine)
    raw_result = getattr(engine, 'raw_result', False)
    return response_validator.parse_result(result, undef_enabled=True, return_types=None, returns_list=None, raw_result=raw_result)

