#!/usr/bin/env python
# 
# Copyright 2014, 2023 by Delphix
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import setuptools
from distutils.core import setup

setup(
    name='delphixpy',
    version='1.11.26.0',
    python_requires='>=3.6',
    description='Delphix Client Bindings',
    author='Delphix',
    author_email='support@delphix.com',
    url='http://www.delphix.com',
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: Apache Software License",
    ],
    long_description="""DelphixPy
=========

DelphixPy is a set of auto-generated Python API wrappers to the
Delphix Virtualization Engine.

Usage
------------

.. code:: python

   # Simple script to refresh a Database
   from delphixpy.delphix_engine import DelphixEngine
   engine = DelphixEngine(
       "delphix-address",
       "delphix-user",
       "delphix-password",
       "DOMAIN",  # Instead of DOMAIN, use SYSTEM if you are using the sysadmin user.
       use_https=True,  # Connect through HTTPS instead of default HTTP
    )
   database.refresh(engine, "ORACLE_DB_CONTAINER-3")

Many more examples can be found in the `DelphixPy Examples Repository <https://github.com/delphix/delphixpy-examples>`_


Supported API Versions
----------------------

DelphixPy supports Delphix Engines versioned 4.0.0.x or equivalently
Delphix Engines running API version 1.3.0 and on.


Changelog
---------

1.11.18
^^^^^^^
- Dropped support for python versions 3.5 and older.

1.10.5
^^^^^^
- Python3.7 introduces backwards incompatible syntax which breaks
  DelphixPy, to accomodate the `job_context.async` function has been
  renamed to `job_context.asyncly`.
- Drop support for Delphix Engines older than 4.1. API Versions: 1.3.0, 1.3.1, 1.3.2, 1.3.3
- Publish universal wheels.

1.10.3
^^^^^^
- API objects are now hashable in Python3
- Undefined objects now raise errors when their attributes are modified
- Various bug fixes

1.10.2
^^^^^^

- Python3 compatibility. Python2 and Python3 are both supported
  now. The Python2 wrappers will now require all strings be of
  type `unicode` and the Python3 wrappers will now require all
  strings to be of type `str`.

  This may cause regressions on existing Python2 code as seen by:
  `AssertionError: Expected one of [u'string'], but got <type 'str'>`

- Https support
- Various speed improvements
""",
    packages=[
        'delphixpy',
        'delphixpy/v1_5_3',
        'delphixpy/v1_5_3/web',
        'delphixpy/v1_5_3/web/authorization',
        'delphixpy/v1_5_3/web/permission',
        'delphixpy/v1_5_3/web/role',
        'delphixpy/v1_5_3/web/toolkit',
        'delphixpy/v1_5_3/web/environment',
        'delphixpy/v1_5_3/web/environment/user',
        'delphixpy/v1_5_3/web/environment/oracle',
        'delphixpy/v1_5_3/web/environment/oracle/listener',
        'delphixpy/v1_5_3/web/environment/oracle/clusternode',
        'delphixpy/v1_5_3/web/environment/windows',
        'delphixpy/v1_5_3/web/environment/windows/clusterinstance',
        'delphixpy/v1_5_3/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_5_3/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_5_3/web/environment/windows/clusternode',
        'delphixpy/v1_5_3/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_5_3/web/capacity',
        'delphixpy/v1_5_3/web/capacity/group',
        'delphixpy/v1_5_3/web/capacity/group/historical',
        'delphixpy/v1_5_3/web/capacity/consumer',
        'delphixpy/v1_5_3/web/capacity/consumer/historical',
        'delphixpy/v1_5_3/web/capacity/snapshot',
        'delphixpy/v1_5_3/web/capacity/system',
        'delphixpy/v1_5_3/web/capacity/system/historical',
        'delphixpy/v1_5_3/web/database',
        'delphixpy/v1_5_3/web/database/template',
        'delphixpy/v1_5_3/web/registration',
        'delphixpy/v1_5_3/web/registration/status',
        'delphixpy/v1_5_3/web/host',
        'delphixpy/v1_5_3/web/host/privilegeElevation',
        'delphixpy/v1_5_3/web/host/privilegeElevation/profile',
        'delphixpy/v1_5_3/web/data',
        'delphixpy/v1_5_3/web/repository',
        'delphixpy/v1_5_3/web/repository/template',
        'delphixpy/v1_5_3/web/policy',
        'delphixpy/v1_5_3/web/user',
        'delphixpy/v1_5_3/web/alert',
        'delphixpy/v1_5_3/web/alert/profile',
        'delphixpy/v1_5_3/web/objects',
        'delphixpy/v1_5_3/web/fault',
        'delphixpy/v1_5_3/web/fault/effect',
        'delphixpy/v1_5_3/web/group',
        'delphixpy/v1_5_3/web/connectivity',
        'delphixpy/v1_5_3/web/notification',
        'delphixpy/v1_5_3/web/delphix',
        'delphixpy/v1_5_3/web/job',
        'delphixpy/v1_5_3/web/about',
        'delphixpy/v1_5_3/web/timeflow',
        'delphixpy/v1_5_3/web/timeflow/bookmark',
        'delphixpy/v1_5_3/web/timeflow/oracle',
        'delphixpy/v1_5_3/web/timeflow/oracle/log',
        'delphixpy/v1_5_3/web/action',
        'delphixpy/v1_5_3/web/jetstream',
        'delphixpy/v1_5_3/web/jetstream/branch',
        'delphixpy/v1_5_3/web/jetstream/container',
        'delphixpy/v1_5_3/web/jetstream/usagedata',
        'delphixpy/v1_5_3/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_5_3/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_5_3/web/jetstream/bookmark',
        'delphixpy/v1_5_3/web/jetstream/datasource',
        'delphixpy/v1_5_3/web/jetstream/operation',
        'delphixpy/v1_5_3/web/jetstream/template',
        'delphixpy/v1_5_3/web/jetstream/usage',
        'delphixpy/v1_5_3/web/jetstream/usage/branch',
        'delphixpy/v1_5_3/web/jetstream/usage/user',
        'delphixpy/v1_5_3/web/jetstream/usage/container',
        'delphixpy/v1_5_3/web/jetstream/usage/bookmark',
        'delphixpy/v1_5_3/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_5_3/web/jetstream/usage/template',
        'delphixpy/v1_5_3/web/storage',
        'delphixpy/v1_5_3/web/storage/remove',
        'delphixpy/v1_5_3/web/storage/test',
        'delphixpy/v1_5_3/web/storage/device',
        'delphixpy/v1_5_3/web/storage/scrub',
        'delphixpy/v1_5_3/web/domain',
        'delphixpy/v1_5_3/web/analytics',
        'delphixpy/v1_5_3/web/analytics/statistic',
        'delphixpy/v1_5_3/web/snapshot',
        'delphixpy/v1_5_3/web/sourceconfig',
        'delphixpy/v1_5_3/web/sourceconfig/oracle',
        'delphixpy/v1_5_3/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_5_3/web/namespace',
        'delphixpy/v1_5_3/web/replication',
        'delphixpy/v1_5_3/web/replication/spec',
        'delphixpy/v1_5_3/web/replication/targetstate',
        'delphixpy/v1_5_3/web/replication/sourcestate',
        'delphixpy/v1_5_3/web/replication/serializationpoint',
        'delphixpy/v1_5_3/web/source',
        'delphixpy/v1_5_3/web/source/operationTemplate',
        'delphixpy/v1_5_3/web/service',
        'delphixpy/v1_5_3/web/service/smtp',
        'delphixpy/v1_5_3/web/service/ldap',
        'delphixpy/v1_5_3/web/service/ldap/server',
        'delphixpy/v1_5_3/web/service/snmp',
        'delphixpy/v1_5_3/web/service/snmp/manager',
        'delphixpy/v1_5_3/web/service/linkingsettings',
        'delphixpy/v1_5_3/web/service/phonehome',
        'delphixpy/v1_5_3/web/service/security',
        'delphixpy/v1_5_3/web/service/dns',
        'delphixpy/v1_5_3/web/service/schema',
        'delphixpy/v1_5_3/web/service/locale',
        'delphixpy/v1_5_3/web/service/proxy',
        'delphixpy/v1_5_3/web/service/certificate',
        'delphixpy/v1_5_3/web/service/time',
        'delphixpy/v1_5_3/web/service/syslog',
        'delphixpy/v1_5_3/web/service/support',
        'delphixpy/v1_5_3/web/service/support/access',
        'delphixpy/v1_5_3/web/service/support/bundle',
        'delphixpy/v1_5_3/web/system',
        'delphixpy/v1_5_3/web/system/version',
        'delphixpy/v1_5_3/web/network',
        'delphixpy/v1_5_3/web/network/route',
        'delphixpy/v1_5_3/web/network/test',
        'delphixpy/v1_5_3/web/network/test/latency',
        'delphixpy/v1_5_3/web/network/test/throughput',
        'delphixpy/v1_5_3/web/network/test/dsp',
        'delphixpy/v1_5_3/web/network/interface',
        'delphixpy/v1_5_3/web/session',
        'delphixpy/v1_10_2',
        'delphixpy/v1_10_2/web',
        'delphixpy/v1_10_2/web/authorization',
        'delphixpy/v1_10_2/web/authorization/configuration',
        'delphixpy/v1_10_2/web/permission',
        'delphixpy/v1_10_2/web/passwordPolicy',
        'delphixpy/v1_10_2/web/role',
        'delphixpy/v1_10_2/web/toolkit',
        'delphixpy/v1_10_2/web/environment',
        'delphixpy/v1_10_2/web/environment/user',
        'delphixpy/v1_10_2/web/environment/oracle',
        'delphixpy/v1_10_2/web/environment/oracle/listener',
        'delphixpy/v1_10_2/web/environment/oracle/clusternode',
        'delphixpy/v1_10_2/web/environment/windows',
        'delphixpy/v1_10_2/web/environment/windows/clusterinstance',
        'delphixpy/v1_10_2/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_10_2/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_10_2/web/environment/windows/clusternode',
        'delphixpy/v1_10_2/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_10_2/web/capacity',
        'delphixpy/v1_10_2/web/capacity/group',
        'delphixpy/v1_10_2/web/capacity/group/historical',
        'delphixpy/v1_10_2/web/capacity/consumer',
        'delphixpy/v1_10_2/web/capacity/consumer/historical',
        'delphixpy/v1_10_2/web/capacity/snapshot',
        'delphixpy/v1_10_2/web/capacity/system',
        'delphixpy/v1_10_2/web/capacity/system/historical',
        'delphixpy/v1_10_2/web/database',
        'delphixpy/v1_10_2/web/database/performanceHistory',
        'delphixpy/v1_10_2/web/database/template',
        'delphixpy/v1_10_2/web/registration',
        'delphixpy/v1_10_2/web/registration/status',
        'delphixpy/v1_10_2/web/host',
        'delphixpy/v1_10_2/web/host/privilegeElevation',
        'delphixpy/v1_10_2/web/host/privilegeElevation/profile',
        'delphixpy/v1_10_2/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_10_2/web/data',
        'delphixpy/v1_10_2/web/transformation',
        'delphixpy/v1_10_2/web/repository',
        'delphixpy/v1_10_2/web/repository/template',
        'delphixpy/v1_10_2/web/policy',
        'delphixpy/v1_10_2/web/user',
        'delphixpy/v1_10_2/web/alert',
        'delphixpy/v1_10_2/web/alert/profile',
        'delphixpy/v1_10_2/web/objects',
        'delphixpy/v1_10_2/web/maskingjob',
        'delphixpy/v1_10_2/web/maskingjob/serviceconfig',
        'delphixpy/v1_10_2/web/timezone',
        'delphixpy/v1_10_2/web/fault',
        'delphixpy/v1_10_2/web/fault/effect',
        'delphixpy/v1_10_2/web/group',
        'delphixpy/v1_10_2/web/connectivity',
        'delphixpy/v1_10_2/web/notification',
        'delphixpy/v1_10_2/web/delphix',
        'delphixpy/v1_10_2/web/job',
        'delphixpy/v1_10_2/web/about',
        'delphixpy/v1_10_2/web/timeflow',
        'delphixpy/v1_10_2/web/timeflow/bookmark',
        'delphixpy/v1_10_2/web/timeflow/oracle',
        'delphixpy/v1_10_2/web/timeflow/oracle/log',
        'delphixpy/v1_10_2/web/action',
        'delphixpy/v1_10_2/web/storage',
        'delphixpy/v1_10_2/web/storage/remove',
        'delphixpy/v1_10_2/web/storage/test',
        'delphixpy/v1_10_2/web/storage/device',
        'delphixpy/v1_10_2/web/storage/scrub',
        'delphixpy/v1_10_2/web/domain',
        'delphixpy/v1_10_2/web/analytics',
        'delphixpy/v1_10_2/web/analytics/statistic',
        'delphixpy/v1_10_2/web/selfservice',
        'delphixpy/v1_10_2/web/selfservice/branch',
        'delphixpy/v1_10_2/web/selfservice/container',
        'delphixpy/v1_10_2/web/selfservice/usagedata',
        'delphixpy/v1_10_2/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_10_2/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_10_2/web/selfservice/bookmark',
        'delphixpy/v1_10_2/web/selfservice/datasource',
        'delphixpy/v1_10_2/web/selfservice/operation',
        'delphixpy/v1_10_2/web/selfservice/template',
        'delphixpy/v1_10_2/web/selfservice/usage',
        'delphixpy/v1_10_2/web/selfservice/usage/branch',
        'delphixpy/v1_10_2/web/selfservice/usage/user',
        'delphixpy/v1_10_2/web/selfservice/usage/container',
        'delphixpy/v1_10_2/web/selfservice/usage/bookmark',
        'delphixpy/v1_10_2/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_10_2/web/selfservice/usage/template',
        'delphixpy/v1_10_2/web/selfservice/config',
        'delphixpy/v1_10_2/web/snapshot',
        'delphixpy/v1_10_2/web/sourceconfig',
        'delphixpy/v1_10_2/web/namespace',
        'delphixpy/v1_10_2/web/replication',
        'delphixpy/v1_10_2/web/replication/spec',
        'delphixpy/v1_10_2/web/replication/targetstate',
        'delphixpy/v1_10_2/web/replication/sourcestate',
        'delphixpy/v1_10_2/web/replication/serializationpoint',
        'delphixpy/v1_10_2/web/source',
        'delphixpy/v1_10_2/web/source/operationTemplate',
        'delphixpy/v1_10_2/web/service',
        'delphixpy/v1_10_2/web/service/smtp',
        'delphixpy/v1_10_2/web/service/ldap',
        'delphixpy/v1_10_2/web/service/ldap/server',
        'delphixpy/v1_10_2/web/service/snmp',
        'delphixpy/v1_10_2/web/service/snmp/manager',
        'delphixpy/v1_10_2/web/service/userInterface',
        'delphixpy/v1_10_2/web/service/linkingsettings',
        'delphixpy/v1_10_2/web/service/phonehome',
        'delphixpy/v1_10_2/web/service/httpConnector',
        'delphixpy/v1_10_2/web/service/security',
        'delphixpy/v1_10_2/web/service/dns',
        'delphixpy/v1_10_2/web/service/kerberos',
        'delphixpy/v1_10_2/web/service/schema',
        'delphixpy/v1_10_2/web/service/tls',
        'delphixpy/v1_10_2/web/service/tls/endEntityCertificate',
        'delphixpy/v1_10_2/web/service/tls/csr',
        'delphixpy/v1_10_2/web/service/tls/cipherSuite',
        'delphixpy/v1_10_2/web/service/tls/caCertificate',
        'delphixpy/v1_10_2/web/service/insight',
        'delphixpy/v1_10_2/web/service/insight/splunkHec',
        'delphixpy/v1_10_2/web/service/saml',
        'delphixpy/v1_10_2/web/service/saml/serviceprovider',
        'delphixpy/v1_10_2/web/service/locale',
        'delphixpy/v1_10_2/web/service/cloud',
        'delphixpy/v1_10_2/web/service/proxy',
        'delphixpy/v1_10_2/web/service/certificate',
        'delphixpy/v1_10_2/web/service/time',
        'delphixpy/v1_10_2/web/service/syslog',
        'delphixpy/v1_10_2/web/service/support',
        'delphixpy/v1_10_2/web/service/support/access',
        'delphixpy/v1_10_2/web/service/support/bundle',
        'delphixpy/v1_10_2/web/system',
        'delphixpy/v1_10_2/web/system/upgradeCheckResult',
        'delphixpy/v1_10_2/web/system/status',
        'delphixpy/v1_10_2/web/system/version',
        'delphixpy/v1_10_2/web/system/package',
        'delphixpy/v1_10_2/web/network',
        'delphixpy/v1_10_2/web/network/route',
        'delphixpy/v1_10_2/web/network/test',
        'delphixpy/v1_10_2/web/network/test/latency',
        'delphixpy/v1_10_2/web/network/test/throughput',
        'delphixpy/v1_10_2/web/network/test/dsp',
        'delphixpy/v1_10_2/web/network/interface',
        'delphixpy/v1_10_2/web/network/dsp',
        'delphixpy/v1_10_2/web/network/dsp/autotune',
        'delphixpy/v1_10_2/web/session',
        'delphixpy/v1_8_2',
        'delphixpy/v1_8_2/web',
        'delphixpy/v1_8_2/web/authorization',
        'delphixpy/v1_8_2/web/permission',
        'delphixpy/v1_8_2/web/role',
        'delphixpy/v1_8_2/web/toolkit',
        'delphixpy/v1_8_2/web/environment',
        'delphixpy/v1_8_2/web/environment/user',
        'delphixpy/v1_8_2/web/environment/oracle',
        'delphixpy/v1_8_2/web/environment/oracle/listener',
        'delphixpy/v1_8_2/web/environment/oracle/clusternode',
        'delphixpy/v1_8_2/web/environment/windows',
        'delphixpy/v1_8_2/web/environment/windows/clusterinstance',
        'delphixpy/v1_8_2/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_8_2/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_8_2/web/environment/windows/clusternode',
        'delphixpy/v1_8_2/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_8_2/web/capacity',
        'delphixpy/v1_8_2/web/capacity/group',
        'delphixpy/v1_8_2/web/capacity/group/historical',
        'delphixpy/v1_8_2/web/capacity/consumer',
        'delphixpy/v1_8_2/web/capacity/consumer/historical',
        'delphixpy/v1_8_2/web/capacity/snapshot',
        'delphixpy/v1_8_2/web/capacity/system',
        'delphixpy/v1_8_2/web/capacity/system/historical',
        'delphixpy/v1_8_2/web/database',
        'delphixpy/v1_8_2/web/database/template',
        'delphixpy/v1_8_2/web/registration',
        'delphixpy/v1_8_2/web/registration/status',
        'delphixpy/v1_8_2/web/host',
        'delphixpy/v1_8_2/web/host/privilegeElevation',
        'delphixpy/v1_8_2/web/host/privilegeElevation/profile',
        'delphixpy/v1_8_2/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_8_2/web/data',
        'delphixpy/v1_8_2/web/transformation',
        'delphixpy/v1_8_2/web/repository',
        'delphixpy/v1_8_2/web/repository/template',
        'delphixpy/v1_8_2/web/policy',
        'delphixpy/v1_8_2/web/user',
        'delphixpy/v1_8_2/web/alert',
        'delphixpy/v1_8_2/web/alert/profile',
        'delphixpy/v1_8_2/web/objects',
        'delphixpy/v1_8_2/web/maskingjob',
        'delphixpy/v1_8_2/web/maskingjob/serviceconfig',
        'delphixpy/v1_8_2/web/timezone',
        'delphixpy/v1_8_2/web/fault',
        'delphixpy/v1_8_2/web/fault/effect',
        'delphixpy/v1_8_2/web/group',
        'delphixpy/v1_8_2/web/connectivity',
        'delphixpy/v1_8_2/web/notification',
        'delphixpy/v1_8_2/web/delphix',
        'delphixpy/v1_8_2/web/job',
        'delphixpy/v1_8_2/web/about',
        'delphixpy/v1_8_2/web/timeflow',
        'delphixpy/v1_8_2/web/timeflow/bookmark',
        'delphixpy/v1_8_2/web/timeflow/oracle',
        'delphixpy/v1_8_2/web/timeflow/oracle/log',
        'delphixpy/v1_8_2/web/action',
        'delphixpy/v1_8_2/web/jetstream',
        'delphixpy/v1_8_2/web/jetstream/branch',
        'delphixpy/v1_8_2/web/jetstream/container',
        'delphixpy/v1_8_2/web/jetstream/usagedata',
        'delphixpy/v1_8_2/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_8_2/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_8_2/web/jetstream/bookmark',
        'delphixpy/v1_8_2/web/jetstream/datasource',
        'delphixpy/v1_8_2/web/jetstream/operation',
        'delphixpy/v1_8_2/web/jetstream/template',
        'delphixpy/v1_8_2/web/jetstream/usage',
        'delphixpy/v1_8_2/web/jetstream/usage/branch',
        'delphixpy/v1_8_2/web/jetstream/usage/user',
        'delphixpy/v1_8_2/web/jetstream/usage/container',
        'delphixpy/v1_8_2/web/jetstream/usage/bookmark',
        'delphixpy/v1_8_2/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_8_2/web/jetstream/usage/template',
        'delphixpy/v1_8_2/web/storage',
        'delphixpy/v1_8_2/web/storage/remove',
        'delphixpy/v1_8_2/web/storage/test',
        'delphixpy/v1_8_2/web/storage/device',
        'delphixpy/v1_8_2/web/storage/scrub',
        'delphixpy/v1_8_2/web/domain',
        'delphixpy/v1_8_2/web/analytics',
        'delphixpy/v1_8_2/web/analytics/statistic',
        'delphixpy/v1_8_2/web/snapshot',
        'delphixpy/v1_8_2/web/sourceconfig',
        'delphixpy/v1_8_2/web/sourceconfig/oracle',
        'delphixpy/v1_8_2/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_8_2/web/namespace',
        'delphixpy/v1_8_2/web/replication',
        'delphixpy/v1_8_2/web/replication/spec',
        'delphixpy/v1_8_2/web/replication/targetstate',
        'delphixpy/v1_8_2/web/replication/sourcestate',
        'delphixpy/v1_8_2/web/replication/serializationpoint',
        'delphixpy/v1_8_2/web/source',
        'delphixpy/v1_8_2/web/source/operationTemplate',
        'delphixpy/v1_8_2/web/service',
        'delphixpy/v1_8_2/web/service/smtp',
        'delphixpy/v1_8_2/web/service/ldap',
        'delphixpy/v1_8_2/web/service/ldap/server',
        'delphixpy/v1_8_2/web/service/snmp',
        'delphixpy/v1_8_2/web/service/snmp/manager',
        'delphixpy/v1_8_2/web/service/linkingsettings',
        'delphixpy/v1_8_2/web/service/phonehome',
        'delphixpy/v1_8_2/web/service/httpConnector',
        'delphixpy/v1_8_2/web/service/security',
        'delphixpy/v1_8_2/web/service/dns',
        'delphixpy/v1_8_2/web/service/kerberos',
        'delphixpy/v1_8_2/web/service/schema',
        'delphixpy/v1_8_2/web/service/saml',
        'delphixpy/v1_8_2/web/service/saml/serviceprovider',
        'delphixpy/v1_8_2/web/service/locale',
        'delphixpy/v1_8_2/web/service/proxy',
        'delphixpy/v1_8_2/web/service/certificate',
        'delphixpy/v1_8_2/web/service/time',
        'delphixpy/v1_8_2/web/service/syslog',
        'delphixpy/v1_8_2/web/service/support',
        'delphixpy/v1_8_2/web/service/support/access',
        'delphixpy/v1_8_2/web/service/support/bundle',
        'delphixpy/v1_8_2/web/system',
        'delphixpy/v1_8_2/web/system/version',
        'delphixpy/v1_8_2/web/network',
        'delphixpy/v1_8_2/web/network/route',
        'delphixpy/v1_8_2/web/network/test',
        'delphixpy/v1_8_2/web/network/test/latency',
        'delphixpy/v1_8_2/web/network/test/throughput',
        'delphixpy/v1_8_2/web/network/test/dsp',
        'delphixpy/v1_8_2/web/network/interface',
        'delphixpy/v1_8_2/web/session',
        'delphixpy/v1_10_4',
        'delphixpy/v1_10_4/web',
        'delphixpy/v1_10_4/web/authorization',
        'delphixpy/v1_10_4/web/authorization/configuration',
        'delphixpy/v1_10_4/web/permission',
        'delphixpy/v1_10_4/web/passwordPolicy',
        'delphixpy/v1_10_4/web/role',
        'delphixpy/v1_10_4/web/toolkit',
        'delphixpy/v1_10_4/web/environment',
        'delphixpy/v1_10_4/web/environment/user',
        'delphixpy/v1_10_4/web/environment/oracle',
        'delphixpy/v1_10_4/web/environment/oracle/listener',
        'delphixpy/v1_10_4/web/environment/oracle/clusternode',
        'delphixpy/v1_10_4/web/environment/windows',
        'delphixpy/v1_10_4/web/environment/windows/clusterinstance',
        'delphixpy/v1_10_4/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_10_4/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_10_4/web/environment/windows/clusternode',
        'delphixpy/v1_10_4/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_10_4/web/capacity',
        'delphixpy/v1_10_4/web/capacity/group',
        'delphixpy/v1_10_4/web/capacity/group/historical',
        'delphixpy/v1_10_4/web/capacity/consumer',
        'delphixpy/v1_10_4/web/capacity/consumer/historical',
        'delphixpy/v1_10_4/web/capacity/snapshot',
        'delphixpy/v1_10_4/web/capacity/system',
        'delphixpy/v1_10_4/web/capacity/system/historical',
        'delphixpy/v1_10_4/web/database',
        'delphixpy/v1_10_4/web/database/performanceHistory',
        'delphixpy/v1_10_4/web/database/template',
        'delphixpy/v1_10_4/web/registration',
        'delphixpy/v1_10_4/web/registration/status',
        'delphixpy/v1_10_4/web/host',
        'delphixpy/v1_10_4/web/host/privilegeElevation',
        'delphixpy/v1_10_4/web/host/privilegeElevation/profile',
        'delphixpy/v1_10_4/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_10_4/web/data',
        'delphixpy/v1_10_4/web/transformation',
        'delphixpy/v1_10_4/web/repository',
        'delphixpy/v1_10_4/web/repository/template',
        'delphixpy/v1_10_4/web/policy',
        'delphixpy/v1_10_4/web/user',
        'delphixpy/v1_10_4/web/alert',
        'delphixpy/v1_10_4/web/alert/profile',
        'delphixpy/v1_10_4/web/objects',
        'delphixpy/v1_10_4/web/maskingjob',
        'delphixpy/v1_10_4/web/maskingjob/serviceconfig',
        'delphixpy/v1_10_4/web/timezone',
        'delphixpy/v1_10_4/web/fault',
        'delphixpy/v1_10_4/web/fault/effect',
        'delphixpy/v1_10_4/web/group',
        'delphixpy/v1_10_4/web/connectivity',
        'delphixpy/v1_10_4/web/notification',
        'delphixpy/v1_10_4/web/delphix',
        'delphixpy/v1_10_4/web/job',
        'delphixpy/v1_10_4/web/usage',
        'delphixpy/v1_10_4/web/about',
        'delphixpy/v1_10_4/web/timeflow',
        'delphixpy/v1_10_4/web/timeflow/bookmark',
        'delphixpy/v1_10_4/web/timeflow/oracle',
        'delphixpy/v1_10_4/web/timeflow/oracle/log',
        'delphixpy/v1_10_4/web/action',
        'delphixpy/v1_10_4/web/storage',
        'delphixpy/v1_10_4/web/storage/remove',
        'delphixpy/v1_10_4/web/storage/test',
        'delphixpy/v1_10_4/web/storage/device',
        'delphixpy/v1_10_4/web/storage/scrub',
        'delphixpy/v1_10_4/web/domain',
        'delphixpy/v1_10_4/web/analytics',
        'delphixpy/v1_10_4/web/analytics/statistic',
        'delphixpy/v1_10_4/web/selfservice',
        'delphixpy/v1_10_4/web/selfservice/branch',
        'delphixpy/v1_10_4/web/selfservice/container',
        'delphixpy/v1_10_4/web/selfservice/usagedata',
        'delphixpy/v1_10_4/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_10_4/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_10_4/web/selfservice/bookmark',
        'delphixpy/v1_10_4/web/selfservice/datasource',
        'delphixpy/v1_10_4/web/selfservice/operation',
        'delphixpy/v1_10_4/web/selfservice/template',
        'delphixpy/v1_10_4/web/selfservice/usage',
        'delphixpy/v1_10_4/web/selfservice/usage/branch',
        'delphixpy/v1_10_4/web/selfservice/usage/user',
        'delphixpy/v1_10_4/web/selfservice/usage/container',
        'delphixpy/v1_10_4/web/selfservice/usage/bookmark',
        'delphixpy/v1_10_4/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_10_4/web/selfservice/usage/template',
        'delphixpy/v1_10_4/web/selfservice/config',
        'delphixpy/v1_10_4/web/snapshot',
        'delphixpy/v1_10_4/web/sourceconfig',
        'delphixpy/v1_10_4/web/namespace',
        'delphixpy/v1_10_4/web/replication',
        'delphixpy/v1_10_4/web/replication/spec',
        'delphixpy/v1_10_4/web/replication/targetstate',
        'delphixpy/v1_10_4/web/replication/sourcestate',
        'delphixpy/v1_10_4/web/replication/serializationpoint',
        'delphixpy/v1_10_4/web/source',
        'delphixpy/v1_10_4/web/source/operationTemplate',
        'delphixpy/v1_10_4/web/service',
        'delphixpy/v1_10_4/web/service/smtp',
        'delphixpy/v1_10_4/web/service/ldap',
        'delphixpy/v1_10_4/web/service/ldap/server',
        'delphixpy/v1_10_4/web/service/snmp',
        'delphixpy/v1_10_4/web/service/snmp/manager',
        'delphixpy/v1_10_4/web/service/userInterface',
        'delphixpy/v1_10_4/web/service/linkingsettings',
        'delphixpy/v1_10_4/web/service/phonehome',
        'delphixpy/v1_10_4/web/service/httpConnector',
        'delphixpy/v1_10_4/web/service/security',
        'delphixpy/v1_10_4/web/service/dns',
        'delphixpy/v1_10_4/web/service/kerberos',
        'delphixpy/v1_10_4/web/service/schema',
        'delphixpy/v1_10_4/web/service/tls',
        'delphixpy/v1_10_4/web/service/tls/endEntityCertificate',
        'delphixpy/v1_10_4/web/service/tls/csr',
        'delphixpy/v1_10_4/web/service/tls/cipherSuite',
        'delphixpy/v1_10_4/web/service/tls/caCertificate',
        'delphixpy/v1_10_4/web/service/insight',
        'delphixpy/v1_10_4/web/service/insight/splunkHec',
        'delphixpy/v1_10_4/web/service/saml',
        'delphixpy/v1_10_4/web/service/saml/serviceprovider',
        'delphixpy/v1_10_4/web/service/locale',
        'delphixpy/v1_10_4/web/service/cloud',
        'delphixpy/v1_10_4/web/service/proxy',
        'delphixpy/v1_10_4/web/service/certificate',
        'delphixpy/v1_10_4/web/service/time',
        'delphixpy/v1_10_4/web/service/syslog',
        'delphixpy/v1_10_4/web/service/support',
        'delphixpy/v1_10_4/web/service/support/access',
        'delphixpy/v1_10_4/web/service/support/bundle',
        'delphixpy/v1_10_4/web/service/sso',
        'delphixpy/v1_10_4/web/system',
        'delphixpy/v1_10_4/web/system/upgradeCheckResult',
        'delphixpy/v1_10_4/web/system/status',
        'delphixpy/v1_10_4/web/system/version',
        'delphixpy/v1_10_4/web/system/package',
        'delphixpy/v1_10_4/web/network',
        'delphixpy/v1_10_4/web/network/route',
        'delphixpy/v1_10_4/web/network/test',
        'delphixpy/v1_10_4/web/network/test/latency',
        'delphixpy/v1_10_4/web/network/test/throughput',
        'delphixpy/v1_10_4/web/network/test/dsp',
        'delphixpy/v1_10_4/web/network/interface',
        'delphixpy/v1_10_4/web/network/dsp',
        'delphixpy/v1_10_4/web/network/dsp/autotune',
        'delphixpy/v1_10_4/web/session',
        'delphixpy/v1_11_4',
        'delphixpy/v1_11_4/web',
        'delphixpy/v1_11_4/web/authorization',
        'delphixpy/v1_11_4/web/authorization/configuration',
        'delphixpy/v1_11_4/web/permission',
        'delphixpy/v1_11_4/web/passwordPolicy',
        'delphixpy/v1_11_4/web/role',
        'delphixpy/v1_11_4/web/toolkit',
        'delphixpy/v1_11_4/web/environment',
        'delphixpy/v1_11_4/web/environment/user',
        'delphixpy/v1_11_4/web/environment/oracle',
        'delphixpy/v1_11_4/web/environment/oracle/listener',
        'delphixpy/v1_11_4/web/environment/oracle/clusternode',
        'delphixpy/v1_11_4/web/environment/windows',
        'delphixpy/v1_11_4/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_4/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_4/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_4/web/environment/windows/clusternode',
        'delphixpy/v1_11_4/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_4/web/capacity',
        'delphixpy/v1_11_4/web/capacity/group',
        'delphixpy/v1_11_4/web/capacity/group/historical',
        'delphixpy/v1_11_4/web/capacity/consumer',
        'delphixpy/v1_11_4/web/capacity/consumer/historical',
        'delphixpy/v1_11_4/web/capacity/snapshot',
        'delphixpy/v1_11_4/web/capacity/system',
        'delphixpy/v1_11_4/web/capacity/system/historical',
        'delphixpy/v1_11_4/web/database',
        'delphixpy/v1_11_4/web/database/performanceHistory',
        'delphixpy/v1_11_4/web/database/template',
        'delphixpy/v1_11_4/web/registration',
        'delphixpy/v1_11_4/web/registration/status',
        'delphixpy/v1_11_4/web/host',
        'delphixpy/v1_11_4/web/host/privilegeElevation',
        'delphixpy/v1_11_4/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_4/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_4/web/theme',
        'delphixpy/v1_11_4/web/data',
        'delphixpy/v1_11_4/web/transformation',
        'delphixpy/v1_11_4/web/repository',
        'delphixpy/v1_11_4/web/repository/template',
        'delphixpy/v1_11_4/web/policy',
        'delphixpy/v1_11_4/web/user',
        'delphixpy/v1_11_4/web/alert',
        'delphixpy/v1_11_4/web/alert/profile',
        'delphixpy/v1_11_4/web/objects',
        'delphixpy/v1_11_4/web/maskingjob',
        'delphixpy/v1_11_4/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_4/web/timezone',
        'delphixpy/v1_11_4/web/fault',
        'delphixpy/v1_11_4/web/fault/effect',
        'delphixpy/v1_11_4/web/group',
        'delphixpy/v1_11_4/web/license',
        'delphixpy/v1_11_4/web/connectivity',
        'delphixpy/v1_11_4/web/notification',
        'delphixpy/v1_11_4/web/delphix',
        'delphixpy/v1_11_4/web/job',
        'delphixpy/v1_11_4/web/usage',
        'delphixpy/v1_11_4/web/about',
        'delphixpy/v1_11_4/web/timeflow',
        'delphixpy/v1_11_4/web/timeflow/bookmark',
        'delphixpy/v1_11_4/web/timeflow/oracle',
        'delphixpy/v1_11_4/web/timeflow/oracle/log',
        'delphixpy/v1_11_4/web/action',
        'delphixpy/v1_11_4/web/storage',
        'delphixpy/v1_11_4/web/storage/remove',
        'delphixpy/v1_11_4/web/storage/test',
        'delphixpy/v1_11_4/web/storage/device',
        'delphixpy/v1_11_4/web/storage/scrub',
        'delphixpy/v1_11_4/web/domain',
        'delphixpy/v1_11_4/web/analytics',
        'delphixpy/v1_11_4/web/analytics/statistic',
        'delphixpy/v1_11_4/web/selfservice',
        'delphixpy/v1_11_4/web/selfservice/branch',
        'delphixpy/v1_11_4/web/selfservice/container',
        'delphixpy/v1_11_4/web/selfservice/usagedata',
        'delphixpy/v1_11_4/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_4/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_4/web/selfservice/bookmark',
        'delphixpy/v1_11_4/web/selfservice/datasource',
        'delphixpy/v1_11_4/web/selfservice/operation',
        'delphixpy/v1_11_4/web/selfservice/template',
        'delphixpy/v1_11_4/web/selfservice/usage',
        'delphixpy/v1_11_4/web/selfservice/usage/branch',
        'delphixpy/v1_11_4/web/selfservice/usage/user',
        'delphixpy/v1_11_4/web/selfservice/usage/container',
        'delphixpy/v1_11_4/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_4/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_4/web/selfservice/usage/template',
        'delphixpy/v1_11_4/web/selfservice/config',
        'delphixpy/v1_11_4/web/snapshot',
        'delphixpy/v1_11_4/web/sourceconfig',
        'delphixpy/v1_11_4/web/namespace',
        'delphixpy/v1_11_4/web/replication',
        'delphixpy/v1_11_4/web/replication/spec',
        'delphixpy/v1_11_4/web/replication/targetstate',
        'delphixpy/v1_11_4/web/replication/sourcestate',
        'delphixpy/v1_11_4/web/replication/serializationpoint',
        'delphixpy/v1_11_4/web/source',
        'delphixpy/v1_11_4/web/source/operationTemplate',
        'delphixpy/v1_11_4/web/service',
        'delphixpy/v1_11_4/web/service/smtp',
        'delphixpy/v1_11_4/web/service/ldap',
        'delphixpy/v1_11_4/web/service/ldap/server',
        'delphixpy/v1_11_4/web/service/nfs',
        'delphixpy/v1_11_4/web/service/snmp',
        'delphixpy/v1_11_4/web/service/snmp/manager',
        'delphixpy/v1_11_4/web/service/userInterface',
        'delphixpy/v1_11_4/web/service/linkingsettings',
        'delphixpy/v1_11_4/web/service/phonehome',
        'delphixpy/v1_11_4/web/service/httpConnector',
        'delphixpy/v1_11_4/web/service/userPaths',
        'delphixpy/v1_11_4/web/service/security',
        'delphixpy/v1_11_4/web/service/dns',
        'delphixpy/v1_11_4/web/service/kerberos',
        'delphixpy/v1_11_4/web/service/schema',
        'delphixpy/v1_11_4/web/service/tls',
        'delphixpy/v1_11_4/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_4/web/service/tls/csr',
        'delphixpy/v1_11_4/web/service/tls/cipherSuite',
        'delphixpy/v1_11_4/web/service/tls/caCertificate',
        'delphixpy/v1_11_4/web/service/insight',
        'delphixpy/v1_11_4/web/service/insight/splunkHec',
        'delphixpy/v1_11_4/web/service/locale',
        'delphixpy/v1_11_4/web/service/cloud',
        'delphixpy/v1_11_4/web/service/proxy',
        'delphixpy/v1_11_4/web/service/certificate',
        'delphixpy/v1_11_4/web/service/time',
        'delphixpy/v1_11_4/web/service/syslog',
        'delphixpy/v1_11_4/web/service/support',
        'delphixpy/v1_11_4/web/service/support/access',
        'delphixpy/v1_11_4/web/service/support/bundle',
        'delphixpy/v1_11_4/web/service/minimalPhonehome',
        'delphixpy/v1_11_4/web/service/passwordVault',
        'delphixpy/v1_11_4/web/service/sso',
        'delphixpy/v1_11_4/web/system',
        'delphixpy/v1_11_4/web/system/verification',
        'delphixpy/v1_11_4/web/system/verification/reports',
        'delphixpy/v1_11_4/web/system/verification/reports/steps',
        'delphixpy/v1_11_4/web/system/upgradeCheckResult',
        'delphixpy/v1_11_4/web/system/status',
        'delphixpy/v1_11_4/web/system/version',
        'delphixpy/v1_11_4/web/system/package',
        'delphixpy/v1_11_4/web/network',
        'delphixpy/v1_11_4/web/network/route',
        'delphixpy/v1_11_4/web/network/test',
        'delphixpy/v1_11_4/web/network/test/latency',
        'delphixpy/v1_11_4/web/network/test/throughput',
        'delphixpy/v1_11_4/web/network/test/dsp',
        'delphixpy/v1_11_4/web/network/interface',
        'delphixpy/v1_11_4/web/network/dsp',
        'delphixpy/v1_11_4/web/network/dsp/autotune',
        'delphixpy/v1_11_4/web/session',
        'delphixpy/v1_4_3',
        'delphixpy/v1_4_3/web',
        'delphixpy/v1_4_3/web/authorization',
        'delphixpy/v1_4_3/web/permission',
        'delphixpy/v1_4_3/web/role',
        'delphixpy/v1_4_3/web/toolkit',
        'delphixpy/v1_4_3/web/environment',
        'delphixpy/v1_4_3/web/environment/user',
        'delphixpy/v1_4_3/web/environment/oracle',
        'delphixpy/v1_4_3/web/environment/oracle/listener',
        'delphixpy/v1_4_3/web/environment/oracle/clusternode',
        'delphixpy/v1_4_3/web/environment/windows',
        'delphixpy/v1_4_3/web/environment/windows/clusterinstance',
        'delphixpy/v1_4_3/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_4_3/web/environment/windows/clusternode',
        'delphixpy/v1_4_3/web/capacity',
        'delphixpy/v1_4_3/web/capacity/group',
        'delphixpy/v1_4_3/web/capacity/group/historical',
        'delphixpy/v1_4_3/web/capacity/consumer',
        'delphixpy/v1_4_3/web/capacity/consumer/historical',
        'delphixpy/v1_4_3/web/capacity/snapshot',
        'delphixpy/v1_4_3/web/capacity/system',
        'delphixpy/v1_4_3/web/capacity/system/historical',
        'delphixpy/v1_4_3/web/database',
        'delphixpy/v1_4_3/web/database/template',
        'delphixpy/v1_4_3/web/registration',
        'delphixpy/v1_4_3/web/registration/status',
        'delphixpy/v1_4_3/web/host',
        'delphixpy/v1_4_3/web/host/privilegeElevation',
        'delphixpy/v1_4_3/web/host/privilegeElevation/profile',
        'delphixpy/v1_4_3/web/data',
        'delphixpy/v1_4_3/web/repository',
        'delphixpy/v1_4_3/web/policy',
        'delphixpy/v1_4_3/web/user',
        'delphixpy/v1_4_3/web/alert',
        'delphixpy/v1_4_3/web/alert/profile',
        'delphixpy/v1_4_3/web/objects',
        'delphixpy/v1_4_3/web/fault',
        'delphixpy/v1_4_3/web/fault/effect',
        'delphixpy/v1_4_3/web/group',
        'delphixpy/v1_4_3/web/connectivity',
        'delphixpy/v1_4_3/web/notification',
        'delphixpy/v1_4_3/web/delphix',
        'delphixpy/v1_4_3/web/job',
        'delphixpy/v1_4_3/web/about',
        'delphixpy/v1_4_3/web/timeflow',
        'delphixpy/v1_4_3/web/timeflow/bookmark',
        'delphixpy/v1_4_3/web/action',
        'delphixpy/v1_4_3/web/jetstream',
        'delphixpy/v1_4_3/web/jetstream/branch',
        'delphixpy/v1_4_3/web/jetstream/capacity',
        'delphixpy/v1_4_3/web/jetstream/capacity/branch',
        'delphixpy/v1_4_3/web/jetstream/capacity/container',
        'delphixpy/v1_4_3/web/jetstream/capacity/bookmark',
        'delphixpy/v1_4_3/web/jetstream/capacity/bookmark/tag',
        'delphixpy/v1_4_3/web/jetstream/capacity/template',
        'delphixpy/v1_4_3/web/jetstream/preferences',
        'delphixpy/v1_4_3/web/jetstream/container',
        'delphixpy/v1_4_3/web/jetstream/usagedata',
        'delphixpy/v1_4_3/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_4_3/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_4_3/web/jetstream/bookmark',
        'delphixpy/v1_4_3/web/jetstream/datasource',
        'delphixpy/v1_4_3/web/jetstream/operation',
        'delphixpy/v1_4_3/web/jetstream/template',
        'delphixpy/v1_4_3/web/storage',
        'delphixpy/v1_4_3/web/storage/device',
        'delphixpy/v1_4_3/web/storage/scrub',
        'delphixpy/v1_4_3/web/domain',
        'delphixpy/v1_4_3/web/analytics',
        'delphixpy/v1_4_3/web/analytics/statistic',
        'delphixpy/v1_4_3/web/snapshot',
        'delphixpy/v1_4_3/web/sourceconfig',
        'delphixpy/v1_4_3/web/sourceconfig/oracle',
        'delphixpy/v1_4_3/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_4_3/web/namespace',
        'delphixpy/v1_4_3/web/replication',
        'delphixpy/v1_4_3/web/replication/spec',
        'delphixpy/v1_4_3/web/source',
        'delphixpy/v1_4_3/web/service',
        'delphixpy/v1_4_3/web/service/smtp',
        'delphixpy/v1_4_3/web/service/ldap',
        'delphixpy/v1_4_3/web/service/ldap/server',
        'delphixpy/v1_4_3/web/service/snmp',
        'delphixpy/v1_4_3/web/service/snmp/manager',
        'delphixpy/v1_4_3/web/service/linkingsettings',
        'delphixpy/v1_4_3/web/service/phonehome',
        'delphixpy/v1_4_3/web/service/security',
        'delphixpy/v1_4_3/web/service/dns',
        'delphixpy/v1_4_3/web/service/locale',
        'delphixpy/v1_4_3/web/service/proxy',
        'delphixpy/v1_4_3/web/service/certificate',
        'delphixpy/v1_4_3/web/service/time',
        'delphixpy/v1_4_3/web/service/syslog',
        'delphixpy/v1_4_3/web/service/support',
        'delphixpy/v1_4_3/web/service/support/access',
        'delphixpy/v1_4_3/web/service/support/bundle',
        'delphixpy/v1_4_3/web/system',
        'delphixpy/v1_4_3/web/system/version',
        'delphixpy/v1_4_3/web/network',
        'delphixpy/v1_4_3/web/network/route',
        'delphixpy/v1_4_3/web/network/test',
        'delphixpy/v1_4_3/web/network/test/latency',
        'delphixpy/v1_4_3/web/network/test/throughput',
        'delphixpy/v1_4_3/web/network/interface',
        'delphixpy/v1_4_3/web/session',
        'delphixpy/v1_9_2',
        'delphixpy/v1_9_2/web',
        'delphixpy/v1_9_2/web/authorization',
        'delphixpy/v1_9_2/web/permission',
        'delphixpy/v1_9_2/web/passwordPolicy',
        'delphixpy/v1_9_2/web/role',
        'delphixpy/v1_9_2/web/toolkit',
        'delphixpy/v1_9_2/web/environment',
        'delphixpy/v1_9_2/web/environment/user',
        'delphixpy/v1_9_2/web/environment/oracle',
        'delphixpy/v1_9_2/web/environment/oracle/listener',
        'delphixpy/v1_9_2/web/environment/oracle/clusternode',
        'delphixpy/v1_9_2/web/environment/windows',
        'delphixpy/v1_9_2/web/environment/windows/clusterinstance',
        'delphixpy/v1_9_2/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_9_2/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_9_2/web/environment/windows/clusternode',
        'delphixpy/v1_9_2/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_9_2/web/capacity',
        'delphixpy/v1_9_2/web/capacity/group',
        'delphixpy/v1_9_2/web/capacity/group/historical',
        'delphixpy/v1_9_2/web/capacity/consumer',
        'delphixpy/v1_9_2/web/capacity/consumer/historical',
        'delphixpy/v1_9_2/web/capacity/snapshot',
        'delphixpy/v1_9_2/web/capacity/system',
        'delphixpy/v1_9_2/web/capacity/system/historical',
        'delphixpy/v1_9_2/web/database',
        'delphixpy/v1_9_2/web/database/performanceHistory',
        'delphixpy/v1_9_2/web/database/template',
        'delphixpy/v1_9_2/web/registration',
        'delphixpy/v1_9_2/web/registration/status',
        'delphixpy/v1_9_2/web/host',
        'delphixpy/v1_9_2/web/host/privilegeElevation',
        'delphixpy/v1_9_2/web/host/privilegeElevation/profile',
        'delphixpy/v1_9_2/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_9_2/web/data',
        'delphixpy/v1_9_2/web/transformation',
        'delphixpy/v1_9_2/web/repository',
        'delphixpy/v1_9_2/web/repository/template',
        'delphixpy/v1_9_2/web/policy',
        'delphixpy/v1_9_2/web/user',
        'delphixpy/v1_9_2/web/alert',
        'delphixpy/v1_9_2/web/alert/profile',
        'delphixpy/v1_9_2/web/objects',
        'delphixpy/v1_9_2/web/maskingjob',
        'delphixpy/v1_9_2/web/maskingjob/serviceconfig',
        'delphixpy/v1_9_2/web/timezone',
        'delphixpy/v1_9_2/web/fault',
        'delphixpy/v1_9_2/web/fault/effect',
        'delphixpy/v1_9_2/web/group',
        'delphixpy/v1_9_2/web/connectivity',
        'delphixpy/v1_9_2/web/notification',
        'delphixpy/v1_9_2/web/insight',
        'delphixpy/v1_9_2/web/insight/splunkHec',
        'delphixpy/v1_9_2/web/delphix',
        'delphixpy/v1_9_2/web/job',
        'delphixpy/v1_9_2/web/about',
        'delphixpy/v1_9_2/web/timeflow',
        'delphixpy/v1_9_2/web/timeflow/bookmark',
        'delphixpy/v1_9_2/web/timeflow/oracle',
        'delphixpy/v1_9_2/web/timeflow/oracle/log',
        'delphixpy/v1_9_2/web/action',
        'delphixpy/v1_9_2/web/storage',
        'delphixpy/v1_9_2/web/storage/remove',
        'delphixpy/v1_9_2/web/storage/test',
        'delphixpy/v1_9_2/web/storage/device',
        'delphixpy/v1_9_2/web/storage/scrub',
        'delphixpy/v1_9_2/web/domain',
        'delphixpy/v1_9_2/web/analytics',
        'delphixpy/v1_9_2/web/analytics/statistic',
        'delphixpy/v1_9_2/web/selfservice',
        'delphixpy/v1_9_2/web/selfservice/branch',
        'delphixpy/v1_9_2/web/selfservice/container',
        'delphixpy/v1_9_2/web/selfservice/usagedata',
        'delphixpy/v1_9_2/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_9_2/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_9_2/web/selfservice/bookmark',
        'delphixpy/v1_9_2/web/selfservice/datasource',
        'delphixpy/v1_9_2/web/selfservice/operation',
        'delphixpy/v1_9_2/web/selfservice/template',
        'delphixpy/v1_9_2/web/selfservice/usage',
        'delphixpy/v1_9_2/web/selfservice/usage/branch',
        'delphixpy/v1_9_2/web/selfservice/usage/user',
        'delphixpy/v1_9_2/web/selfservice/usage/container',
        'delphixpy/v1_9_2/web/selfservice/usage/bookmark',
        'delphixpy/v1_9_2/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_9_2/web/selfservice/usage/template',
        'delphixpy/v1_9_2/web/selfservice/config',
        'delphixpy/v1_9_2/web/snapshot',
        'delphixpy/v1_9_2/web/sourceconfig',
        'delphixpy/v1_9_2/web/namespace',
        'delphixpy/v1_9_2/web/replication',
        'delphixpy/v1_9_2/web/replication/spec',
        'delphixpy/v1_9_2/web/replication/targetstate',
        'delphixpy/v1_9_2/web/replication/sourcestate',
        'delphixpy/v1_9_2/web/replication/serializationpoint',
        'delphixpy/v1_9_2/web/source',
        'delphixpy/v1_9_2/web/source/operationTemplate',
        'delphixpy/v1_9_2/web/service',
        'delphixpy/v1_9_2/web/service/smtp',
        'delphixpy/v1_9_2/web/service/ldap',
        'delphixpy/v1_9_2/web/service/ldap/server',
        'delphixpy/v1_9_2/web/service/snmp',
        'delphixpy/v1_9_2/web/service/snmp/manager',
        'delphixpy/v1_9_2/web/service/userInterface',
        'delphixpy/v1_9_2/web/service/linkingsettings',
        'delphixpy/v1_9_2/web/service/phonehome',
        'delphixpy/v1_9_2/web/service/httpConnector',
        'delphixpy/v1_9_2/web/service/security',
        'delphixpy/v1_9_2/web/service/dns',
        'delphixpy/v1_9_2/web/service/kerberos',
        'delphixpy/v1_9_2/web/service/schema',
        'delphixpy/v1_9_2/web/service/tls',
        'delphixpy/v1_9_2/web/service/tls/endEntityCertificate',
        'delphixpy/v1_9_2/web/service/tls/csr',
        'delphixpy/v1_9_2/web/service/tls/caCertificate',
        'delphixpy/v1_9_2/web/service/saml',
        'delphixpy/v1_9_2/web/service/saml/serviceprovider',
        'delphixpy/v1_9_2/web/service/locale',
        'delphixpy/v1_9_2/web/service/proxy',
        'delphixpy/v1_9_2/web/service/certificate',
        'delphixpy/v1_9_2/web/service/time',
        'delphixpy/v1_9_2/web/service/syslog',
        'delphixpy/v1_9_2/web/service/support',
        'delphixpy/v1_9_2/web/service/support/access',
        'delphixpy/v1_9_2/web/service/support/bundle',
        'delphixpy/v1_9_2/web/system',
        'delphixpy/v1_9_2/web/system/upgradeCheckResult',
        'delphixpy/v1_9_2/web/system/version',
        'delphixpy/v1_9_2/web/system/package',
        'delphixpy/v1_9_2/web/network',
        'delphixpy/v1_9_2/web/network/route',
        'delphixpy/v1_9_2/web/network/test',
        'delphixpy/v1_9_2/web/network/test/latency',
        'delphixpy/v1_9_2/web/network/test/throughput',
        'delphixpy/v1_9_2/web/network/test/dsp',
        'delphixpy/v1_9_2/web/network/interface',
        'delphixpy/v1_9_2/web/network/dsp',
        'delphixpy/v1_9_2/web/network/dsp/autotune',
        'delphixpy/v1_9_2/web/session',
        'delphixpy/v1_5_2',
        'delphixpy/v1_5_2/web',
        'delphixpy/v1_5_2/web/authorization',
        'delphixpy/v1_5_2/web/permission',
        'delphixpy/v1_5_2/web/role',
        'delphixpy/v1_5_2/web/toolkit',
        'delphixpy/v1_5_2/web/environment',
        'delphixpy/v1_5_2/web/environment/user',
        'delphixpy/v1_5_2/web/environment/oracle',
        'delphixpy/v1_5_2/web/environment/oracle/listener',
        'delphixpy/v1_5_2/web/environment/oracle/clusternode',
        'delphixpy/v1_5_2/web/environment/windows',
        'delphixpy/v1_5_2/web/environment/windows/clusterinstance',
        'delphixpy/v1_5_2/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_5_2/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_5_2/web/environment/windows/clusternode',
        'delphixpy/v1_5_2/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_5_2/web/capacity',
        'delphixpy/v1_5_2/web/capacity/group',
        'delphixpy/v1_5_2/web/capacity/group/historical',
        'delphixpy/v1_5_2/web/capacity/consumer',
        'delphixpy/v1_5_2/web/capacity/consumer/historical',
        'delphixpy/v1_5_2/web/capacity/snapshot',
        'delphixpy/v1_5_2/web/capacity/system',
        'delphixpy/v1_5_2/web/capacity/system/historical',
        'delphixpy/v1_5_2/web/database',
        'delphixpy/v1_5_2/web/database/template',
        'delphixpy/v1_5_2/web/registration',
        'delphixpy/v1_5_2/web/registration/status',
        'delphixpy/v1_5_2/web/host',
        'delphixpy/v1_5_2/web/host/privilegeElevation',
        'delphixpy/v1_5_2/web/host/privilegeElevation/profile',
        'delphixpy/v1_5_2/web/data',
        'delphixpy/v1_5_2/web/repository',
        'delphixpy/v1_5_2/web/repository/template',
        'delphixpy/v1_5_2/web/policy',
        'delphixpy/v1_5_2/web/user',
        'delphixpy/v1_5_2/web/alert',
        'delphixpy/v1_5_2/web/alert/profile',
        'delphixpy/v1_5_2/web/objects',
        'delphixpy/v1_5_2/web/fault',
        'delphixpy/v1_5_2/web/fault/effect',
        'delphixpy/v1_5_2/web/group',
        'delphixpy/v1_5_2/web/connectivity',
        'delphixpy/v1_5_2/web/notification',
        'delphixpy/v1_5_2/web/delphix',
        'delphixpy/v1_5_2/web/job',
        'delphixpy/v1_5_2/web/about',
        'delphixpy/v1_5_2/web/timeflow',
        'delphixpy/v1_5_2/web/timeflow/bookmark',
        'delphixpy/v1_5_2/web/timeflow/oracle',
        'delphixpy/v1_5_2/web/timeflow/oracle/log',
        'delphixpy/v1_5_2/web/action',
        'delphixpy/v1_5_2/web/jetstream',
        'delphixpy/v1_5_2/web/jetstream/branch',
        'delphixpy/v1_5_2/web/jetstream/container',
        'delphixpy/v1_5_2/web/jetstream/usagedata',
        'delphixpy/v1_5_2/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_5_2/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_5_2/web/jetstream/bookmark',
        'delphixpy/v1_5_2/web/jetstream/datasource',
        'delphixpy/v1_5_2/web/jetstream/operation',
        'delphixpy/v1_5_2/web/jetstream/template',
        'delphixpy/v1_5_2/web/jetstream/usage',
        'delphixpy/v1_5_2/web/jetstream/usage/branch',
        'delphixpy/v1_5_2/web/jetstream/usage/user',
        'delphixpy/v1_5_2/web/jetstream/usage/container',
        'delphixpy/v1_5_2/web/jetstream/usage/bookmark',
        'delphixpy/v1_5_2/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_5_2/web/jetstream/usage/template',
        'delphixpy/v1_5_2/web/storage',
        'delphixpy/v1_5_2/web/storage/test',
        'delphixpy/v1_5_2/web/storage/device',
        'delphixpy/v1_5_2/web/storage/scrub',
        'delphixpy/v1_5_2/web/domain',
        'delphixpy/v1_5_2/web/analytics',
        'delphixpy/v1_5_2/web/analytics/statistic',
        'delphixpy/v1_5_2/web/snapshot',
        'delphixpy/v1_5_2/web/sourceconfig',
        'delphixpy/v1_5_2/web/sourceconfig/oracle',
        'delphixpy/v1_5_2/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_5_2/web/namespace',
        'delphixpy/v1_5_2/web/replication',
        'delphixpy/v1_5_2/web/replication/spec',
        'delphixpy/v1_5_2/web/replication/targetstate',
        'delphixpy/v1_5_2/web/replication/sourcestate',
        'delphixpy/v1_5_2/web/replication/serializationpoint',
        'delphixpy/v1_5_2/web/source',
        'delphixpy/v1_5_2/web/source/operationTemplate',
        'delphixpy/v1_5_2/web/service',
        'delphixpy/v1_5_2/web/service/smtp',
        'delphixpy/v1_5_2/web/service/ldap',
        'delphixpy/v1_5_2/web/service/ldap/server',
        'delphixpy/v1_5_2/web/service/snmp',
        'delphixpy/v1_5_2/web/service/snmp/manager',
        'delphixpy/v1_5_2/web/service/linkingsettings',
        'delphixpy/v1_5_2/web/service/phonehome',
        'delphixpy/v1_5_2/web/service/security',
        'delphixpy/v1_5_2/web/service/dns',
        'delphixpy/v1_5_2/web/service/schema',
        'delphixpy/v1_5_2/web/service/locale',
        'delphixpy/v1_5_2/web/service/proxy',
        'delphixpy/v1_5_2/web/service/certificate',
        'delphixpy/v1_5_2/web/service/time',
        'delphixpy/v1_5_2/web/service/syslog',
        'delphixpy/v1_5_2/web/service/support',
        'delphixpy/v1_5_2/web/service/support/access',
        'delphixpy/v1_5_2/web/service/support/bundle',
        'delphixpy/v1_5_2/web/system',
        'delphixpy/v1_5_2/web/system/version',
        'delphixpy/v1_5_2/web/network',
        'delphixpy/v1_5_2/web/network/route',
        'delphixpy/v1_5_2/web/network/test',
        'delphixpy/v1_5_2/web/network/test/latency',
        'delphixpy/v1_5_2/web/network/test/throughput',
        'delphixpy/v1_5_2/web/network/test/dsp',
        'delphixpy/v1_5_2/web/network/interface',
        'delphixpy/v1_5_2/web/session',
        'delphixpy/v1_5_0',
        'delphixpy/v1_5_0/web',
        'delphixpy/v1_5_0/web/authorization',
        'delphixpy/v1_5_0/web/permission',
        'delphixpy/v1_5_0/web/role',
        'delphixpy/v1_5_0/web/toolkit',
        'delphixpy/v1_5_0/web/environment',
        'delphixpy/v1_5_0/web/environment/user',
        'delphixpy/v1_5_0/web/environment/oracle',
        'delphixpy/v1_5_0/web/environment/oracle/listener',
        'delphixpy/v1_5_0/web/environment/oracle/clusternode',
        'delphixpy/v1_5_0/web/environment/windows',
        'delphixpy/v1_5_0/web/environment/windows/clusterinstance',
        'delphixpy/v1_5_0/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_5_0/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_5_0/web/environment/windows/clusternode',
        'delphixpy/v1_5_0/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_5_0/web/capacity',
        'delphixpy/v1_5_0/web/capacity/group',
        'delphixpy/v1_5_0/web/capacity/group/historical',
        'delphixpy/v1_5_0/web/capacity/consumer',
        'delphixpy/v1_5_0/web/capacity/consumer/historical',
        'delphixpy/v1_5_0/web/capacity/snapshot',
        'delphixpy/v1_5_0/web/capacity/system',
        'delphixpy/v1_5_0/web/capacity/system/historical',
        'delphixpy/v1_5_0/web/database',
        'delphixpy/v1_5_0/web/database/template',
        'delphixpy/v1_5_0/web/registration',
        'delphixpy/v1_5_0/web/registration/status',
        'delphixpy/v1_5_0/web/host',
        'delphixpy/v1_5_0/web/host/privilegeElevation',
        'delphixpy/v1_5_0/web/host/privilegeElevation/profile',
        'delphixpy/v1_5_0/web/data',
        'delphixpy/v1_5_0/web/repository',
        'delphixpy/v1_5_0/web/repository/template',
        'delphixpy/v1_5_0/web/policy',
        'delphixpy/v1_5_0/web/user',
        'delphixpy/v1_5_0/web/alert',
        'delphixpy/v1_5_0/web/alert/profile',
        'delphixpy/v1_5_0/web/objects',
        'delphixpy/v1_5_0/web/fault',
        'delphixpy/v1_5_0/web/fault/effect',
        'delphixpy/v1_5_0/web/group',
        'delphixpy/v1_5_0/web/connectivity',
        'delphixpy/v1_5_0/web/notification',
        'delphixpy/v1_5_0/web/delphix',
        'delphixpy/v1_5_0/web/job',
        'delphixpy/v1_5_0/web/about',
        'delphixpy/v1_5_0/web/timeflow',
        'delphixpy/v1_5_0/web/timeflow/bookmark',
        'delphixpy/v1_5_0/web/timeflow/oracle',
        'delphixpy/v1_5_0/web/timeflow/oracle/log',
        'delphixpy/v1_5_0/web/action',
        'delphixpy/v1_5_0/web/jetstream',
        'delphixpy/v1_5_0/web/jetstream/branch',
        'delphixpy/v1_5_0/web/jetstream/container',
        'delphixpy/v1_5_0/web/jetstream/usagedata',
        'delphixpy/v1_5_0/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_5_0/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_5_0/web/jetstream/bookmark',
        'delphixpy/v1_5_0/web/jetstream/datasource',
        'delphixpy/v1_5_0/web/jetstream/operation',
        'delphixpy/v1_5_0/web/jetstream/template',
        'delphixpy/v1_5_0/web/jetstream/usage',
        'delphixpy/v1_5_0/web/jetstream/usage/branch',
        'delphixpy/v1_5_0/web/jetstream/usage/user',
        'delphixpy/v1_5_0/web/jetstream/usage/container',
        'delphixpy/v1_5_0/web/jetstream/usage/bookmark',
        'delphixpy/v1_5_0/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_5_0/web/jetstream/usage/template',
        'delphixpy/v1_5_0/web/storage',
        'delphixpy/v1_5_0/web/storage/test',
        'delphixpy/v1_5_0/web/storage/device',
        'delphixpy/v1_5_0/web/storage/scrub',
        'delphixpy/v1_5_0/web/domain',
        'delphixpy/v1_5_0/web/analytics',
        'delphixpy/v1_5_0/web/analytics/statistic',
        'delphixpy/v1_5_0/web/snapshot',
        'delphixpy/v1_5_0/web/sourceconfig',
        'delphixpy/v1_5_0/web/sourceconfig/oracle',
        'delphixpy/v1_5_0/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_5_0/web/namespace',
        'delphixpy/v1_5_0/web/replication',
        'delphixpy/v1_5_0/web/replication/spec',
        'delphixpy/v1_5_0/web/replication/targetstate',
        'delphixpy/v1_5_0/web/replication/sourcestate',
        'delphixpy/v1_5_0/web/replication/serializationpoint',
        'delphixpy/v1_5_0/web/source',
        'delphixpy/v1_5_0/web/source/operationTemplate',
        'delphixpy/v1_5_0/web/service',
        'delphixpy/v1_5_0/web/service/smtp',
        'delphixpy/v1_5_0/web/service/ldap',
        'delphixpy/v1_5_0/web/service/ldap/server',
        'delphixpy/v1_5_0/web/service/snmp',
        'delphixpy/v1_5_0/web/service/snmp/manager',
        'delphixpy/v1_5_0/web/service/linkingsettings',
        'delphixpy/v1_5_0/web/service/phonehome',
        'delphixpy/v1_5_0/web/service/security',
        'delphixpy/v1_5_0/web/service/dns',
        'delphixpy/v1_5_0/web/service/schema',
        'delphixpy/v1_5_0/web/service/locale',
        'delphixpy/v1_5_0/web/service/proxy',
        'delphixpy/v1_5_0/web/service/certificate',
        'delphixpy/v1_5_0/web/service/time',
        'delphixpy/v1_5_0/web/service/syslog',
        'delphixpy/v1_5_0/web/service/support',
        'delphixpy/v1_5_0/web/service/support/access',
        'delphixpy/v1_5_0/web/service/support/bundle',
        'delphixpy/v1_5_0/web/system',
        'delphixpy/v1_5_0/web/system/version',
        'delphixpy/v1_5_0/web/network',
        'delphixpy/v1_5_0/web/network/route',
        'delphixpy/v1_5_0/web/network/test',
        'delphixpy/v1_5_0/web/network/test/latency',
        'delphixpy/v1_5_0/web/network/test/throughput',
        'delphixpy/v1_5_0/web/network/test/dsp',
        'delphixpy/v1_5_0/web/network/interface',
        'delphixpy/v1_5_0/web/session',
        'delphixpy/v1_11_12',
        'delphixpy/v1_11_12/web',
        'delphixpy/v1_11_12/web/authorization',
        'delphixpy/v1_11_12/web/authorization/configuration',
        'delphixpy/v1_11_12/web/permission',
        'delphixpy/v1_11_12/web/passwordPolicy',
        'delphixpy/v1_11_12/web/role',
        'delphixpy/v1_11_12/web/toolkit',
        'delphixpy/v1_11_12/web/environment',
        'delphixpy/v1_11_12/web/environment/user',
        'delphixpy/v1_11_12/web/environment/oracle',
        'delphixpy/v1_11_12/web/environment/oracle/listener',
        'delphixpy/v1_11_12/web/environment/oracle/clusternode',
        'delphixpy/v1_11_12/web/environment/windows',
        'delphixpy/v1_11_12/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_12/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_12/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_12/web/environment/windows/clusternode',
        'delphixpy/v1_11_12/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_12/web/capacity',
        'delphixpy/v1_11_12/web/capacity/heldspace',
        'delphixpy/v1_11_12/web/capacity/group',
        'delphixpy/v1_11_12/web/capacity/group/historical',
        'delphixpy/v1_11_12/web/capacity/consumer',
        'delphixpy/v1_11_12/web/capacity/consumer/historical',
        'delphixpy/v1_11_12/web/capacity/snapshot',
        'delphixpy/v1_11_12/web/capacity/system',
        'delphixpy/v1_11_12/web/capacity/system/historical',
        'delphixpy/v1_11_12/web/database',
        'delphixpy/v1_11_12/web/database/performanceHistory',
        'delphixpy/v1_11_12/web/database/template',
        'delphixpy/v1_11_12/web/registration',
        'delphixpy/v1_11_12/web/registration/status',
        'delphixpy/v1_11_12/web/host',
        'delphixpy/v1_11_12/web/host/privilegeElevation',
        'delphixpy/v1_11_12/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_12/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_12/web/theme',
        'delphixpy/v1_11_12/web/osadmin',
        'delphixpy/v1_11_12/web/osadmin/engineStatus',
        'delphixpy/v1_11_12/web/data',
        'delphixpy/v1_11_12/web/transformation',
        'delphixpy/v1_11_12/web/repository',
        'delphixpy/v1_11_12/web/repository/template',
        'delphixpy/v1_11_12/web/policy',
        'delphixpy/v1_11_12/web/user',
        'delphixpy/v1_11_12/web/alert',
        'delphixpy/v1_11_12/web/alert/profile',
        'delphixpy/v1_11_12/web/objects',
        'delphixpy/v1_11_12/web/maskingjob',
        'delphixpy/v1_11_12/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_12/web/timezone',
        'delphixpy/v1_11_12/web/fault',
        'delphixpy/v1_11_12/web/fault/effect',
        'delphixpy/v1_11_12/web/group',
        'delphixpy/v1_11_12/web/license',
        'delphixpy/v1_11_12/web/connectivity',
        'delphixpy/v1_11_12/web/notification',
        'delphixpy/v1_11_12/web/delphix',
        'delphixpy/v1_11_12/web/job',
        'delphixpy/v1_11_12/web/usage',
        'delphixpy/v1_11_12/web/about',
        'delphixpy/v1_11_12/web/timeflow',
        'delphixpy/v1_11_12/web/timeflow/bookmark',
        'delphixpy/v1_11_12/web/timeflow/oracle',
        'delphixpy/v1_11_12/web/timeflow/oracle/log',
        'delphixpy/v1_11_12/web/action',
        'delphixpy/v1_11_12/web/storage',
        'delphixpy/v1_11_12/web/storage/objectStorage',
        'delphixpy/v1_11_12/web/storage/remove',
        'delphixpy/v1_11_12/web/storage/iscsi',
        'delphixpy/v1_11_12/web/storage/iscsi/target',
        'delphixpy/v1_11_12/web/storage/iscsi/initiator',
        'delphixpy/v1_11_12/web/storage/test',
        'delphixpy/v1_11_12/web/storage/device',
        'delphixpy/v1_11_12/web/storage/scrub',
        'delphixpy/v1_11_12/web/domain',
        'delphixpy/v1_11_12/web/analytics',
        'delphixpy/v1_11_12/web/analytics/statistic',
        'delphixpy/v1_11_12/web/selfservice',
        'delphixpy/v1_11_12/web/selfservice/branch',
        'delphixpy/v1_11_12/web/selfservice/container',
        'delphixpy/v1_11_12/web/selfservice/usagedata',
        'delphixpy/v1_11_12/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_12/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_12/web/selfservice/bookmark',
        'delphixpy/v1_11_12/web/selfservice/datasource',
        'delphixpy/v1_11_12/web/selfservice/operation',
        'delphixpy/v1_11_12/web/selfservice/template',
        'delphixpy/v1_11_12/web/selfservice/usage',
        'delphixpy/v1_11_12/web/selfservice/usage/branch',
        'delphixpy/v1_11_12/web/selfservice/usage/user',
        'delphixpy/v1_11_12/web/selfservice/usage/container',
        'delphixpy/v1_11_12/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_12/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_12/web/selfservice/usage/template',
        'delphixpy/v1_11_12/web/selfservice/config',
        'delphixpy/v1_11_12/web/snapshot',
        'delphixpy/v1_11_12/web/sourceconfig',
        'delphixpy/v1_11_12/web/namespace',
        'delphixpy/v1_11_12/web/replication',
        'delphixpy/v1_11_12/web/replication/spec',
        'delphixpy/v1_11_12/web/replication/targetstate',
        'delphixpy/v1_11_12/web/replication/sourcestate',
        'delphixpy/v1_11_12/web/replication/serializationpoint',
        'delphixpy/v1_11_12/web/source',
        'delphixpy/v1_11_12/web/source/operationTemplate',
        'delphixpy/v1_11_12/web/service',
        'delphixpy/v1_11_12/web/service/smtp',
        'delphixpy/v1_11_12/web/service/ldap',
        'delphixpy/v1_11_12/web/service/ldap/server',
        'delphixpy/v1_11_12/web/service/nfs',
        'delphixpy/v1_11_12/web/service/host',
        'delphixpy/v1_11_12/web/service/host/address',
        'delphixpy/v1_11_12/web/service/snmp',
        'delphixpy/v1_11_12/web/service/snmp/v3',
        'delphixpy/v1_11_12/web/service/snmp/v3/manager',
        'delphixpy/v1_11_12/web/service/snmp/v3/usm',
        'delphixpy/v1_11_12/web/service/snmp/v2',
        'delphixpy/v1_11_12/web/service/snmp/v2/manager',
        'delphixpy/v1_11_12/web/service/userInterface',
        'delphixpy/v1_11_12/web/service/linkingsettings',
        'delphixpy/v1_11_12/web/service/phonehome',
        'delphixpy/v1_11_12/web/service/httpConnector',
        'delphixpy/v1_11_12/web/service/userPaths',
        'delphixpy/v1_11_12/web/service/security',
        'delphixpy/v1_11_12/web/service/dns',
        'delphixpy/v1_11_12/web/service/kerberos',
        'delphixpy/v1_11_12/web/service/schema',
        'delphixpy/v1_11_12/web/service/tls',
        'delphixpy/v1_11_12/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_12/web/service/tls/csr',
        'delphixpy/v1_11_12/web/service/tls/cipherSuite',
        'delphixpy/v1_11_12/web/service/tls/caCertificate',
        'delphixpy/v1_11_12/web/service/insight',
        'delphixpy/v1_11_12/web/service/insight/splunkHec',
        'delphixpy/v1_11_12/web/service/locale',
        'delphixpy/v1_11_12/web/service/cloud',
        'delphixpy/v1_11_12/web/service/proxy',
        'delphixpy/v1_11_12/web/service/time',
        'delphixpy/v1_11_12/web/service/syslog',
        'delphixpy/v1_11_12/web/service/support',
        'delphixpy/v1_11_12/web/service/support/access',
        'delphixpy/v1_11_12/web/service/support/bundle',
        'delphixpy/v1_11_12/web/service/minimalPhonehome',
        'delphixpy/v1_11_12/web/service/passwordVault',
        'delphixpy/v1_11_12/web/service/oauth2',
        'delphixpy/v1_11_12/web/service/sso',
        'delphixpy/v1_11_12/web/system',
        'delphixpy/v1_11_12/web/system/verification',
        'delphixpy/v1_11_12/web/system/verification/reports',
        'delphixpy/v1_11_12/web/system/verification/reports/steps',
        'delphixpy/v1_11_12/web/system/advancedSettings',
        'delphixpy/v1_11_12/web/system/upgradeCheckResult',
        'delphixpy/v1_11_12/web/system/status',
        'delphixpy/v1_11_12/web/system/version',
        'delphixpy/v1_11_12/web/system/package',
        'delphixpy/v1_11_12/web/network',
        'delphixpy/v1_11_12/web/network/route',
        'delphixpy/v1_11_12/web/network/test',
        'delphixpy/v1_11_12/web/network/test/latency',
        'delphixpy/v1_11_12/web/network/test/throughput',
        'delphixpy/v1_11_12/web/network/test/dsp',
        'delphixpy/v1_11_12/web/network/interface',
        'delphixpy/v1_11_12/web/network/dsp',
        'delphixpy/v1_11_12/web/network/dsp/autotune',
        'delphixpy/v1_11_12/web/session',
        'delphixpy/v1_10_0',
        'delphixpy/v1_10_0/web',
        'delphixpy/v1_10_0/web/authorization',
        'delphixpy/v1_10_0/web/authorization/configuration',
        'delphixpy/v1_10_0/web/permission',
        'delphixpy/v1_10_0/web/passwordPolicy',
        'delphixpy/v1_10_0/web/role',
        'delphixpy/v1_10_0/web/toolkit',
        'delphixpy/v1_10_0/web/environment',
        'delphixpy/v1_10_0/web/environment/user',
        'delphixpy/v1_10_0/web/environment/oracle',
        'delphixpy/v1_10_0/web/environment/oracle/listener',
        'delphixpy/v1_10_0/web/environment/oracle/clusternode',
        'delphixpy/v1_10_0/web/environment/windows',
        'delphixpy/v1_10_0/web/environment/windows/clusterinstance',
        'delphixpy/v1_10_0/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_10_0/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_10_0/web/environment/windows/clusternode',
        'delphixpy/v1_10_0/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_10_0/web/capacity',
        'delphixpy/v1_10_0/web/capacity/group',
        'delphixpy/v1_10_0/web/capacity/group/historical',
        'delphixpy/v1_10_0/web/capacity/consumer',
        'delphixpy/v1_10_0/web/capacity/consumer/historical',
        'delphixpy/v1_10_0/web/capacity/snapshot',
        'delphixpy/v1_10_0/web/capacity/system',
        'delphixpy/v1_10_0/web/capacity/system/historical',
        'delphixpy/v1_10_0/web/database',
        'delphixpy/v1_10_0/web/database/performanceHistory',
        'delphixpy/v1_10_0/web/database/template',
        'delphixpy/v1_10_0/web/registration',
        'delphixpy/v1_10_0/web/registration/status',
        'delphixpy/v1_10_0/web/host',
        'delphixpy/v1_10_0/web/host/privilegeElevation',
        'delphixpy/v1_10_0/web/host/privilegeElevation/profile',
        'delphixpy/v1_10_0/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_10_0/web/data',
        'delphixpy/v1_10_0/web/transformation',
        'delphixpy/v1_10_0/web/repository',
        'delphixpy/v1_10_0/web/repository/template',
        'delphixpy/v1_10_0/web/policy',
        'delphixpy/v1_10_0/web/user',
        'delphixpy/v1_10_0/web/alert',
        'delphixpy/v1_10_0/web/alert/profile',
        'delphixpy/v1_10_0/web/objects',
        'delphixpy/v1_10_0/web/maskingjob',
        'delphixpy/v1_10_0/web/maskingjob/serviceconfig',
        'delphixpy/v1_10_0/web/timezone',
        'delphixpy/v1_10_0/web/fault',
        'delphixpy/v1_10_0/web/fault/effect',
        'delphixpy/v1_10_0/web/group',
        'delphixpy/v1_10_0/web/connectivity',
        'delphixpy/v1_10_0/web/notification',
        'delphixpy/v1_10_0/web/delphix',
        'delphixpy/v1_10_0/web/job',
        'delphixpy/v1_10_0/web/about',
        'delphixpy/v1_10_0/web/timeflow',
        'delphixpy/v1_10_0/web/timeflow/bookmark',
        'delphixpy/v1_10_0/web/timeflow/oracle',
        'delphixpy/v1_10_0/web/timeflow/oracle/log',
        'delphixpy/v1_10_0/web/action',
        'delphixpy/v1_10_0/web/storage',
        'delphixpy/v1_10_0/web/storage/remove',
        'delphixpy/v1_10_0/web/storage/test',
        'delphixpy/v1_10_0/web/storage/device',
        'delphixpy/v1_10_0/web/storage/scrub',
        'delphixpy/v1_10_0/web/domain',
        'delphixpy/v1_10_0/web/analytics',
        'delphixpy/v1_10_0/web/analytics/statistic',
        'delphixpy/v1_10_0/web/selfservice',
        'delphixpy/v1_10_0/web/selfservice/branch',
        'delphixpy/v1_10_0/web/selfservice/container',
        'delphixpy/v1_10_0/web/selfservice/usagedata',
        'delphixpy/v1_10_0/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_10_0/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_10_0/web/selfservice/bookmark',
        'delphixpy/v1_10_0/web/selfservice/datasource',
        'delphixpy/v1_10_0/web/selfservice/operation',
        'delphixpy/v1_10_0/web/selfservice/template',
        'delphixpy/v1_10_0/web/selfservice/usage',
        'delphixpy/v1_10_0/web/selfservice/usage/branch',
        'delphixpy/v1_10_0/web/selfservice/usage/user',
        'delphixpy/v1_10_0/web/selfservice/usage/container',
        'delphixpy/v1_10_0/web/selfservice/usage/bookmark',
        'delphixpy/v1_10_0/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_10_0/web/selfservice/usage/template',
        'delphixpy/v1_10_0/web/selfservice/config',
        'delphixpy/v1_10_0/web/snapshot',
        'delphixpy/v1_10_0/web/sourceconfig',
        'delphixpy/v1_10_0/web/namespace',
        'delphixpy/v1_10_0/web/replication',
        'delphixpy/v1_10_0/web/replication/spec',
        'delphixpy/v1_10_0/web/replication/targetstate',
        'delphixpy/v1_10_0/web/replication/sourcestate',
        'delphixpy/v1_10_0/web/replication/serializationpoint',
        'delphixpy/v1_10_0/web/source',
        'delphixpy/v1_10_0/web/source/operationTemplate',
        'delphixpy/v1_10_0/web/service',
        'delphixpy/v1_10_0/web/service/smtp',
        'delphixpy/v1_10_0/web/service/ldap',
        'delphixpy/v1_10_0/web/service/ldap/server',
        'delphixpy/v1_10_0/web/service/snmp',
        'delphixpy/v1_10_0/web/service/snmp/manager',
        'delphixpy/v1_10_0/web/service/userInterface',
        'delphixpy/v1_10_0/web/service/linkingsettings',
        'delphixpy/v1_10_0/web/service/phonehome',
        'delphixpy/v1_10_0/web/service/httpConnector',
        'delphixpy/v1_10_0/web/service/security',
        'delphixpy/v1_10_0/web/service/dns',
        'delphixpy/v1_10_0/web/service/kerberos',
        'delphixpy/v1_10_0/web/service/schema',
        'delphixpy/v1_10_0/web/service/tls',
        'delphixpy/v1_10_0/web/service/tls/endEntityCertificate',
        'delphixpy/v1_10_0/web/service/tls/csr',
        'delphixpy/v1_10_0/web/service/tls/caCertificate',
        'delphixpy/v1_10_0/web/service/insight',
        'delphixpy/v1_10_0/web/service/insight/splunkHec',
        'delphixpy/v1_10_0/web/service/saml',
        'delphixpy/v1_10_0/web/service/saml/serviceprovider',
        'delphixpy/v1_10_0/web/service/locale',
        'delphixpy/v1_10_0/web/service/proxy',
        'delphixpy/v1_10_0/web/service/certificate',
        'delphixpy/v1_10_0/web/service/time',
        'delphixpy/v1_10_0/web/service/syslog',
        'delphixpy/v1_10_0/web/service/support',
        'delphixpy/v1_10_0/web/service/support/access',
        'delphixpy/v1_10_0/web/service/support/bundle',
        'delphixpy/v1_10_0/web/system',
        'delphixpy/v1_10_0/web/system/upgradeCheckResult',
        'delphixpy/v1_10_0/web/system/version',
        'delphixpy/v1_10_0/web/system/package',
        'delphixpy/v1_10_0/web/network',
        'delphixpy/v1_10_0/web/network/route',
        'delphixpy/v1_10_0/web/network/test',
        'delphixpy/v1_10_0/web/network/test/latency',
        'delphixpy/v1_10_0/web/network/test/throughput',
        'delphixpy/v1_10_0/web/network/test/dsp',
        'delphixpy/v1_10_0/web/network/interface',
        'delphixpy/v1_10_0/web/network/dsp',
        'delphixpy/v1_10_0/web/network/dsp/autotune',
        'delphixpy/v1_10_0/web/session',
        'delphixpy/v1_11_17',
        'delphixpy/v1_11_17/web',
        'delphixpy/v1_11_17/web/authorization',
        'delphixpy/v1_11_17/web/authorization/configuration',
        'delphixpy/v1_11_17/web/permission',
        'delphixpy/v1_11_17/web/passwordPolicy',
        'delphixpy/v1_11_17/web/role',
        'delphixpy/v1_11_17/web/toolkit',
        'delphixpy/v1_11_17/web/environment',
        'delphixpy/v1_11_17/web/environment/user',
        'delphixpy/v1_11_17/web/environment/oracle',
        'delphixpy/v1_11_17/web/environment/oracle/listener',
        'delphixpy/v1_11_17/web/environment/oracle/clusternode',
        'delphixpy/v1_11_17/web/environment/windows',
        'delphixpy/v1_11_17/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_17/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_17/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_17/web/environment/windows/clusternode',
        'delphixpy/v1_11_17/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_17/web/capacity',
        'delphixpy/v1_11_17/web/capacity/heldspace',
        'delphixpy/v1_11_17/web/capacity/group',
        'delphixpy/v1_11_17/web/capacity/group/historical',
        'delphixpy/v1_11_17/web/capacity/consumer',
        'delphixpy/v1_11_17/web/capacity/consumer/historical',
        'delphixpy/v1_11_17/web/capacity/snapshot',
        'delphixpy/v1_11_17/web/capacity/system',
        'delphixpy/v1_11_17/web/capacity/system/historical',
        'delphixpy/v1_11_17/web/database',
        'delphixpy/v1_11_17/web/database/performanceHistory',
        'delphixpy/v1_11_17/web/database/template',
        'delphixpy/v1_11_17/web/registration',
        'delphixpy/v1_11_17/web/registration/status',
        'delphixpy/v1_11_17/web/host',
        'delphixpy/v1_11_17/web/host/privilegeElevation',
        'delphixpy/v1_11_17/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_17/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_17/web/theme',
        'delphixpy/v1_11_17/web/osadmin',
        'delphixpy/v1_11_17/web/osadmin/engineStatus',
        'delphixpy/v1_11_17/web/data',
        'delphixpy/v1_11_17/web/transformation',
        'delphixpy/v1_11_17/web/repository',
        'delphixpy/v1_11_17/web/repository/template',
        'delphixpy/v1_11_17/web/policy',
        'delphixpy/v1_11_17/web/user',
        'delphixpy/v1_11_17/web/alert',
        'delphixpy/v1_11_17/web/alert/profile',
        'delphixpy/v1_11_17/web/objects',
        'delphixpy/v1_11_17/web/maskingjob',
        'delphixpy/v1_11_17/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_17/web/timezone',
        'delphixpy/v1_11_17/web/fault',
        'delphixpy/v1_11_17/web/fault/effect',
        'delphixpy/v1_11_17/web/group',
        'delphixpy/v1_11_17/web/license',
        'delphixpy/v1_11_17/web/connectivity',
        'delphixpy/v1_11_17/web/notification',
        'delphixpy/v1_11_17/web/delphix',
        'delphixpy/v1_11_17/web/job',
        'delphixpy/v1_11_17/web/job/retention',
        'delphixpy/v1_11_17/web/usage',
        'delphixpy/v1_11_17/web/about',
        'delphixpy/v1_11_17/web/timeflow',
        'delphixpy/v1_11_17/web/timeflow/bookmark',
        'delphixpy/v1_11_17/web/timeflow/oracle',
        'delphixpy/v1_11_17/web/timeflow/oracle/log',
        'delphixpy/v1_11_17/web/action',
        'delphixpy/v1_11_17/web/storage',
        'delphixpy/v1_11_17/web/storage/objectStorage',
        'delphixpy/v1_11_17/web/storage/remove',
        'delphixpy/v1_11_17/web/storage/iscsi',
        'delphixpy/v1_11_17/web/storage/iscsi/target',
        'delphixpy/v1_11_17/web/storage/iscsi/initiator',
        'delphixpy/v1_11_17/web/storage/test',
        'delphixpy/v1_11_17/web/storage/device',
        'delphixpy/v1_11_17/web/storage/scrub',
        'delphixpy/v1_11_17/web/domain',
        'delphixpy/v1_11_17/web/analytics',
        'delphixpy/v1_11_17/web/analytics/statistic',
        'delphixpy/v1_11_17/web/selfservice',
        'delphixpy/v1_11_17/web/selfservice/branch',
        'delphixpy/v1_11_17/web/selfservice/container',
        'delphixpy/v1_11_17/web/selfservice/usagedata',
        'delphixpy/v1_11_17/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_17/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_17/web/selfservice/bookmark',
        'delphixpy/v1_11_17/web/selfservice/datasource',
        'delphixpy/v1_11_17/web/selfservice/operation',
        'delphixpy/v1_11_17/web/selfservice/template',
        'delphixpy/v1_11_17/web/selfservice/usage',
        'delphixpy/v1_11_17/web/selfservice/usage/branch',
        'delphixpy/v1_11_17/web/selfservice/usage/user',
        'delphixpy/v1_11_17/web/selfservice/usage/container',
        'delphixpy/v1_11_17/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_17/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_17/web/selfservice/usage/template',
        'delphixpy/v1_11_17/web/selfservice/config',
        'delphixpy/v1_11_17/web/snapshot',
        'delphixpy/v1_11_17/web/sourceconfig',
        'delphixpy/v1_11_17/web/namespace',
        'delphixpy/v1_11_17/web/replication',
        'delphixpy/v1_11_17/web/replication/spec',
        'delphixpy/v1_11_17/web/replication/targetstate',
        'delphixpy/v1_11_17/web/replication/sourcestate',
        'delphixpy/v1_11_17/web/replication/serializationpoint',
        'delphixpy/v1_11_17/web/source',
        'delphixpy/v1_11_17/web/source/operationTemplate',
        'delphixpy/v1_11_17/web/service',
        'delphixpy/v1_11_17/web/service/smtp',
        'delphixpy/v1_11_17/web/service/ldap',
        'delphixpy/v1_11_17/web/service/ldap/server',
        'delphixpy/v1_11_17/web/service/nfs',
        'delphixpy/v1_11_17/web/service/host',
        'delphixpy/v1_11_17/web/service/host/address',
        'delphixpy/v1_11_17/web/service/snmp',
        'delphixpy/v1_11_17/web/service/snmp/v3',
        'delphixpy/v1_11_17/web/service/snmp/v3/manager',
        'delphixpy/v1_11_17/web/service/snmp/v3/usm',
        'delphixpy/v1_11_17/web/service/snmp/v2',
        'delphixpy/v1_11_17/web/service/snmp/v2/manager',
        'delphixpy/v1_11_17/web/service/userInterface',
        'delphixpy/v1_11_17/web/service/linkingsettings',
        'delphixpy/v1_11_17/web/service/phonehome',
        'delphixpy/v1_11_17/web/service/events',
        'delphixpy/v1_11_17/web/service/fluentd',
        'delphixpy/v1_11_17/web/service/fluentd/plugins',
        'delphixpy/v1_11_17/web/service/fluentd/configuration',
        'delphixpy/v1_11_17/web/service/httpConnector',
        'delphixpy/v1_11_17/web/service/userPaths',
        'delphixpy/v1_11_17/web/service/security',
        'delphixpy/v1_11_17/web/service/dns',
        'delphixpy/v1_11_17/web/service/kerberos',
        'delphixpy/v1_11_17/web/service/schema',
        'delphixpy/v1_11_17/web/service/tls',
        'delphixpy/v1_11_17/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_17/web/service/tls/csr',
        'delphixpy/v1_11_17/web/service/tls/cipherSuite',
        'delphixpy/v1_11_17/web/service/tls/caCertificate',
        'delphixpy/v1_11_17/web/service/insight',
        'delphixpy/v1_11_17/web/service/insight/splunkHec',
        'delphixpy/v1_11_17/web/service/locale',
        'delphixpy/v1_11_17/web/service/cloud',
        'delphixpy/v1_11_17/web/service/proxy',
        'delphixpy/v1_11_17/web/service/time',
        'delphixpy/v1_11_17/web/service/syslog',
        'delphixpy/v1_11_17/web/service/passwordReset',
        'delphixpy/v1_11_17/web/service/support',
        'delphixpy/v1_11_17/web/service/support/access',
        'delphixpy/v1_11_17/web/service/support/bundle',
        'delphixpy/v1_11_17/web/service/minimalPhonehome',
        'delphixpy/v1_11_17/web/service/passwordVault',
        'delphixpy/v1_11_17/web/service/oauth2',
        'delphixpy/v1_11_17/web/service/sso',
        'delphixpy/v1_11_17/web/system',
        'delphixpy/v1_11_17/web/system/verification',
        'delphixpy/v1_11_17/web/system/verification/reports',
        'delphixpy/v1_11_17/web/system/verification/reports/steps',
        'delphixpy/v1_11_17/web/system/advancedSettings',
        'delphixpy/v1_11_17/web/system/upgradeCheckResult',
        'delphixpy/v1_11_17/web/system/status',
        'delphixpy/v1_11_17/web/system/version',
        'delphixpy/v1_11_17/web/system/package',
        'delphixpy/v1_11_17/web/network',
        'delphixpy/v1_11_17/web/network/route',
        'delphixpy/v1_11_17/web/network/test',
        'delphixpy/v1_11_17/web/network/test/latency',
        'delphixpy/v1_11_17/web/network/test/throughput',
        'delphixpy/v1_11_17/web/network/test/dsp',
        'delphixpy/v1_11_17/web/network/interface',
        'delphixpy/v1_11_17/web/network/dsp',
        'delphixpy/v1_11_17/web/network/dsp/autotune',
        'delphixpy/v1_11_17/web/session',
        'delphixpy/v1_11_17/web/netty',
        'delphixpy/v1_11_2',
        'delphixpy/v1_11_2/web',
        'delphixpy/v1_11_2/web/authorization',
        'delphixpy/v1_11_2/web/authorization/configuration',
        'delphixpy/v1_11_2/web/permission',
        'delphixpy/v1_11_2/web/passwordPolicy',
        'delphixpy/v1_11_2/web/role',
        'delphixpy/v1_11_2/web/toolkit',
        'delphixpy/v1_11_2/web/environment',
        'delphixpy/v1_11_2/web/environment/user',
        'delphixpy/v1_11_2/web/environment/oracle',
        'delphixpy/v1_11_2/web/environment/oracle/listener',
        'delphixpy/v1_11_2/web/environment/oracle/clusternode',
        'delphixpy/v1_11_2/web/environment/windows',
        'delphixpy/v1_11_2/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_2/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_2/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_2/web/environment/windows/clusternode',
        'delphixpy/v1_11_2/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_2/web/capacity',
        'delphixpy/v1_11_2/web/capacity/group',
        'delphixpy/v1_11_2/web/capacity/group/historical',
        'delphixpy/v1_11_2/web/capacity/consumer',
        'delphixpy/v1_11_2/web/capacity/consumer/historical',
        'delphixpy/v1_11_2/web/capacity/snapshot',
        'delphixpy/v1_11_2/web/capacity/system',
        'delphixpy/v1_11_2/web/capacity/system/historical',
        'delphixpy/v1_11_2/web/database',
        'delphixpy/v1_11_2/web/database/performanceHistory',
        'delphixpy/v1_11_2/web/database/template',
        'delphixpy/v1_11_2/web/registration',
        'delphixpy/v1_11_2/web/registration/status',
        'delphixpy/v1_11_2/web/host',
        'delphixpy/v1_11_2/web/host/privilegeElevation',
        'delphixpy/v1_11_2/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_2/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_2/web/theme',
        'delphixpy/v1_11_2/web/data',
        'delphixpy/v1_11_2/web/transformation',
        'delphixpy/v1_11_2/web/repository',
        'delphixpy/v1_11_2/web/repository/template',
        'delphixpy/v1_11_2/web/policy',
        'delphixpy/v1_11_2/web/user',
        'delphixpy/v1_11_2/web/alert',
        'delphixpy/v1_11_2/web/alert/profile',
        'delphixpy/v1_11_2/web/objects',
        'delphixpy/v1_11_2/web/maskingjob',
        'delphixpy/v1_11_2/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_2/web/timezone',
        'delphixpy/v1_11_2/web/fault',
        'delphixpy/v1_11_2/web/fault/effect',
        'delphixpy/v1_11_2/web/group',
        'delphixpy/v1_11_2/web/connectivity',
        'delphixpy/v1_11_2/web/notification',
        'delphixpy/v1_11_2/web/delphix',
        'delphixpy/v1_11_2/web/job',
        'delphixpy/v1_11_2/web/usage',
        'delphixpy/v1_11_2/web/about',
        'delphixpy/v1_11_2/web/timeflow',
        'delphixpy/v1_11_2/web/timeflow/bookmark',
        'delphixpy/v1_11_2/web/timeflow/oracle',
        'delphixpy/v1_11_2/web/timeflow/oracle/log',
        'delphixpy/v1_11_2/web/action',
        'delphixpy/v1_11_2/web/storage',
        'delphixpy/v1_11_2/web/storage/remove',
        'delphixpy/v1_11_2/web/storage/test',
        'delphixpy/v1_11_2/web/storage/device',
        'delphixpy/v1_11_2/web/storage/scrub',
        'delphixpy/v1_11_2/web/domain',
        'delphixpy/v1_11_2/web/analytics',
        'delphixpy/v1_11_2/web/analytics/statistic',
        'delphixpy/v1_11_2/web/selfservice',
        'delphixpy/v1_11_2/web/selfservice/branch',
        'delphixpy/v1_11_2/web/selfservice/container',
        'delphixpy/v1_11_2/web/selfservice/usagedata',
        'delphixpy/v1_11_2/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_2/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_2/web/selfservice/bookmark',
        'delphixpy/v1_11_2/web/selfservice/datasource',
        'delphixpy/v1_11_2/web/selfservice/operation',
        'delphixpy/v1_11_2/web/selfservice/template',
        'delphixpy/v1_11_2/web/selfservice/usage',
        'delphixpy/v1_11_2/web/selfservice/usage/branch',
        'delphixpy/v1_11_2/web/selfservice/usage/user',
        'delphixpy/v1_11_2/web/selfservice/usage/container',
        'delphixpy/v1_11_2/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_2/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_2/web/selfservice/usage/template',
        'delphixpy/v1_11_2/web/selfservice/config',
        'delphixpy/v1_11_2/web/snapshot',
        'delphixpy/v1_11_2/web/sourceconfig',
        'delphixpy/v1_11_2/web/namespace',
        'delphixpy/v1_11_2/web/replication',
        'delphixpy/v1_11_2/web/replication/spec',
        'delphixpy/v1_11_2/web/replication/targetstate',
        'delphixpy/v1_11_2/web/replication/sourcestate',
        'delphixpy/v1_11_2/web/replication/serializationpoint',
        'delphixpy/v1_11_2/web/source',
        'delphixpy/v1_11_2/web/source/operationTemplate',
        'delphixpy/v1_11_2/web/service',
        'delphixpy/v1_11_2/web/service/smtp',
        'delphixpy/v1_11_2/web/service/ldap',
        'delphixpy/v1_11_2/web/service/ldap/server',
        'delphixpy/v1_11_2/web/service/nfs',
        'delphixpy/v1_11_2/web/service/snmp',
        'delphixpy/v1_11_2/web/service/snmp/manager',
        'delphixpy/v1_11_2/web/service/userInterface',
        'delphixpy/v1_11_2/web/service/linkingsettings',
        'delphixpy/v1_11_2/web/service/phonehome',
        'delphixpy/v1_11_2/web/service/httpConnector',
        'delphixpy/v1_11_2/web/service/userPaths',
        'delphixpy/v1_11_2/web/service/security',
        'delphixpy/v1_11_2/web/service/dns',
        'delphixpy/v1_11_2/web/service/kerberos',
        'delphixpy/v1_11_2/web/service/schema',
        'delphixpy/v1_11_2/web/service/tls',
        'delphixpy/v1_11_2/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_2/web/service/tls/csr',
        'delphixpy/v1_11_2/web/service/tls/cipherSuite',
        'delphixpy/v1_11_2/web/service/tls/caCertificate',
        'delphixpy/v1_11_2/web/service/insight',
        'delphixpy/v1_11_2/web/service/insight/splunkHec',
        'delphixpy/v1_11_2/web/service/saml',
        'delphixpy/v1_11_2/web/service/saml/serviceprovider',
        'delphixpy/v1_11_2/web/service/locale',
        'delphixpy/v1_11_2/web/service/cloud',
        'delphixpy/v1_11_2/web/service/proxy',
        'delphixpy/v1_11_2/web/service/certificate',
        'delphixpy/v1_11_2/web/service/time',
        'delphixpy/v1_11_2/web/service/syslog',
        'delphixpy/v1_11_2/web/service/support',
        'delphixpy/v1_11_2/web/service/support/access',
        'delphixpy/v1_11_2/web/service/support/bundle',
        'delphixpy/v1_11_2/web/service/minimalPhonehome',
        'delphixpy/v1_11_2/web/service/passwordVault',
        'delphixpy/v1_11_2/web/service/sso',
        'delphixpy/v1_11_2/web/system',
        'delphixpy/v1_11_2/web/system/verification',
        'delphixpy/v1_11_2/web/system/verification/reports',
        'delphixpy/v1_11_2/web/system/verification/reports/steps',
        'delphixpy/v1_11_2/web/system/upgradeCheckResult',
        'delphixpy/v1_11_2/web/system/status',
        'delphixpy/v1_11_2/web/system/version',
        'delphixpy/v1_11_2/web/system/package',
        'delphixpy/v1_11_2/web/network',
        'delphixpy/v1_11_2/web/network/route',
        'delphixpy/v1_11_2/web/network/test',
        'delphixpy/v1_11_2/web/network/test/latency',
        'delphixpy/v1_11_2/web/network/test/throughput',
        'delphixpy/v1_11_2/web/network/test/dsp',
        'delphixpy/v1_11_2/web/network/interface',
        'delphixpy/v1_11_2/web/network/dsp',
        'delphixpy/v1_11_2/web/network/dsp/autotune',
        'delphixpy/v1_11_2/web/session',
        'delphixpy/v1_11_0',
        'delphixpy/v1_11_0/web',
        'delphixpy/v1_11_0/web/authorization',
        'delphixpy/v1_11_0/web/authorization/configuration',
        'delphixpy/v1_11_0/web/permission',
        'delphixpy/v1_11_0/web/passwordPolicy',
        'delphixpy/v1_11_0/web/role',
        'delphixpy/v1_11_0/web/toolkit',
        'delphixpy/v1_11_0/web/environment',
        'delphixpy/v1_11_0/web/environment/user',
        'delphixpy/v1_11_0/web/environment/oracle',
        'delphixpy/v1_11_0/web/environment/oracle/listener',
        'delphixpy/v1_11_0/web/environment/oracle/clusternode',
        'delphixpy/v1_11_0/web/environment/windows',
        'delphixpy/v1_11_0/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_0/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_0/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_0/web/environment/windows/clusternode',
        'delphixpy/v1_11_0/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_0/web/capacity',
        'delphixpy/v1_11_0/web/capacity/group',
        'delphixpy/v1_11_0/web/capacity/group/historical',
        'delphixpy/v1_11_0/web/capacity/consumer',
        'delphixpy/v1_11_0/web/capacity/consumer/historical',
        'delphixpy/v1_11_0/web/capacity/snapshot',
        'delphixpy/v1_11_0/web/capacity/system',
        'delphixpy/v1_11_0/web/capacity/system/historical',
        'delphixpy/v1_11_0/web/database',
        'delphixpy/v1_11_0/web/database/performanceHistory',
        'delphixpy/v1_11_0/web/database/template',
        'delphixpy/v1_11_0/web/registration',
        'delphixpy/v1_11_0/web/registration/status',
        'delphixpy/v1_11_0/web/host',
        'delphixpy/v1_11_0/web/host/privilegeElevation',
        'delphixpy/v1_11_0/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_0/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_0/web/theme',
        'delphixpy/v1_11_0/web/data',
        'delphixpy/v1_11_0/web/transformation',
        'delphixpy/v1_11_0/web/repository',
        'delphixpy/v1_11_0/web/repository/template',
        'delphixpy/v1_11_0/web/policy',
        'delphixpy/v1_11_0/web/user',
        'delphixpy/v1_11_0/web/alert',
        'delphixpy/v1_11_0/web/alert/profile',
        'delphixpy/v1_11_0/web/objects',
        'delphixpy/v1_11_0/web/maskingjob',
        'delphixpy/v1_11_0/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_0/web/timezone',
        'delphixpy/v1_11_0/web/fault',
        'delphixpy/v1_11_0/web/fault/effect',
        'delphixpy/v1_11_0/web/group',
        'delphixpy/v1_11_0/web/connectivity',
        'delphixpy/v1_11_0/web/notification',
        'delphixpy/v1_11_0/web/delphix',
        'delphixpy/v1_11_0/web/job',
        'delphixpy/v1_11_0/web/usage',
        'delphixpy/v1_11_0/web/about',
        'delphixpy/v1_11_0/web/timeflow',
        'delphixpy/v1_11_0/web/timeflow/bookmark',
        'delphixpy/v1_11_0/web/timeflow/oracle',
        'delphixpy/v1_11_0/web/timeflow/oracle/log',
        'delphixpy/v1_11_0/web/action',
        'delphixpy/v1_11_0/web/storage',
        'delphixpy/v1_11_0/web/storage/remove',
        'delphixpy/v1_11_0/web/storage/test',
        'delphixpy/v1_11_0/web/storage/device',
        'delphixpy/v1_11_0/web/storage/scrub',
        'delphixpy/v1_11_0/web/domain',
        'delphixpy/v1_11_0/web/analytics',
        'delphixpy/v1_11_0/web/analytics/statistic',
        'delphixpy/v1_11_0/web/selfservice',
        'delphixpy/v1_11_0/web/selfservice/branch',
        'delphixpy/v1_11_0/web/selfservice/container',
        'delphixpy/v1_11_0/web/selfservice/usagedata',
        'delphixpy/v1_11_0/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_0/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_0/web/selfservice/bookmark',
        'delphixpy/v1_11_0/web/selfservice/datasource',
        'delphixpy/v1_11_0/web/selfservice/operation',
        'delphixpy/v1_11_0/web/selfservice/template',
        'delphixpy/v1_11_0/web/selfservice/usage',
        'delphixpy/v1_11_0/web/selfservice/usage/branch',
        'delphixpy/v1_11_0/web/selfservice/usage/user',
        'delphixpy/v1_11_0/web/selfservice/usage/container',
        'delphixpy/v1_11_0/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_0/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_0/web/selfservice/usage/template',
        'delphixpy/v1_11_0/web/selfservice/config',
        'delphixpy/v1_11_0/web/snapshot',
        'delphixpy/v1_11_0/web/sourceconfig',
        'delphixpy/v1_11_0/web/namespace',
        'delphixpy/v1_11_0/web/replication',
        'delphixpy/v1_11_0/web/replication/spec',
        'delphixpy/v1_11_0/web/replication/targetstate',
        'delphixpy/v1_11_0/web/replication/sourcestate',
        'delphixpy/v1_11_0/web/replication/serializationpoint',
        'delphixpy/v1_11_0/web/source',
        'delphixpy/v1_11_0/web/source/operationTemplate',
        'delphixpy/v1_11_0/web/service',
        'delphixpy/v1_11_0/web/service/smtp',
        'delphixpy/v1_11_0/web/service/ldap',
        'delphixpy/v1_11_0/web/service/ldap/server',
        'delphixpy/v1_11_0/web/service/nfs',
        'delphixpy/v1_11_0/web/service/snmp',
        'delphixpy/v1_11_0/web/service/snmp/manager',
        'delphixpy/v1_11_0/web/service/userInterface',
        'delphixpy/v1_11_0/web/service/linkingsettings',
        'delphixpy/v1_11_0/web/service/phonehome',
        'delphixpy/v1_11_0/web/service/httpConnector',
        'delphixpy/v1_11_0/web/service/userPaths',
        'delphixpy/v1_11_0/web/service/security',
        'delphixpy/v1_11_0/web/service/dns',
        'delphixpy/v1_11_0/web/service/kerberos',
        'delphixpy/v1_11_0/web/service/schema',
        'delphixpy/v1_11_0/web/service/tls',
        'delphixpy/v1_11_0/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_0/web/service/tls/csr',
        'delphixpy/v1_11_0/web/service/tls/cipherSuite',
        'delphixpy/v1_11_0/web/service/tls/caCertificate',
        'delphixpy/v1_11_0/web/service/insight',
        'delphixpy/v1_11_0/web/service/insight/splunkHec',
        'delphixpy/v1_11_0/web/service/saml',
        'delphixpy/v1_11_0/web/service/saml/serviceprovider',
        'delphixpy/v1_11_0/web/service/locale',
        'delphixpy/v1_11_0/web/service/cloud',
        'delphixpy/v1_11_0/web/service/proxy',
        'delphixpy/v1_11_0/web/service/certificate',
        'delphixpy/v1_11_0/web/service/time',
        'delphixpy/v1_11_0/web/service/syslog',
        'delphixpy/v1_11_0/web/service/support',
        'delphixpy/v1_11_0/web/service/support/access',
        'delphixpy/v1_11_0/web/service/support/bundle',
        'delphixpy/v1_11_0/web/service/sso',
        'delphixpy/v1_11_0/web/system',
        'delphixpy/v1_11_0/web/system/verification',
        'delphixpy/v1_11_0/web/system/verification/reports',
        'delphixpy/v1_11_0/web/system/verification/reports/steps',
        'delphixpy/v1_11_0/web/system/upgradeCheckResult',
        'delphixpy/v1_11_0/web/system/status',
        'delphixpy/v1_11_0/web/system/version',
        'delphixpy/v1_11_0/web/system/package',
        'delphixpy/v1_11_0/web/network',
        'delphixpy/v1_11_0/web/network/route',
        'delphixpy/v1_11_0/web/network/test',
        'delphixpy/v1_11_0/web/network/test/latency',
        'delphixpy/v1_11_0/web/network/test/throughput',
        'delphixpy/v1_11_0/web/network/test/dsp',
        'delphixpy/v1_11_0/web/network/interface',
        'delphixpy/v1_11_0/web/network/dsp',
        'delphixpy/v1_11_0/web/network/dsp/autotune',
        'delphixpy/v1_11_0/web/session',
        'delphixpy/v1_11_23',
        'delphixpy/v1_11_23/web',
        'delphixpy/v1_11_23/web/authorization',
        'delphixpy/v1_11_23/web/authorization/configuration',
        'delphixpy/v1_11_23/web/permission',
        'delphixpy/v1_11_23/web/passwordPolicy',
        'delphixpy/v1_11_23/web/role',
        'delphixpy/v1_11_23/web/toolkit',
        'delphixpy/v1_11_23/web/environment',
        'delphixpy/v1_11_23/web/environment/user',
        'delphixpy/v1_11_23/web/environment/oracle',
        'delphixpy/v1_11_23/web/environment/oracle/listener',
        'delphixpy/v1_11_23/web/environment/oracle/clusternode',
        'delphixpy/v1_11_23/web/environment/windows',
        'delphixpy/v1_11_23/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_23/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_23/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_23/web/environment/windows/clusternode',
        'delphixpy/v1_11_23/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_23/web/capacity',
        'delphixpy/v1_11_23/web/capacity/heldspace',
        'delphixpy/v1_11_23/web/capacity/group',
        'delphixpy/v1_11_23/web/capacity/group/historical',
        'delphixpy/v1_11_23/web/capacity/consumer',
        'delphixpy/v1_11_23/web/capacity/consumer/historical',
        'delphixpy/v1_11_23/web/capacity/snapshot',
        'delphixpy/v1_11_23/web/capacity/system',
        'delphixpy/v1_11_23/web/capacity/system/historical',
        'delphixpy/v1_11_23/web/database',
        'delphixpy/v1_11_23/web/database/performanceHistory',
        'delphixpy/v1_11_23/web/database/template',
        'delphixpy/v1_11_23/web/registration',
        'delphixpy/v1_11_23/web/registration/status',
        'delphixpy/v1_11_23/web/host',
        'delphixpy/v1_11_23/web/host/privilegeElevation',
        'delphixpy/v1_11_23/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_23/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_23/web/theme',
        'delphixpy/v1_11_23/web/repave',
        'delphixpy/v1_11_23/web/osadmin',
        'delphixpy/v1_11_23/web/osadmin/engineStatus',
        'delphixpy/v1_11_23/web/data',
        'delphixpy/v1_11_23/web/transformation',
        'delphixpy/v1_11_23/web/repository',
        'delphixpy/v1_11_23/web/repository/template',
        'delphixpy/v1_11_23/web/policy',
        'delphixpy/v1_11_23/web/user',
        'delphixpy/v1_11_23/web/superuser',
        'delphixpy/v1_11_23/web/superuser/session',
        'delphixpy/v1_11_23/web/alert',
        'delphixpy/v1_11_23/web/alert/profile',
        'delphixpy/v1_11_23/web/objects',
        'delphixpy/v1_11_23/web/maskingjob',
        'delphixpy/v1_11_23/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_23/web/timezone',
        'delphixpy/v1_11_23/web/fault',
        'delphixpy/v1_11_23/web/fault/effect',
        'delphixpy/v1_11_23/web/group',
        'delphixpy/v1_11_23/web/license',
        'delphixpy/v1_11_23/web/connectivity',
        'delphixpy/v1_11_23/web/notification',
        'delphixpy/v1_11_23/web/delphix',
        'delphixpy/v1_11_23/web/job',
        'delphixpy/v1_11_23/web/job/retention',
        'delphixpy/v1_11_23/web/usage',
        'delphixpy/v1_11_23/web/about',
        'delphixpy/v1_11_23/web/timeflow',
        'delphixpy/v1_11_23/web/timeflow/bookmark',
        'delphixpy/v1_11_23/web/timeflow/oracle',
        'delphixpy/v1_11_23/web/timeflow/oracle/log',
        'delphixpy/v1_11_23/web/action',
        'delphixpy/v1_11_23/web/storage',
        'delphixpy/v1_11_23/web/storage/objectStorage',
        'delphixpy/v1_11_23/web/storage/remove',
        'delphixpy/v1_11_23/web/storage/iscsi',
        'delphixpy/v1_11_23/web/storage/iscsi/target',
        'delphixpy/v1_11_23/web/storage/iscsi/initiator',
        'delphixpy/v1_11_23/web/storage/test',
        'delphixpy/v1_11_23/web/storage/device',
        'delphixpy/v1_11_23/web/storage/scrub',
        'delphixpy/v1_11_23/web/domain',
        'delphixpy/v1_11_23/web/analytics',
        'delphixpy/v1_11_23/web/analytics/statistic',
        'delphixpy/v1_11_23/web/selfservice',
        'delphixpy/v1_11_23/web/selfservice/branch',
        'delphixpy/v1_11_23/web/selfservice/container',
        'delphixpy/v1_11_23/web/selfservice/usagedata',
        'delphixpy/v1_11_23/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_23/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_23/web/selfservice/bookmark',
        'delphixpy/v1_11_23/web/selfservice/datasource',
        'delphixpy/v1_11_23/web/selfservice/operation',
        'delphixpy/v1_11_23/web/selfservice/template',
        'delphixpy/v1_11_23/web/selfservice/usage',
        'delphixpy/v1_11_23/web/selfservice/usage/branch',
        'delphixpy/v1_11_23/web/selfservice/usage/user',
        'delphixpy/v1_11_23/web/selfservice/usage/container',
        'delphixpy/v1_11_23/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_23/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_23/web/selfservice/usage/template',
        'delphixpy/v1_11_23/web/selfservice/config',
        'delphixpy/v1_11_23/web/snapshot',
        'delphixpy/v1_11_23/web/sourceconfig',
        'delphixpy/v1_11_23/web/namespace',
        'delphixpy/v1_11_23/web/replication',
        'delphixpy/v1_11_23/web/replication/spec',
        'delphixpy/v1_11_23/web/replication/targetstate',
        'delphixpy/v1_11_23/web/replication/sourcestate',
        'delphixpy/v1_11_23/web/replication/serializationpoint',
        'delphixpy/v1_11_23/web/source',
        'delphixpy/v1_11_23/web/source/operationTemplate',
        'delphixpy/v1_11_23/web/service',
        'delphixpy/v1_11_23/web/service/smtp',
        'delphixpy/v1_11_23/web/service/ldap',
        'delphixpy/v1_11_23/web/service/ldap/server',
        'delphixpy/v1_11_23/web/service/nfs',
        'delphixpy/v1_11_23/web/service/host',
        'delphixpy/v1_11_23/web/service/host/address',
        'delphixpy/v1_11_23/web/service/snmp',
        'delphixpy/v1_11_23/web/service/snmp/v3',
        'delphixpy/v1_11_23/web/service/snmp/v3/manager',
        'delphixpy/v1_11_23/web/service/snmp/v3/usm',
        'delphixpy/v1_11_23/web/service/snmp/v2',
        'delphixpy/v1_11_23/web/service/snmp/v2/manager',
        'delphixpy/v1_11_23/web/service/userInterface',
        'delphixpy/v1_11_23/web/service/linkingsettings',
        'delphixpy/v1_11_23/web/service/phonehome',
        'delphixpy/v1_11_23/web/service/events',
        'delphixpy/v1_11_23/web/service/fluentd',
        'delphixpy/v1_11_23/web/service/fluentd/plugins',
        'delphixpy/v1_11_23/web/service/fluentd/configuration',
        'delphixpy/v1_11_23/web/service/httpConnector',
        'delphixpy/v1_11_23/web/service/userPaths',
        'delphixpy/v1_11_23/web/service/security',
        'delphixpy/v1_11_23/web/service/dns',
        'delphixpy/v1_11_23/web/service/kerberos',
        'delphixpy/v1_11_23/web/service/schema',
        'delphixpy/v1_11_23/web/service/tls',
        'delphixpy/v1_11_23/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_23/web/service/tls/csr',
        'delphixpy/v1_11_23/web/service/tls/cipherSuite',
        'delphixpy/v1_11_23/web/service/tls/caCertificate',
        'delphixpy/v1_11_23/web/service/insight',
        'delphixpy/v1_11_23/web/service/insight/splunkHec',
        'delphixpy/v1_11_23/web/service/locale',
        'delphixpy/v1_11_23/web/service/cloud',
        'delphixpy/v1_11_23/web/service/proxy',
        'delphixpy/v1_11_23/web/service/time',
        'delphixpy/v1_11_23/web/service/syslog',
        'delphixpy/v1_11_23/web/service/passwordReset',
        'delphixpy/v1_11_23/web/service/support',
        'delphixpy/v1_11_23/web/service/support/access',
        'delphixpy/v1_11_23/web/service/support/bundle',
        'delphixpy/v1_11_23/web/service/minimalPhonehome',
        'delphixpy/v1_11_23/web/service/passwordVault',
        'delphixpy/v1_11_23/web/service/oauth2',
        'delphixpy/v1_11_23/web/service/sso',
        'delphixpy/v1_11_23/web/system',
        'delphixpy/v1_11_23/web/system/verification',
        'delphixpy/v1_11_23/web/system/verification/reports',
        'delphixpy/v1_11_23/web/system/verification/reports/steps',
        'delphixpy/v1_11_23/web/system/advancedSettings',
        'delphixpy/v1_11_23/web/system/upgradeCheckResult',
        'delphixpy/v1_11_23/web/system/status',
        'delphixpy/v1_11_23/web/system/version',
        'delphixpy/v1_11_23/web/network',
        'delphixpy/v1_11_23/web/network/route',
        'delphixpy/v1_11_23/web/network/test',
        'delphixpy/v1_11_23/web/network/test/latency',
        'delphixpy/v1_11_23/web/network/test/throughput',
        'delphixpy/v1_11_23/web/network/test/dsp',
        'delphixpy/v1_11_23/web/network/interface',
        'delphixpy/v1_11_23/web/network/dsp',
        'delphixpy/v1_11_23/web/network/dsp/autotune',
        'delphixpy/v1_11_23/web/session',
        'delphixpy/v1_4_0',
        'delphixpy/v1_4_0/web',
        'delphixpy/v1_4_0/web/authorization',
        'delphixpy/v1_4_0/web/permission',
        'delphixpy/v1_4_0/web/role',
        'delphixpy/v1_4_0/web/toolkit',
        'delphixpy/v1_4_0/web/environment',
        'delphixpy/v1_4_0/web/environment/user',
        'delphixpy/v1_4_0/web/environment/oracle',
        'delphixpy/v1_4_0/web/environment/oracle/listener',
        'delphixpy/v1_4_0/web/environment/oracle/clusternode',
        'delphixpy/v1_4_0/web/environment/windows',
        'delphixpy/v1_4_0/web/environment/windows/clusterinstance',
        'delphixpy/v1_4_0/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_4_0/web/environment/windows/clusternode',
        'delphixpy/v1_4_0/web/capacity',
        'delphixpy/v1_4_0/web/capacity/group',
        'delphixpy/v1_4_0/web/capacity/group/historical',
        'delphixpy/v1_4_0/web/capacity/consumer',
        'delphixpy/v1_4_0/web/capacity/consumer/historical',
        'delphixpy/v1_4_0/web/capacity/snapshot',
        'delphixpy/v1_4_0/web/capacity/system',
        'delphixpy/v1_4_0/web/capacity/system/historical',
        'delphixpy/v1_4_0/web/database',
        'delphixpy/v1_4_0/web/database/template',
        'delphixpy/v1_4_0/web/registration',
        'delphixpy/v1_4_0/web/host',
        'delphixpy/v1_4_0/web/host/privilegeElevation',
        'delphixpy/v1_4_0/web/host/privilegeElevation/profile',
        'delphixpy/v1_4_0/web/data',
        'delphixpy/v1_4_0/web/repository',
        'delphixpy/v1_4_0/web/policy',
        'delphixpy/v1_4_0/web/user',
        'delphixpy/v1_4_0/web/alert',
        'delphixpy/v1_4_0/web/alert/profile',
        'delphixpy/v1_4_0/web/objects',
        'delphixpy/v1_4_0/web/fault',
        'delphixpy/v1_4_0/web/fault/effect',
        'delphixpy/v1_4_0/web/group',
        'delphixpy/v1_4_0/web/connectivity',
        'delphixpy/v1_4_0/web/notification',
        'delphixpy/v1_4_0/web/delphix',
        'delphixpy/v1_4_0/web/job',
        'delphixpy/v1_4_0/web/about',
        'delphixpy/v1_4_0/web/timeflow',
        'delphixpy/v1_4_0/web/timeflow/bookmark',
        'delphixpy/v1_4_0/web/action',
        'delphixpy/v1_4_0/web/jetstream',
        'delphixpy/v1_4_0/web/jetstream/branch',
        'delphixpy/v1_4_0/web/jetstream/capacity',
        'delphixpy/v1_4_0/web/jetstream/capacity/branch',
        'delphixpy/v1_4_0/web/jetstream/capacity/container',
        'delphixpy/v1_4_0/web/jetstream/capacity/bookmark',
        'delphixpy/v1_4_0/web/jetstream/capacity/bookmark/tag',
        'delphixpy/v1_4_0/web/jetstream/capacity/template',
        'delphixpy/v1_4_0/web/jetstream/preferences',
        'delphixpy/v1_4_0/web/jetstream/container',
        'delphixpy/v1_4_0/web/jetstream/usagedata',
        'delphixpy/v1_4_0/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_4_0/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_4_0/web/jetstream/bookmark',
        'delphixpy/v1_4_0/web/jetstream/datasource',
        'delphixpy/v1_4_0/web/jetstream/operation',
        'delphixpy/v1_4_0/web/jetstream/template',
        'delphixpy/v1_4_0/web/storage',
        'delphixpy/v1_4_0/web/storage/device',
        'delphixpy/v1_4_0/web/storage/scrub',
        'delphixpy/v1_4_0/web/domain',
        'delphixpy/v1_4_0/web/analytics',
        'delphixpy/v1_4_0/web/analytics/statistic',
        'delphixpy/v1_4_0/web/snapshot',
        'delphixpy/v1_4_0/web/sourceconfig',
        'delphixpy/v1_4_0/web/sourceconfig/oracle',
        'delphixpy/v1_4_0/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_4_0/web/namespace',
        'delphixpy/v1_4_0/web/replication',
        'delphixpy/v1_4_0/web/replication/spec',
        'delphixpy/v1_4_0/web/source',
        'delphixpy/v1_4_0/web/service',
        'delphixpy/v1_4_0/web/service/smtp',
        'delphixpy/v1_4_0/web/service/ldap',
        'delphixpy/v1_4_0/web/service/ldap/server',
        'delphixpy/v1_4_0/web/service/snmp',
        'delphixpy/v1_4_0/web/service/snmp/manager',
        'delphixpy/v1_4_0/web/service/linkingsettings',
        'delphixpy/v1_4_0/web/service/phonehome',
        'delphixpy/v1_4_0/web/service/security',
        'delphixpy/v1_4_0/web/service/dns',
        'delphixpy/v1_4_0/web/service/locale',
        'delphixpy/v1_4_0/web/service/proxy',
        'delphixpy/v1_4_0/web/service/certificate',
        'delphixpy/v1_4_0/web/service/time',
        'delphixpy/v1_4_0/web/service/syslog',
        'delphixpy/v1_4_0/web/service/support',
        'delphixpy/v1_4_0/web/service/support/access',
        'delphixpy/v1_4_0/web/service/support/bundle',
        'delphixpy/v1_4_0/web/system',
        'delphixpy/v1_4_0/web/system/version',
        'delphixpy/v1_4_0/web/network',
        'delphixpy/v1_4_0/web/network/route',
        'delphixpy/v1_4_0/web/network/test',
        'delphixpy/v1_4_0/web/network/test/latency',
        'delphixpy/v1_4_0/web/network/test/throughput',
        'delphixpy/v1_4_0/web/network/interface',
        'delphixpy/v1_4_0/web/session',
        'delphixpy/v1_11_9',
        'delphixpy/v1_11_9/web',
        'delphixpy/v1_11_9/web/authorization',
        'delphixpy/v1_11_9/web/authorization/configuration',
        'delphixpy/v1_11_9/web/permission',
        'delphixpy/v1_11_9/web/passwordPolicy',
        'delphixpy/v1_11_9/web/role',
        'delphixpy/v1_11_9/web/toolkit',
        'delphixpy/v1_11_9/web/environment',
        'delphixpy/v1_11_9/web/environment/user',
        'delphixpy/v1_11_9/web/environment/oracle',
        'delphixpy/v1_11_9/web/environment/oracle/listener',
        'delphixpy/v1_11_9/web/environment/oracle/clusternode',
        'delphixpy/v1_11_9/web/environment/windows',
        'delphixpy/v1_11_9/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_9/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_9/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_9/web/environment/windows/clusternode',
        'delphixpy/v1_11_9/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_9/web/capacity',
        'delphixpy/v1_11_9/web/capacity/heldspace',
        'delphixpy/v1_11_9/web/capacity/group',
        'delphixpy/v1_11_9/web/capacity/group/historical',
        'delphixpy/v1_11_9/web/capacity/consumer',
        'delphixpy/v1_11_9/web/capacity/consumer/historical',
        'delphixpy/v1_11_9/web/capacity/snapshot',
        'delphixpy/v1_11_9/web/capacity/system',
        'delphixpy/v1_11_9/web/capacity/system/historical',
        'delphixpy/v1_11_9/web/database',
        'delphixpy/v1_11_9/web/database/performanceHistory',
        'delphixpy/v1_11_9/web/database/template',
        'delphixpy/v1_11_9/web/registration',
        'delphixpy/v1_11_9/web/registration/status',
        'delphixpy/v1_11_9/web/host',
        'delphixpy/v1_11_9/web/host/privilegeElevation',
        'delphixpy/v1_11_9/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_9/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_9/web/theme',
        'delphixpy/v1_11_9/web/data',
        'delphixpy/v1_11_9/web/transformation',
        'delphixpy/v1_11_9/web/repository',
        'delphixpy/v1_11_9/web/repository/template',
        'delphixpy/v1_11_9/web/policy',
        'delphixpy/v1_11_9/web/user',
        'delphixpy/v1_11_9/web/alert',
        'delphixpy/v1_11_9/web/alert/profile',
        'delphixpy/v1_11_9/web/objects',
        'delphixpy/v1_11_9/web/maskingjob',
        'delphixpy/v1_11_9/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_9/web/timezone',
        'delphixpy/v1_11_9/web/fault',
        'delphixpy/v1_11_9/web/fault/effect',
        'delphixpy/v1_11_9/web/group',
        'delphixpy/v1_11_9/web/license',
        'delphixpy/v1_11_9/web/connectivity',
        'delphixpy/v1_11_9/web/notification',
        'delphixpy/v1_11_9/web/delphix',
        'delphixpy/v1_11_9/web/job',
        'delphixpy/v1_11_9/web/usage',
        'delphixpy/v1_11_9/web/about',
        'delphixpy/v1_11_9/web/timeflow',
        'delphixpy/v1_11_9/web/timeflow/bookmark',
        'delphixpy/v1_11_9/web/timeflow/oracle',
        'delphixpy/v1_11_9/web/timeflow/oracle/log',
        'delphixpy/v1_11_9/web/action',
        'delphixpy/v1_11_9/web/storage',
        'delphixpy/v1_11_9/web/storage/remove',
        'delphixpy/v1_11_9/web/storage/iscsi',
        'delphixpy/v1_11_9/web/storage/iscsi/target',
        'delphixpy/v1_11_9/web/storage/iscsi/initiator',
        'delphixpy/v1_11_9/web/storage/test',
        'delphixpy/v1_11_9/web/storage/device',
        'delphixpy/v1_11_9/web/storage/scrub',
        'delphixpy/v1_11_9/web/domain',
        'delphixpy/v1_11_9/web/analytics',
        'delphixpy/v1_11_9/web/analytics/statistic',
        'delphixpy/v1_11_9/web/selfservice',
        'delphixpy/v1_11_9/web/selfservice/branch',
        'delphixpy/v1_11_9/web/selfservice/container',
        'delphixpy/v1_11_9/web/selfservice/usagedata',
        'delphixpy/v1_11_9/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_9/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_9/web/selfservice/bookmark',
        'delphixpy/v1_11_9/web/selfservice/datasource',
        'delphixpy/v1_11_9/web/selfservice/operation',
        'delphixpy/v1_11_9/web/selfservice/template',
        'delphixpy/v1_11_9/web/selfservice/usage',
        'delphixpy/v1_11_9/web/selfservice/usage/branch',
        'delphixpy/v1_11_9/web/selfservice/usage/user',
        'delphixpy/v1_11_9/web/selfservice/usage/container',
        'delphixpy/v1_11_9/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_9/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_9/web/selfservice/usage/template',
        'delphixpy/v1_11_9/web/selfservice/config',
        'delphixpy/v1_11_9/web/snapshot',
        'delphixpy/v1_11_9/web/sourceconfig',
        'delphixpy/v1_11_9/web/namespace',
        'delphixpy/v1_11_9/web/replication',
        'delphixpy/v1_11_9/web/replication/spec',
        'delphixpy/v1_11_9/web/replication/targetstate',
        'delphixpy/v1_11_9/web/replication/sourcestate',
        'delphixpy/v1_11_9/web/replication/serializationpoint',
        'delphixpy/v1_11_9/web/source',
        'delphixpy/v1_11_9/web/source/operationTemplate',
        'delphixpy/v1_11_9/web/service',
        'delphixpy/v1_11_9/web/service/smtp',
        'delphixpy/v1_11_9/web/service/ldap',
        'delphixpy/v1_11_9/web/service/ldap/server',
        'delphixpy/v1_11_9/web/service/nfs',
        'delphixpy/v1_11_9/web/service/host',
        'delphixpy/v1_11_9/web/service/host/address',
        'delphixpy/v1_11_9/web/service/snmp',
        'delphixpy/v1_11_9/web/service/snmp/v3',
        'delphixpy/v1_11_9/web/service/snmp/v3/manager',
        'delphixpy/v1_11_9/web/service/snmp/v3/usm',
        'delphixpy/v1_11_9/web/service/snmp/v2',
        'delphixpy/v1_11_9/web/service/snmp/v2/manager',
        'delphixpy/v1_11_9/web/service/userInterface',
        'delphixpy/v1_11_9/web/service/linkingsettings',
        'delphixpy/v1_11_9/web/service/phonehome',
        'delphixpy/v1_11_9/web/service/httpConnector',
        'delphixpy/v1_11_9/web/service/userPaths',
        'delphixpy/v1_11_9/web/service/security',
        'delphixpy/v1_11_9/web/service/dns',
        'delphixpy/v1_11_9/web/service/kerberos',
        'delphixpy/v1_11_9/web/service/schema',
        'delphixpy/v1_11_9/web/service/tls',
        'delphixpy/v1_11_9/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_9/web/service/tls/csr',
        'delphixpy/v1_11_9/web/service/tls/cipherSuite',
        'delphixpy/v1_11_9/web/service/tls/caCertificate',
        'delphixpy/v1_11_9/web/service/insight',
        'delphixpy/v1_11_9/web/service/insight/splunkHec',
        'delphixpy/v1_11_9/web/service/locale',
        'delphixpy/v1_11_9/web/service/cloud',
        'delphixpy/v1_11_9/web/service/proxy',
        'delphixpy/v1_11_9/web/service/time',
        'delphixpy/v1_11_9/web/service/syslog',
        'delphixpy/v1_11_9/web/service/support',
        'delphixpy/v1_11_9/web/service/support/access',
        'delphixpy/v1_11_9/web/service/support/bundle',
        'delphixpy/v1_11_9/web/service/minimalPhonehome',
        'delphixpy/v1_11_9/web/service/passwordVault',
        'delphixpy/v1_11_9/web/service/sso',
        'delphixpy/v1_11_9/web/system',
        'delphixpy/v1_11_9/web/system/verification',
        'delphixpy/v1_11_9/web/system/verification/reports',
        'delphixpy/v1_11_9/web/system/verification/reports/steps',
        'delphixpy/v1_11_9/web/system/advancedSettings',
        'delphixpy/v1_11_9/web/system/upgradeCheckResult',
        'delphixpy/v1_11_9/web/system/status',
        'delphixpy/v1_11_9/web/system/version',
        'delphixpy/v1_11_9/web/system/package',
        'delphixpy/v1_11_9/web/network',
        'delphixpy/v1_11_9/web/network/route',
        'delphixpy/v1_11_9/web/network/test',
        'delphixpy/v1_11_9/web/network/test/latency',
        'delphixpy/v1_11_9/web/network/test/throughput',
        'delphixpy/v1_11_9/web/network/test/dsp',
        'delphixpy/v1_11_9/web/network/interface',
        'delphixpy/v1_11_9/web/network/dsp',
        'delphixpy/v1_11_9/web/network/dsp/autotune',
        'delphixpy/v1_11_9/web/session',
        'delphixpy/v1_11_26',
        'delphixpy/v1_11_26/web',
        'delphixpy/v1_11_26/web/authorization',
        'delphixpy/v1_11_26/web/authorization/configuration',
        'delphixpy/v1_11_26/web/permission',
        'delphixpy/v1_11_26/web/passwordPolicy',
        'delphixpy/v1_11_26/web/role',
        'delphixpy/v1_11_26/web/toolkit',
        'delphixpy/v1_11_26/web/environment',
        'delphixpy/v1_11_26/web/environment/user',
        'delphixpy/v1_11_26/web/environment/oracle',
        'delphixpy/v1_11_26/web/environment/oracle/listener',
        'delphixpy/v1_11_26/web/environment/oracle/clusternode',
        'delphixpy/v1_11_26/web/environment/windows',
        'delphixpy/v1_11_26/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_26/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_26/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_26/web/environment/windows/clusternode',
        'delphixpy/v1_11_26/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_26/web/capacity',
        'delphixpy/v1_11_26/web/capacity/heldspace',
        'delphixpy/v1_11_26/web/capacity/group',
        'delphixpy/v1_11_26/web/capacity/group/historical',
        'delphixpy/v1_11_26/web/capacity/consumer',
        'delphixpy/v1_11_26/web/capacity/consumer/historical',
        'delphixpy/v1_11_26/web/capacity/snapshot',
        'delphixpy/v1_11_26/web/capacity/system',
        'delphixpy/v1_11_26/web/capacity/system/historical',
        'delphixpy/v1_11_26/web/database',
        'delphixpy/v1_11_26/web/database/performanceHistory',
        'delphixpy/v1_11_26/web/database/template',
        'delphixpy/v1_11_26/web/registration',
        'delphixpy/v1_11_26/web/registration/status',
        'delphixpy/v1_11_26/web/host',
        'delphixpy/v1_11_26/web/host/privilegeElevation',
        'delphixpy/v1_11_26/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_26/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_26/web/theme',
        'delphixpy/v1_11_26/web/repave',
        'delphixpy/v1_11_26/web/osadmin',
        'delphixpy/v1_11_26/web/osadmin/engineStatus',
        'delphixpy/v1_11_26/web/data',
        'delphixpy/v1_11_26/web/transformation',
        'delphixpy/v1_11_26/web/repository',
        'delphixpy/v1_11_26/web/repository/template',
        'delphixpy/v1_11_26/web/policy',
        'delphixpy/v1_11_26/web/user',
        'delphixpy/v1_11_26/web/superuser',
        'delphixpy/v1_11_26/web/superuser/session',
        'delphixpy/v1_11_26/web/alert',
        'delphixpy/v1_11_26/web/alert/profile',
        'delphixpy/v1_11_26/web/objects',
        'delphixpy/v1_11_26/web/maskingjob',
        'delphixpy/v1_11_26/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_26/web/timezone',
        'delphixpy/v1_11_26/web/fault',
        'delphixpy/v1_11_26/web/fault/effect',
        'delphixpy/v1_11_26/web/group',
        'delphixpy/v1_11_26/web/license',
        'delphixpy/v1_11_26/web/connectivity',
        'delphixpy/v1_11_26/web/notification',
        'delphixpy/v1_11_26/web/delphix',
        'delphixpy/v1_11_26/web/job',
        'delphixpy/v1_11_26/web/job/retention',
        'delphixpy/v1_11_26/web/usage',
        'delphixpy/v1_11_26/web/about',
        'delphixpy/v1_11_26/web/timeflow',
        'delphixpy/v1_11_26/web/timeflow/bookmark',
        'delphixpy/v1_11_26/web/timeflow/oracle',
        'delphixpy/v1_11_26/web/timeflow/oracle/log',
        'delphixpy/v1_11_26/web/action',
        'delphixpy/v1_11_26/web/storage',
        'delphixpy/v1_11_26/web/storage/objectStorage',
        'delphixpy/v1_11_26/web/storage/remove',
        'delphixpy/v1_11_26/web/storage/iscsi',
        'delphixpy/v1_11_26/web/storage/iscsi/target',
        'delphixpy/v1_11_26/web/storage/iscsi/initiator',
        'delphixpy/v1_11_26/web/storage/migrate',
        'delphixpy/v1_11_26/web/storage/test',
        'delphixpy/v1_11_26/web/storage/device',
        'delphixpy/v1_11_26/web/storage/scrub',
        'delphixpy/v1_11_26/web/domain',
        'delphixpy/v1_11_26/web/analytics',
        'delphixpy/v1_11_26/web/analytics/statistic',
        'delphixpy/v1_11_26/web/selfservice',
        'delphixpy/v1_11_26/web/selfservice/branch',
        'delphixpy/v1_11_26/web/selfservice/container',
        'delphixpy/v1_11_26/web/selfservice/usagedata',
        'delphixpy/v1_11_26/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_26/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_26/web/selfservice/bookmark',
        'delphixpy/v1_11_26/web/selfservice/datasource',
        'delphixpy/v1_11_26/web/selfservice/operation',
        'delphixpy/v1_11_26/web/selfservice/template',
        'delphixpy/v1_11_26/web/selfservice/usage',
        'delphixpy/v1_11_26/web/selfservice/usage/branch',
        'delphixpy/v1_11_26/web/selfservice/usage/user',
        'delphixpy/v1_11_26/web/selfservice/usage/container',
        'delphixpy/v1_11_26/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_26/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_26/web/selfservice/usage/template',
        'delphixpy/v1_11_26/web/selfservice/config',
        'delphixpy/v1_11_26/web/snapshot',
        'delphixpy/v1_11_26/web/sourceconfig',
        'delphixpy/v1_11_26/web/namespace',
        'delphixpy/v1_11_26/web/replication',
        'delphixpy/v1_11_26/web/replication/spec',
        'delphixpy/v1_11_26/web/replication/targetstate',
        'delphixpy/v1_11_26/web/replication/sourcestate',
        'delphixpy/v1_11_26/web/replication/serializationpoint',
        'delphixpy/v1_11_26/web/source',
        'delphixpy/v1_11_26/web/source/operationTemplate',
        'delphixpy/v1_11_26/web/service',
        'delphixpy/v1_11_26/web/service/smtp',
        'delphixpy/v1_11_26/web/service/ldap',
        'delphixpy/v1_11_26/web/service/ldap/server',
        'delphixpy/v1_11_26/web/service/nfs',
        'delphixpy/v1_11_26/web/service/nfs/encryption',
        'delphixpy/v1_11_26/web/service/host',
        'delphixpy/v1_11_26/web/service/host/address',
        'delphixpy/v1_11_26/web/service/snmp',
        'delphixpy/v1_11_26/web/service/snmp/v3',
        'delphixpy/v1_11_26/web/service/snmp/v3/manager',
        'delphixpy/v1_11_26/web/service/snmp/v3/usm',
        'delphixpy/v1_11_26/web/service/snmp/v2',
        'delphixpy/v1_11_26/web/service/snmp/v2/manager',
        'delphixpy/v1_11_26/web/service/userInterface',
        'delphixpy/v1_11_26/web/service/linkingsettings',
        'delphixpy/v1_11_26/web/service/phonehome',
        'delphixpy/v1_11_26/web/service/events',
        'delphixpy/v1_11_26/web/service/fluentd',
        'delphixpy/v1_11_26/web/service/fluentd/plugins',
        'delphixpy/v1_11_26/web/service/fluentd/configuration',
        'delphixpy/v1_11_26/web/service/httpConnector',
        'delphixpy/v1_11_26/web/service/userPaths',
        'delphixpy/v1_11_26/web/service/security',
        'delphixpy/v1_11_26/web/service/dns',
        'delphixpy/v1_11_26/web/service/kerberos',
        'delphixpy/v1_11_26/web/service/schema',
        'delphixpy/v1_11_26/web/service/tls',
        'delphixpy/v1_11_26/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_26/web/service/tls/csr',
        'delphixpy/v1_11_26/web/service/tls/cipherSuite',
        'delphixpy/v1_11_26/web/service/tls/caCertificate',
        'delphixpy/v1_11_26/web/service/insight',
        'delphixpy/v1_11_26/web/service/insight/splunkHec',
        'delphixpy/v1_11_26/web/service/locale',
        'delphixpy/v1_11_26/web/service/cloud',
        'delphixpy/v1_11_26/web/service/proxy',
        'delphixpy/v1_11_26/web/service/time',
        'delphixpy/v1_11_26/web/service/syslog',
        'delphixpy/v1_11_26/web/service/passwordReset',
        'delphixpy/v1_11_26/web/service/support',
        'delphixpy/v1_11_26/web/service/support/access',
        'delphixpy/v1_11_26/web/service/support/bundle',
        'delphixpy/v1_11_26/web/service/minimalPhonehome',
        'delphixpy/v1_11_26/web/service/passwordVault',
        'delphixpy/v1_11_26/web/service/oauth2',
        'delphixpy/v1_11_26/web/service/sso',
        'delphixpy/v1_11_26/web/system',
        'delphixpy/v1_11_26/web/system/verification',
        'delphixpy/v1_11_26/web/system/verification/reports',
        'delphixpy/v1_11_26/web/system/verification/reports/steps',
        'delphixpy/v1_11_26/web/system/advancedSettings',
        'delphixpy/v1_11_26/web/system/upgradeCheckResult',
        'delphixpy/v1_11_26/web/system/status',
        'delphixpy/v1_11_26/web/system/version',
        'delphixpy/v1_11_26/web/network',
        'delphixpy/v1_11_26/web/network/route',
        'delphixpy/v1_11_26/web/network/test',
        'delphixpy/v1_11_26/web/network/test/latency',
        'delphixpy/v1_11_26/web/network/test/throughput',
        'delphixpy/v1_11_26/web/network/test/dsp',
        'delphixpy/v1_11_26/web/network/interface',
        'delphixpy/v1_11_26/web/network/dsp',
        'delphixpy/v1_11_26/web/network/dsp/autotune',
        'delphixpy/v1_11_26/web/session',
        'delphixpy/v1_7_0',
        'delphixpy/v1_7_0/web',
        'delphixpy/v1_7_0/web/authorization',
        'delphixpy/v1_7_0/web/permission',
        'delphixpy/v1_7_0/web/role',
        'delphixpy/v1_7_0/web/toolkit',
        'delphixpy/v1_7_0/web/environment',
        'delphixpy/v1_7_0/web/environment/user',
        'delphixpy/v1_7_0/web/environment/oracle',
        'delphixpy/v1_7_0/web/environment/oracle/listener',
        'delphixpy/v1_7_0/web/environment/oracle/clusternode',
        'delphixpy/v1_7_0/web/environment/windows',
        'delphixpy/v1_7_0/web/environment/windows/clusterinstance',
        'delphixpy/v1_7_0/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_7_0/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_7_0/web/environment/windows/clusternode',
        'delphixpy/v1_7_0/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_7_0/web/capacity',
        'delphixpy/v1_7_0/web/capacity/group',
        'delphixpy/v1_7_0/web/capacity/group/historical',
        'delphixpy/v1_7_0/web/capacity/consumer',
        'delphixpy/v1_7_0/web/capacity/consumer/historical',
        'delphixpy/v1_7_0/web/capacity/snapshot',
        'delphixpy/v1_7_0/web/capacity/system',
        'delphixpy/v1_7_0/web/capacity/system/historical',
        'delphixpy/v1_7_0/web/database',
        'delphixpy/v1_7_0/web/database/template',
        'delphixpy/v1_7_0/web/registration',
        'delphixpy/v1_7_0/web/registration/status',
        'delphixpy/v1_7_0/web/host',
        'delphixpy/v1_7_0/web/host/privilegeElevation',
        'delphixpy/v1_7_0/web/host/privilegeElevation/profile',
        'delphixpy/v1_7_0/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_7_0/web/data',
        'delphixpy/v1_7_0/web/transformation',
        'delphixpy/v1_7_0/web/repository',
        'delphixpy/v1_7_0/web/repository/template',
        'delphixpy/v1_7_0/web/policy',
        'delphixpy/v1_7_0/web/user',
        'delphixpy/v1_7_0/web/alert',
        'delphixpy/v1_7_0/web/alert/profile',
        'delphixpy/v1_7_0/web/objects',
        'delphixpy/v1_7_0/web/maskingjob',
        'delphixpy/v1_7_0/web/maskingjob/serviceconfig',
        'delphixpy/v1_7_0/web/timezone',
        'delphixpy/v1_7_0/web/fault',
        'delphixpy/v1_7_0/web/fault/effect',
        'delphixpy/v1_7_0/web/group',
        'delphixpy/v1_7_0/web/connectivity',
        'delphixpy/v1_7_0/web/notification',
        'delphixpy/v1_7_0/web/delphix',
        'delphixpy/v1_7_0/web/job',
        'delphixpy/v1_7_0/web/about',
        'delphixpy/v1_7_0/web/timeflow',
        'delphixpy/v1_7_0/web/timeflow/bookmark',
        'delphixpy/v1_7_0/web/timeflow/oracle',
        'delphixpy/v1_7_0/web/timeflow/oracle/log',
        'delphixpy/v1_7_0/web/action',
        'delphixpy/v1_7_0/web/jetstream',
        'delphixpy/v1_7_0/web/jetstream/branch',
        'delphixpy/v1_7_0/web/jetstream/container',
        'delphixpy/v1_7_0/web/jetstream/usagedata',
        'delphixpy/v1_7_0/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_7_0/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_7_0/web/jetstream/bookmark',
        'delphixpy/v1_7_0/web/jetstream/datasource',
        'delphixpy/v1_7_0/web/jetstream/operation',
        'delphixpy/v1_7_0/web/jetstream/template',
        'delphixpy/v1_7_0/web/jetstream/usage',
        'delphixpy/v1_7_0/web/jetstream/usage/branch',
        'delphixpy/v1_7_0/web/jetstream/usage/user',
        'delphixpy/v1_7_0/web/jetstream/usage/container',
        'delphixpy/v1_7_0/web/jetstream/usage/bookmark',
        'delphixpy/v1_7_0/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_7_0/web/jetstream/usage/template',
        'delphixpy/v1_7_0/web/storage',
        'delphixpy/v1_7_0/web/storage/remove',
        'delphixpy/v1_7_0/web/storage/test',
        'delphixpy/v1_7_0/web/storage/device',
        'delphixpy/v1_7_0/web/storage/scrub',
        'delphixpy/v1_7_0/web/domain',
        'delphixpy/v1_7_0/web/analytics',
        'delphixpy/v1_7_0/web/analytics/statistic',
        'delphixpy/v1_7_0/web/snapshot',
        'delphixpy/v1_7_0/web/sourceconfig',
        'delphixpy/v1_7_0/web/sourceconfig/oracle',
        'delphixpy/v1_7_0/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_7_0/web/namespace',
        'delphixpy/v1_7_0/web/replication',
        'delphixpy/v1_7_0/web/replication/spec',
        'delphixpy/v1_7_0/web/replication/targetstate',
        'delphixpy/v1_7_0/web/replication/sourcestate',
        'delphixpy/v1_7_0/web/replication/serializationpoint',
        'delphixpy/v1_7_0/web/source',
        'delphixpy/v1_7_0/web/source/operationTemplate',
        'delphixpy/v1_7_0/web/service',
        'delphixpy/v1_7_0/web/service/smtp',
        'delphixpy/v1_7_0/web/service/ldap',
        'delphixpy/v1_7_0/web/service/ldap/server',
        'delphixpy/v1_7_0/web/service/snmp',
        'delphixpy/v1_7_0/web/service/snmp/manager',
        'delphixpy/v1_7_0/web/service/linkingsettings',
        'delphixpy/v1_7_0/web/service/phonehome',
        'delphixpy/v1_7_0/web/service/security',
        'delphixpy/v1_7_0/web/service/dns',
        'delphixpy/v1_7_0/web/service/schema',
        'delphixpy/v1_7_0/web/service/locale',
        'delphixpy/v1_7_0/web/service/proxy',
        'delphixpy/v1_7_0/web/service/certificate',
        'delphixpy/v1_7_0/web/service/time',
        'delphixpy/v1_7_0/web/service/syslog',
        'delphixpy/v1_7_0/web/service/support',
        'delphixpy/v1_7_0/web/service/support/access',
        'delphixpy/v1_7_0/web/service/support/bundle',
        'delphixpy/v1_7_0/web/system',
        'delphixpy/v1_7_0/web/system/version',
        'delphixpy/v1_7_0/web/network',
        'delphixpy/v1_7_0/web/network/route',
        'delphixpy/v1_7_0/web/network/test',
        'delphixpy/v1_7_0/web/network/test/latency',
        'delphixpy/v1_7_0/web/network/test/throughput',
        'delphixpy/v1_7_0/web/network/test/dsp',
        'delphixpy/v1_7_0/web/network/interface',
        'delphixpy/v1_7_0/web/session',
        'delphixpy/v1_11_20',
        'delphixpy/v1_11_20/web',
        'delphixpy/v1_11_20/web/authorization',
        'delphixpy/v1_11_20/web/authorization/configuration',
        'delphixpy/v1_11_20/web/permission',
        'delphixpy/v1_11_20/web/passwordPolicy',
        'delphixpy/v1_11_20/web/role',
        'delphixpy/v1_11_20/web/toolkit',
        'delphixpy/v1_11_20/web/environment',
        'delphixpy/v1_11_20/web/environment/user',
        'delphixpy/v1_11_20/web/environment/oracle',
        'delphixpy/v1_11_20/web/environment/oracle/listener',
        'delphixpy/v1_11_20/web/environment/oracle/clusternode',
        'delphixpy/v1_11_20/web/environment/windows',
        'delphixpy/v1_11_20/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_20/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_20/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_20/web/environment/windows/clusternode',
        'delphixpy/v1_11_20/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_20/web/capacity',
        'delphixpy/v1_11_20/web/capacity/heldspace',
        'delphixpy/v1_11_20/web/capacity/group',
        'delphixpy/v1_11_20/web/capacity/group/historical',
        'delphixpy/v1_11_20/web/capacity/consumer',
        'delphixpy/v1_11_20/web/capacity/consumer/historical',
        'delphixpy/v1_11_20/web/capacity/snapshot',
        'delphixpy/v1_11_20/web/capacity/system',
        'delphixpy/v1_11_20/web/capacity/system/historical',
        'delphixpy/v1_11_20/web/database',
        'delphixpy/v1_11_20/web/database/performanceHistory',
        'delphixpy/v1_11_20/web/database/template',
        'delphixpy/v1_11_20/web/registration',
        'delphixpy/v1_11_20/web/registration/status',
        'delphixpy/v1_11_20/web/host',
        'delphixpy/v1_11_20/web/host/privilegeElevation',
        'delphixpy/v1_11_20/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_20/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_20/web/theme',
        'delphixpy/v1_11_20/web/repave',
        'delphixpy/v1_11_20/web/osadmin',
        'delphixpy/v1_11_20/web/osadmin/engineStatus',
        'delphixpy/v1_11_20/web/data',
        'delphixpy/v1_11_20/web/transformation',
        'delphixpy/v1_11_20/web/repository',
        'delphixpy/v1_11_20/web/repository/template',
        'delphixpy/v1_11_20/web/policy',
        'delphixpy/v1_11_20/web/user',
        'delphixpy/v1_11_20/web/alert',
        'delphixpy/v1_11_20/web/alert/profile',
        'delphixpy/v1_11_20/web/objects',
        'delphixpy/v1_11_20/web/maskingjob',
        'delphixpy/v1_11_20/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_20/web/timezone',
        'delphixpy/v1_11_20/web/fault',
        'delphixpy/v1_11_20/web/fault/effect',
        'delphixpy/v1_11_20/web/group',
        'delphixpy/v1_11_20/web/license',
        'delphixpy/v1_11_20/web/connectivity',
        'delphixpy/v1_11_20/web/notification',
        'delphixpy/v1_11_20/web/delphix',
        'delphixpy/v1_11_20/web/job',
        'delphixpy/v1_11_20/web/job/retention',
        'delphixpy/v1_11_20/web/usage',
        'delphixpy/v1_11_20/web/about',
        'delphixpy/v1_11_20/web/timeflow',
        'delphixpy/v1_11_20/web/timeflow/bookmark',
        'delphixpy/v1_11_20/web/timeflow/oracle',
        'delphixpy/v1_11_20/web/timeflow/oracle/log',
        'delphixpy/v1_11_20/web/action',
        'delphixpy/v1_11_20/web/storage',
        'delphixpy/v1_11_20/web/storage/objectStorage',
        'delphixpy/v1_11_20/web/storage/remove',
        'delphixpy/v1_11_20/web/storage/iscsi',
        'delphixpy/v1_11_20/web/storage/iscsi/target',
        'delphixpy/v1_11_20/web/storage/iscsi/initiator',
        'delphixpy/v1_11_20/web/storage/test',
        'delphixpy/v1_11_20/web/storage/device',
        'delphixpy/v1_11_20/web/storage/scrub',
        'delphixpy/v1_11_20/web/domain',
        'delphixpy/v1_11_20/web/analytics',
        'delphixpy/v1_11_20/web/analytics/statistic',
        'delphixpy/v1_11_20/web/selfservice',
        'delphixpy/v1_11_20/web/selfservice/branch',
        'delphixpy/v1_11_20/web/selfservice/container',
        'delphixpy/v1_11_20/web/selfservice/usagedata',
        'delphixpy/v1_11_20/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_20/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_20/web/selfservice/bookmark',
        'delphixpy/v1_11_20/web/selfservice/datasource',
        'delphixpy/v1_11_20/web/selfservice/operation',
        'delphixpy/v1_11_20/web/selfservice/template',
        'delphixpy/v1_11_20/web/selfservice/usage',
        'delphixpy/v1_11_20/web/selfservice/usage/branch',
        'delphixpy/v1_11_20/web/selfservice/usage/user',
        'delphixpy/v1_11_20/web/selfservice/usage/container',
        'delphixpy/v1_11_20/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_20/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_20/web/selfservice/usage/template',
        'delphixpy/v1_11_20/web/selfservice/config',
        'delphixpy/v1_11_20/web/snapshot',
        'delphixpy/v1_11_20/web/sourceconfig',
        'delphixpy/v1_11_20/web/namespace',
        'delphixpy/v1_11_20/web/replication',
        'delphixpy/v1_11_20/web/replication/spec',
        'delphixpy/v1_11_20/web/replication/targetstate',
        'delphixpy/v1_11_20/web/replication/sourcestate',
        'delphixpy/v1_11_20/web/replication/serializationpoint',
        'delphixpy/v1_11_20/web/source',
        'delphixpy/v1_11_20/web/source/operationTemplate',
        'delphixpy/v1_11_20/web/service',
        'delphixpy/v1_11_20/web/service/smtp',
        'delphixpy/v1_11_20/web/service/ldap',
        'delphixpy/v1_11_20/web/service/ldap/server',
        'delphixpy/v1_11_20/web/service/nfs',
        'delphixpy/v1_11_20/web/service/host',
        'delphixpy/v1_11_20/web/service/host/address',
        'delphixpy/v1_11_20/web/service/snmp',
        'delphixpy/v1_11_20/web/service/snmp/v3',
        'delphixpy/v1_11_20/web/service/snmp/v3/manager',
        'delphixpy/v1_11_20/web/service/snmp/v3/usm',
        'delphixpy/v1_11_20/web/service/snmp/v2',
        'delphixpy/v1_11_20/web/service/snmp/v2/manager',
        'delphixpy/v1_11_20/web/service/userInterface',
        'delphixpy/v1_11_20/web/service/linkingsettings',
        'delphixpy/v1_11_20/web/service/phonehome',
        'delphixpy/v1_11_20/web/service/events',
        'delphixpy/v1_11_20/web/service/fluentd',
        'delphixpy/v1_11_20/web/service/fluentd/plugins',
        'delphixpy/v1_11_20/web/service/fluentd/configuration',
        'delphixpy/v1_11_20/web/service/httpConnector',
        'delphixpy/v1_11_20/web/service/userPaths',
        'delphixpy/v1_11_20/web/service/security',
        'delphixpy/v1_11_20/web/service/dns',
        'delphixpy/v1_11_20/web/service/kerberos',
        'delphixpy/v1_11_20/web/service/schema',
        'delphixpy/v1_11_20/web/service/tls',
        'delphixpy/v1_11_20/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_20/web/service/tls/csr',
        'delphixpy/v1_11_20/web/service/tls/cipherSuite',
        'delphixpy/v1_11_20/web/service/tls/caCertificate',
        'delphixpy/v1_11_20/web/service/insight',
        'delphixpy/v1_11_20/web/service/insight/splunkHec',
        'delphixpy/v1_11_20/web/service/locale',
        'delphixpy/v1_11_20/web/service/cloud',
        'delphixpy/v1_11_20/web/service/proxy',
        'delphixpy/v1_11_20/web/service/time',
        'delphixpy/v1_11_20/web/service/syslog',
        'delphixpy/v1_11_20/web/service/passwordReset',
        'delphixpy/v1_11_20/web/service/support',
        'delphixpy/v1_11_20/web/service/support/access',
        'delphixpy/v1_11_20/web/service/support/bundle',
        'delphixpy/v1_11_20/web/service/minimalPhonehome',
        'delphixpy/v1_11_20/web/service/passwordVault',
        'delphixpy/v1_11_20/web/service/oauth2',
        'delphixpy/v1_11_20/web/service/sso',
        'delphixpy/v1_11_20/web/system',
        'delphixpy/v1_11_20/web/system/verification',
        'delphixpy/v1_11_20/web/system/verification/reports',
        'delphixpy/v1_11_20/web/system/verification/reports/steps',
        'delphixpy/v1_11_20/web/system/advancedSettings',
        'delphixpy/v1_11_20/web/system/upgradeCheckResult',
        'delphixpy/v1_11_20/web/system/status',
        'delphixpy/v1_11_20/web/system/version',
        'delphixpy/v1_11_20/web/network',
        'delphixpy/v1_11_20/web/network/route',
        'delphixpy/v1_11_20/web/network/test',
        'delphixpy/v1_11_20/web/network/test/latency',
        'delphixpy/v1_11_20/web/network/test/throughput',
        'delphixpy/v1_11_20/web/network/test/dsp',
        'delphixpy/v1_11_20/web/network/interface',
        'delphixpy/v1_11_20/web/network/dsp',
        'delphixpy/v1_11_20/web/network/dsp/autotune',
        'delphixpy/v1_11_20/web/session',
        'delphixpy/v1_8_0',
        'delphixpy/v1_8_0/web',
        'delphixpy/v1_8_0/web/authorization',
        'delphixpy/v1_8_0/web/permission',
        'delphixpy/v1_8_0/web/role',
        'delphixpy/v1_8_0/web/toolkit',
        'delphixpy/v1_8_0/web/environment',
        'delphixpy/v1_8_0/web/environment/user',
        'delphixpy/v1_8_0/web/environment/oracle',
        'delphixpy/v1_8_0/web/environment/oracle/listener',
        'delphixpy/v1_8_0/web/environment/oracle/clusternode',
        'delphixpy/v1_8_0/web/environment/windows',
        'delphixpy/v1_8_0/web/environment/windows/clusterinstance',
        'delphixpy/v1_8_0/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_8_0/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_8_0/web/environment/windows/clusternode',
        'delphixpy/v1_8_0/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_8_0/web/capacity',
        'delphixpy/v1_8_0/web/capacity/group',
        'delphixpy/v1_8_0/web/capacity/group/historical',
        'delphixpy/v1_8_0/web/capacity/consumer',
        'delphixpy/v1_8_0/web/capacity/consumer/historical',
        'delphixpy/v1_8_0/web/capacity/snapshot',
        'delphixpy/v1_8_0/web/capacity/system',
        'delphixpy/v1_8_0/web/capacity/system/historical',
        'delphixpy/v1_8_0/web/database',
        'delphixpy/v1_8_0/web/database/template',
        'delphixpy/v1_8_0/web/registration',
        'delphixpy/v1_8_0/web/registration/status',
        'delphixpy/v1_8_0/web/host',
        'delphixpy/v1_8_0/web/host/privilegeElevation',
        'delphixpy/v1_8_0/web/host/privilegeElevation/profile',
        'delphixpy/v1_8_0/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_8_0/web/data',
        'delphixpy/v1_8_0/web/transformation',
        'delphixpy/v1_8_0/web/repository',
        'delphixpy/v1_8_0/web/repository/template',
        'delphixpy/v1_8_0/web/policy',
        'delphixpy/v1_8_0/web/user',
        'delphixpy/v1_8_0/web/alert',
        'delphixpy/v1_8_0/web/alert/profile',
        'delphixpy/v1_8_0/web/objects',
        'delphixpy/v1_8_0/web/maskingjob',
        'delphixpy/v1_8_0/web/maskingjob/serviceconfig',
        'delphixpy/v1_8_0/web/timezone',
        'delphixpy/v1_8_0/web/fault',
        'delphixpy/v1_8_0/web/fault/effect',
        'delphixpy/v1_8_0/web/group',
        'delphixpy/v1_8_0/web/connectivity',
        'delphixpy/v1_8_0/web/notification',
        'delphixpy/v1_8_0/web/delphix',
        'delphixpy/v1_8_0/web/job',
        'delphixpy/v1_8_0/web/about',
        'delphixpy/v1_8_0/web/timeflow',
        'delphixpy/v1_8_0/web/timeflow/bookmark',
        'delphixpy/v1_8_0/web/timeflow/oracle',
        'delphixpy/v1_8_0/web/timeflow/oracle/log',
        'delphixpy/v1_8_0/web/action',
        'delphixpy/v1_8_0/web/jetstream',
        'delphixpy/v1_8_0/web/jetstream/branch',
        'delphixpy/v1_8_0/web/jetstream/container',
        'delphixpy/v1_8_0/web/jetstream/usagedata',
        'delphixpy/v1_8_0/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_8_0/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_8_0/web/jetstream/bookmark',
        'delphixpy/v1_8_0/web/jetstream/datasource',
        'delphixpy/v1_8_0/web/jetstream/operation',
        'delphixpy/v1_8_0/web/jetstream/template',
        'delphixpy/v1_8_0/web/jetstream/usage',
        'delphixpy/v1_8_0/web/jetstream/usage/branch',
        'delphixpy/v1_8_0/web/jetstream/usage/user',
        'delphixpy/v1_8_0/web/jetstream/usage/container',
        'delphixpy/v1_8_0/web/jetstream/usage/bookmark',
        'delphixpy/v1_8_0/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_8_0/web/jetstream/usage/template',
        'delphixpy/v1_8_0/web/storage',
        'delphixpy/v1_8_0/web/storage/remove',
        'delphixpy/v1_8_0/web/storage/test',
        'delphixpy/v1_8_0/web/storage/device',
        'delphixpy/v1_8_0/web/storage/scrub',
        'delphixpy/v1_8_0/web/domain',
        'delphixpy/v1_8_0/web/analytics',
        'delphixpy/v1_8_0/web/analytics/statistic',
        'delphixpy/v1_8_0/web/snapshot',
        'delphixpy/v1_8_0/web/sourceconfig',
        'delphixpy/v1_8_0/web/sourceconfig/oracle',
        'delphixpy/v1_8_0/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_8_0/web/namespace',
        'delphixpy/v1_8_0/web/replication',
        'delphixpy/v1_8_0/web/replication/spec',
        'delphixpy/v1_8_0/web/replication/targetstate',
        'delphixpy/v1_8_0/web/replication/sourcestate',
        'delphixpy/v1_8_0/web/replication/serializationpoint',
        'delphixpy/v1_8_0/web/source',
        'delphixpy/v1_8_0/web/source/operationTemplate',
        'delphixpy/v1_8_0/web/service',
        'delphixpy/v1_8_0/web/service/smtp',
        'delphixpy/v1_8_0/web/service/ldap',
        'delphixpy/v1_8_0/web/service/ldap/server',
        'delphixpy/v1_8_0/web/service/snmp',
        'delphixpy/v1_8_0/web/service/snmp/manager',
        'delphixpy/v1_8_0/web/service/linkingsettings',
        'delphixpy/v1_8_0/web/service/phonehome',
        'delphixpy/v1_8_0/web/service/security',
        'delphixpy/v1_8_0/web/service/dns',
        'delphixpy/v1_8_0/web/service/schema',
        'delphixpy/v1_8_0/web/service/saml',
        'delphixpy/v1_8_0/web/service/saml/serviceprovider',
        'delphixpy/v1_8_0/web/service/locale',
        'delphixpy/v1_8_0/web/service/proxy',
        'delphixpy/v1_8_0/web/service/certificate',
        'delphixpy/v1_8_0/web/service/time',
        'delphixpy/v1_8_0/web/service/syslog',
        'delphixpy/v1_8_0/web/service/support',
        'delphixpy/v1_8_0/web/service/support/access',
        'delphixpy/v1_8_0/web/service/support/bundle',
        'delphixpy/v1_8_0/web/system',
        'delphixpy/v1_8_0/web/system/version',
        'delphixpy/v1_8_0/web/network',
        'delphixpy/v1_8_0/web/network/route',
        'delphixpy/v1_8_0/web/network/test',
        'delphixpy/v1_8_0/web/network/test/latency',
        'delphixpy/v1_8_0/web/network/test/throughput',
        'delphixpy/v1_8_0/web/network/test/dsp',
        'delphixpy/v1_8_0/web/network/interface',
        'delphixpy/v1_8_0/web/session',
        'delphixpy/v1_11_5',
        'delphixpy/v1_11_5/web',
        'delphixpy/v1_11_5/web/authorization',
        'delphixpy/v1_11_5/web/authorization/configuration',
        'delphixpy/v1_11_5/web/permission',
        'delphixpy/v1_11_5/web/passwordPolicy',
        'delphixpy/v1_11_5/web/role',
        'delphixpy/v1_11_5/web/toolkit',
        'delphixpy/v1_11_5/web/environment',
        'delphixpy/v1_11_5/web/environment/user',
        'delphixpy/v1_11_5/web/environment/oracle',
        'delphixpy/v1_11_5/web/environment/oracle/listener',
        'delphixpy/v1_11_5/web/environment/oracle/clusternode',
        'delphixpy/v1_11_5/web/environment/windows',
        'delphixpy/v1_11_5/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_5/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_5/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_5/web/environment/windows/clusternode',
        'delphixpy/v1_11_5/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_5/web/capacity',
        'delphixpy/v1_11_5/web/capacity/group',
        'delphixpy/v1_11_5/web/capacity/group/historical',
        'delphixpy/v1_11_5/web/capacity/consumer',
        'delphixpy/v1_11_5/web/capacity/consumer/historical',
        'delphixpy/v1_11_5/web/capacity/snapshot',
        'delphixpy/v1_11_5/web/capacity/system',
        'delphixpy/v1_11_5/web/capacity/system/historical',
        'delphixpy/v1_11_5/web/database',
        'delphixpy/v1_11_5/web/database/performanceHistory',
        'delphixpy/v1_11_5/web/database/template',
        'delphixpy/v1_11_5/web/registration',
        'delphixpy/v1_11_5/web/registration/status',
        'delphixpy/v1_11_5/web/host',
        'delphixpy/v1_11_5/web/host/privilegeElevation',
        'delphixpy/v1_11_5/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_5/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_5/web/theme',
        'delphixpy/v1_11_5/web/data',
        'delphixpy/v1_11_5/web/transformation',
        'delphixpy/v1_11_5/web/repository',
        'delphixpy/v1_11_5/web/repository/template',
        'delphixpy/v1_11_5/web/policy',
        'delphixpy/v1_11_5/web/user',
        'delphixpy/v1_11_5/web/alert',
        'delphixpy/v1_11_5/web/alert/profile',
        'delphixpy/v1_11_5/web/objects',
        'delphixpy/v1_11_5/web/maskingjob',
        'delphixpy/v1_11_5/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_5/web/timezone',
        'delphixpy/v1_11_5/web/fault',
        'delphixpy/v1_11_5/web/fault/effect',
        'delphixpy/v1_11_5/web/group',
        'delphixpy/v1_11_5/web/license',
        'delphixpy/v1_11_5/web/connectivity',
        'delphixpy/v1_11_5/web/notification',
        'delphixpy/v1_11_5/web/delphix',
        'delphixpy/v1_11_5/web/job',
        'delphixpy/v1_11_5/web/usage',
        'delphixpy/v1_11_5/web/about',
        'delphixpy/v1_11_5/web/timeflow',
        'delphixpy/v1_11_5/web/timeflow/bookmark',
        'delphixpy/v1_11_5/web/timeflow/oracle',
        'delphixpy/v1_11_5/web/timeflow/oracle/log',
        'delphixpy/v1_11_5/web/action',
        'delphixpy/v1_11_5/web/storage',
        'delphixpy/v1_11_5/web/storage/remove',
        'delphixpy/v1_11_5/web/storage/test',
        'delphixpy/v1_11_5/web/storage/device',
        'delphixpy/v1_11_5/web/storage/scrub',
        'delphixpy/v1_11_5/web/domain',
        'delphixpy/v1_11_5/web/analytics',
        'delphixpy/v1_11_5/web/analytics/statistic',
        'delphixpy/v1_11_5/web/selfservice',
        'delphixpy/v1_11_5/web/selfservice/branch',
        'delphixpy/v1_11_5/web/selfservice/container',
        'delphixpy/v1_11_5/web/selfservice/usagedata',
        'delphixpy/v1_11_5/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_5/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_5/web/selfservice/bookmark',
        'delphixpy/v1_11_5/web/selfservice/datasource',
        'delphixpy/v1_11_5/web/selfservice/operation',
        'delphixpy/v1_11_5/web/selfservice/template',
        'delphixpy/v1_11_5/web/selfservice/usage',
        'delphixpy/v1_11_5/web/selfservice/usage/branch',
        'delphixpy/v1_11_5/web/selfservice/usage/user',
        'delphixpy/v1_11_5/web/selfservice/usage/container',
        'delphixpy/v1_11_5/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_5/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_5/web/selfservice/usage/template',
        'delphixpy/v1_11_5/web/selfservice/config',
        'delphixpy/v1_11_5/web/snapshot',
        'delphixpy/v1_11_5/web/sourceconfig',
        'delphixpy/v1_11_5/web/namespace',
        'delphixpy/v1_11_5/web/replication',
        'delphixpy/v1_11_5/web/replication/spec',
        'delphixpy/v1_11_5/web/replication/targetstate',
        'delphixpy/v1_11_5/web/replication/sourcestate',
        'delphixpy/v1_11_5/web/replication/serializationpoint',
        'delphixpy/v1_11_5/web/source',
        'delphixpy/v1_11_5/web/source/operationTemplate',
        'delphixpy/v1_11_5/web/service',
        'delphixpy/v1_11_5/web/service/smtp',
        'delphixpy/v1_11_5/web/service/ldap',
        'delphixpy/v1_11_5/web/service/ldap/server',
        'delphixpy/v1_11_5/web/service/nfs',
        'delphixpy/v1_11_5/web/service/host',
        'delphixpy/v1_11_5/web/service/host/address',
        'delphixpy/v1_11_5/web/service/snmp',
        'delphixpy/v1_11_5/web/service/snmp/v3',
        'delphixpy/v1_11_5/web/service/snmp/v3/manager',
        'delphixpy/v1_11_5/web/service/snmp/v3/usm',
        'delphixpy/v1_11_5/web/service/snmp/v2',
        'delphixpy/v1_11_5/web/service/snmp/v2/manager',
        'delphixpy/v1_11_5/web/service/userInterface',
        'delphixpy/v1_11_5/web/service/linkingsettings',
        'delphixpy/v1_11_5/web/service/phonehome',
        'delphixpy/v1_11_5/web/service/httpConnector',
        'delphixpy/v1_11_5/web/service/userPaths',
        'delphixpy/v1_11_5/web/service/security',
        'delphixpy/v1_11_5/web/service/dns',
        'delphixpy/v1_11_5/web/service/kerberos',
        'delphixpy/v1_11_5/web/service/schema',
        'delphixpy/v1_11_5/web/service/tls',
        'delphixpy/v1_11_5/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_5/web/service/tls/csr',
        'delphixpy/v1_11_5/web/service/tls/cipherSuite',
        'delphixpy/v1_11_5/web/service/tls/caCertificate',
        'delphixpy/v1_11_5/web/service/insight',
        'delphixpy/v1_11_5/web/service/insight/splunkHec',
        'delphixpy/v1_11_5/web/service/locale',
        'delphixpy/v1_11_5/web/service/cloud',
        'delphixpy/v1_11_5/web/service/proxy',
        'delphixpy/v1_11_5/web/service/time',
        'delphixpy/v1_11_5/web/service/syslog',
        'delphixpy/v1_11_5/web/service/support',
        'delphixpy/v1_11_5/web/service/support/access',
        'delphixpy/v1_11_5/web/service/support/bundle',
        'delphixpy/v1_11_5/web/service/minimalPhonehome',
        'delphixpy/v1_11_5/web/service/passwordVault',
        'delphixpy/v1_11_5/web/service/sso',
        'delphixpy/v1_11_5/web/system',
        'delphixpy/v1_11_5/web/system/verification',
        'delphixpy/v1_11_5/web/system/verification/reports',
        'delphixpy/v1_11_5/web/system/verification/reports/steps',
        'delphixpy/v1_11_5/web/system/upgradeCheckResult',
        'delphixpy/v1_11_5/web/system/status',
        'delphixpy/v1_11_5/web/system/version',
        'delphixpy/v1_11_5/web/system/package',
        'delphixpy/v1_11_5/web/network',
        'delphixpy/v1_11_5/web/network/route',
        'delphixpy/v1_11_5/web/network/test',
        'delphixpy/v1_11_5/web/network/test/latency',
        'delphixpy/v1_11_5/web/network/test/throughput',
        'delphixpy/v1_11_5/web/network/test/dsp',
        'delphixpy/v1_11_5/web/network/interface',
        'delphixpy/v1_11_5/web/network/dsp',
        'delphixpy/v1_11_5/web/network/dsp/autotune',
        'delphixpy/v1_11_5/web/session',
        'delphixpy/v1_10_6',
        'delphixpy/v1_10_6/web',
        'delphixpy/v1_10_6/web/authorization',
        'delphixpy/v1_10_6/web/authorization/configuration',
        'delphixpy/v1_10_6/web/permission',
        'delphixpy/v1_10_6/web/passwordPolicy',
        'delphixpy/v1_10_6/web/role',
        'delphixpy/v1_10_6/web/toolkit',
        'delphixpy/v1_10_6/web/environment',
        'delphixpy/v1_10_6/web/environment/user',
        'delphixpy/v1_10_6/web/environment/oracle',
        'delphixpy/v1_10_6/web/environment/oracle/listener',
        'delphixpy/v1_10_6/web/environment/oracle/clusternode',
        'delphixpy/v1_10_6/web/environment/windows',
        'delphixpy/v1_10_6/web/environment/windows/clusterinstance',
        'delphixpy/v1_10_6/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_10_6/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_10_6/web/environment/windows/clusternode',
        'delphixpy/v1_10_6/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_10_6/web/capacity',
        'delphixpy/v1_10_6/web/capacity/group',
        'delphixpy/v1_10_6/web/capacity/group/historical',
        'delphixpy/v1_10_6/web/capacity/consumer',
        'delphixpy/v1_10_6/web/capacity/consumer/historical',
        'delphixpy/v1_10_6/web/capacity/snapshot',
        'delphixpy/v1_10_6/web/capacity/system',
        'delphixpy/v1_10_6/web/capacity/system/historical',
        'delphixpy/v1_10_6/web/database',
        'delphixpy/v1_10_6/web/database/performanceHistory',
        'delphixpy/v1_10_6/web/database/template',
        'delphixpy/v1_10_6/web/registration',
        'delphixpy/v1_10_6/web/registration/status',
        'delphixpy/v1_10_6/web/host',
        'delphixpy/v1_10_6/web/host/privilegeElevation',
        'delphixpy/v1_10_6/web/host/privilegeElevation/profile',
        'delphixpy/v1_10_6/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_10_6/web/data',
        'delphixpy/v1_10_6/web/transformation',
        'delphixpy/v1_10_6/web/repository',
        'delphixpy/v1_10_6/web/repository/template',
        'delphixpy/v1_10_6/web/policy',
        'delphixpy/v1_10_6/web/user',
        'delphixpy/v1_10_6/web/alert',
        'delphixpy/v1_10_6/web/alert/profile',
        'delphixpy/v1_10_6/web/objects',
        'delphixpy/v1_10_6/web/maskingjob',
        'delphixpy/v1_10_6/web/maskingjob/serviceconfig',
        'delphixpy/v1_10_6/web/timezone',
        'delphixpy/v1_10_6/web/fault',
        'delphixpy/v1_10_6/web/fault/effect',
        'delphixpy/v1_10_6/web/group',
        'delphixpy/v1_10_6/web/connectivity',
        'delphixpy/v1_10_6/web/notification',
        'delphixpy/v1_10_6/web/delphix',
        'delphixpy/v1_10_6/web/job',
        'delphixpy/v1_10_6/web/usage',
        'delphixpy/v1_10_6/web/about',
        'delphixpy/v1_10_6/web/timeflow',
        'delphixpy/v1_10_6/web/timeflow/bookmark',
        'delphixpy/v1_10_6/web/timeflow/oracle',
        'delphixpy/v1_10_6/web/timeflow/oracle/log',
        'delphixpy/v1_10_6/web/action',
        'delphixpy/v1_10_6/web/storage',
        'delphixpy/v1_10_6/web/storage/remove',
        'delphixpy/v1_10_6/web/storage/test',
        'delphixpy/v1_10_6/web/storage/device',
        'delphixpy/v1_10_6/web/storage/scrub',
        'delphixpy/v1_10_6/web/domain',
        'delphixpy/v1_10_6/web/analytics',
        'delphixpy/v1_10_6/web/analytics/statistic',
        'delphixpy/v1_10_6/web/selfservice',
        'delphixpy/v1_10_6/web/selfservice/branch',
        'delphixpy/v1_10_6/web/selfservice/container',
        'delphixpy/v1_10_6/web/selfservice/usagedata',
        'delphixpy/v1_10_6/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_10_6/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_10_6/web/selfservice/bookmark',
        'delphixpy/v1_10_6/web/selfservice/datasource',
        'delphixpy/v1_10_6/web/selfservice/operation',
        'delphixpy/v1_10_6/web/selfservice/template',
        'delphixpy/v1_10_6/web/selfservice/usage',
        'delphixpy/v1_10_6/web/selfservice/usage/branch',
        'delphixpy/v1_10_6/web/selfservice/usage/user',
        'delphixpy/v1_10_6/web/selfservice/usage/container',
        'delphixpy/v1_10_6/web/selfservice/usage/bookmark',
        'delphixpy/v1_10_6/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_10_6/web/selfservice/usage/template',
        'delphixpy/v1_10_6/web/selfservice/config',
        'delphixpy/v1_10_6/web/snapshot',
        'delphixpy/v1_10_6/web/sourceconfig',
        'delphixpy/v1_10_6/web/namespace',
        'delphixpy/v1_10_6/web/replication',
        'delphixpy/v1_10_6/web/replication/spec',
        'delphixpy/v1_10_6/web/replication/targetstate',
        'delphixpy/v1_10_6/web/replication/sourcestate',
        'delphixpy/v1_10_6/web/replication/serializationpoint',
        'delphixpy/v1_10_6/web/source',
        'delphixpy/v1_10_6/web/source/operationTemplate',
        'delphixpy/v1_10_6/web/service',
        'delphixpy/v1_10_6/web/service/smtp',
        'delphixpy/v1_10_6/web/service/ldap',
        'delphixpy/v1_10_6/web/service/ldap/server',
        'delphixpy/v1_10_6/web/service/snmp',
        'delphixpy/v1_10_6/web/service/snmp/manager',
        'delphixpy/v1_10_6/web/service/userInterface',
        'delphixpy/v1_10_6/web/service/linkingsettings',
        'delphixpy/v1_10_6/web/service/phonehome',
        'delphixpy/v1_10_6/web/service/httpConnector',
        'delphixpy/v1_10_6/web/service/security',
        'delphixpy/v1_10_6/web/service/dns',
        'delphixpy/v1_10_6/web/service/kerberos',
        'delphixpy/v1_10_6/web/service/schema',
        'delphixpy/v1_10_6/web/service/tls',
        'delphixpy/v1_10_6/web/service/tls/endEntityCertificate',
        'delphixpy/v1_10_6/web/service/tls/csr',
        'delphixpy/v1_10_6/web/service/tls/cipherSuite',
        'delphixpy/v1_10_6/web/service/tls/caCertificate',
        'delphixpy/v1_10_6/web/service/insight',
        'delphixpy/v1_10_6/web/service/insight/splunkHec',
        'delphixpy/v1_10_6/web/service/saml',
        'delphixpy/v1_10_6/web/service/saml/serviceprovider',
        'delphixpy/v1_10_6/web/service/locale',
        'delphixpy/v1_10_6/web/service/cloud',
        'delphixpy/v1_10_6/web/service/proxy',
        'delphixpy/v1_10_6/web/service/certificate',
        'delphixpy/v1_10_6/web/service/time',
        'delphixpy/v1_10_6/web/service/syslog',
        'delphixpy/v1_10_6/web/service/support',
        'delphixpy/v1_10_6/web/service/support/access',
        'delphixpy/v1_10_6/web/service/support/bundle',
        'delphixpy/v1_10_6/web/service/sso',
        'delphixpy/v1_10_6/web/system',
        'delphixpy/v1_10_6/web/system/upgradeCheckResult',
        'delphixpy/v1_10_6/web/system/status',
        'delphixpy/v1_10_6/web/system/version',
        'delphixpy/v1_10_6/web/system/package',
        'delphixpy/v1_10_6/web/network',
        'delphixpy/v1_10_6/web/network/route',
        'delphixpy/v1_10_6/web/network/test',
        'delphixpy/v1_10_6/web/network/test/latency',
        'delphixpy/v1_10_6/web/network/test/throughput',
        'delphixpy/v1_10_6/web/network/test/dsp',
        'delphixpy/v1_10_6/web/network/interface',
        'delphixpy/v1_10_6/web/network/dsp',
        'delphixpy/v1_10_6/web/network/dsp/autotune',
        'delphixpy/v1_10_6/web/session',
        'delphixpy/v1_10_1',
        'delphixpy/v1_10_1/web',
        'delphixpy/v1_10_1/web/authorization',
        'delphixpy/v1_10_1/web/authorization/configuration',
        'delphixpy/v1_10_1/web/permission',
        'delphixpy/v1_10_1/web/passwordPolicy',
        'delphixpy/v1_10_1/web/role',
        'delphixpy/v1_10_1/web/toolkit',
        'delphixpy/v1_10_1/web/environment',
        'delphixpy/v1_10_1/web/environment/user',
        'delphixpy/v1_10_1/web/environment/oracle',
        'delphixpy/v1_10_1/web/environment/oracle/listener',
        'delphixpy/v1_10_1/web/environment/oracle/clusternode',
        'delphixpy/v1_10_1/web/environment/windows',
        'delphixpy/v1_10_1/web/environment/windows/clusterinstance',
        'delphixpy/v1_10_1/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_10_1/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_10_1/web/environment/windows/clusternode',
        'delphixpy/v1_10_1/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_10_1/web/capacity',
        'delphixpy/v1_10_1/web/capacity/group',
        'delphixpy/v1_10_1/web/capacity/group/historical',
        'delphixpy/v1_10_1/web/capacity/consumer',
        'delphixpy/v1_10_1/web/capacity/consumer/historical',
        'delphixpy/v1_10_1/web/capacity/snapshot',
        'delphixpy/v1_10_1/web/capacity/system',
        'delphixpy/v1_10_1/web/capacity/system/historical',
        'delphixpy/v1_10_1/web/database',
        'delphixpy/v1_10_1/web/database/performanceHistory',
        'delphixpy/v1_10_1/web/database/template',
        'delphixpy/v1_10_1/web/registration',
        'delphixpy/v1_10_1/web/registration/status',
        'delphixpy/v1_10_1/web/host',
        'delphixpy/v1_10_1/web/host/privilegeElevation',
        'delphixpy/v1_10_1/web/host/privilegeElevation/profile',
        'delphixpy/v1_10_1/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_10_1/web/data',
        'delphixpy/v1_10_1/web/transformation',
        'delphixpy/v1_10_1/web/repository',
        'delphixpy/v1_10_1/web/repository/template',
        'delphixpy/v1_10_1/web/policy',
        'delphixpy/v1_10_1/web/user',
        'delphixpy/v1_10_1/web/alert',
        'delphixpy/v1_10_1/web/alert/profile',
        'delphixpy/v1_10_1/web/objects',
        'delphixpy/v1_10_1/web/maskingjob',
        'delphixpy/v1_10_1/web/maskingjob/serviceconfig',
        'delphixpy/v1_10_1/web/timezone',
        'delphixpy/v1_10_1/web/fault',
        'delphixpy/v1_10_1/web/fault/effect',
        'delphixpy/v1_10_1/web/group',
        'delphixpy/v1_10_1/web/connectivity',
        'delphixpy/v1_10_1/web/notification',
        'delphixpy/v1_10_1/web/delphix',
        'delphixpy/v1_10_1/web/job',
        'delphixpy/v1_10_1/web/about',
        'delphixpy/v1_10_1/web/timeflow',
        'delphixpy/v1_10_1/web/timeflow/bookmark',
        'delphixpy/v1_10_1/web/timeflow/oracle',
        'delphixpy/v1_10_1/web/timeflow/oracle/log',
        'delphixpy/v1_10_1/web/action',
        'delphixpy/v1_10_1/web/storage',
        'delphixpy/v1_10_1/web/storage/remove',
        'delphixpy/v1_10_1/web/storage/test',
        'delphixpy/v1_10_1/web/storage/device',
        'delphixpy/v1_10_1/web/storage/scrub',
        'delphixpy/v1_10_1/web/domain',
        'delphixpy/v1_10_1/web/analytics',
        'delphixpy/v1_10_1/web/analytics/statistic',
        'delphixpy/v1_10_1/web/selfservice',
        'delphixpy/v1_10_1/web/selfservice/branch',
        'delphixpy/v1_10_1/web/selfservice/container',
        'delphixpy/v1_10_1/web/selfservice/usagedata',
        'delphixpy/v1_10_1/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_10_1/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_10_1/web/selfservice/bookmark',
        'delphixpy/v1_10_1/web/selfservice/datasource',
        'delphixpy/v1_10_1/web/selfservice/operation',
        'delphixpy/v1_10_1/web/selfservice/template',
        'delphixpy/v1_10_1/web/selfservice/usage',
        'delphixpy/v1_10_1/web/selfservice/usage/branch',
        'delphixpy/v1_10_1/web/selfservice/usage/user',
        'delphixpy/v1_10_1/web/selfservice/usage/container',
        'delphixpy/v1_10_1/web/selfservice/usage/bookmark',
        'delphixpy/v1_10_1/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_10_1/web/selfservice/usage/template',
        'delphixpy/v1_10_1/web/selfservice/config',
        'delphixpy/v1_10_1/web/snapshot',
        'delphixpy/v1_10_1/web/sourceconfig',
        'delphixpy/v1_10_1/web/namespace',
        'delphixpy/v1_10_1/web/replication',
        'delphixpy/v1_10_1/web/replication/spec',
        'delphixpy/v1_10_1/web/replication/targetstate',
        'delphixpy/v1_10_1/web/replication/sourcestate',
        'delphixpy/v1_10_1/web/replication/serializationpoint',
        'delphixpy/v1_10_1/web/source',
        'delphixpy/v1_10_1/web/source/operationTemplate',
        'delphixpy/v1_10_1/web/service',
        'delphixpy/v1_10_1/web/service/smtp',
        'delphixpy/v1_10_1/web/service/ldap',
        'delphixpy/v1_10_1/web/service/ldap/server',
        'delphixpy/v1_10_1/web/service/snmp',
        'delphixpy/v1_10_1/web/service/snmp/manager',
        'delphixpy/v1_10_1/web/service/userInterface',
        'delphixpy/v1_10_1/web/service/linkingsettings',
        'delphixpy/v1_10_1/web/service/phonehome',
        'delphixpy/v1_10_1/web/service/httpConnector',
        'delphixpy/v1_10_1/web/service/security',
        'delphixpy/v1_10_1/web/service/dns',
        'delphixpy/v1_10_1/web/service/kerberos',
        'delphixpy/v1_10_1/web/service/schema',
        'delphixpy/v1_10_1/web/service/tls',
        'delphixpy/v1_10_1/web/service/tls/endEntityCertificate',
        'delphixpy/v1_10_1/web/service/tls/csr',
        'delphixpy/v1_10_1/web/service/tls/caCertificate',
        'delphixpy/v1_10_1/web/service/insight',
        'delphixpy/v1_10_1/web/service/insight/splunkHec',
        'delphixpy/v1_10_1/web/service/saml',
        'delphixpy/v1_10_1/web/service/saml/serviceprovider',
        'delphixpy/v1_10_1/web/service/locale',
        'delphixpy/v1_10_1/web/service/proxy',
        'delphixpy/v1_10_1/web/service/certificate',
        'delphixpy/v1_10_1/web/service/time',
        'delphixpy/v1_10_1/web/service/syslog',
        'delphixpy/v1_10_1/web/service/support',
        'delphixpy/v1_10_1/web/service/support/access',
        'delphixpy/v1_10_1/web/service/support/bundle',
        'delphixpy/v1_10_1/web/system',
        'delphixpy/v1_10_1/web/system/upgradeCheckResult',
        'delphixpy/v1_10_1/web/system/status',
        'delphixpy/v1_10_1/web/system/version',
        'delphixpy/v1_10_1/web/system/package',
        'delphixpy/v1_10_1/web/network',
        'delphixpy/v1_10_1/web/network/route',
        'delphixpy/v1_10_1/web/network/test',
        'delphixpy/v1_10_1/web/network/test/latency',
        'delphixpy/v1_10_1/web/network/test/throughput',
        'delphixpy/v1_10_1/web/network/test/dsp',
        'delphixpy/v1_10_1/web/network/interface',
        'delphixpy/v1_10_1/web/network/dsp',
        'delphixpy/v1_10_1/web/network/dsp/autotune',
        'delphixpy/v1_10_1/web/session',
        'delphixpy/v1_11_6',
        'delphixpy/v1_11_6/web',
        'delphixpy/v1_11_6/web/authorization',
        'delphixpy/v1_11_6/web/authorization/configuration',
        'delphixpy/v1_11_6/web/permission',
        'delphixpy/v1_11_6/web/passwordPolicy',
        'delphixpy/v1_11_6/web/role',
        'delphixpy/v1_11_6/web/toolkit',
        'delphixpy/v1_11_6/web/environment',
        'delphixpy/v1_11_6/web/environment/user',
        'delphixpy/v1_11_6/web/environment/oracle',
        'delphixpy/v1_11_6/web/environment/oracle/listener',
        'delphixpy/v1_11_6/web/environment/oracle/clusternode',
        'delphixpy/v1_11_6/web/environment/windows',
        'delphixpy/v1_11_6/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_6/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_6/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_6/web/environment/windows/clusternode',
        'delphixpy/v1_11_6/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_6/web/capacity',
        'delphixpy/v1_11_6/web/capacity/heldspace',
        'delphixpy/v1_11_6/web/capacity/group',
        'delphixpy/v1_11_6/web/capacity/group/historical',
        'delphixpy/v1_11_6/web/capacity/consumer',
        'delphixpy/v1_11_6/web/capacity/consumer/historical',
        'delphixpy/v1_11_6/web/capacity/snapshot',
        'delphixpy/v1_11_6/web/capacity/system',
        'delphixpy/v1_11_6/web/capacity/system/historical',
        'delphixpy/v1_11_6/web/database',
        'delphixpy/v1_11_6/web/database/performanceHistory',
        'delphixpy/v1_11_6/web/database/template',
        'delphixpy/v1_11_6/web/registration',
        'delphixpy/v1_11_6/web/registration/status',
        'delphixpy/v1_11_6/web/host',
        'delphixpy/v1_11_6/web/host/privilegeElevation',
        'delphixpy/v1_11_6/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_6/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_6/web/theme',
        'delphixpy/v1_11_6/web/data',
        'delphixpy/v1_11_6/web/transformation',
        'delphixpy/v1_11_6/web/repository',
        'delphixpy/v1_11_6/web/repository/template',
        'delphixpy/v1_11_6/web/policy',
        'delphixpy/v1_11_6/web/user',
        'delphixpy/v1_11_6/web/alert',
        'delphixpy/v1_11_6/web/alert/profile',
        'delphixpy/v1_11_6/web/objects',
        'delphixpy/v1_11_6/web/maskingjob',
        'delphixpy/v1_11_6/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_6/web/timezone',
        'delphixpy/v1_11_6/web/fault',
        'delphixpy/v1_11_6/web/fault/effect',
        'delphixpy/v1_11_6/web/group',
        'delphixpy/v1_11_6/web/license',
        'delphixpy/v1_11_6/web/connectivity',
        'delphixpy/v1_11_6/web/notification',
        'delphixpy/v1_11_6/web/delphix',
        'delphixpy/v1_11_6/web/job',
        'delphixpy/v1_11_6/web/usage',
        'delphixpy/v1_11_6/web/about',
        'delphixpy/v1_11_6/web/timeflow',
        'delphixpy/v1_11_6/web/timeflow/bookmark',
        'delphixpy/v1_11_6/web/timeflow/oracle',
        'delphixpy/v1_11_6/web/timeflow/oracle/log',
        'delphixpy/v1_11_6/web/action',
        'delphixpy/v1_11_6/web/storage',
        'delphixpy/v1_11_6/web/storage/remove',
        'delphixpy/v1_11_6/web/storage/test',
        'delphixpy/v1_11_6/web/storage/device',
        'delphixpy/v1_11_6/web/storage/scrub',
        'delphixpy/v1_11_6/web/domain',
        'delphixpy/v1_11_6/web/analytics',
        'delphixpy/v1_11_6/web/analytics/statistic',
        'delphixpy/v1_11_6/web/selfservice',
        'delphixpy/v1_11_6/web/selfservice/branch',
        'delphixpy/v1_11_6/web/selfservice/container',
        'delphixpy/v1_11_6/web/selfservice/usagedata',
        'delphixpy/v1_11_6/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_6/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_6/web/selfservice/bookmark',
        'delphixpy/v1_11_6/web/selfservice/datasource',
        'delphixpy/v1_11_6/web/selfservice/operation',
        'delphixpy/v1_11_6/web/selfservice/template',
        'delphixpy/v1_11_6/web/selfservice/usage',
        'delphixpy/v1_11_6/web/selfservice/usage/branch',
        'delphixpy/v1_11_6/web/selfservice/usage/user',
        'delphixpy/v1_11_6/web/selfservice/usage/container',
        'delphixpy/v1_11_6/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_6/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_6/web/selfservice/usage/template',
        'delphixpy/v1_11_6/web/selfservice/config',
        'delphixpy/v1_11_6/web/snapshot',
        'delphixpy/v1_11_6/web/sourceconfig',
        'delphixpy/v1_11_6/web/namespace',
        'delphixpy/v1_11_6/web/replication',
        'delphixpy/v1_11_6/web/replication/spec',
        'delphixpy/v1_11_6/web/replication/targetstate',
        'delphixpy/v1_11_6/web/replication/sourcestate',
        'delphixpy/v1_11_6/web/replication/serializationpoint',
        'delphixpy/v1_11_6/web/source',
        'delphixpy/v1_11_6/web/source/operationTemplate',
        'delphixpy/v1_11_6/web/service',
        'delphixpy/v1_11_6/web/service/smtp',
        'delphixpy/v1_11_6/web/service/ldap',
        'delphixpy/v1_11_6/web/service/ldap/server',
        'delphixpy/v1_11_6/web/service/nfs',
        'delphixpy/v1_11_6/web/service/host',
        'delphixpy/v1_11_6/web/service/host/address',
        'delphixpy/v1_11_6/web/service/snmp',
        'delphixpy/v1_11_6/web/service/snmp/v3',
        'delphixpy/v1_11_6/web/service/snmp/v3/manager',
        'delphixpy/v1_11_6/web/service/snmp/v3/usm',
        'delphixpy/v1_11_6/web/service/snmp/v2',
        'delphixpy/v1_11_6/web/service/snmp/v2/manager',
        'delphixpy/v1_11_6/web/service/userInterface',
        'delphixpy/v1_11_6/web/service/linkingsettings',
        'delphixpy/v1_11_6/web/service/phonehome',
        'delphixpy/v1_11_6/web/service/httpConnector',
        'delphixpy/v1_11_6/web/service/userPaths',
        'delphixpy/v1_11_6/web/service/security',
        'delphixpy/v1_11_6/web/service/dns',
        'delphixpy/v1_11_6/web/service/kerberos',
        'delphixpy/v1_11_6/web/service/schema',
        'delphixpy/v1_11_6/web/service/tls',
        'delphixpy/v1_11_6/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_6/web/service/tls/csr',
        'delphixpy/v1_11_6/web/service/tls/cipherSuite',
        'delphixpy/v1_11_6/web/service/tls/caCertificate',
        'delphixpy/v1_11_6/web/service/insight',
        'delphixpy/v1_11_6/web/service/insight/splunkHec',
        'delphixpy/v1_11_6/web/service/locale',
        'delphixpy/v1_11_6/web/service/cloud',
        'delphixpy/v1_11_6/web/service/proxy',
        'delphixpy/v1_11_6/web/service/time',
        'delphixpy/v1_11_6/web/service/syslog',
        'delphixpy/v1_11_6/web/service/support',
        'delphixpy/v1_11_6/web/service/support/access',
        'delphixpy/v1_11_6/web/service/support/bundle',
        'delphixpy/v1_11_6/web/service/minimalPhonehome',
        'delphixpy/v1_11_6/web/service/passwordVault',
        'delphixpy/v1_11_6/web/service/sso',
        'delphixpy/v1_11_6/web/system',
        'delphixpy/v1_11_6/web/system/verification',
        'delphixpy/v1_11_6/web/system/verification/reports',
        'delphixpy/v1_11_6/web/system/verification/reports/steps',
        'delphixpy/v1_11_6/web/system/upgradeCheckResult',
        'delphixpy/v1_11_6/web/system/status',
        'delphixpy/v1_11_6/web/system/version',
        'delphixpy/v1_11_6/web/system/package',
        'delphixpy/v1_11_6/web/network',
        'delphixpy/v1_11_6/web/network/route',
        'delphixpy/v1_11_6/web/network/test',
        'delphixpy/v1_11_6/web/network/test/latency',
        'delphixpy/v1_11_6/web/network/test/throughput',
        'delphixpy/v1_11_6/web/network/test/dsp',
        'delphixpy/v1_11_6/web/network/interface',
        'delphixpy/v1_11_6/web/network/dsp',
        'delphixpy/v1_11_6/web/network/dsp/autotune',
        'delphixpy/v1_11_6/web/session',
        'delphixpy/v1_11_8',
        'delphixpy/v1_11_8/web',
        'delphixpy/v1_11_8/web/authorization',
        'delphixpy/v1_11_8/web/authorization/configuration',
        'delphixpy/v1_11_8/web/permission',
        'delphixpy/v1_11_8/web/passwordPolicy',
        'delphixpy/v1_11_8/web/role',
        'delphixpy/v1_11_8/web/toolkit',
        'delphixpy/v1_11_8/web/environment',
        'delphixpy/v1_11_8/web/environment/user',
        'delphixpy/v1_11_8/web/environment/oracle',
        'delphixpy/v1_11_8/web/environment/oracle/listener',
        'delphixpy/v1_11_8/web/environment/oracle/clusternode',
        'delphixpy/v1_11_8/web/environment/windows',
        'delphixpy/v1_11_8/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_8/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_8/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_8/web/environment/windows/clusternode',
        'delphixpy/v1_11_8/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_8/web/capacity',
        'delphixpy/v1_11_8/web/capacity/heldspace',
        'delphixpy/v1_11_8/web/capacity/group',
        'delphixpy/v1_11_8/web/capacity/group/historical',
        'delphixpy/v1_11_8/web/capacity/consumer',
        'delphixpy/v1_11_8/web/capacity/consumer/historical',
        'delphixpy/v1_11_8/web/capacity/snapshot',
        'delphixpy/v1_11_8/web/capacity/system',
        'delphixpy/v1_11_8/web/capacity/system/historical',
        'delphixpy/v1_11_8/web/database',
        'delphixpy/v1_11_8/web/database/performanceHistory',
        'delphixpy/v1_11_8/web/database/template',
        'delphixpy/v1_11_8/web/registration',
        'delphixpy/v1_11_8/web/registration/status',
        'delphixpy/v1_11_8/web/host',
        'delphixpy/v1_11_8/web/host/privilegeElevation',
        'delphixpy/v1_11_8/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_8/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_8/web/theme',
        'delphixpy/v1_11_8/web/data',
        'delphixpy/v1_11_8/web/transformation',
        'delphixpy/v1_11_8/web/repository',
        'delphixpy/v1_11_8/web/repository/template',
        'delphixpy/v1_11_8/web/policy',
        'delphixpy/v1_11_8/web/user',
        'delphixpy/v1_11_8/web/alert',
        'delphixpy/v1_11_8/web/alert/profile',
        'delphixpy/v1_11_8/web/objects',
        'delphixpy/v1_11_8/web/maskingjob',
        'delphixpy/v1_11_8/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_8/web/timezone',
        'delphixpy/v1_11_8/web/fault',
        'delphixpy/v1_11_8/web/fault/effect',
        'delphixpy/v1_11_8/web/group',
        'delphixpy/v1_11_8/web/license',
        'delphixpy/v1_11_8/web/connectivity',
        'delphixpy/v1_11_8/web/notification',
        'delphixpy/v1_11_8/web/delphix',
        'delphixpy/v1_11_8/web/job',
        'delphixpy/v1_11_8/web/usage',
        'delphixpy/v1_11_8/web/about',
        'delphixpy/v1_11_8/web/timeflow',
        'delphixpy/v1_11_8/web/timeflow/bookmark',
        'delphixpy/v1_11_8/web/timeflow/oracle',
        'delphixpy/v1_11_8/web/timeflow/oracle/log',
        'delphixpy/v1_11_8/web/action',
        'delphixpy/v1_11_8/web/storage',
        'delphixpy/v1_11_8/web/storage/remove',
        'delphixpy/v1_11_8/web/storage/iscsi',
        'delphixpy/v1_11_8/web/storage/iscsi/target',
        'delphixpy/v1_11_8/web/storage/iscsi/initiator',
        'delphixpy/v1_11_8/web/storage/test',
        'delphixpy/v1_11_8/web/storage/device',
        'delphixpy/v1_11_8/web/storage/scrub',
        'delphixpy/v1_11_8/web/domain',
        'delphixpy/v1_11_8/web/analytics',
        'delphixpy/v1_11_8/web/analytics/statistic',
        'delphixpy/v1_11_8/web/selfservice',
        'delphixpy/v1_11_8/web/selfservice/branch',
        'delphixpy/v1_11_8/web/selfservice/container',
        'delphixpy/v1_11_8/web/selfservice/usagedata',
        'delphixpy/v1_11_8/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_8/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_8/web/selfservice/bookmark',
        'delphixpy/v1_11_8/web/selfservice/datasource',
        'delphixpy/v1_11_8/web/selfservice/operation',
        'delphixpy/v1_11_8/web/selfservice/template',
        'delphixpy/v1_11_8/web/selfservice/usage',
        'delphixpy/v1_11_8/web/selfservice/usage/branch',
        'delphixpy/v1_11_8/web/selfservice/usage/user',
        'delphixpy/v1_11_8/web/selfservice/usage/container',
        'delphixpy/v1_11_8/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_8/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_8/web/selfservice/usage/template',
        'delphixpy/v1_11_8/web/selfservice/config',
        'delphixpy/v1_11_8/web/snapshot',
        'delphixpy/v1_11_8/web/sourceconfig',
        'delphixpy/v1_11_8/web/namespace',
        'delphixpy/v1_11_8/web/replication',
        'delphixpy/v1_11_8/web/replication/spec',
        'delphixpy/v1_11_8/web/replication/targetstate',
        'delphixpy/v1_11_8/web/replication/sourcestate',
        'delphixpy/v1_11_8/web/replication/serializationpoint',
        'delphixpy/v1_11_8/web/source',
        'delphixpy/v1_11_8/web/source/operationTemplate',
        'delphixpy/v1_11_8/web/service',
        'delphixpy/v1_11_8/web/service/smtp',
        'delphixpy/v1_11_8/web/service/ldap',
        'delphixpy/v1_11_8/web/service/ldap/server',
        'delphixpy/v1_11_8/web/service/nfs',
        'delphixpy/v1_11_8/web/service/host',
        'delphixpy/v1_11_8/web/service/host/address',
        'delphixpy/v1_11_8/web/service/snmp',
        'delphixpy/v1_11_8/web/service/snmp/v3',
        'delphixpy/v1_11_8/web/service/snmp/v3/manager',
        'delphixpy/v1_11_8/web/service/snmp/v3/usm',
        'delphixpy/v1_11_8/web/service/snmp/v2',
        'delphixpy/v1_11_8/web/service/snmp/v2/manager',
        'delphixpy/v1_11_8/web/service/userInterface',
        'delphixpy/v1_11_8/web/service/linkingsettings',
        'delphixpy/v1_11_8/web/service/phonehome',
        'delphixpy/v1_11_8/web/service/httpConnector',
        'delphixpy/v1_11_8/web/service/userPaths',
        'delphixpy/v1_11_8/web/service/security',
        'delphixpy/v1_11_8/web/service/dns',
        'delphixpy/v1_11_8/web/service/kerberos',
        'delphixpy/v1_11_8/web/service/schema',
        'delphixpy/v1_11_8/web/service/tls',
        'delphixpy/v1_11_8/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_8/web/service/tls/csr',
        'delphixpy/v1_11_8/web/service/tls/cipherSuite',
        'delphixpy/v1_11_8/web/service/tls/caCertificate',
        'delphixpy/v1_11_8/web/service/insight',
        'delphixpy/v1_11_8/web/service/insight/splunkHec',
        'delphixpy/v1_11_8/web/service/locale',
        'delphixpy/v1_11_8/web/service/cloud',
        'delphixpy/v1_11_8/web/service/proxy',
        'delphixpy/v1_11_8/web/service/time',
        'delphixpy/v1_11_8/web/service/syslog',
        'delphixpy/v1_11_8/web/service/support',
        'delphixpy/v1_11_8/web/service/support/access',
        'delphixpy/v1_11_8/web/service/support/bundle',
        'delphixpy/v1_11_8/web/service/minimalPhonehome',
        'delphixpy/v1_11_8/web/service/passwordVault',
        'delphixpy/v1_11_8/web/service/sso',
        'delphixpy/v1_11_8/web/system',
        'delphixpy/v1_11_8/web/system/verification',
        'delphixpy/v1_11_8/web/system/verification/reports',
        'delphixpy/v1_11_8/web/system/verification/reports/steps',
        'delphixpy/v1_11_8/web/system/advancedSettings',
        'delphixpy/v1_11_8/web/system/upgradeCheckResult',
        'delphixpy/v1_11_8/web/system/status',
        'delphixpy/v1_11_8/web/system/version',
        'delphixpy/v1_11_8/web/system/package',
        'delphixpy/v1_11_8/web/network',
        'delphixpy/v1_11_8/web/network/route',
        'delphixpy/v1_11_8/web/network/test',
        'delphixpy/v1_11_8/web/network/test/latency',
        'delphixpy/v1_11_8/web/network/test/throughput',
        'delphixpy/v1_11_8/web/network/test/dsp',
        'delphixpy/v1_11_8/web/network/interface',
        'delphixpy/v1_11_8/web/network/dsp',
        'delphixpy/v1_11_8/web/network/dsp/autotune',
        'delphixpy/v1_11_8/web/session',
        'delphixpy/v1_11_1',
        'delphixpy/v1_11_1/web',
        'delphixpy/v1_11_1/web/authorization',
        'delphixpy/v1_11_1/web/authorization/configuration',
        'delphixpy/v1_11_1/web/permission',
        'delphixpy/v1_11_1/web/passwordPolicy',
        'delphixpy/v1_11_1/web/role',
        'delphixpy/v1_11_1/web/toolkit',
        'delphixpy/v1_11_1/web/environment',
        'delphixpy/v1_11_1/web/environment/user',
        'delphixpy/v1_11_1/web/environment/oracle',
        'delphixpy/v1_11_1/web/environment/oracle/listener',
        'delphixpy/v1_11_1/web/environment/oracle/clusternode',
        'delphixpy/v1_11_1/web/environment/windows',
        'delphixpy/v1_11_1/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_1/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_1/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_1/web/environment/windows/clusternode',
        'delphixpy/v1_11_1/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_1/web/capacity',
        'delphixpy/v1_11_1/web/capacity/group',
        'delphixpy/v1_11_1/web/capacity/group/historical',
        'delphixpy/v1_11_1/web/capacity/consumer',
        'delphixpy/v1_11_1/web/capacity/consumer/historical',
        'delphixpy/v1_11_1/web/capacity/snapshot',
        'delphixpy/v1_11_1/web/capacity/system',
        'delphixpy/v1_11_1/web/capacity/system/historical',
        'delphixpy/v1_11_1/web/database',
        'delphixpy/v1_11_1/web/database/performanceHistory',
        'delphixpy/v1_11_1/web/database/template',
        'delphixpy/v1_11_1/web/registration',
        'delphixpy/v1_11_1/web/registration/status',
        'delphixpy/v1_11_1/web/host',
        'delphixpy/v1_11_1/web/host/privilegeElevation',
        'delphixpy/v1_11_1/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_1/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_1/web/theme',
        'delphixpy/v1_11_1/web/data',
        'delphixpy/v1_11_1/web/transformation',
        'delphixpy/v1_11_1/web/repository',
        'delphixpy/v1_11_1/web/repository/template',
        'delphixpy/v1_11_1/web/policy',
        'delphixpy/v1_11_1/web/user',
        'delphixpy/v1_11_1/web/alert',
        'delphixpy/v1_11_1/web/alert/profile',
        'delphixpy/v1_11_1/web/objects',
        'delphixpy/v1_11_1/web/maskingjob',
        'delphixpy/v1_11_1/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_1/web/timezone',
        'delphixpy/v1_11_1/web/fault',
        'delphixpy/v1_11_1/web/fault/effect',
        'delphixpy/v1_11_1/web/group',
        'delphixpy/v1_11_1/web/connectivity',
        'delphixpy/v1_11_1/web/notification',
        'delphixpy/v1_11_1/web/delphix',
        'delphixpy/v1_11_1/web/job',
        'delphixpy/v1_11_1/web/usage',
        'delphixpy/v1_11_1/web/about',
        'delphixpy/v1_11_1/web/timeflow',
        'delphixpy/v1_11_1/web/timeflow/bookmark',
        'delphixpy/v1_11_1/web/timeflow/oracle',
        'delphixpy/v1_11_1/web/timeflow/oracle/log',
        'delphixpy/v1_11_1/web/action',
        'delphixpy/v1_11_1/web/storage',
        'delphixpy/v1_11_1/web/storage/remove',
        'delphixpy/v1_11_1/web/storage/test',
        'delphixpy/v1_11_1/web/storage/device',
        'delphixpy/v1_11_1/web/storage/scrub',
        'delphixpy/v1_11_1/web/domain',
        'delphixpy/v1_11_1/web/analytics',
        'delphixpy/v1_11_1/web/analytics/statistic',
        'delphixpy/v1_11_1/web/selfservice',
        'delphixpy/v1_11_1/web/selfservice/branch',
        'delphixpy/v1_11_1/web/selfservice/container',
        'delphixpy/v1_11_1/web/selfservice/usagedata',
        'delphixpy/v1_11_1/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_1/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_1/web/selfservice/bookmark',
        'delphixpy/v1_11_1/web/selfservice/datasource',
        'delphixpy/v1_11_1/web/selfservice/operation',
        'delphixpy/v1_11_1/web/selfservice/template',
        'delphixpy/v1_11_1/web/selfservice/usage',
        'delphixpy/v1_11_1/web/selfservice/usage/branch',
        'delphixpy/v1_11_1/web/selfservice/usage/user',
        'delphixpy/v1_11_1/web/selfservice/usage/container',
        'delphixpy/v1_11_1/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_1/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_1/web/selfservice/usage/template',
        'delphixpy/v1_11_1/web/selfservice/config',
        'delphixpy/v1_11_1/web/snapshot',
        'delphixpy/v1_11_1/web/sourceconfig',
        'delphixpy/v1_11_1/web/namespace',
        'delphixpy/v1_11_1/web/replication',
        'delphixpy/v1_11_1/web/replication/spec',
        'delphixpy/v1_11_1/web/replication/targetstate',
        'delphixpy/v1_11_1/web/replication/sourcestate',
        'delphixpy/v1_11_1/web/replication/serializationpoint',
        'delphixpy/v1_11_1/web/source',
        'delphixpy/v1_11_1/web/source/operationTemplate',
        'delphixpy/v1_11_1/web/service',
        'delphixpy/v1_11_1/web/service/smtp',
        'delphixpy/v1_11_1/web/service/ldap',
        'delphixpy/v1_11_1/web/service/ldap/server',
        'delphixpy/v1_11_1/web/service/nfs',
        'delphixpy/v1_11_1/web/service/snmp',
        'delphixpy/v1_11_1/web/service/snmp/manager',
        'delphixpy/v1_11_1/web/service/userInterface',
        'delphixpy/v1_11_1/web/service/linkingsettings',
        'delphixpy/v1_11_1/web/service/phonehome',
        'delphixpy/v1_11_1/web/service/httpConnector',
        'delphixpy/v1_11_1/web/service/userPaths',
        'delphixpy/v1_11_1/web/service/security',
        'delphixpy/v1_11_1/web/service/dns',
        'delphixpy/v1_11_1/web/service/kerberos',
        'delphixpy/v1_11_1/web/service/schema',
        'delphixpy/v1_11_1/web/service/tls',
        'delphixpy/v1_11_1/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_1/web/service/tls/csr',
        'delphixpy/v1_11_1/web/service/tls/cipherSuite',
        'delphixpy/v1_11_1/web/service/tls/caCertificate',
        'delphixpy/v1_11_1/web/service/insight',
        'delphixpy/v1_11_1/web/service/insight/splunkHec',
        'delphixpy/v1_11_1/web/service/saml',
        'delphixpy/v1_11_1/web/service/saml/serviceprovider',
        'delphixpy/v1_11_1/web/service/locale',
        'delphixpy/v1_11_1/web/service/cloud',
        'delphixpy/v1_11_1/web/service/proxy',
        'delphixpy/v1_11_1/web/service/certificate',
        'delphixpy/v1_11_1/web/service/time',
        'delphixpy/v1_11_1/web/service/syslog',
        'delphixpy/v1_11_1/web/service/support',
        'delphixpy/v1_11_1/web/service/support/access',
        'delphixpy/v1_11_1/web/service/support/bundle',
        'delphixpy/v1_11_1/web/service/minimalPhonehome',
        'delphixpy/v1_11_1/web/service/sso',
        'delphixpy/v1_11_1/web/system',
        'delphixpy/v1_11_1/web/system/verification',
        'delphixpy/v1_11_1/web/system/verification/reports',
        'delphixpy/v1_11_1/web/system/verification/reports/steps',
        'delphixpy/v1_11_1/web/system/upgradeCheckResult',
        'delphixpy/v1_11_1/web/system/status',
        'delphixpy/v1_11_1/web/system/version',
        'delphixpy/v1_11_1/web/system/package',
        'delphixpy/v1_11_1/web/network',
        'delphixpy/v1_11_1/web/network/route',
        'delphixpy/v1_11_1/web/network/test',
        'delphixpy/v1_11_1/web/network/test/latency',
        'delphixpy/v1_11_1/web/network/test/throughput',
        'delphixpy/v1_11_1/web/network/test/dsp',
        'delphixpy/v1_11_1/web/network/interface',
        'delphixpy/v1_11_1/web/network/dsp',
        'delphixpy/v1_11_1/web/network/dsp/autotune',
        'delphixpy/v1_11_1/web/session',
        'delphixpy/v1_9_0',
        'delphixpy/v1_9_0/web',
        'delphixpy/v1_9_0/web/authorization',
        'delphixpy/v1_9_0/web/permission',
        'delphixpy/v1_9_0/web/passwordPolicy',
        'delphixpy/v1_9_0/web/role',
        'delphixpy/v1_9_0/web/toolkit',
        'delphixpy/v1_9_0/web/environment',
        'delphixpy/v1_9_0/web/environment/user',
        'delphixpy/v1_9_0/web/environment/oracle',
        'delphixpy/v1_9_0/web/environment/oracle/listener',
        'delphixpy/v1_9_0/web/environment/oracle/clusternode',
        'delphixpy/v1_9_0/web/environment/windows',
        'delphixpy/v1_9_0/web/environment/windows/clusterinstance',
        'delphixpy/v1_9_0/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_9_0/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_9_0/web/environment/windows/clusternode',
        'delphixpy/v1_9_0/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_9_0/web/capacity',
        'delphixpy/v1_9_0/web/capacity/group',
        'delphixpy/v1_9_0/web/capacity/group/historical',
        'delphixpy/v1_9_0/web/capacity/consumer',
        'delphixpy/v1_9_0/web/capacity/consumer/historical',
        'delphixpy/v1_9_0/web/capacity/snapshot',
        'delphixpy/v1_9_0/web/capacity/system',
        'delphixpy/v1_9_0/web/capacity/system/historical',
        'delphixpy/v1_9_0/web/database',
        'delphixpy/v1_9_0/web/database/performanceHistory',
        'delphixpy/v1_9_0/web/database/template',
        'delphixpy/v1_9_0/web/registration',
        'delphixpy/v1_9_0/web/registration/status',
        'delphixpy/v1_9_0/web/host',
        'delphixpy/v1_9_0/web/host/privilegeElevation',
        'delphixpy/v1_9_0/web/host/privilegeElevation/profile',
        'delphixpy/v1_9_0/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_9_0/web/data',
        'delphixpy/v1_9_0/web/transformation',
        'delphixpy/v1_9_0/web/repository',
        'delphixpy/v1_9_0/web/repository/template',
        'delphixpy/v1_9_0/web/policy',
        'delphixpy/v1_9_0/web/user',
        'delphixpy/v1_9_0/web/alert',
        'delphixpy/v1_9_0/web/alert/profile',
        'delphixpy/v1_9_0/web/objects',
        'delphixpy/v1_9_0/web/maskingjob',
        'delphixpy/v1_9_0/web/maskingjob/serviceconfig',
        'delphixpy/v1_9_0/web/timezone',
        'delphixpy/v1_9_0/web/fault',
        'delphixpy/v1_9_0/web/fault/effect',
        'delphixpy/v1_9_0/web/group',
        'delphixpy/v1_9_0/web/connectivity',
        'delphixpy/v1_9_0/web/notification',
        'delphixpy/v1_9_0/web/delphix',
        'delphixpy/v1_9_0/web/job',
        'delphixpy/v1_9_0/web/about',
        'delphixpy/v1_9_0/web/timeflow',
        'delphixpy/v1_9_0/web/timeflow/bookmark',
        'delphixpy/v1_9_0/web/timeflow/oracle',
        'delphixpy/v1_9_0/web/timeflow/oracle/log',
        'delphixpy/v1_9_0/web/action',
        'delphixpy/v1_9_0/web/jetstream',
        'delphixpy/v1_9_0/web/jetstream/branch',
        'delphixpy/v1_9_0/web/jetstream/container',
        'delphixpy/v1_9_0/web/jetstream/usagedata',
        'delphixpy/v1_9_0/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_9_0/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_9_0/web/jetstream/bookmark',
        'delphixpy/v1_9_0/web/jetstream/datasource',
        'delphixpy/v1_9_0/web/jetstream/operation',
        'delphixpy/v1_9_0/web/jetstream/template',
        'delphixpy/v1_9_0/web/jetstream/usage',
        'delphixpy/v1_9_0/web/jetstream/usage/branch',
        'delphixpy/v1_9_0/web/jetstream/usage/user',
        'delphixpy/v1_9_0/web/jetstream/usage/container',
        'delphixpy/v1_9_0/web/jetstream/usage/bookmark',
        'delphixpy/v1_9_0/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_9_0/web/jetstream/usage/template',
        'delphixpy/v1_9_0/web/jetstream/config',
        'delphixpy/v1_9_0/web/storage',
        'delphixpy/v1_9_0/web/storage/remove',
        'delphixpy/v1_9_0/web/storage/test',
        'delphixpy/v1_9_0/web/storage/device',
        'delphixpy/v1_9_0/web/storage/scrub',
        'delphixpy/v1_9_0/web/domain',
        'delphixpy/v1_9_0/web/analytics',
        'delphixpy/v1_9_0/web/analytics/statistic',
        'delphixpy/v1_9_0/web/snapshot',
        'delphixpy/v1_9_0/web/sourceconfig',
        'delphixpy/v1_9_0/web/namespace',
        'delphixpy/v1_9_0/web/replication',
        'delphixpy/v1_9_0/web/replication/spec',
        'delphixpy/v1_9_0/web/replication/targetstate',
        'delphixpy/v1_9_0/web/replication/sourcestate',
        'delphixpy/v1_9_0/web/replication/serializationpoint',
        'delphixpy/v1_9_0/web/source',
        'delphixpy/v1_9_0/web/source/operationTemplate',
        'delphixpy/v1_9_0/web/service',
        'delphixpy/v1_9_0/web/service/smtp',
        'delphixpy/v1_9_0/web/service/ldap',
        'delphixpy/v1_9_0/web/service/ldap/server',
        'delphixpy/v1_9_0/web/service/snmp',
        'delphixpy/v1_9_0/web/service/snmp/manager',
        'delphixpy/v1_9_0/web/service/linkingsettings',
        'delphixpy/v1_9_0/web/service/phonehome',
        'delphixpy/v1_9_0/web/service/httpConnector',
        'delphixpy/v1_9_0/web/service/security',
        'delphixpy/v1_9_0/web/service/dns',
        'delphixpy/v1_9_0/web/service/kerberos',
        'delphixpy/v1_9_0/web/service/schema',
        'delphixpy/v1_9_0/web/service/tls',
        'delphixpy/v1_9_0/web/service/tls/cacert',
        'delphixpy/v1_9_0/web/service/saml',
        'delphixpy/v1_9_0/web/service/saml/serviceprovider',
        'delphixpy/v1_9_0/web/service/locale',
        'delphixpy/v1_9_0/web/service/proxy',
        'delphixpy/v1_9_0/web/service/certificate',
        'delphixpy/v1_9_0/web/service/time',
        'delphixpy/v1_9_0/web/service/syslog',
        'delphixpy/v1_9_0/web/service/support',
        'delphixpy/v1_9_0/web/service/support/access',
        'delphixpy/v1_9_0/web/service/support/bundle',
        'delphixpy/v1_9_0/web/system',
        'delphixpy/v1_9_0/web/system/upgradeCheckResult',
        'delphixpy/v1_9_0/web/system/version',
        'delphixpy/v1_9_0/web/system/package',
        'delphixpy/v1_9_0/web/network',
        'delphixpy/v1_9_0/web/network/route',
        'delphixpy/v1_9_0/web/network/test',
        'delphixpy/v1_9_0/web/network/test/latency',
        'delphixpy/v1_9_0/web/network/test/throughput',
        'delphixpy/v1_9_0/web/network/test/dsp',
        'delphixpy/v1_9_0/web/network/interface',
        'delphixpy/v1_9_0/web/network/dsp',
        'delphixpy/v1_9_0/web/network/dsp/autotune',
        'delphixpy/v1_9_0/web/session',
        'delphixpy/v1_11_15',
        'delphixpy/v1_11_15/web',
        'delphixpy/v1_11_15/web/authorization',
        'delphixpy/v1_11_15/web/authorization/configuration',
        'delphixpy/v1_11_15/web/permission',
        'delphixpy/v1_11_15/web/passwordPolicy',
        'delphixpy/v1_11_15/web/role',
        'delphixpy/v1_11_15/web/toolkit',
        'delphixpy/v1_11_15/web/environment',
        'delphixpy/v1_11_15/web/environment/user',
        'delphixpy/v1_11_15/web/environment/oracle',
        'delphixpy/v1_11_15/web/environment/oracle/listener',
        'delphixpy/v1_11_15/web/environment/oracle/clusternode',
        'delphixpy/v1_11_15/web/environment/windows',
        'delphixpy/v1_11_15/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_15/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_15/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_15/web/environment/windows/clusternode',
        'delphixpy/v1_11_15/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_15/web/capacity',
        'delphixpy/v1_11_15/web/capacity/heldspace',
        'delphixpy/v1_11_15/web/capacity/group',
        'delphixpy/v1_11_15/web/capacity/group/historical',
        'delphixpy/v1_11_15/web/capacity/consumer',
        'delphixpy/v1_11_15/web/capacity/consumer/historical',
        'delphixpy/v1_11_15/web/capacity/snapshot',
        'delphixpy/v1_11_15/web/capacity/system',
        'delphixpy/v1_11_15/web/capacity/system/historical',
        'delphixpy/v1_11_15/web/database',
        'delphixpy/v1_11_15/web/database/performanceHistory',
        'delphixpy/v1_11_15/web/database/template',
        'delphixpy/v1_11_15/web/registration',
        'delphixpy/v1_11_15/web/registration/status',
        'delphixpy/v1_11_15/web/host',
        'delphixpy/v1_11_15/web/host/privilegeElevation',
        'delphixpy/v1_11_15/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_15/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_15/web/theme',
        'delphixpy/v1_11_15/web/osadmin',
        'delphixpy/v1_11_15/web/osadmin/engineStatus',
        'delphixpy/v1_11_15/web/data',
        'delphixpy/v1_11_15/web/transformation',
        'delphixpy/v1_11_15/web/repository',
        'delphixpy/v1_11_15/web/repository/template',
        'delphixpy/v1_11_15/web/policy',
        'delphixpy/v1_11_15/web/user',
        'delphixpy/v1_11_15/web/alert',
        'delphixpy/v1_11_15/web/alert/profile',
        'delphixpy/v1_11_15/web/objects',
        'delphixpy/v1_11_15/web/maskingjob',
        'delphixpy/v1_11_15/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_15/web/timezone',
        'delphixpy/v1_11_15/web/fault',
        'delphixpy/v1_11_15/web/fault/effect',
        'delphixpy/v1_11_15/web/group',
        'delphixpy/v1_11_15/web/license',
        'delphixpy/v1_11_15/web/connectivity',
        'delphixpy/v1_11_15/web/notification',
        'delphixpy/v1_11_15/web/delphix',
        'delphixpy/v1_11_15/web/job',
        'delphixpy/v1_11_15/web/usage',
        'delphixpy/v1_11_15/web/about',
        'delphixpy/v1_11_15/web/timeflow',
        'delphixpy/v1_11_15/web/timeflow/bookmark',
        'delphixpy/v1_11_15/web/timeflow/oracle',
        'delphixpy/v1_11_15/web/timeflow/oracle/log',
        'delphixpy/v1_11_15/web/action',
        'delphixpy/v1_11_15/web/storage',
        'delphixpy/v1_11_15/web/storage/objectStorage',
        'delphixpy/v1_11_15/web/storage/remove',
        'delphixpy/v1_11_15/web/storage/iscsi',
        'delphixpy/v1_11_15/web/storage/iscsi/target',
        'delphixpy/v1_11_15/web/storage/iscsi/initiator',
        'delphixpy/v1_11_15/web/storage/test',
        'delphixpy/v1_11_15/web/storage/device',
        'delphixpy/v1_11_15/web/storage/scrub',
        'delphixpy/v1_11_15/web/domain',
        'delphixpy/v1_11_15/web/analytics',
        'delphixpy/v1_11_15/web/analytics/statistic',
        'delphixpy/v1_11_15/web/selfservice',
        'delphixpy/v1_11_15/web/selfservice/branch',
        'delphixpy/v1_11_15/web/selfservice/container',
        'delphixpy/v1_11_15/web/selfservice/usagedata',
        'delphixpy/v1_11_15/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_15/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_15/web/selfservice/bookmark',
        'delphixpy/v1_11_15/web/selfservice/datasource',
        'delphixpy/v1_11_15/web/selfservice/operation',
        'delphixpy/v1_11_15/web/selfservice/template',
        'delphixpy/v1_11_15/web/selfservice/usage',
        'delphixpy/v1_11_15/web/selfservice/usage/branch',
        'delphixpy/v1_11_15/web/selfservice/usage/user',
        'delphixpy/v1_11_15/web/selfservice/usage/container',
        'delphixpy/v1_11_15/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_15/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_15/web/selfservice/usage/template',
        'delphixpy/v1_11_15/web/selfservice/config',
        'delphixpy/v1_11_15/web/snapshot',
        'delphixpy/v1_11_15/web/sourceconfig',
        'delphixpy/v1_11_15/web/namespace',
        'delphixpy/v1_11_15/web/replication',
        'delphixpy/v1_11_15/web/replication/spec',
        'delphixpy/v1_11_15/web/replication/targetstate',
        'delphixpy/v1_11_15/web/replication/sourcestate',
        'delphixpy/v1_11_15/web/replication/serializationpoint',
        'delphixpy/v1_11_15/web/source',
        'delphixpy/v1_11_15/web/source/operationTemplate',
        'delphixpy/v1_11_15/web/service',
        'delphixpy/v1_11_15/web/service/smtp',
        'delphixpy/v1_11_15/web/service/ldap',
        'delphixpy/v1_11_15/web/service/ldap/server',
        'delphixpy/v1_11_15/web/service/nfs',
        'delphixpy/v1_11_15/web/service/host',
        'delphixpy/v1_11_15/web/service/host/address',
        'delphixpy/v1_11_15/web/service/snmp',
        'delphixpy/v1_11_15/web/service/snmp/v3',
        'delphixpy/v1_11_15/web/service/snmp/v3/manager',
        'delphixpy/v1_11_15/web/service/snmp/v3/usm',
        'delphixpy/v1_11_15/web/service/snmp/v2',
        'delphixpy/v1_11_15/web/service/snmp/v2/manager',
        'delphixpy/v1_11_15/web/service/userInterface',
        'delphixpy/v1_11_15/web/service/linkingsettings',
        'delphixpy/v1_11_15/web/service/phonehome',
        'delphixpy/v1_11_15/web/service/fluentd',
        'delphixpy/v1_11_15/web/service/fluentd/plugins',
        'delphixpy/v1_11_15/web/service/fluentd/configuration',
        'delphixpy/v1_11_15/web/service/httpConnector',
        'delphixpy/v1_11_15/web/service/userPaths',
        'delphixpy/v1_11_15/web/service/security',
        'delphixpy/v1_11_15/web/service/dns',
        'delphixpy/v1_11_15/web/service/kerberos',
        'delphixpy/v1_11_15/web/service/schema',
        'delphixpy/v1_11_15/web/service/tls',
        'delphixpy/v1_11_15/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_15/web/service/tls/csr',
        'delphixpy/v1_11_15/web/service/tls/cipherSuite',
        'delphixpy/v1_11_15/web/service/tls/caCertificate',
        'delphixpy/v1_11_15/web/service/insight',
        'delphixpy/v1_11_15/web/service/insight/splunkHec',
        'delphixpy/v1_11_15/web/service/locale',
        'delphixpy/v1_11_15/web/service/cloud',
        'delphixpy/v1_11_15/web/service/proxy',
        'delphixpy/v1_11_15/web/service/time',
        'delphixpy/v1_11_15/web/service/syslog',
        'delphixpy/v1_11_15/web/service/support',
        'delphixpy/v1_11_15/web/service/support/access',
        'delphixpy/v1_11_15/web/service/support/bundle',
        'delphixpy/v1_11_15/web/service/minimalPhonehome',
        'delphixpy/v1_11_15/web/service/passwordVault',
        'delphixpy/v1_11_15/web/service/oauth2',
        'delphixpy/v1_11_15/web/service/sso',
        'delphixpy/v1_11_15/web/system',
        'delphixpy/v1_11_15/web/system/verification',
        'delphixpy/v1_11_15/web/system/verification/reports',
        'delphixpy/v1_11_15/web/system/verification/reports/steps',
        'delphixpy/v1_11_15/web/system/advancedSettings',
        'delphixpy/v1_11_15/web/system/upgradeCheckResult',
        'delphixpy/v1_11_15/web/system/status',
        'delphixpy/v1_11_15/web/system/version',
        'delphixpy/v1_11_15/web/system/package',
        'delphixpy/v1_11_15/web/network',
        'delphixpy/v1_11_15/web/network/route',
        'delphixpy/v1_11_15/web/network/test',
        'delphixpy/v1_11_15/web/network/test/latency',
        'delphixpy/v1_11_15/web/network/test/throughput',
        'delphixpy/v1_11_15/web/network/test/dsp',
        'delphixpy/v1_11_15/web/network/interface',
        'delphixpy/v1_11_15/web/network/dsp',
        'delphixpy/v1_11_15/web/network/dsp/autotune',
        'delphixpy/v1_11_15/web/session',
        'delphixpy/v1_11_15/web/netty',
        'delphixpy/v1_11_18',
        'delphixpy/v1_11_18/web',
        'delphixpy/v1_11_18/web/authorization',
        'delphixpy/v1_11_18/web/authorization/configuration',
        'delphixpy/v1_11_18/web/permission',
        'delphixpy/v1_11_18/web/passwordPolicy',
        'delphixpy/v1_11_18/web/role',
        'delphixpy/v1_11_18/web/toolkit',
        'delphixpy/v1_11_18/web/environment',
        'delphixpy/v1_11_18/web/environment/user',
        'delphixpy/v1_11_18/web/environment/oracle',
        'delphixpy/v1_11_18/web/environment/oracle/listener',
        'delphixpy/v1_11_18/web/environment/oracle/clusternode',
        'delphixpy/v1_11_18/web/environment/windows',
        'delphixpy/v1_11_18/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_18/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_18/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_18/web/environment/windows/clusternode',
        'delphixpy/v1_11_18/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_18/web/capacity',
        'delphixpy/v1_11_18/web/capacity/heldspace',
        'delphixpy/v1_11_18/web/capacity/group',
        'delphixpy/v1_11_18/web/capacity/group/historical',
        'delphixpy/v1_11_18/web/capacity/consumer',
        'delphixpy/v1_11_18/web/capacity/consumer/historical',
        'delphixpy/v1_11_18/web/capacity/snapshot',
        'delphixpy/v1_11_18/web/capacity/system',
        'delphixpy/v1_11_18/web/capacity/system/historical',
        'delphixpy/v1_11_18/web/database',
        'delphixpy/v1_11_18/web/database/performanceHistory',
        'delphixpy/v1_11_18/web/database/template',
        'delphixpy/v1_11_18/web/registration',
        'delphixpy/v1_11_18/web/registration/status',
        'delphixpy/v1_11_18/web/host',
        'delphixpy/v1_11_18/web/host/privilegeElevation',
        'delphixpy/v1_11_18/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_18/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_18/web/theme',
        'delphixpy/v1_11_18/web/repave',
        'delphixpy/v1_11_18/web/osadmin',
        'delphixpy/v1_11_18/web/osadmin/engineStatus',
        'delphixpy/v1_11_18/web/data',
        'delphixpy/v1_11_18/web/transformation',
        'delphixpy/v1_11_18/web/repository',
        'delphixpy/v1_11_18/web/repository/template',
        'delphixpy/v1_11_18/web/policy',
        'delphixpy/v1_11_18/web/user',
        'delphixpy/v1_11_18/web/alert',
        'delphixpy/v1_11_18/web/alert/profile',
        'delphixpy/v1_11_18/web/objects',
        'delphixpy/v1_11_18/web/maskingjob',
        'delphixpy/v1_11_18/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_18/web/timezone',
        'delphixpy/v1_11_18/web/fault',
        'delphixpy/v1_11_18/web/fault/effect',
        'delphixpy/v1_11_18/web/group',
        'delphixpy/v1_11_18/web/license',
        'delphixpy/v1_11_18/web/connectivity',
        'delphixpy/v1_11_18/web/notification',
        'delphixpy/v1_11_18/web/delphix',
        'delphixpy/v1_11_18/web/job',
        'delphixpy/v1_11_18/web/job/retention',
        'delphixpy/v1_11_18/web/usage',
        'delphixpy/v1_11_18/web/about',
        'delphixpy/v1_11_18/web/timeflow',
        'delphixpy/v1_11_18/web/timeflow/bookmark',
        'delphixpy/v1_11_18/web/timeflow/oracle',
        'delphixpy/v1_11_18/web/timeflow/oracle/log',
        'delphixpy/v1_11_18/web/action',
        'delphixpy/v1_11_18/web/storage',
        'delphixpy/v1_11_18/web/storage/objectStorage',
        'delphixpy/v1_11_18/web/storage/remove',
        'delphixpy/v1_11_18/web/storage/iscsi',
        'delphixpy/v1_11_18/web/storage/iscsi/target',
        'delphixpy/v1_11_18/web/storage/iscsi/initiator',
        'delphixpy/v1_11_18/web/storage/test',
        'delphixpy/v1_11_18/web/storage/device',
        'delphixpy/v1_11_18/web/storage/scrub',
        'delphixpy/v1_11_18/web/domain',
        'delphixpy/v1_11_18/web/analytics',
        'delphixpy/v1_11_18/web/analytics/statistic',
        'delphixpy/v1_11_18/web/selfservice',
        'delphixpy/v1_11_18/web/selfservice/branch',
        'delphixpy/v1_11_18/web/selfservice/container',
        'delphixpy/v1_11_18/web/selfservice/usagedata',
        'delphixpy/v1_11_18/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_18/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_18/web/selfservice/bookmark',
        'delphixpy/v1_11_18/web/selfservice/datasource',
        'delphixpy/v1_11_18/web/selfservice/operation',
        'delphixpy/v1_11_18/web/selfservice/template',
        'delphixpy/v1_11_18/web/selfservice/usage',
        'delphixpy/v1_11_18/web/selfservice/usage/branch',
        'delphixpy/v1_11_18/web/selfservice/usage/user',
        'delphixpy/v1_11_18/web/selfservice/usage/container',
        'delphixpy/v1_11_18/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_18/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_18/web/selfservice/usage/template',
        'delphixpy/v1_11_18/web/selfservice/config',
        'delphixpy/v1_11_18/web/snapshot',
        'delphixpy/v1_11_18/web/sourceconfig',
        'delphixpy/v1_11_18/web/namespace',
        'delphixpy/v1_11_18/web/replication',
        'delphixpy/v1_11_18/web/replication/spec',
        'delphixpy/v1_11_18/web/replication/targetstate',
        'delphixpy/v1_11_18/web/replication/sourcestate',
        'delphixpy/v1_11_18/web/replication/serializationpoint',
        'delphixpy/v1_11_18/web/source',
        'delphixpy/v1_11_18/web/source/operationTemplate',
        'delphixpy/v1_11_18/web/service',
        'delphixpy/v1_11_18/web/service/smtp',
        'delphixpy/v1_11_18/web/service/ldap',
        'delphixpy/v1_11_18/web/service/ldap/server',
        'delphixpy/v1_11_18/web/service/nfs',
        'delphixpy/v1_11_18/web/service/host',
        'delphixpy/v1_11_18/web/service/host/address',
        'delphixpy/v1_11_18/web/service/snmp',
        'delphixpy/v1_11_18/web/service/snmp/v3',
        'delphixpy/v1_11_18/web/service/snmp/v3/manager',
        'delphixpy/v1_11_18/web/service/snmp/v3/usm',
        'delphixpy/v1_11_18/web/service/snmp/v2',
        'delphixpy/v1_11_18/web/service/snmp/v2/manager',
        'delphixpy/v1_11_18/web/service/userInterface',
        'delphixpy/v1_11_18/web/service/linkingsettings',
        'delphixpy/v1_11_18/web/service/phonehome',
        'delphixpy/v1_11_18/web/service/events',
        'delphixpy/v1_11_18/web/service/fluentd',
        'delphixpy/v1_11_18/web/service/fluentd/plugins',
        'delphixpy/v1_11_18/web/service/fluentd/configuration',
        'delphixpy/v1_11_18/web/service/httpConnector',
        'delphixpy/v1_11_18/web/service/userPaths',
        'delphixpy/v1_11_18/web/service/security',
        'delphixpy/v1_11_18/web/service/dns',
        'delphixpy/v1_11_18/web/service/kerberos',
        'delphixpy/v1_11_18/web/service/schema',
        'delphixpy/v1_11_18/web/service/tls',
        'delphixpy/v1_11_18/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_18/web/service/tls/csr',
        'delphixpy/v1_11_18/web/service/tls/cipherSuite',
        'delphixpy/v1_11_18/web/service/tls/caCertificate',
        'delphixpy/v1_11_18/web/service/insight',
        'delphixpy/v1_11_18/web/service/insight/splunkHec',
        'delphixpy/v1_11_18/web/service/locale',
        'delphixpy/v1_11_18/web/service/cloud',
        'delphixpy/v1_11_18/web/service/proxy',
        'delphixpy/v1_11_18/web/service/time',
        'delphixpy/v1_11_18/web/service/syslog',
        'delphixpy/v1_11_18/web/service/passwordReset',
        'delphixpy/v1_11_18/web/service/support',
        'delphixpy/v1_11_18/web/service/support/access',
        'delphixpy/v1_11_18/web/service/support/bundle',
        'delphixpy/v1_11_18/web/service/minimalPhonehome',
        'delphixpy/v1_11_18/web/service/passwordVault',
        'delphixpy/v1_11_18/web/service/oauth2',
        'delphixpy/v1_11_18/web/service/sso',
        'delphixpy/v1_11_18/web/system',
        'delphixpy/v1_11_18/web/system/verification',
        'delphixpy/v1_11_18/web/system/verification/reports',
        'delphixpy/v1_11_18/web/system/verification/reports/steps',
        'delphixpy/v1_11_18/web/system/advancedSettings',
        'delphixpy/v1_11_18/web/system/upgradeCheckResult',
        'delphixpy/v1_11_18/web/system/status',
        'delphixpy/v1_11_18/web/system/version',
        'delphixpy/v1_11_18/web/network',
        'delphixpy/v1_11_18/web/network/route',
        'delphixpy/v1_11_18/web/network/test',
        'delphixpy/v1_11_18/web/network/test/latency',
        'delphixpy/v1_11_18/web/network/test/throughput',
        'delphixpy/v1_11_18/web/network/test/dsp',
        'delphixpy/v1_11_18/web/network/interface',
        'delphixpy/v1_11_18/web/network/dsp',
        'delphixpy/v1_11_18/web/network/dsp/autotune',
        'delphixpy/v1_11_18/web/session',
        'delphixpy/v1_11_14',
        'delphixpy/v1_11_14/web',
        'delphixpy/v1_11_14/web/authorization',
        'delphixpy/v1_11_14/web/authorization/configuration',
        'delphixpy/v1_11_14/web/permission',
        'delphixpy/v1_11_14/web/passwordPolicy',
        'delphixpy/v1_11_14/web/role',
        'delphixpy/v1_11_14/web/toolkit',
        'delphixpy/v1_11_14/web/environment',
        'delphixpy/v1_11_14/web/environment/user',
        'delphixpy/v1_11_14/web/environment/oracle',
        'delphixpy/v1_11_14/web/environment/oracle/listener',
        'delphixpy/v1_11_14/web/environment/oracle/clusternode',
        'delphixpy/v1_11_14/web/environment/windows',
        'delphixpy/v1_11_14/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_14/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_14/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_14/web/environment/windows/clusternode',
        'delphixpy/v1_11_14/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_14/web/capacity',
        'delphixpy/v1_11_14/web/capacity/heldspace',
        'delphixpy/v1_11_14/web/capacity/group',
        'delphixpy/v1_11_14/web/capacity/group/historical',
        'delphixpy/v1_11_14/web/capacity/consumer',
        'delphixpy/v1_11_14/web/capacity/consumer/historical',
        'delphixpy/v1_11_14/web/capacity/snapshot',
        'delphixpy/v1_11_14/web/capacity/system',
        'delphixpy/v1_11_14/web/capacity/system/historical',
        'delphixpy/v1_11_14/web/database',
        'delphixpy/v1_11_14/web/database/performanceHistory',
        'delphixpy/v1_11_14/web/database/template',
        'delphixpy/v1_11_14/web/registration',
        'delphixpy/v1_11_14/web/registration/status',
        'delphixpy/v1_11_14/web/host',
        'delphixpy/v1_11_14/web/host/privilegeElevation',
        'delphixpy/v1_11_14/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_14/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_14/web/theme',
        'delphixpy/v1_11_14/web/osadmin',
        'delphixpy/v1_11_14/web/osadmin/engineStatus',
        'delphixpy/v1_11_14/web/data',
        'delphixpy/v1_11_14/web/transformation',
        'delphixpy/v1_11_14/web/repository',
        'delphixpy/v1_11_14/web/repository/template',
        'delphixpy/v1_11_14/web/policy',
        'delphixpy/v1_11_14/web/user',
        'delphixpy/v1_11_14/web/alert',
        'delphixpy/v1_11_14/web/alert/profile',
        'delphixpy/v1_11_14/web/objects',
        'delphixpy/v1_11_14/web/maskingjob',
        'delphixpy/v1_11_14/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_14/web/timezone',
        'delphixpy/v1_11_14/web/fault',
        'delphixpy/v1_11_14/web/fault/effect',
        'delphixpy/v1_11_14/web/group',
        'delphixpy/v1_11_14/web/license',
        'delphixpy/v1_11_14/web/connectivity',
        'delphixpy/v1_11_14/web/notification',
        'delphixpy/v1_11_14/web/delphix',
        'delphixpy/v1_11_14/web/job',
        'delphixpy/v1_11_14/web/usage',
        'delphixpy/v1_11_14/web/about',
        'delphixpy/v1_11_14/web/timeflow',
        'delphixpy/v1_11_14/web/timeflow/bookmark',
        'delphixpy/v1_11_14/web/timeflow/oracle',
        'delphixpy/v1_11_14/web/timeflow/oracle/log',
        'delphixpy/v1_11_14/web/action',
        'delphixpy/v1_11_14/web/storage',
        'delphixpy/v1_11_14/web/storage/objectStorage',
        'delphixpy/v1_11_14/web/storage/remove',
        'delphixpy/v1_11_14/web/storage/iscsi',
        'delphixpy/v1_11_14/web/storage/iscsi/target',
        'delphixpy/v1_11_14/web/storage/iscsi/initiator',
        'delphixpy/v1_11_14/web/storage/test',
        'delphixpy/v1_11_14/web/storage/device',
        'delphixpy/v1_11_14/web/storage/scrub',
        'delphixpy/v1_11_14/web/domain',
        'delphixpy/v1_11_14/web/analytics',
        'delphixpy/v1_11_14/web/analytics/statistic',
        'delphixpy/v1_11_14/web/selfservice',
        'delphixpy/v1_11_14/web/selfservice/branch',
        'delphixpy/v1_11_14/web/selfservice/container',
        'delphixpy/v1_11_14/web/selfservice/usagedata',
        'delphixpy/v1_11_14/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_14/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_14/web/selfservice/bookmark',
        'delphixpy/v1_11_14/web/selfservice/datasource',
        'delphixpy/v1_11_14/web/selfservice/operation',
        'delphixpy/v1_11_14/web/selfservice/template',
        'delphixpy/v1_11_14/web/selfservice/usage',
        'delphixpy/v1_11_14/web/selfservice/usage/branch',
        'delphixpy/v1_11_14/web/selfservice/usage/user',
        'delphixpy/v1_11_14/web/selfservice/usage/container',
        'delphixpy/v1_11_14/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_14/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_14/web/selfservice/usage/template',
        'delphixpy/v1_11_14/web/selfservice/config',
        'delphixpy/v1_11_14/web/snapshot',
        'delphixpy/v1_11_14/web/sourceconfig',
        'delphixpy/v1_11_14/web/namespace',
        'delphixpy/v1_11_14/web/replication',
        'delphixpy/v1_11_14/web/replication/spec',
        'delphixpy/v1_11_14/web/replication/targetstate',
        'delphixpy/v1_11_14/web/replication/sourcestate',
        'delphixpy/v1_11_14/web/replication/serializationpoint',
        'delphixpy/v1_11_14/web/source',
        'delphixpy/v1_11_14/web/source/operationTemplate',
        'delphixpy/v1_11_14/web/service',
        'delphixpy/v1_11_14/web/service/smtp',
        'delphixpy/v1_11_14/web/service/ldap',
        'delphixpy/v1_11_14/web/service/ldap/server',
        'delphixpy/v1_11_14/web/service/nfs',
        'delphixpy/v1_11_14/web/service/host',
        'delphixpy/v1_11_14/web/service/host/address',
        'delphixpy/v1_11_14/web/service/snmp',
        'delphixpy/v1_11_14/web/service/snmp/v3',
        'delphixpy/v1_11_14/web/service/snmp/v3/manager',
        'delphixpy/v1_11_14/web/service/snmp/v3/usm',
        'delphixpy/v1_11_14/web/service/snmp/v2',
        'delphixpy/v1_11_14/web/service/snmp/v2/manager',
        'delphixpy/v1_11_14/web/service/userInterface',
        'delphixpy/v1_11_14/web/service/linkingsettings',
        'delphixpy/v1_11_14/web/service/phonehome',
        'delphixpy/v1_11_14/web/service/fluentd',
        'delphixpy/v1_11_14/web/service/fluentd/plugins',
        'delphixpy/v1_11_14/web/service/fluentd/configuration',
        'delphixpy/v1_11_14/web/service/httpConnector',
        'delphixpy/v1_11_14/web/service/userPaths',
        'delphixpy/v1_11_14/web/service/security',
        'delphixpy/v1_11_14/web/service/dns',
        'delphixpy/v1_11_14/web/service/kerberos',
        'delphixpy/v1_11_14/web/service/schema',
        'delphixpy/v1_11_14/web/service/tls',
        'delphixpy/v1_11_14/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_14/web/service/tls/csr',
        'delphixpy/v1_11_14/web/service/tls/cipherSuite',
        'delphixpy/v1_11_14/web/service/tls/caCertificate',
        'delphixpy/v1_11_14/web/service/insight',
        'delphixpy/v1_11_14/web/service/insight/splunkHec',
        'delphixpy/v1_11_14/web/service/locale',
        'delphixpy/v1_11_14/web/service/cloud',
        'delphixpy/v1_11_14/web/service/proxy',
        'delphixpy/v1_11_14/web/service/time',
        'delphixpy/v1_11_14/web/service/syslog',
        'delphixpy/v1_11_14/web/service/support',
        'delphixpy/v1_11_14/web/service/support/access',
        'delphixpy/v1_11_14/web/service/support/bundle',
        'delphixpy/v1_11_14/web/service/minimalPhonehome',
        'delphixpy/v1_11_14/web/service/passwordVault',
        'delphixpy/v1_11_14/web/service/oauth2',
        'delphixpy/v1_11_14/web/service/sso',
        'delphixpy/v1_11_14/web/system',
        'delphixpy/v1_11_14/web/system/verification',
        'delphixpy/v1_11_14/web/system/verification/reports',
        'delphixpy/v1_11_14/web/system/verification/reports/steps',
        'delphixpy/v1_11_14/web/system/advancedSettings',
        'delphixpy/v1_11_14/web/system/upgradeCheckResult',
        'delphixpy/v1_11_14/web/system/status',
        'delphixpy/v1_11_14/web/system/version',
        'delphixpy/v1_11_14/web/system/package',
        'delphixpy/v1_11_14/web/network',
        'delphixpy/v1_11_14/web/network/route',
        'delphixpy/v1_11_14/web/network/test',
        'delphixpy/v1_11_14/web/network/test/latency',
        'delphixpy/v1_11_14/web/network/test/throughput',
        'delphixpy/v1_11_14/web/network/test/dsp',
        'delphixpy/v1_11_14/web/network/interface',
        'delphixpy/v1_11_14/web/network/dsp',
        'delphixpy/v1_11_14/web/network/dsp/autotune',
        'delphixpy/v1_11_14/web/session',
        'delphixpy/v1_11_14/web/netty',
        'delphixpy/v1_11_13',
        'delphixpy/v1_11_13/web',
        'delphixpy/v1_11_13/web/authorization',
        'delphixpy/v1_11_13/web/authorization/configuration',
        'delphixpy/v1_11_13/web/permission',
        'delphixpy/v1_11_13/web/passwordPolicy',
        'delphixpy/v1_11_13/web/role',
        'delphixpy/v1_11_13/web/toolkit',
        'delphixpy/v1_11_13/web/environment',
        'delphixpy/v1_11_13/web/environment/user',
        'delphixpy/v1_11_13/web/environment/oracle',
        'delphixpy/v1_11_13/web/environment/oracle/listener',
        'delphixpy/v1_11_13/web/environment/oracle/clusternode',
        'delphixpy/v1_11_13/web/environment/windows',
        'delphixpy/v1_11_13/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_13/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_13/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_13/web/environment/windows/clusternode',
        'delphixpy/v1_11_13/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_13/web/capacity',
        'delphixpy/v1_11_13/web/capacity/heldspace',
        'delphixpy/v1_11_13/web/capacity/group',
        'delphixpy/v1_11_13/web/capacity/group/historical',
        'delphixpy/v1_11_13/web/capacity/consumer',
        'delphixpy/v1_11_13/web/capacity/consumer/historical',
        'delphixpy/v1_11_13/web/capacity/snapshot',
        'delphixpy/v1_11_13/web/capacity/system',
        'delphixpy/v1_11_13/web/capacity/system/historical',
        'delphixpy/v1_11_13/web/database',
        'delphixpy/v1_11_13/web/database/performanceHistory',
        'delphixpy/v1_11_13/web/database/template',
        'delphixpy/v1_11_13/web/registration',
        'delphixpy/v1_11_13/web/registration/status',
        'delphixpy/v1_11_13/web/host',
        'delphixpy/v1_11_13/web/host/privilegeElevation',
        'delphixpy/v1_11_13/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_13/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_13/web/theme',
        'delphixpy/v1_11_13/web/osadmin',
        'delphixpy/v1_11_13/web/osadmin/engineStatus',
        'delphixpy/v1_11_13/web/data',
        'delphixpy/v1_11_13/web/transformation',
        'delphixpy/v1_11_13/web/repository',
        'delphixpy/v1_11_13/web/repository/template',
        'delphixpy/v1_11_13/web/policy',
        'delphixpy/v1_11_13/web/user',
        'delphixpy/v1_11_13/web/alert',
        'delphixpy/v1_11_13/web/alert/profile',
        'delphixpy/v1_11_13/web/objects',
        'delphixpy/v1_11_13/web/maskingjob',
        'delphixpy/v1_11_13/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_13/web/timezone',
        'delphixpy/v1_11_13/web/fault',
        'delphixpy/v1_11_13/web/fault/effect',
        'delphixpy/v1_11_13/web/group',
        'delphixpy/v1_11_13/web/license',
        'delphixpy/v1_11_13/web/connectivity',
        'delphixpy/v1_11_13/web/notification',
        'delphixpy/v1_11_13/web/delphix',
        'delphixpy/v1_11_13/web/job',
        'delphixpy/v1_11_13/web/usage',
        'delphixpy/v1_11_13/web/about',
        'delphixpy/v1_11_13/web/timeflow',
        'delphixpy/v1_11_13/web/timeflow/bookmark',
        'delphixpy/v1_11_13/web/timeflow/oracle',
        'delphixpy/v1_11_13/web/timeflow/oracle/log',
        'delphixpy/v1_11_13/web/action',
        'delphixpy/v1_11_13/web/storage',
        'delphixpy/v1_11_13/web/storage/objectStorage',
        'delphixpy/v1_11_13/web/storage/remove',
        'delphixpy/v1_11_13/web/storage/iscsi',
        'delphixpy/v1_11_13/web/storage/iscsi/target',
        'delphixpy/v1_11_13/web/storage/iscsi/initiator',
        'delphixpy/v1_11_13/web/storage/test',
        'delphixpy/v1_11_13/web/storage/device',
        'delphixpy/v1_11_13/web/storage/scrub',
        'delphixpy/v1_11_13/web/domain',
        'delphixpy/v1_11_13/web/analytics',
        'delphixpy/v1_11_13/web/analytics/statistic',
        'delphixpy/v1_11_13/web/selfservice',
        'delphixpy/v1_11_13/web/selfservice/branch',
        'delphixpy/v1_11_13/web/selfservice/container',
        'delphixpy/v1_11_13/web/selfservice/usagedata',
        'delphixpy/v1_11_13/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_13/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_13/web/selfservice/bookmark',
        'delphixpy/v1_11_13/web/selfservice/datasource',
        'delphixpy/v1_11_13/web/selfservice/operation',
        'delphixpy/v1_11_13/web/selfservice/template',
        'delphixpy/v1_11_13/web/selfservice/usage',
        'delphixpy/v1_11_13/web/selfservice/usage/branch',
        'delphixpy/v1_11_13/web/selfservice/usage/user',
        'delphixpy/v1_11_13/web/selfservice/usage/container',
        'delphixpy/v1_11_13/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_13/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_13/web/selfservice/usage/template',
        'delphixpy/v1_11_13/web/selfservice/config',
        'delphixpy/v1_11_13/web/snapshot',
        'delphixpy/v1_11_13/web/sourceconfig',
        'delphixpy/v1_11_13/web/namespace',
        'delphixpy/v1_11_13/web/replication',
        'delphixpy/v1_11_13/web/replication/spec',
        'delphixpy/v1_11_13/web/replication/targetstate',
        'delphixpy/v1_11_13/web/replication/sourcestate',
        'delphixpy/v1_11_13/web/replication/serializationpoint',
        'delphixpy/v1_11_13/web/source',
        'delphixpy/v1_11_13/web/source/operationTemplate',
        'delphixpy/v1_11_13/web/service',
        'delphixpy/v1_11_13/web/service/smtp',
        'delphixpy/v1_11_13/web/service/ldap',
        'delphixpy/v1_11_13/web/service/ldap/server',
        'delphixpy/v1_11_13/web/service/nfs',
        'delphixpy/v1_11_13/web/service/host',
        'delphixpy/v1_11_13/web/service/host/address',
        'delphixpy/v1_11_13/web/service/snmp',
        'delphixpy/v1_11_13/web/service/snmp/v3',
        'delphixpy/v1_11_13/web/service/snmp/v3/manager',
        'delphixpy/v1_11_13/web/service/snmp/v3/usm',
        'delphixpy/v1_11_13/web/service/snmp/v2',
        'delphixpy/v1_11_13/web/service/snmp/v2/manager',
        'delphixpy/v1_11_13/web/service/userInterface',
        'delphixpy/v1_11_13/web/service/linkingsettings',
        'delphixpy/v1_11_13/web/service/phonehome',
        'delphixpy/v1_11_13/web/service/fluentd',
        'delphixpy/v1_11_13/web/service/fluentd/plugins',
        'delphixpy/v1_11_13/web/service/fluentd/configuration',
        'delphixpy/v1_11_13/web/service/httpConnector',
        'delphixpy/v1_11_13/web/service/userPaths',
        'delphixpy/v1_11_13/web/service/security',
        'delphixpy/v1_11_13/web/service/dns',
        'delphixpy/v1_11_13/web/service/kerberos',
        'delphixpy/v1_11_13/web/service/schema',
        'delphixpy/v1_11_13/web/service/tls',
        'delphixpy/v1_11_13/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_13/web/service/tls/csr',
        'delphixpy/v1_11_13/web/service/tls/cipherSuite',
        'delphixpy/v1_11_13/web/service/tls/caCertificate',
        'delphixpy/v1_11_13/web/service/insight',
        'delphixpy/v1_11_13/web/service/insight/splunkHec',
        'delphixpy/v1_11_13/web/service/locale',
        'delphixpy/v1_11_13/web/service/cloud',
        'delphixpy/v1_11_13/web/service/proxy',
        'delphixpy/v1_11_13/web/service/time',
        'delphixpy/v1_11_13/web/service/syslog',
        'delphixpy/v1_11_13/web/service/support',
        'delphixpy/v1_11_13/web/service/support/access',
        'delphixpy/v1_11_13/web/service/support/bundle',
        'delphixpy/v1_11_13/web/service/minimalPhonehome',
        'delphixpy/v1_11_13/web/service/passwordVault',
        'delphixpy/v1_11_13/web/service/oauth2',
        'delphixpy/v1_11_13/web/service/sso',
        'delphixpy/v1_11_13/web/system',
        'delphixpy/v1_11_13/web/system/verification',
        'delphixpy/v1_11_13/web/system/verification/reports',
        'delphixpy/v1_11_13/web/system/verification/reports/steps',
        'delphixpy/v1_11_13/web/system/advancedSettings',
        'delphixpy/v1_11_13/web/system/upgradeCheckResult',
        'delphixpy/v1_11_13/web/system/status',
        'delphixpy/v1_11_13/web/system/version',
        'delphixpy/v1_11_13/web/system/package',
        'delphixpy/v1_11_13/web/network',
        'delphixpy/v1_11_13/web/network/route',
        'delphixpy/v1_11_13/web/network/test',
        'delphixpy/v1_11_13/web/network/test/latency',
        'delphixpy/v1_11_13/web/network/test/throughput',
        'delphixpy/v1_11_13/web/network/test/dsp',
        'delphixpy/v1_11_13/web/network/interface',
        'delphixpy/v1_11_13/web/network/dsp',
        'delphixpy/v1_11_13/web/network/dsp/autotune',
        'delphixpy/v1_11_13/web/session',
        'delphixpy/v1_11_13/web/netty',
        'delphixpy/v1_11_7',
        'delphixpy/v1_11_7/web',
        'delphixpy/v1_11_7/web/authorization',
        'delphixpy/v1_11_7/web/authorization/configuration',
        'delphixpy/v1_11_7/web/permission',
        'delphixpy/v1_11_7/web/passwordPolicy',
        'delphixpy/v1_11_7/web/role',
        'delphixpy/v1_11_7/web/toolkit',
        'delphixpy/v1_11_7/web/environment',
        'delphixpy/v1_11_7/web/environment/user',
        'delphixpy/v1_11_7/web/environment/oracle',
        'delphixpy/v1_11_7/web/environment/oracle/listener',
        'delphixpy/v1_11_7/web/environment/oracle/clusternode',
        'delphixpy/v1_11_7/web/environment/windows',
        'delphixpy/v1_11_7/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_7/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_7/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_7/web/environment/windows/clusternode',
        'delphixpy/v1_11_7/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_7/web/capacity',
        'delphixpy/v1_11_7/web/capacity/heldspace',
        'delphixpy/v1_11_7/web/capacity/group',
        'delphixpy/v1_11_7/web/capacity/group/historical',
        'delphixpy/v1_11_7/web/capacity/consumer',
        'delphixpy/v1_11_7/web/capacity/consumer/historical',
        'delphixpy/v1_11_7/web/capacity/snapshot',
        'delphixpy/v1_11_7/web/capacity/system',
        'delphixpy/v1_11_7/web/capacity/system/historical',
        'delphixpy/v1_11_7/web/database',
        'delphixpy/v1_11_7/web/database/performanceHistory',
        'delphixpy/v1_11_7/web/database/template',
        'delphixpy/v1_11_7/web/registration',
        'delphixpy/v1_11_7/web/registration/status',
        'delphixpy/v1_11_7/web/host',
        'delphixpy/v1_11_7/web/host/privilegeElevation',
        'delphixpy/v1_11_7/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_7/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_7/web/theme',
        'delphixpy/v1_11_7/web/data',
        'delphixpy/v1_11_7/web/transformation',
        'delphixpy/v1_11_7/web/repository',
        'delphixpy/v1_11_7/web/repository/template',
        'delphixpy/v1_11_7/web/policy',
        'delphixpy/v1_11_7/web/user',
        'delphixpy/v1_11_7/web/alert',
        'delphixpy/v1_11_7/web/alert/profile',
        'delphixpy/v1_11_7/web/objects',
        'delphixpy/v1_11_7/web/maskingjob',
        'delphixpy/v1_11_7/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_7/web/timezone',
        'delphixpy/v1_11_7/web/fault',
        'delphixpy/v1_11_7/web/fault/effect',
        'delphixpy/v1_11_7/web/group',
        'delphixpy/v1_11_7/web/license',
        'delphixpy/v1_11_7/web/connectivity',
        'delphixpy/v1_11_7/web/notification',
        'delphixpy/v1_11_7/web/delphix',
        'delphixpy/v1_11_7/web/job',
        'delphixpy/v1_11_7/web/usage',
        'delphixpy/v1_11_7/web/about',
        'delphixpy/v1_11_7/web/timeflow',
        'delphixpy/v1_11_7/web/timeflow/bookmark',
        'delphixpy/v1_11_7/web/timeflow/oracle',
        'delphixpy/v1_11_7/web/timeflow/oracle/log',
        'delphixpy/v1_11_7/web/action',
        'delphixpy/v1_11_7/web/storage',
        'delphixpy/v1_11_7/web/storage/remove',
        'delphixpy/v1_11_7/web/storage/test',
        'delphixpy/v1_11_7/web/storage/device',
        'delphixpy/v1_11_7/web/storage/scrub',
        'delphixpy/v1_11_7/web/domain',
        'delphixpy/v1_11_7/web/analytics',
        'delphixpy/v1_11_7/web/analytics/statistic',
        'delphixpy/v1_11_7/web/selfservice',
        'delphixpy/v1_11_7/web/selfservice/branch',
        'delphixpy/v1_11_7/web/selfservice/container',
        'delphixpy/v1_11_7/web/selfservice/usagedata',
        'delphixpy/v1_11_7/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_7/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_7/web/selfservice/bookmark',
        'delphixpy/v1_11_7/web/selfservice/datasource',
        'delphixpy/v1_11_7/web/selfservice/operation',
        'delphixpy/v1_11_7/web/selfservice/template',
        'delphixpy/v1_11_7/web/selfservice/usage',
        'delphixpy/v1_11_7/web/selfservice/usage/branch',
        'delphixpy/v1_11_7/web/selfservice/usage/user',
        'delphixpy/v1_11_7/web/selfservice/usage/container',
        'delphixpy/v1_11_7/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_7/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_7/web/selfservice/usage/template',
        'delphixpy/v1_11_7/web/selfservice/config',
        'delphixpy/v1_11_7/web/snapshot',
        'delphixpy/v1_11_7/web/sourceconfig',
        'delphixpy/v1_11_7/web/namespace',
        'delphixpy/v1_11_7/web/replication',
        'delphixpy/v1_11_7/web/replication/spec',
        'delphixpy/v1_11_7/web/replication/targetstate',
        'delphixpy/v1_11_7/web/replication/sourcestate',
        'delphixpy/v1_11_7/web/replication/serializationpoint',
        'delphixpy/v1_11_7/web/source',
        'delphixpy/v1_11_7/web/source/operationTemplate',
        'delphixpy/v1_11_7/web/service',
        'delphixpy/v1_11_7/web/service/smtp',
        'delphixpy/v1_11_7/web/service/ldap',
        'delphixpy/v1_11_7/web/service/ldap/server',
        'delphixpy/v1_11_7/web/service/nfs',
        'delphixpy/v1_11_7/web/service/host',
        'delphixpy/v1_11_7/web/service/host/address',
        'delphixpy/v1_11_7/web/service/snmp',
        'delphixpy/v1_11_7/web/service/snmp/v3',
        'delphixpy/v1_11_7/web/service/snmp/v3/manager',
        'delphixpy/v1_11_7/web/service/snmp/v3/usm',
        'delphixpy/v1_11_7/web/service/snmp/v2',
        'delphixpy/v1_11_7/web/service/snmp/v2/manager',
        'delphixpy/v1_11_7/web/service/userInterface',
        'delphixpy/v1_11_7/web/service/linkingsettings',
        'delphixpy/v1_11_7/web/service/phonehome',
        'delphixpy/v1_11_7/web/service/httpConnector',
        'delphixpy/v1_11_7/web/service/userPaths',
        'delphixpy/v1_11_7/web/service/security',
        'delphixpy/v1_11_7/web/service/dns',
        'delphixpy/v1_11_7/web/service/kerberos',
        'delphixpy/v1_11_7/web/service/schema',
        'delphixpy/v1_11_7/web/service/tls',
        'delphixpy/v1_11_7/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_7/web/service/tls/csr',
        'delphixpy/v1_11_7/web/service/tls/cipherSuite',
        'delphixpy/v1_11_7/web/service/tls/caCertificate',
        'delphixpy/v1_11_7/web/service/insight',
        'delphixpy/v1_11_7/web/service/insight/splunkHec',
        'delphixpy/v1_11_7/web/service/locale',
        'delphixpy/v1_11_7/web/service/cloud',
        'delphixpy/v1_11_7/web/service/proxy',
        'delphixpy/v1_11_7/web/service/time',
        'delphixpy/v1_11_7/web/service/syslog',
        'delphixpy/v1_11_7/web/service/support',
        'delphixpy/v1_11_7/web/service/support/access',
        'delphixpy/v1_11_7/web/service/support/bundle',
        'delphixpy/v1_11_7/web/service/minimalPhonehome',
        'delphixpy/v1_11_7/web/service/passwordVault',
        'delphixpy/v1_11_7/web/service/sso',
        'delphixpy/v1_11_7/web/system',
        'delphixpy/v1_11_7/web/system/verification',
        'delphixpy/v1_11_7/web/system/verification/reports',
        'delphixpy/v1_11_7/web/system/verification/reports/steps',
        'delphixpy/v1_11_7/web/system/upgradeCheckResult',
        'delphixpy/v1_11_7/web/system/status',
        'delphixpy/v1_11_7/web/system/version',
        'delphixpy/v1_11_7/web/system/package',
        'delphixpy/v1_11_7/web/network',
        'delphixpy/v1_11_7/web/network/route',
        'delphixpy/v1_11_7/web/network/test',
        'delphixpy/v1_11_7/web/network/test/latency',
        'delphixpy/v1_11_7/web/network/test/throughput',
        'delphixpy/v1_11_7/web/network/test/dsp',
        'delphixpy/v1_11_7/web/network/interface',
        'delphixpy/v1_11_7/web/network/dsp',
        'delphixpy/v1_11_7/web/network/dsp/autotune',
        'delphixpy/v1_11_7/web/session',
        'delphixpy/v1_11_3',
        'delphixpy/v1_11_3/web',
        'delphixpy/v1_11_3/web/authorization',
        'delphixpy/v1_11_3/web/authorization/configuration',
        'delphixpy/v1_11_3/web/permission',
        'delphixpy/v1_11_3/web/passwordPolicy',
        'delphixpy/v1_11_3/web/role',
        'delphixpy/v1_11_3/web/toolkit',
        'delphixpy/v1_11_3/web/environment',
        'delphixpy/v1_11_3/web/environment/user',
        'delphixpy/v1_11_3/web/environment/oracle',
        'delphixpy/v1_11_3/web/environment/oracle/listener',
        'delphixpy/v1_11_3/web/environment/oracle/clusternode',
        'delphixpy/v1_11_3/web/environment/windows',
        'delphixpy/v1_11_3/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_3/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_3/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_3/web/environment/windows/clusternode',
        'delphixpy/v1_11_3/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_3/web/capacity',
        'delphixpy/v1_11_3/web/capacity/group',
        'delphixpy/v1_11_3/web/capacity/group/historical',
        'delphixpy/v1_11_3/web/capacity/consumer',
        'delphixpy/v1_11_3/web/capacity/consumer/historical',
        'delphixpy/v1_11_3/web/capacity/snapshot',
        'delphixpy/v1_11_3/web/capacity/system',
        'delphixpy/v1_11_3/web/capacity/system/historical',
        'delphixpy/v1_11_3/web/database',
        'delphixpy/v1_11_3/web/database/performanceHistory',
        'delphixpy/v1_11_3/web/database/template',
        'delphixpy/v1_11_3/web/registration',
        'delphixpy/v1_11_3/web/registration/status',
        'delphixpy/v1_11_3/web/host',
        'delphixpy/v1_11_3/web/host/privilegeElevation',
        'delphixpy/v1_11_3/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_3/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_3/web/theme',
        'delphixpy/v1_11_3/web/data',
        'delphixpy/v1_11_3/web/transformation',
        'delphixpy/v1_11_3/web/repository',
        'delphixpy/v1_11_3/web/repository/template',
        'delphixpy/v1_11_3/web/policy',
        'delphixpy/v1_11_3/web/user',
        'delphixpy/v1_11_3/web/alert',
        'delphixpy/v1_11_3/web/alert/profile',
        'delphixpy/v1_11_3/web/objects',
        'delphixpy/v1_11_3/web/maskingjob',
        'delphixpy/v1_11_3/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_3/web/timezone',
        'delphixpy/v1_11_3/web/fault',
        'delphixpy/v1_11_3/web/fault/effect',
        'delphixpy/v1_11_3/web/group',
        'delphixpy/v1_11_3/web/license',
        'delphixpy/v1_11_3/web/connectivity',
        'delphixpy/v1_11_3/web/notification',
        'delphixpy/v1_11_3/web/delphix',
        'delphixpy/v1_11_3/web/job',
        'delphixpy/v1_11_3/web/usage',
        'delphixpy/v1_11_3/web/about',
        'delphixpy/v1_11_3/web/timeflow',
        'delphixpy/v1_11_3/web/timeflow/bookmark',
        'delphixpy/v1_11_3/web/timeflow/oracle',
        'delphixpy/v1_11_3/web/timeflow/oracle/log',
        'delphixpy/v1_11_3/web/action',
        'delphixpy/v1_11_3/web/storage',
        'delphixpy/v1_11_3/web/storage/remove',
        'delphixpy/v1_11_3/web/storage/test',
        'delphixpy/v1_11_3/web/storage/device',
        'delphixpy/v1_11_3/web/storage/scrub',
        'delphixpy/v1_11_3/web/domain',
        'delphixpy/v1_11_3/web/analytics',
        'delphixpy/v1_11_3/web/analytics/statistic',
        'delphixpy/v1_11_3/web/selfservice',
        'delphixpy/v1_11_3/web/selfservice/branch',
        'delphixpy/v1_11_3/web/selfservice/container',
        'delphixpy/v1_11_3/web/selfservice/usagedata',
        'delphixpy/v1_11_3/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_3/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_3/web/selfservice/bookmark',
        'delphixpy/v1_11_3/web/selfservice/datasource',
        'delphixpy/v1_11_3/web/selfservice/operation',
        'delphixpy/v1_11_3/web/selfservice/template',
        'delphixpy/v1_11_3/web/selfservice/usage',
        'delphixpy/v1_11_3/web/selfservice/usage/branch',
        'delphixpy/v1_11_3/web/selfservice/usage/user',
        'delphixpy/v1_11_3/web/selfservice/usage/container',
        'delphixpy/v1_11_3/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_3/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_3/web/selfservice/usage/template',
        'delphixpy/v1_11_3/web/selfservice/config',
        'delphixpy/v1_11_3/web/snapshot',
        'delphixpy/v1_11_3/web/sourceconfig',
        'delphixpy/v1_11_3/web/namespace',
        'delphixpy/v1_11_3/web/replication',
        'delphixpy/v1_11_3/web/replication/spec',
        'delphixpy/v1_11_3/web/replication/targetstate',
        'delphixpy/v1_11_3/web/replication/sourcestate',
        'delphixpy/v1_11_3/web/replication/serializationpoint',
        'delphixpy/v1_11_3/web/source',
        'delphixpy/v1_11_3/web/source/operationTemplate',
        'delphixpy/v1_11_3/web/service',
        'delphixpy/v1_11_3/web/service/smtp',
        'delphixpy/v1_11_3/web/service/ldap',
        'delphixpy/v1_11_3/web/service/ldap/server',
        'delphixpy/v1_11_3/web/service/nfs',
        'delphixpy/v1_11_3/web/service/snmp',
        'delphixpy/v1_11_3/web/service/snmp/manager',
        'delphixpy/v1_11_3/web/service/userInterface',
        'delphixpy/v1_11_3/web/service/linkingsettings',
        'delphixpy/v1_11_3/web/service/phonehome',
        'delphixpy/v1_11_3/web/service/httpConnector',
        'delphixpy/v1_11_3/web/service/userPaths',
        'delphixpy/v1_11_3/web/service/security',
        'delphixpy/v1_11_3/web/service/dns',
        'delphixpy/v1_11_3/web/service/kerberos',
        'delphixpy/v1_11_3/web/service/schema',
        'delphixpy/v1_11_3/web/service/tls',
        'delphixpy/v1_11_3/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_3/web/service/tls/csr',
        'delphixpy/v1_11_3/web/service/tls/cipherSuite',
        'delphixpy/v1_11_3/web/service/tls/caCertificate',
        'delphixpy/v1_11_3/web/service/insight',
        'delphixpy/v1_11_3/web/service/insight/splunkHec',
        'delphixpy/v1_11_3/web/service/locale',
        'delphixpy/v1_11_3/web/service/cloud',
        'delphixpy/v1_11_3/web/service/proxy',
        'delphixpy/v1_11_3/web/service/certificate',
        'delphixpy/v1_11_3/web/service/time',
        'delphixpy/v1_11_3/web/service/syslog',
        'delphixpy/v1_11_3/web/service/support',
        'delphixpy/v1_11_3/web/service/support/access',
        'delphixpy/v1_11_3/web/service/support/bundle',
        'delphixpy/v1_11_3/web/service/minimalPhonehome',
        'delphixpy/v1_11_3/web/service/passwordVault',
        'delphixpy/v1_11_3/web/service/sso',
        'delphixpy/v1_11_3/web/system',
        'delphixpy/v1_11_3/web/system/verification',
        'delphixpy/v1_11_3/web/system/verification/reports',
        'delphixpy/v1_11_3/web/system/verification/reports/steps',
        'delphixpy/v1_11_3/web/system/upgradeCheckResult',
        'delphixpy/v1_11_3/web/system/status',
        'delphixpy/v1_11_3/web/system/version',
        'delphixpy/v1_11_3/web/system/package',
        'delphixpy/v1_11_3/web/network',
        'delphixpy/v1_11_3/web/network/route',
        'delphixpy/v1_11_3/web/network/test',
        'delphixpy/v1_11_3/web/network/test/latency',
        'delphixpy/v1_11_3/web/network/test/throughput',
        'delphixpy/v1_11_3/web/network/test/dsp',
        'delphixpy/v1_11_3/web/network/interface',
        'delphixpy/v1_11_3/web/network/dsp',
        'delphixpy/v1_11_3/web/network/dsp/autotune',
        'delphixpy/v1_11_3/web/session',
        'delphixpy/v1_11_24',
        'delphixpy/v1_11_24/web',
        'delphixpy/v1_11_24/web/authorization',
        'delphixpy/v1_11_24/web/authorization/configuration',
        'delphixpy/v1_11_24/web/permission',
        'delphixpy/v1_11_24/web/passwordPolicy',
        'delphixpy/v1_11_24/web/role',
        'delphixpy/v1_11_24/web/toolkit',
        'delphixpy/v1_11_24/web/environment',
        'delphixpy/v1_11_24/web/environment/user',
        'delphixpy/v1_11_24/web/environment/oracle',
        'delphixpy/v1_11_24/web/environment/oracle/listener',
        'delphixpy/v1_11_24/web/environment/oracle/clusternode',
        'delphixpy/v1_11_24/web/environment/windows',
        'delphixpy/v1_11_24/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_24/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_24/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_24/web/environment/windows/clusternode',
        'delphixpy/v1_11_24/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_24/web/capacity',
        'delphixpy/v1_11_24/web/capacity/heldspace',
        'delphixpy/v1_11_24/web/capacity/group',
        'delphixpy/v1_11_24/web/capacity/group/historical',
        'delphixpy/v1_11_24/web/capacity/consumer',
        'delphixpy/v1_11_24/web/capacity/consumer/historical',
        'delphixpy/v1_11_24/web/capacity/snapshot',
        'delphixpy/v1_11_24/web/capacity/system',
        'delphixpy/v1_11_24/web/capacity/system/historical',
        'delphixpy/v1_11_24/web/database',
        'delphixpy/v1_11_24/web/database/performanceHistory',
        'delphixpy/v1_11_24/web/database/template',
        'delphixpy/v1_11_24/web/registration',
        'delphixpy/v1_11_24/web/registration/status',
        'delphixpy/v1_11_24/web/host',
        'delphixpy/v1_11_24/web/host/privilegeElevation',
        'delphixpy/v1_11_24/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_24/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_24/web/theme',
        'delphixpy/v1_11_24/web/repave',
        'delphixpy/v1_11_24/web/osadmin',
        'delphixpy/v1_11_24/web/osadmin/engineStatus',
        'delphixpy/v1_11_24/web/data',
        'delphixpy/v1_11_24/web/transformation',
        'delphixpy/v1_11_24/web/repository',
        'delphixpy/v1_11_24/web/repository/template',
        'delphixpy/v1_11_24/web/policy',
        'delphixpy/v1_11_24/web/user',
        'delphixpy/v1_11_24/web/superuser',
        'delphixpy/v1_11_24/web/superuser/session',
        'delphixpy/v1_11_24/web/alert',
        'delphixpy/v1_11_24/web/alert/profile',
        'delphixpy/v1_11_24/web/objects',
        'delphixpy/v1_11_24/web/maskingjob',
        'delphixpy/v1_11_24/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_24/web/timezone',
        'delphixpy/v1_11_24/web/fault',
        'delphixpy/v1_11_24/web/fault/effect',
        'delphixpy/v1_11_24/web/group',
        'delphixpy/v1_11_24/web/license',
        'delphixpy/v1_11_24/web/connectivity',
        'delphixpy/v1_11_24/web/notification',
        'delphixpy/v1_11_24/web/delphix',
        'delphixpy/v1_11_24/web/job',
        'delphixpy/v1_11_24/web/job/retention',
        'delphixpy/v1_11_24/web/usage',
        'delphixpy/v1_11_24/web/about',
        'delphixpy/v1_11_24/web/timeflow',
        'delphixpy/v1_11_24/web/timeflow/bookmark',
        'delphixpy/v1_11_24/web/timeflow/oracle',
        'delphixpy/v1_11_24/web/timeflow/oracle/log',
        'delphixpy/v1_11_24/web/action',
        'delphixpy/v1_11_24/web/storage',
        'delphixpy/v1_11_24/web/storage/objectStorage',
        'delphixpy/v1_11_24/web/storage/remove',
        'delphixpy/v1_11_24/web/storage/iscsi',
        'delphixpy/v1_11_24/web/storage/iscsi/target',
        'delphixpy/v1_11_24/web/storage/iscsi/initiator',
        'delphixpy/v1_11_24/web/storage/migrate',
        'delphixpy/v1_11_24/web/storage/test',
        'delphixpy/v1_11_24/web/storage/device',
        'delphixpy/v1_11_24/web/storage/scrub',
        'delphixpy/v1_11_24/web/domain',
        'delphixpy/v1_11_24/web/analytics',
        'delphixpy/v1_11_24/web/analytics/statistic',
        'delphixpy/v1_11_24/web/selfservice',
        'delphixpy/v1_11_24/web/selfservice/branch',
        'delphixpy/v1_11_24/web/selfservice/container',
        'delphixpy/v1_11_24/web/selfservice/usagedata',
        'delphixpy/v1_11_24/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_24/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_24/web/selfservice/bookmark',
        'delphixpy/v1_11_24/web/selfservice/datasource',
        'delphixpy/v1_11_24/web/selfservice/operation',
        'delphixpy/v1_11_24/web/selfservice/template',
        'delphixpy/v1_11_24/web/selfservice/usage',
        'delphixpy/v1_11_24/web/selfservice/usage/branch',
        'delphixpy/v1_11_24/web/selfservice/usage/user',
        'delphixpy/v1_11_24/web/selfservice/usage/container',
        'delphixpy/v1_11_24/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_24/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_24/web/selfservice/usage/template',
        'delphixpy/v1_11_24/web/selfservice/config',
        'delphixpy/v1_11_24/web/snapshot',
        'delphixpy/v1_11_24/web/sourceconfig',
        'delphixpy/v1_11_24/web/namespace',
        'delphixpy/v1_11_24/web/replication',
        'delphixpy/v1_11_24/web/replication/spec',
        'delphixpy/v1_11_24/web/replication/targetstate',
        'delphixpy/v1_11_24/web/replication/sourcestate',
        'delphixpy/v1_11_24/web/replication/serializationpoint',
        'delphixpy/v1_11_24/web/source',
        'delphixpy/v1_11_24/web/source/operationTemplate',
        'delphixpy/v1_11_24/web/service',
        'delphixpy/v1_11_24/web/service/smtp',
        'delphixpy/v1_11_24/web/service/ldap',
        'delphixpy/v1_11_24/web/service/ldap/server',
        'delphixpy/v1_11_24/web/service/nfs',
        'delphixpy/v1_11_24/web/service/host',
        'delphixpy/v1_11_24/web/service/host/address',
        'delphixpy/v1_11_24/web/service/snmp',
        'delphixpy/v1_11_24/web/service/snmp/v3',
        'delphixpy/v1_11_24/web/service/snmp/v3/manager',
        'delphixpy/v1_11_24/web/service/snmp/v3/usm',
        'delphixpy/v1_11_24/web/service/snmp/v2',
        'delphixpy/v1_11_24/web/service/snmp/v2/manager',
        'delphixpy/v1_11_24/web/service/userInterface',
        'delphixpy/v1_11_24/web/service/linkingsettings',
        'delphixpy/v1_11_24/web/service/phonehome',
        'delphixpy/v1_11_24/web/service/events',
        'delphixpy/v1_11_24/web/service/fluentd',
        'delphixpy/v1_11_24/web/service/fluentd/plugins',
        'delphixpy/v1_11_24/web/service/fluentd/configuration',
        'delphixpy/v1_11_24/web/service/httpConnector',
        'delphixpy/v1_11_24/web/service/userPaths',
        'delphixpy/v1_11_24/web/service/security',
        'delphixpy/v1_11_24/web/service/dns',
        'delphixpy/v1_11_24/web/service/kerberos',
        'delphixpy/v1_11_24/web/service/schema',
        'delphixpy/v1_11_24/web/service/tls',
        'delphixpy/v1_11_24/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_24/web/service/tls/csr',
        'delphixpy/v1_11_24/web/service/tls/cipherSuite',
        'delphixpy/v1_11_24/web/service/tls/caCertificate',
        'delphixpy/v1_11_24/web/service/insight',
        'delphixpy/v1_11_24/web/service/insight/splunkHec',
        'delphixpy/v1_11_24/web/service/locale',
        'delphixpy/v1_11_24/web/service/cloud',
        'delphixpy/v1_11_24/web/service/proxy',
        'delphixpy/v1_11_24/web/service/time',
        'delphixpy/v1_11_24/web/service/syslog',
        'delphixpy/v1_11_24/web/service/passwordReset',
        'delphixpy/v1_11_24/web/service/support',
        'delphixpy/v1_11_24/web/service/support/access',
        'delphixpy/v1_11_24/web/service/support/bundle',
        'delphixpy/v1_11_24/web/service/minimalPhonehome',
        'delphixpy/v1_11_24/web/service/passwordVault',
        'delphixpy/v1_11_24/web/service/oauth2',
        'delphixpy/v1_11_24/web/service/sso',
        'delphixpy/v1_11_24/web/system',
        'delphixpy/v1_11_24/web/system/verification',
        'delphixpy/v1_11_24/web/system/verification/reports',
        'delphixpy/v1_11_24/web/system/verification/reports/steps',
        'delphixpy/v1_11_24/web/system/advancedSettings',
        'delphixpy/v1_11_24/web/system/upgradeCheckResult',
        'delphixpy/v1_11_24/web/system/status',
        'delphixpy/v1_11_24/web/system/version',
        'delphixpy/v1_11_24/web/network',
        'delphixpy/v1_11_24/web/network/route',
        'delphixpy/v1_11_24/web/network/test',
        'delphixpy/v1_11_24/web/network/test/latency',
        'delphixpy/v1_11_24/web/network/test/throughput',
        'delphixpy/v1_11_24/web/network/test/dsp',
        'delphixpy/v1_11_24/web/network/interface',
        'delphixpy/v1_11_24/web/network/dsp',
        'delphixpy/v1_11_24/web/network/dsp/autotune',
        'delphixpy/v1_11_24/web/session',
        'delphixpy/v1_6_2',
        'delphixpy/v1_6_2/web',
        'delphixpy/v1_6_2/web/authorization',
        'delphixpy/v1_6_2/web/permission',
        'delphixpy/v1_6_2/web/role',
        'delphixpy/v1_6_2/web/toolkit',
        'delphixpy/v1_6_2/web/environment',
        'delphixpy/v1_6_2/web/environment/user',
        'delphixpy/v1_6_2/web/environment/oracle',
        'delphixpy/v1_6_2/web/environment/oracle/listener',
        'delphixpy/v1_6_2/web/environment/oracle/clusternode',
        'delphixpy/v1_6_2/web/environment/windows',
        'delphixpy/v1_6_2/web/environment/windows/clusterinstance',
        'delphixpy/v1_6_2/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_6_2/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_6_2/web/environment/windows/clusternode',
        'delphixpy/v1_6_2/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_6_2/web/capacity',
        'delphixpy/v1_6_2/web/capacity/group',
        'delphixpy/v1_6_2/web/capacity/group/historical',
        'delphixpy/v1_6_2/web/capacity/consumer',
        'delphixpy/v1_6_2/web/capacity/consumer/historical',
        'delphixpy/v1_6_2/web/capacity/snapshot',
        'delphixpy/v1_6_2/web/capacity/system',
        'delphixpy/v1_6_2/web/capacity/system/historical',
        'delphixpy/v1_6_2/web/database',
        'delphixpy/v1_6_2/web/database/template',
        'delphixpy/v1_6_2/web/registration',
        'delphixpy/v1_6_2/web/registration/status',
        'delphixpy/v1_6_2/web/host',
        'delphixpy/v1_6_2/web/host/privilegeElevation',
        'delphixpy/v1_6_2/web/host/privilegeElevation/profile',
        'delphixpy/v1_6_2/web/data',
        'delphixpy/v1_6_2/web/repository',
        'delphixpy/v1_6_2/web/repository/template',
        'delphixpy/v1_6_2/web/policy',
        'delphixpy/v1_6_2/web/user',
        'delphixpy/v1_6_2/web/alert',
        'delphixpy/v1_6_2/web/alert/profile',
        'delphixpy/v1_6_2/web/objects',
        'delphixpy/v1_6_2/web/fault',
        'delphixpy/v1_6_2/web/fault/effect',
        'delphixpy/v1_6_2/web/group',
        'delphixpy/v1_6_2/web/connectivity',
        'delphixpy/v1_6_2/web/notification',
        'delphixpy/v1_6_2/web/delphix',
        'delphixpy/v1_6_2/web/job',
        'delphixpy/v1_6_2/web/about',
        'delphixpy/v1_6_2/web/timeflow',
        'delphixpy/v1_6_2/web/timeflow/bookmark',
        'delphixpy/v1_6_2/web/timeflow/oracle',
        'delphixpy/v1_6_2/web/timeflow/oracle/log',
        'delphixpy/v1_6_2/web/action',
        'delphixpy/v1_6_2/web/jetstream',
        'delphixpy/v1_6_2/web/jetstream/branch',
        'delphixpy/v1_6_2/web/jetstream/container',
        'delphixpy/v1_6_2/web/jetstream/usagedata',
        'delphixpy/v1_6_2/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_6_2/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_6_2/web/jetstream/bookmark',
        'delphixpy/v1_6_2/web/jetstream/datasource',
        'delphixpy/v1_6_2/web/jetstream/operation',
        'delphixpy/v1_6_2/web/jetstream/template',
        'delphixpy/v1_6_2/web/jetstream/usage',
        'delphixpy/v1_6_2/web/jetstream/usage/branch',
        'delphixpy/v1_6_2/web/jetstream/usage/user',
        'delphixpy/v1_6_2/web/jetstream/usage/container',
        'delphixpy/v1_6_2/web/jetstream/usage/bookmark',
        'delphixpy/v1_6_2/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_6_2/web/jetstream/usage/template',
        'delphixpy/v1_6_2/web/storage',
        'delphixpy/v1_6_2/web/storage/remove',
        'delphixpy/v1_6_2/web/storage/test',
        'delphixpy/v1_6_2/web/storage/device',
        'delphixpy/v1_6_2/web/storage/scrub',
        'delphixpy/v1_6_2/web/domain',
        'delphixpy/v1_6_2/web/analytics',
        'delphixpy/v1_6_2/web/analytics/statistic',
        'delphixpy/v1_6_2/web/snapshot',
        'delphixpy/v1_6_2/web/sourceconfig',
        'delphixpy/v1_6_2/web/sourceconfig/oracle',
        'delphixpy/v1_6_2/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_6_2/web/namespace',
        'delphixpy/v1_6_2/web/replication',
        'delphixpy/v1_6_2/web/replication/spec',
        'delphixpy/v1_6_2/web/replication/targetstate',
        'delphixpy/v1_6_2/web/replication/sourcestate',
        'delphixpy/v1_6_2/web/replication/serializationpoint',
        'delphixpy/v1_6_2/web/source',
        'delphixpy/v1_6_2/web/source/operationTemplate',
        'delphixpy/v1_6_2/web/service',
        'delphixpy/v1_6_2/web/service/smtp',
        'delphixpy/v1_6_2/web/service/ldap',
        'delphixpy/v1_6_2/web/service/ldap/server',
        'delphixpy/v1_6_2/web/service/snmp',
        'delphixpy/v1_6_2/web/service/snmp/manager',
        'delphixpy/v1_6_2/web/service/linkingsettings',
        'delphixpy/v1_6_2/web/service/phonehome',
        'delphixpy/v1_6_2/web/service/security',
        'delphixpy/v1_6_2/web/service/dns',
        'delphixpy/v1_6_2/web/service/schema',
        'delphixpy/v1_6_2/web/service/locale',
        'delphixpy/v1_6_2/web/service/proxy',
        'delphixpy/v1_6_2/web/service/certificate',
        'delphixpy/v1_6_2/web/service/time',
        'delphixpy/v1_6_2/web/service/syslog',
        'delphixpy/v1_6_2/web/service/support',
        'delphixpy/v1_6_2/web/service/support/access',
        'delphixpy/v1_6_2/web/service/support/bundle',
        'delphixpy/v1_6_2/web/system',
        'delphixpy/v1_6_2/web/system/version',
        'delphixpy/v1_6_2/web/network',
        'delphixpy/v1_6_2/web/network/route',
        'delphixpy/v1_6_2/web/network/test',
        'delphixpy/v1_6_2/web/network/test/latency',
        'delphixpy/v1_6_2/web/network/test/throughput',
        'delphixpy/v1_6_2/web/network/test/dsp',
        'delphixpy/v1_6_2/web/network/interface',
        'delphixpy/v1_6_2/web/session',
        'delphixpy/v1_4_1',
        'delphixpy/v1_4_1/web',
        'delphixpy/v1_4_1/web/authorization',
        'delphixpy/v1_4_1/web/permission',
        'delphixpy/v1_4_1/web/role',
        'delphixpy/v1_4_1/web/toolkit',
        'delphixpy/v1_4_1/web/environment',
        'delphixpy/v1_4_1/web/environment/user',
        'delphixpy/v1_4_1/web/environment/oracle',
        'delphixpy/v1_4_1/web/environment/oracle/listener',
        'delphixpy/v1_4_1/web/environment/oracle/clusternode',
        'delphixpy/v1_4_1/web/environment/windows',
        'delphixpy/v1_4_1/web/environment/windows/clusterinstance',
        'delphixpy/v1_4_1/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_4_1/web/environment/windows/clusternode',
        'delphixpy/v1_4_1/web/capacity',
        'delphixpy/v1_4_1/web/capacity/group',
        'delphixpy/v1_4_1/web/capacity/group/historical',
        'delphixpy/v1_4_1/web/capacity/consumer',
        'delphixpy/v1_4_1/web/capacity/consumer/historical',
        'delphixpy/v1_4_1/web/capacity/snapshot',
        'delphixpy/v1_4_1/web/capacity/system',
        'delphixpy/v1_4_1/web/capacity/system/historical',
        'delphixpy/v1_4_1/web/database',
        'delphixpy/v1_4_1/web/database/template',
        'delphixpy/v1_4_1/web/registration',
        'delphixpy/v1_4_1/web/registration/status',
        'delphixpy/v1_4_1/web/host',
        'delphixpy/v1_4_1/web/host/privilegeElevation',
        'delphixpy/v1_4_1/web/host/privilegeElevation/profile',
        'delphixpy/v1_4_1/web/data',
        'delphixpy/v1_4_1/web/repository',
        'delphixpy/v1_4_1/web/policy',
        'delphixpy/v1_4_1/web/user',
        'delphixpy/v1_4_1/web/alert',
        'delphixpy/v1_4_1/web/alert/profile',
        'delphixpy/v1_4_1/web/objects',
        'delphixpy/v1_4_1/web/fault',
        'delphixpy/v1_4_1/web/fault/effect',
        'delphixpy/v1_4_1/web/group',
        'delphixpy/v1_4_1/web/connectivity',
        'delphixpy/v1_4_1/web/notification',
        'delphixpy/v1_4_1/web/delphix',
        'delphixpy/v1_4_1/web/job',
        'delphixpy/v1_4_1/web/about',
        'delphixpy/v1_4_1/web/timeflow',
        'delphixpy/v1_4_1/web/timeflow/bookmark',
        'delphixpy/v1_4_1/web/action',
        'delphixpy/v1_4_1/web/jetstream',
        'delphixpy/v1_4_1/web/jetstream/branch',
        'delphixpy/v1_4_1/web/jetstream/capacity',
        'delphixpy/v1_4_1/web/jetstream/capacity/branch',
        'delphixpy/v1_4_1/web/jetstream/capacity/container',
        'delphixpy/v1_4_1/web/jetstream/capacity/bookmark',
        'delphixpy/v1_4_1/web/jetstream/capacity/bookmark/tag',
        'delphixpy/v1_4_1/web/jetstream/capacity/template',
        'delphixpy/v1_4_1/web/jetstream/preferences',
        'delphixpy/v1_4_1/web/jetstream/container',
        'delphixpy/v1_4_1/web/jetstream/usagedata',
        'delphixpy/v1_4_1/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_4_1/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_4_1/web/jetstream/bookmark',
        'delphixpy/v1_4_1/web/jetstream/datasource',
        'delphixpy/v1_4_1/web/jetstream/operation',
        'delphixpy/v1_4_1/web/jetstream/template',
        'delphixpy/v1_4_1/web/storage',
        'delphixpy/v1_4_1/web/storage/device',
        'delphixpy/v1_4_1/web/storage/scrub',
        'delphixpy/v1_4_1/web/domain',
        'delphixpy/v1_4_1/web/analytics',
        'delphixpy/v1_4_1/web/analytics/statistic',
        'delphixpy/v1_4_1/web/snapshot',
        'delphixpy/v1_4_1/web/sourceconfig',
        'delphixpy/v1_4_1/web/sourceconfig/oracle',
        'delphixpy/v1_4_1/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_4_1/web/namespace',
        'delphixpy/v1_4_1/web/replication',
        'delphixpy/v1_4_1/web/replication/spec',
        'delphixpy/v1_4_1/web/source',
        'delphixpy/v1_4_1/web/service',
        'delphixpy/v1_4_1/web/service/smtp',
        'delphixpy/v1_4_1/web/service/ldap',
        'delphixpy/v1_4_1/web/service/ldap/server',
        'delphixpy/v1_4_1/web/service/snmp',
        'delphixpy/v1_4_1/web/service/snmp/manager',
        'delphixpy/v1_4_1/web/service/linkingsettings',
        'delphixpy/v1_4_1/web/service/phonehome',
        'delphixpy/v1_4_1/web/service/security',
        'delphixpy/v1_4_1/web/service/dns',
        'delphixpy/v1_4_1/web/service/locale',
        'delphixpy/v1_4_1/web/service/proxy',
        'delphixpy/v1_4_1/web/service/certificate',
        'delphixpy/v1_4_1/web/service/time',
        'delphixpy/v1_4_1/web/service/syslog',
        'delphixpy/v1_4_1/web/service/support',
        'delphixpy/v1_4_1/web/service/support/access',
        'delphixpy/v1_4_1/web/service/support/bundle',
        'delphixpy/v1_4_1/web/system',
        'delphixpy/v1_4_1/web/system/version',
        'delphixpy/v1_4_1/web/network',
        'delphixpy/v1_4_1/web/network/route',
        'delphixpy/v1_4_1/web/network/test',
        'delphixpy/v1_4_1/web/network/test/latency',
        'delphixpy/v1_4_1/web/network/test/throughput',
        'delphixpy/v1_4_1/web/network/interface',
        'delphixpy/v1_4_1/web/session',
        'delphixpy/v1_11_10',
        'delphixpy/v1_11_10/web',
        'delphixpy/v1_11_10/web/authorization',
        'delphixpy/v1_11_10/web/authorization/configuration',
        'delphixpy/v1_11_10/web/permission',
        'delphixpy/v1_11_10/web/passwordPolicy',
        'delphixpy/v1_11_10/web/role',
        'delphixpy/v1_11_10/web/toolkit',
        'delphixpy/v1_11_10/web/environment',
        'delphixpy/v1_11_10/web/environment/user',
        'delphixpy/v1_11_10/web/environment/oracle',
        'delphixpy/v1_11_10/web/environment/oracle/listener',
        'delphixpy/v1_11_10/web/environment/oracle/clusternode',
        'delphixpy/v1_11_10/web/environment/windows',
        'delphixpy/v1_11_10/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_10/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_10/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_10/web/environment/windows/clusternode',
        'delphixpy/v1_11_10/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_10/web/capacity',
        'delphixpy/v1_11_10/web/capacity/heldspace',
        'delphixpy/v1_11_10/web/capacity/group',
        'delphixpy/v1_11_10/web/capacity/group/historical',
        'delphixpy/v1_11_10/web/capacity/consumer',
        'delphixpy/v1_11_10/web/capacity/consumer/historical',
        'delphixpy/v1_11_10/web/capacity/snapshot',
        'delphixpy/v1_11_10/web/capacity/system',
        'delphixpy/v1_11_10/web/capacity/system/historical',
        'delphixpy/v1_11_10/web/database',
        'delphixpy/v1_11_10/web/database/performanceHistory',
        'delphixpy/v1_11_10/web/database/template',
        'delphixpy/v1_11_10/web/registration',
        'delphixpy/v1_11_10/web/registration/status',
        'delphixpy/v1_11_10/web/host',
        'delphixpy/v1_11_10/web/host/privilegeElevation',
        'delphixpy/v1_11_10/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_10/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_10/web/theme',
        'delphixpy/v1_11_10/web/data',
        'delphixpy/v1_11_10/web/transformation',
        'delphixpy/v1_11_10/web/repository',
        'delphixpy/v1_11_10/web/repository/template',
        'delphixpy/v1_11_10/web/policy',
        'delphixpy/v1_11_10/web/user',
        'delphixpy/v1_11_10/web/alert',
        'delphixpy/v1_11_10/web/alert/profile',
        'delphixpy/v1_11_10/web/objects',
        'delphixpy/v1_11_10/web/maskingjob',
        'delphixpy/v1_11_10/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_10/web/timezone',
        'delphixpy/v1_11_10/web/fault',
        'delphixpy/v1_11_10/web/fault/effect',
        'delphixpy/v1_11_10/web/group',
        'delphixpy/v1_11_10/web/license',
        'delphixpy/v1_11_10/web/connectivity',
        'delphixpy/v1_11_10/web/notification',
        'delphixpy/v1_11_10/web/delphix',
        'delphixpy/v1_11_10/web/job',
        'delphixpy/v1_11_10/web/usage',
        'delphixpy/v1_11_10/web/about',
        'delphixpy/v1_11_10/web/timeflow',
        'delphixpy/v1_11_10/web/timeflow/bookmark',
        'delphixpy/v1_11_10/web/timeflow/oracle',
        'delphixpy/v1_11_10/web/timeflow/oracle/log',
        'delphixpy/v1_11_10/web/action',
        'delphixpy/v1_11_10/web/storage',
        'delphixpy/v1_11_10/web/storage/objectStorage',
        'delphixpy/v1_11_10/web/storage/remove',
        'delphixpy/v1_11_10/web/storage/iscsi',
        'delphixpy/v1_11_10/web/storage/iscsi/target',
        'delphixpy/v1_11_10/web/storage/iscsi/initiator',
        'delphixpy/v1_11_10/web/storage/test',
        'delphixpy/v1_11_10/web/storage/device',
        'delphixpy/v1_11_10/web/storage/scrub',
        'delphixpy/v1_11_10/web/domain',
        'delphixpy/v1_11_10/web/analytics',
        'delphixpy/v1_11_10/web/analytics/statistic',
        'delphixpy/v1_11_10/web/selfservice',
        'delphixpy/v1_11_10/web/selfservice/branch',
        'delphixpy/v1_11_10/web/selfservice/container',
        'delphixpy/v1_11_10/web/selfservice/usagedata',
        'delphixpy/v1_11_10/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_10/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_10/web/selfservice/bookmark',
        'delphixpy/v1_11_10/web/selfservice/datasource',
        'delphixpy/v1_11_10/web/selfservice/operation',
        'delphixpy/v1_11_10/web/selfservice/template',
        'delphixpy/v1_11_10/web/selfservice/usage',
        'delphixpy/v1_11_10/web/selfservice/usage/branch',
        'delphixpy/v1_11_10/web/selfservice/usage/user',
        'delphixpy/v1_11_10/web/selfservice/usage/container',
        'delphixpy/v1_11_10/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_10/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_10/web/selfservice/usage/template',
        'delphixpy/v1_11_10/web/selfservice/config',
        'delphixpy/v1_11_10/web/snapshot',
        'delphixpy/v1_11_10/web/sourceconfig',
        'delphixpy/v1_11_10/web/namespace',
        'delphixpy/v1_11_10/web/replication',
        'delphixpy/v1_11_10/web/replication/spec',
        'delphixpy/v1_11_10/web/replication/targetstate',
        'delphixpy/v1_11_10/web/replication/sourcestate',
        'delphixpy/v1_11_10/web/replication/serializationpoint',
        'delphixpy/v1_11_10/web/source',
        'delphixpy/v1_11_10/web/source/operationTemplate',
        'delphixpy/v1_11_10/web/service',
        'delphixpy/v1_11_10/web/service/smtp',
        'delphixpy/v1_11_10/web/service/ldap',
        'delphixpy/v1_11_10/web/service/ldap/server',
        'delphixpy/v1_11_10/web/service/nfs',
        'delphixpy/v1_11_10/web/service/host',
        'delphixpy/v1_11_10/web/service/host/address',
        'delphixpy/v1_11_10/web/service/snmp',
        'delphixpy/v1_11_10/web/service/snmp/v3',
        'delphixpy/v1_11_10/web/service/snmp/v3/manager',
        'delphixpy/v1_11_10/web/service/snmp/v3/usm',
        'delphixpy/v1_11_10/web/service/snmp/v2',
        'delphixpy/v1_11_10/web/service/snmp/v2/manager',
        'delphixpy/v1_11_10/web/service/userInterface',
        'delphixpy/v1_11_10/web/service/linkingsettings',
        'delphixpy/v1_11_10/web/service/phonehome',
        'delphixpy/v1_11_10/web/service/httpConnector',
        'delphixpy/v1_11_10/web/service/userPaths',
        'delphixpy/v1_11_10/web/service/security',
        'delphixpy/v1_11_10/web/service/dns',
        'delphixpy/v1_11_10/web/service/kerberos',
        'delphixpy/v1_11_10/web/service/schema',
        'delphixpy/v1_11_10/web/service/tls',
        'delphixpy/v1_11_10/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_10/web/service/tls/csr',
        'delphixpy/v1_11_10/web/service/tls/cipherSuite',
        'delphixpy/v1_11_10/web/service/tls/caCertificate',
        'delphixpy/v1_11_10/web/service/insight',
        'delphixpy/v1_11_10/web/service/insight/splunkHec',
        'delphixpy/v1_11_10/web/service/locale',
        'delphixpy/v1_11_10/web/service/cloud',
        'delphixpy/v1_11_10/web/service/proxy',
        'delphixpy/v1_11_10/web/service/time',
        'delphixpy/v1_11_10/web/service/syslog',
        'delphixpy/v1_11_10/web/service/support',
        'delphixpy/v1_11_10/web/service/support/access',
        'delphixpy/v1_11_10/web/service/support/bundle',
        'delphixpy/v1_11_10/web/service/minimalPhonehome',
        'delphixpy/v1_11_10/web/service/passwordVault',
        'delphixpy/v1_11_10/web/service/sso',
        'delphixpy/v1_11_10/web/system',
        'delphixpy/v1_11_10/web/system/verification',
        'delphixpy/v1_11_10/web/system/verification/reports',
        'delphixpy/v1_11_10/web/system/verification/reports/steps',
        'delphixpy/v1_11_10/web/system/advancedSettings',
        'delphixpy/v1_11_10/web/system/upgradeCheckResult',
        'delphixpy/v1_11_10/web/system/status',
        'delphixpy/v1_11_10/web/system/version',
        'delphixpy/v1_11_10/web/system/package',
        'delphixpy/v1_11_10/web/network',
        'delphixpy/v1_11_10/web/network/route',
        'delphixpy/v1_11_10/web/network/test',
        'delphixpy/v1_11_10/web/network/test/latency',
        'delphixpy/v1_11_10/web/network/test/throughput',
        'delphixpy/v1_11_10/web/network/test/dsp',
        'delphixpy/v1_11_10/web/network/interface',
        'delphixpy/v1_11_10/web/network/dsp',
        'delphixpy/v1_11_10/web/network/dsp/autotune',
        'delphixpy/v1_11_10/web/session',
        'delphixpy/v1_11_16',
        'delphixpy/v1_11_16/web',
        'delphixpy/v1_11_16/web/authorization',
        'delphixpy/v1_11_16/web/authorization/configuration',
        'delphixpy/v1_11_16/web/permission',
        'delphixpy/v1_11_16/web/passwordPolicy',
        'delphixpy/v1_11_16/web/role',
        'delphixpy/v1_11_16/web/toolkit',
        'delphixpy/v1_11_16/web/environment',
        'delphixpy/v1_11_16/web/environment/user',
        'delphixpy/v1_11_16/web/environment/oracle',
        'delphixpy/v1_11_16/web/environment/oracle/listener',
        'delphixpy/v1_11_16/web/environment/oracle/clusternode',
        'delphixpy/v1_11_16/web/environment/windows',
        'delphixpy/v1_11_16/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_16/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_16/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_16/web/environment/windows/clusternode',
        'delphixpy/v1_11_16/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_16/web/capacity',
        'delphixpy/v1_11_16/web/capacity/heldspace',
        'delphixpy/v1_11_16/web/capacity/group',
        'delphixpy/v1_11_16/web/capacity/group/historical',
        'delphixpy/v1_11_16/web/capacity/consumer',
        'delphixpy/v1_11_16/web/capacity/consumer/historical',
        'delphixpy/v1_11_16/web/capacity/snapshot',
        'delphixpy/v1_11_16/web/capacity/system',
        'delphixpy/v1_11_16/web/capacity/system/historical',
        'delphixpy/v1_11_16/web/database',
        'delphixpy/v1_11_16/web/database/performanceHistory',
        'delphixpy/v1_11_16/web/database/template',
        'delphixpy/v1_11_16/web/registration',
        'delphixpy/v1_11_16/web/registration/status',
        'delphixpy/v1_11_16/web/host',
        'delphixpy/v1_11_16/web/host/privilegeElevation',
        'delphixpy/v1_11_16/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_16/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_16/web/theme',
        'delphixpy/v1_11_16/web/osadmin',
        'delphixpy/v1_11_16/web/osadmin/engineStatus',
        'delphixpy/v1_11_16/web/data',
        'delphixpy/v1_11_16/web/transformation',
        'delphixpy/v1_11_16/web/repository',
        'delphixpy/v1_11_16/web/repository/template',
        'delphixpy/v1_11_16/web/policy',
        'delphixpy/v1_11_16/web/user',
        'delphixpy/v1_11_16/web/alert',
        'delphixpy/v1_11_16/web/alert/profile',
        'delphixpy/v1_11_16/web/objects',
        'delphixpy/v1_11_16/web/maskingjob',
        'delphixpy/v1_11_16/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_16/web/timezone',
        'delphixpy/v1_11_16/web/fault',
        'delphixpy/v1_11_16/web/fault/effect',
        'delphixpy/v1_11_16/web/group',
        'delphixpy/v1_11_16/web/license',
        'delphixpy/v1_11_16/web/connectivity',
        'delphixpy/v1_11_16/web/notification',
        'delphixpy/v1_11_16/web/delphix',
        'delphixpy/v1_11_16/web/job',
        'delphixpy/v1_11_16/web/usage',
        'delphixpy/v1_11_16/web/about',
        'delphixpy/v1_11_16/web/timeflow',
        'delphixpy/v1_11_16/web/timeflow/bookmark',
        'delphixpy/v1_11_16/web/timeflow/oracle',
        'delphixpy/v1_11_16/web/timeflow/oracle/log',
        'delphixpy/v1_11_16/web/action',
        'delphixpy/v1_11_16/web/storage',
        'delphixpy/v1_11_16/web/storage/objectStorage',
        'delphixpy/v1_11_16/web/storage/remove',
        'delphixpy/v1_11_16/web/storage/iscsi',
        'delphixpy/v1_11_16/web/storage/iscsi/target',
        'delphixpy/v1_11_16/web/storage/iscsi/initiator',
        'delphixpy/v1_11_16/web/storage/test',
        'delphixpy/v1_11_16/web/storage/device',
        'delphixpy/v1_11_16/web/storage/scrub',
        'delphixpy/v1_11_16/web/domain',
        'delphixpy/v1_11_16/web/analytics',
        'delphixpy/v1_11_16/web/analytics/statistic',
        'delphixpy/v1_11_16/web/selfservice',
        'delphixpy/v1_11_16/web/selfservice/branch',
        'delphixpy/v1_11_16/web/selfservice/container',
        'delphixpy/v1_11_16/web/selfservice/usagedata',
        'delphixpy/v1_11_16/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_16/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_16/web/selfservice/bookmark',
        'delphixpy/v1_11_16/web/selfservice/datasource',
        'delphixpy/v1_11_16/web/selfservice/operation',
        'delphixpy/v1_11_16/web/selfservice/template',
        'delphixpy/v1_11_16/web/selfservice/usage',
        'delphixpy/v1_11_16/web/selfservice/usage/branch',
        'delphixpy/v1_11_16/web/selfservice/usage/user',
        'delphixpy/v1_11_16/web/selfservice/usage/container',
        'delphixpy/v1_11_16/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_16/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_16/web/selfservice/usage/template',
        'delphixpy/v1_11_16/web/selfservice/config',
        'delphixpy/v1_11_16/web/snapshot',
        'delphixpy/v1_11_16/web/sourceconfig',
        'delphixpy/v1_11_16/web/namespace',
        'delphixpy/v1_11_16/web/replication',
        'delphixpy/v1_11_16/web/replication/spec',
        'delphixpy/v1_11_16/web/replication/targetstate',
        'delphixpy/v1_11_16/web/replication/sourcestate',
        'delphixpy/v1_11_16/web/replication/serializationpoint',
        'delphixpy/v1_11_16/web/source',
        'delphixpy/v1_11_16/web/source/operationTemplate',
        'delphixpy/v1_11_16/web/service',
        'delphixpy/v1_11_16/web/service/smtp',
        'delphixpy/v1_11_16/web/service/ldap',
        'delphixpy/v1_11_16/web/service/ldap/server',
        'delphixpy/v1_11_16/web/service/nfs',
        'delphixpy/v1_11_16/web/service/host',
        'delphixpy/v1_11_16/web/service/host/address',
        'delphixpy/v1_11_16/web/service/snmp',
        'delphixpy/v1_11_16/web/service/snmp/v3',
        'delphixpy/v1_11_16/web/service/snmp/v3/manager',
        'delphixpy/v1_11_16/web/service/snmp/v3/usm',
        'delphixpy/v1_11_16/web/service/snmp/v2',
        'delphixpy/v1_11_16/web/service/snmp/v2/manager',
        'delphixpy/v1_11_16/web/service/userInterface',
        'delphixpy/v1_11_16/web/service/linkingsettings',
        'delphixpy/v1_11_16/web/service/phonehome',
        'delphixpy/v1_11_16/web/service/fluentd',
        'delphixpy/v1_11_16/web/service/fluentd/plugins',
        'delphixpy/v1_11_16/web/service/fluentd/configuration',
        'delphixpy/v1_11_16/web/service/httpConnector',
        'delphixpy/v1_11_16/web/service/userPaths',
        'delphixpy/v1_11_16/web/service/security',
        'delphixpy/v1_11_16/web/service/dns',
        'delphixpy/v1_11_16/web/service/kerberos',
        'delphixpy/v1_11_16/web/service/schema',
        'delphixpy/v1_11_16/web/service/tls',
        'delphixpy/v1_11_16/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_16/web/service/tls/csr',
        'delphixpy/v1_11_16/web/service/tls/cipherSuite',
        'delphixpy/v1_11_16/web/service/tls/caCertificate',
        'delphixpy/v1_11_16/web/service/insight',
        'delphixpy/v1_11_16/web/service/insight/splunkHec',
        'delphixpy/v1_11_16/web/service/locale',
        'delphixpy/v1_11_16/web/service/cloud',
        'delphixpy/v1_11_16/web/service/proxy',
        'delphixpy/v1_11_16/web/service/time',
        'delphixpy/v1_11_16/web/service/syslog',
        'delphixpy/v1_11_16/web/service/passwordReset',
        'delphixpy/v1_11_16/web/service/support',
        'delphixpy/v1_11_16/web/service/support/access',
        'delphixpy/v1_11_16/web/service/support/bundle',
        'delphixpy/v1_11_16/web/service/minimalPhonehome',
        'delphixpy/v1_11_16/web/service/passwordVault',
        'delphixpy/v1_11_16/web/service/oauth2',
        'delphixpy/v1_11_16/web/service/sso',
        'delphixpy/v1_11_16/web/system',
        'delphixpy/v1_11_16/web/system/verification',
        'delphixpy/v1_11_16/web/system/verification/reports',
        'delphixpy/v1_11_16/web/system/verification/reports/steps',
        'delphixpy/v1_11_16/web/system/advancedSettings',
        'delphixpy/v1_11_16/web/system/upgradeCheckResult',
        'delphixpy/v1_11_16/web/system/status',
        'delphixpy/v1_11_16/web/system/version',
        'delphixpy/v1_11_16/web/system/package',
        'delphixpy/v1_11_16/web/network',
        'delphixpy/v1_11_16/web/network/route',
        'delphixpy/v1_11_16/web/network/test',
        'delphixpy/v1_11_16/web/network/test/latency',
        'delphixpy/v1_11_16/web/network/test/throughput',
        'delphixpy/v1_11_16/web/network/test/dsp',
        'delphixpy/v1_11_16/web/network/interface',
        'delphixpy/v1_11_16/web/network/dsp',
        'delphixpy/v1_11_16/web/network/dsp/autotune',
        'delphixpy/v1_11_16/web/session',
        'delphixpy/v1_11_16/web/netty',
        'delphixpy/v1_4_2',
        'delphixpy/v1_4_2/web',
        'delphixpy/v1_4_2/web/authorization',
        'delphixpy/v1_4_2/web/permission',
        'delphixpy/v1_4_2/web/role',
        'delphixpy/v1_4_2/web/toolkit',
        'delphixpy/v1_4_2/web/environment',
        'delphixpy/v1_4_2/web/environment/user',
        'delphixpy/v1_4_2/web/environment/oracle',
        'delphixpy/v1_4_2/web/environment/oracle/listener',
        'delphixpy/v1_4_2/web/environment/oracle/clusternode',
        'delphixpy/v1_4_2/web/environment/windows',
        'delphixpy/v1_4_2/web/environment/windows/clusterinstance',
        'delphixpy/v1_4_2/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_4_2/web/environment/windows/clusternode',
        'delphixpy/v1_4_2/web/capacity',
        'delphixpy/v1_4_2/web/capacity/group',
        'delphixpy/v1_4_2/web/capacity/group/historical',
        'delphixpy/v1_4_2/web/capacity/consumer',
        'delphixpy/v1_4_2/web/capacity/consumer/historical',
        'delphixpy/v1_4_2/web/capacity/snapshot',
        'delphixpy/v1_4_2/web/capacity/system',
        'delphixpy/v1_4_2/web/capacity/system/historical',
        'delphixpy/v1_4_2/web/database',
        'delphixpy/v1_4_2/web/database/template',
        'delphixpy/v1_4_2/web/registration',
        'delphixpy/v1_4_2/web/registration/status',
        'delphixpy/v1_4_2/web/host',
        'delphixpy/v1_4_2/web/host/privilegeElevation',
        'delphixpy/v1_4_2/web/host/privilegeElevation/profile',
        'delphixpy/v1_4_2/web/data',
        'delphixpy/v1_4_2/web/repository',
        'delphixpy/v1_4_2/web/policy',
        'delphixpy/v1_4_2/web/user',
        'delphixpy/v1_4_2/web/alert',
        'delphixpy/v1_4_2/web/alert/profile',
        'delphixpy/v1_4_2/web/objects',
        'delphixpy/v1_4_2/web/fault',
        'delphixpy/v1_4_2/web/fault/effect',
        'delphixpy/v1_4_2/web/group',
        'delphixpy/v1_4_2/web/connectivity',
        'delphixpy/v1_4_2/web/notification',
        'delphixpy/v1_4_2/web/delphix',
        'delphixpy/v1_4_2/web/job',
        'delphixpy/v1_4_2/web/about',
        'delphixpy/v1_4_2/web/timeflow',
        'delphixpy/v1_4_2/web/timeflow/bookmark',
        'delphixpy/v1_4_2/web/action',
        'delphixpy/v1_4_2/web/jetstream',
        'delphixpy/v1_4_2/web/jetstream/branch',
        'delphixpy/v1_4_2/web/jetstream/capacity',
        'delphixpy/v1_4_2/web/jetstream/capacity/branch',
        'delphixpy/v1_4_2/web/jetstream/capacity/container',
        'delphixpy/v1_4_2/web/jetstream/capacity/bookmark',
        'delphixpy/v1_4_2/web/jetstream/capacity/bookmark/tag',
        'delphixpy/v1_4_2/web/jetstream/capacity/template',
        'delphixpy/v1_4_2/web/jetstream/preferences',
        'delphixpy/v1_4_2/web/jetstream/container',
        'delphixpy/v1_4_2/web/jetstream/usagedata',
        'delphixpy/v1_4_2/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_4_2/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_4_2/web/jetstream/bookmark',
        'delphixpy/v1_4_2/web/jetstream/datasource',
        'delphixpy/v1_4_2/web/jetstream/operation',
        'delphixpy/v1_4_2/web/jetstream/template',
        'delphixpy/v1_4_2/web/storage',
        'delphixpy/v1_4_2/web/storage/device',
        'delphixpy/v1_4_2/web/storage/scrub',
        'delphixpy/v1_4_2/web/domain',
        'delphixpy/v1_4_2/web/analytics',
        'delphixpy/v1_4_2/web/analytics/statistic',
        'delphixpy/v1_4_2/web/snapshot',
        'delphixpy/v1_4_2/web/sourceconfig',
        'delphixpy/v1_4_2/web/sourceconfig/oracle',
        'delphixpy/v1_4_2/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_4_2/web/namespace',
        'delphixpy/v1_4_2/web/replication',
        'delphixpy/v1_4_2/web/replication/spec',
        'delphixpy/v1_4_2/web/source',
        'delphixpy/v1_4_2/web/service',
        'delphixpy/v1_4_2/web/service/smtp',
        'delphixpy/v1_4_2/web/service/ldap',
        'delphixpy/v1_4_2/web/service/ldap/server',
        'delphixpy/v1_4_2/web/service/snmp',
        'delphixpy/v1_4_2/web/service/snmp/manager',
        'delphixpy/v1_4_2/web/service/linkingsettings',
        'delphixpy/v1_4_2/web/service/phonehome',
        'delphixpy/v1_4_2/web/service/security',
        'delphixpy/v1_4_2/web/service/dns',
        'delphixpy/v1_4_2/web/service/locale',
        'delphixpy/v1_4_2/web/service/proxy',
        'delphixpy/v1_4_2/web/service/certificate',
        'delphixpy/v1_4_2/web/service/time',
        'delphixpy/v1_4_2/web/service/syslog',
        'delphixpy/v1_4_2/web/service/support',
        'delphixpy/v1_4_2/web/service/support/access',
        'delphixpy/v1_4_2/web/service/support/bundle',
        'delphixpy/v1_4_2/web/system',
        'delphixpy/v1_4_2/web/system/version',
        'delphixpy/v1_4_2/web/network',
        'delphixpy/v1_4_2/web/network/route',
        'delphixpy/v1_4_2/web/network/test',
        'delphixpy/v1_4_2/web/network/test/latency',
        'delphixpy/v1_4_2/web/network/test/throughput',
        'delphixpy/v1_4_2/web/network/interface',
        'delphixpy/v1_4_2/web/session',
        'delphixpy/v1_6_1',
        'delphixpy/v1_6_1/web',
        'delphixpy/v1_6_1/web/authorization',
        'delphixpy/v1_6_1/web/permission',
        'delphixpy/v1_6_1/web/role',
        'delphixpy/v1_6_1/web/toolkit',
        'delphixpy/v1_6_1/web/environment',
        'delphixpy/v1_6_1/web/environment/user',
        'delphixpy/v1_6_1/web/environment/oracle',
        'delphixpy/v1_6_1/web/environment/oracle/listener',
        'delphixpy/v1_6_1/web/environment/oracle/clusternode',
        'delphixpy/v1_6_1/web/environment/windows',
        'delphixpy/v1_6_1/web/environment/windows/clusterinstance',
        'delphixpy/v1_6_1/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_6_1/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_6_1/web/environment/windows/clusternode',
        'delphixpy/v1_6_1/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_6_1/web/capacity',
        'delphixpy/v1_6_1/web/capacity/group',
        'delphixpy/v1_6_1/web/capacity/group/historical',
        'delphixpy/v1_6_1/web/capacity/consumer',
        'delphixpy/v1_6_1/web/capacity/consumer/historical',
        'delphixpy/v1_6_1/web/capacity/snapshot',
        'delphixpy/v1_6_1/web/capacity/system',
        'delphixpy/v1_6_1/web/capacity/system/historical',
        'delphixpy/v1_6_1/web/database',
        'delphixpy/v1_6_1/web/database/template',
        'delphixpy/v1_6_1/web/registration',
        'delphixpy/v1_6_1/web/registration/status',
        'delphixpy/v1_6_1/web/host',
        'delphixpy/v1_6_1/web/host/privilegeElevation',
        'delphixpy/v1_6_1/web/host/privilegeElevation/profile',
        'delphixpy/v1_6_1/web/data',
        'delphixpy/v1_6_1/web/repository',
        'delphixpy/v1_6_1/web/repository/template',
        'delphixpy/v1_6_1/web/policy',
        'delphixpy/v1_6_1/web/user',
        'delphixpy/v1_6_1/web/alert',
        'delphixpy/v1_6_1/web/alert/profile',
        'delphixpy/v1_6_1/web/objects',
        'delphixpy/v1_6_1/web/fault',
        'delphixpy/v1_6_1/web/fault/effect',
        'delphixpy/v1_6_1/web/group',
        'delphixpy/v1_6_1/web/connectivity',
        'delphixpy/v1_6_1/web/notification',
        'delphixpy/v1_6_1/web/delphix',
        'delphixpy/v1_6_1/web/job',
        'delphixpy/v1_6_1/web/about',
        'delphixpy/v1_6_1/web/timeflow',
        'delphixpy/v1_6_1/web/timeflow/bookmark',
        'delphixpy/v1_6_1/web/timeflow/oracle',
        'delphixpy/v1_6_1/web/timeflow/oracle/log',
        'delphixpy/v1_6_1/web/action',
        'delphixpy/v1_6_1/web/jetstream',
        'delphixpy/v1_6_1/web/jetstream/branch',
        'delphixpy/v1_6_1/web/jetstream/container',
        'delphixpy/v1_6_1/web/jetstream/usagedata',
        'delphixpy/v1_6_1/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_6_1/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_6_1/web/jetstream/bookmark',
        'delphixpy/v1_6_1/web/jetstream/datasource',
        'delphixpy/v1_6_1/web/jetstream/operation',
        'delphixpy/v1_6_1/web/jetstream/template',
        'delphixpy/v1_6_1/web/jetstream/usage',
        'delphixpy/v1_6_1/web/jetstream/usage/branch',
        'delphixpy/v1_6_1/web/jetstream/usage/user',
        'delphixpy/v1_6_1/web/jetstream/usage/container',
        'delphixpy/v1_6_1/web/jetstream/usage/bookmark',
        'delphixpy/v1_6_1/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_6_1/web/jetstream/usage/template',
        'delphixpy/v1_6_1/web/storage',
        'delphixpy/v1_6_1/web/storage/remove',
        'delphixpy/v1_6_1/web/storage/test',
        'delphixpy/v1_6_1/web/storage/device',
        'delphixpy/v1_6_1/web/storage/scrub',
        'delphixpy/v1_6_1/web/domain',
        'delphixpy/v1_6_1/web/analytics',
        'delphixpy/v1_6_1/web/analytics/statistic',
        'delphixpy/v1_6_1/web/snapshot',
        'delphixpy/v1_6_1/web/sourceconfig',
        'delphixpy/v1_6_1/web/sourceconfig/oracle',
        'delphixpy/v1_6_1/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_6_1/web/namespace',
        'delphixpy/v1_6_1/web/replication',
        'delphixpy/v1_6_1/web/replication/spec',
        'delphixpy/v1_6_1/web/replication/targetstate',
        'delphixpy/v1_6_1/web/replication/sourcestate',
        'delphixpy/v1_6_1/web/replication/serializationpoint',
        'delphixpy/v1_6_1/web/source',
        'delphixpy/v1_6_1/web/source/operationTemplate',
        'delphixpy/v1_6_1/web/service',
        'delphixpy/v1_6_1/web/service/smtp',
        'delphixpy/v1_6_1/web/service/ldap',
        'delphixpy/v1_6_1/web/service/ldap/server',
        'delphixpy/v1_6_1/web/service/snmp',
        'delphixpy/v1_6_1/web/service/snmp/manager',
        'delphixpy/v1_6_1/web/service/linkingsettings',
        'delphixpy/v1_6_1/web/service/phonehome',
        'delphixpy/v1_6_1/web/service/security',
        'delphixpy/v1_6_1/web/service/dns',
        'delphixpy/v1_6_1/web/service/schema',
        'delphixpy/v1_6_1/web/service/locale',
        'delphixpy/v1_6_1/web/service/proxy',
        'delphixpy/v1_6_1/web/service/certificate',
        'delphixpy/v1_6_1/web/service/time',
        'delphixpy/v1_6_1/web/service/syslog',
        'delphixpy/v1_6_1/web/service/support',
        'delphixpy/v1_6_1/web/service/support/access',
        'delphixpy/v1_6_1/web/service/support/bundle',
        'delphixpy/v1_6_1/web/system',
        'delphixpy/v1_6_1/web/system/version',
        'delphixpy/v1_6_1/web/network',
        'delphixpy/v1_6_1/web/network/route',
        'delphixpy/v1_6_1/web/network/test',
        'delphixpy/v1_6_1/web/network/test/latency',
        'delphixpy/v1_6_1/web/network/test/throughput',
        'delphixpy/v1_6_1/web/network/test/dsp',
        'delphixpy/v1_6_1/web/network/interface',
        'delphixpy/v1_6_1/web/session',
        'delphixpy/v1_11_19',
        'delphixpy/v1_11_19/web',
        'delphixpy/v1_11_19/web/authorization',
        'delphixpy/v1_11_19/web/authorization/configuration',
        'delphixpy/v1_11_19/web/permission',
        'delphixpy/v1_11_19/web/passwordPolicy',
        'delphixpy/v1_11_19/web/role',
        'delphixpy/v1_11_19/web/toolkit',
        'delphixpy/v1_11_19/web/environment',
        'delphixpy/v1_11_19/web/environment/user',
        'delphixpy/v1_11_19/web/environment/oracle',
        'delphixpy/v1_11_19/web/environment/oracle/listener',
        'delphixpy/v1_11_19/web/environment/oracle/clusternode',
        'delphixpy/v1_11_19/web/environment/windows',
        'delphixpy/v1_11_19/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_19/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_19/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_19/web/environment/windows/clusternode',
        'delphixpy/v1_11_19/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_19/web/capacity',
        'delphixpy/v1_11_19/web/capacity/heldspace',
        'delphixpy/v1_11_19/web/capacity/group',
        'delphixpy/v1_11_19/web/capacity/group/historical',
        'delphixpy/v1_11_19/web/capacity/consumer',
        'delphixpy/v1_11_19/web/capacity/consumer/historical',
        'delphixpy/v1_11_19/web/capacity/snapshot',
        'delphixpy/v1_11_19/web/capacity/system',
        'delphixpy/v1_11_19/web/capacity/system/historical',
        'delphixpy/v1_11_19/web/database',
        'delphixpy/v1_11_19/web/database/performanceHistory',
        'delphixpy/v1_11_19/web/database/template',
        'delphixpy/v1_11_19/web/registration',
        'delphixpy/v1_11_19/web/registration/status',
        'delphixpy/v1_11_19/web/host',
        'delphixpy/v1_11_19/web/host/privilegeElevation',
        'delphixpy/v1_11_19/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_19/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_19/web/theme',
        'delphixpy/v1_11_19/web/repave',
        'delphixpy/v1_11_19/web/osadmin',
        'delphixpy/v1_11_19/web/osadmin/engineStatus',
        'delphixpy/v1_11_19/web/data',
        'delphixpy/v1_11_19/web/transformation',
        'delphixpy/v1_11_19/web/repository',
        'delphixpy/v1_11_19/web/repository/template',
        'delphixpy/v1_11_19/web/policy',
        'delphixpy/v1_11_19/web/user',
        'delphixpy/v1_11_19/web/alert',
        'delphixpy/v1_11_19/web/alert/profile',
        'delphixpy/v1_11_19/web/objects',
        'delphixpy/v1_11_19/web/maskingjob',
        'delphixpy/v1_11_19/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_19/web/timezone',
        'delphixpy/v1_11_19/web/fault',
        'delphixpy/v1_11_19/web/fault/effect',
        'delphixpy/v1_11_19/web/group',
        'delphixpy/v1_11_19/web/license',
        'delphixpy/v1_11_19/web/connectivity',
        'delphixpy/v1_11_19/web/notification',
        'delphixpy/v1_11_19/web/delphix',
        'delphixpy/v1_11_19/web/job',
        'delphixpy/v1_11_19/web/job/retention',
        'delphixpy/v1_11_19/web/usage',
        'delphixpy/v1_11_19/web/about',
        'delphixpy/v1_11_19/web/timeflow',
        'delphixpy/v1_11_19/web/timeflow/bookmark',
        'delphixpy/v1_11_19/web/timeflow/oracle',
        'delphixpy/v1_11_19/web/timeflow/oracle/log',
        'delphixpy/v1_11_19/web/action',
        'delphixpy/v1_11_19/web/storage',
        'delphixpy/v1_11_19/web/storage/objectStorage',
        'delphixpy/v1_11_19/web/storage/remove',
        'delphixpy/v1_11_19/web/storage/iscsi',
        'delphixpy/v1_11_19/web/storage/iscsi/target',
        'delphixpy/v1_11_19/web/storage/iscsi/initiator',
        'delphixpy/v1_11_19/web/storage/test',
        'delphixpy/v1_11_19/web/storage/device',
        'delphixpy/v1_11_19/web/storage/scrub',
        'delphixpy/v1_11_19/web/domain',
        'delphixpy/v1_11_19/web/analytics',
        'delphixpy/v1_11_19/web/analytics/statistic',
        'delphixpy/v1_11_19/web/selfservice',
        'delphixpy/v1_11_19/web/selfservice/branch',
        'delphixpy/v1_11_19/web/selfservice/container',
        'delphixpy/v1_11_19/web/selfservice/usagedata',
        'delphixpy/v1_11_19/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_19/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_19/web/selfservice/bookmark',
        'delphixpy/v1_11_19/web/selfservice/datasource',
        'delphixpy/v1_11_19/web/selfservice/operation',
        'delphixpy/v1_11_19/web/selfservice/template',
        'delphixpy/v1_11_19/web/selfservice/usage',
        'delphixpy/v1_11_19/web/selfservice/usage/branch',
        'delphixpy/v1_11_19/web/selfservice/usage/user',
        'delphixpy/v1_11_19/web/selfservice/usage/container',
        'delphixpy/v1_11_19/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_19/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_19/web/selfservice/usage/template',
        'delphixpy/v1_11_19/web/selfservice/config',
        'delphixpy/v1_11_19/web/snapshot',
        'delphixpy/v1_11_19/web/sourceconfig',
        'delphixpy/v1_11_19/web/namespace',
        'delphixpy/v1_11_19/web/replication',
        'delphixpy/v1_11_19/web/replication/spec',
        'delphixpy/v1_11_19/web/replication/targetstate',
        'delphixpy/v1_11_19/web/replication/sourcestate',
        'delphixpy/v1_11_19/web/replication/serializationpoint',
        'delphixpy/v1_11_19/web/source',
        'delphixpy/v1_11_19/web/source/operationTemplate',
        'delphixpy/v1_11_19/web/service',
        'delphixpy/v1_11_19/web/service/smtp',
        'delphixpy/v1_11_19/web/service/ldap',
        'delphixpy/v1_11_19/web/service/ldap/server',
        'delphixpy/v1_11_19/web/service/nfs',
        'delphixpy/v1_11_19/web/service/host',
        'delphixpy/v1_11_19/web/service/host/address',
        'delphixpy/v1_11_19/web/service/snmp',
        'delphixpy/v1_11_19/web/service/snmp/v3',
        'delphixpy/v1_11_19/web/service/snmp/v3/manager',
        'delphixpy/v1_11_19/web/service/snmp/v3/usm',
        'delphixpy/v1_11_19/web/service/snmp/v2',
        'delphixpy/v1_11_19/web/service/snmp/v2/manager',
        'delphixpy/v1_11_19/web/service/userInterface',
        'delphixpy/v1_11_19/web/service/linkingsettings',
        'delphixpy/v1_11_19/web/service/phonehome',
        'delphixpy/v1_11_19/web/service/events',
        'delphixpy/v1_11_19/web/service/fluentd',
        'delphixpy/v1_11_19/web/service/fluentd/plugins',
        'delphixpy/v1_11_19/web/service/fluentd/configuration',
        'delphixpy/v1_11_19/web/service/httpConnector',
        'delphixpy/v1_11_19/web/service/userPaths',
        'delphixpy/v1_11_19/web/service/security',
        'delphixpy/v1_11_19/web/service/dns',
        'delphixpy/v1_11_19/web/service/kerberos',
        'delphixpy/v1_11_19/web/service/schema',
        'delphixpy/v1_11_19/web/service/tls',
        'delphixpy/v1_11_19/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_19/web/service/tls/csr',
        'delphixpy/v1_11_19/web/service/tls/cipherSuite',
        'delphixpy/v1_11_19/web/service/tls/caCertificate',
        'delphixpy/v1_11_19/web/service/insight',
        'delphixpy/v1_11_19/web/service/insight/splunkHec',
        'delphixpy/v1_11_19/web/service/locale',
        'delphixpy/v1_11_19/web/service/cloud',
        'delphixpy/v1_11_19/web/service/proxy',
        'delphixpy/v1_11_19/web/service/time',
        'delphixpy/v1_11_19/web/service/syslog',
        'delphixpy/v1_11_19/web/service/passwordReset',
        'delphixpy/v1_11_19/web/service/support',
        'delphixpy/v1_11_19/web/service/support/access',
        'delphixpy/v1_11_19/web/service/support/bundle',
        'delphixpy/v1_11_19/web/service/minimalPhonehome',
        'delphixpy/v1_11_19/web/service/passwordVault',
        'delphixpy/v1_11_19/web/service/oauth2',
        'delphixpy/v1_11_19/web/service/sso',
        'delphixpy/v1_11_19/web/system',
        'delphixpy/v1_11_19/web/system/verification',
        'delphixpy/v1_11_19/web/system/verification/reports',
        'delphixpy/v1_11_19/web/system/verification/reports/steps',
        'delphixpy/v1_11_19/web/system/advancedSettings',
        'delphixpy/v1_11_19/web/system/upgradeCheckResult',
        'delphixpy/v1_11_19/web/system/status',
        'delphixpy/v1_11_19/web/system/version',
        'delphixpy/v1_11_19/web/network',
        'delphixpy/v1_11_19/web/network/route',
        'delphixpy/v1_11_19/web/network/test',
        'delphixpy/v1_11_19/web/network/test/latency',
        'delphixpy/v1_11_19/web/network/test/throughput',
        'delphixpy/v1_11_19/web/network/test/dsp',
        'delphixpy/v1_11_19/web/network/interface',
        'delphixpy/v1_11_19/web/network/dsp',
        'delphixpy/v1_11_19/web/network/dsp/autotune',
        'delphixpy/v1_11_19/web/session',
        'delphixpy/v1_5_1',
        'delphixpy/v1_5_1/web',
        'delphixpy/v1_5_1/web/authorization',
        'delphixpy/v1_5_1/web/permission',
        'delphixpy/v1_5_1/web/role',
        'delphixpy/v1_5_1/web/toolkit',
        'delphixpy/v1_5_1/web/environment',
        'delphixpy/v1_5_1/web/environment/user',
        'delphixpy/v1_5_1/web/environment/oracle',
        'delphixpy/v1_5_1/web/environment/oracle/listener',
        'delphixpy/v1_5_1/web/environment/oracle/clusternode',
        'delphixpy/v1_5_1/web/environment/windows',
        'delphixpy/v1_5_1/web/environment/windows/clusterinstance',
        'delphixpy/v1_5_1/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_5_1/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_5_1/web/environment/windows/clusternode',
        'delphixpy/v1_5_1/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_5_1/web/capacity',
        'delphixpy/v1_5_1/web/capacity/group',
        'delphixpy/v1_5_1/web/capacity/group/historical',
        'delphixpy/v1_5_1/web/capacity/consumer',
        'delphixpy/v1_5_1/web/capacity/consumer/historical',
        'delphixpy/v1_5_1/web/capacity/snapshot',
        'delphixpy/v1_5_1/web/capacity/system',
        'delphixpy/v1_5_1/web/capacity/system/historical',
        'delphixpy/v1_5_1/web/database',
        'delphixpy/v1_5_1/web/database/template',
        'delphixpy/v1_5_1/web/registration',
        'delphixpy/v1_5_1/web/registration/status',
        'delphixpy/v1_5_1/web/host',
        'delphixpy/v1_5_1/web/host/privilegeElevation',
        'delphixpy/v1_5_1/web/host/privilegeElevation/profile',
        'delphixpy/v1_5_1/web/data',
        'delphixpy/v1_5_1/web/repository',
        'delphixpy/v1_5_1/web/repository/template',
        'delphixpy/v1_5_1/web/policy',
        'delphixpy/v1_5_1/web/user',
        'delphixpy/v1_5_1/web/alert',
        'delphixpy/v1_5_1/web/alert/profile',
        'delphixpy/v1_5_1/web/objects',
        'delphixpy/v1_5_1/web/fault',
        'delphixpy/v1_5_1/web/fault/effect',
        'delphixpy/v1_5_1/web/group',
        'delphixpy/v1_5_1/web/connectivity',
        'delphixpy/v1_5_1/web/notification',
        'delphixpy/v1_5_1/web/delphix',
        'delphixpy/v1_5_1/web/job',
        'delphixpy/v1_5_1/web/about',
        'delphixpy/v1_5_1/web/timeflow',
        'delphixpy/v1_5_1/web/timeflow/bookmark',
        'delphixpy/v1_5_1/web/timeflow/oracle',
        'delphixpy/v1_5_1/web/timeflow/oracle/log',
        'delphixpy/v1_5_1/web/action',
        'delphixpy/v1_5_1/web/jetstream',
        'delphixpy/v1_5_1/web/jetstream/branch',
        'delphixpy/v1_5_1/web/jetstream/container',
        'delphixpy/v1_5_1/web/jetstream/usagedata',
        'delphixpy/v1_5_1/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_5_1/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_5_1/web/jetstream/bookmark',
        'delphixpy/v1_5_1/web/jetstream/datasource',
        'delphixpy/v1_5_1/web/jetstream/operation',
        'delphixpy/v1_5_1/web/jetstream/template',
        'delphixpy/v1_5_1/web/jetstream/usage',
        'delphixpy/v1_5_1/web/jetstream/usage/branch',
        'delphixpy/v1_5_1/web/jetstream/usage/user',
        'delphixpy/v1_5_1/web/jetstream/usage/container',
        'delphixpy/v1_5_1/web/jetstream/usage/bookmark',
        'delphixpy/v1_5_1/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_5_1/web/jetstream/usage/template',
        'delphixpy/v1_5_1/web/storage',
        'delphixpy/v1_5_1/web/storage/test',
        'delphixpy/v1_5_1/web/storage/device',
        'delphixpy/v1_5_1/web/storage/scrub',
        'delphixpy/v1_5_1/web/domain',
        'delphixpy/v1_5_1/web/analytics',
        'delphixpy/v1_5_1/web/analytics/statistic',
        'delphixpy/v1_5_1/web/snapshot',
        'delphixpy/v1_5_1/web/sourceconfig',
        'delphixpy/v1_5_1/web/sourceconfig/oracle',
        'delphixpy/v1_5_1/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_5_1/web/namespace',
        'delphixpy/v1_5_1/web/replication',
        'delphixpy/v1_5_1/web/replication/spec',
        'delphixpy/v1_5_1/web/replication/targetstate',
        'delphixpy/v1_5_1/web/replication/sourcestate',
        'delphixpy/v1_5_1/web/replication/serializationpoint',
        'delphixpy/v1_5_1/web/source',
        'delphixpy/v1_5_1/web/source/operationTemplate',
        'delphixpy/v1_5_1/web/service',
        'delphixpy/v1_5_1/web/service/smtp',
        'delphixpy/v1_5_1/web/service/ldap',
        'delphixpy/v1_5_1/web/service/ldap/server',
        'delphixpy/v1_5_1/web/service/snmp',
        'delphixpy/v1_5_1/web/service/snmp/manager',
        'delphixpy/v1_5_1/web/service/linkingsettings',
        'delphixpy/v1_5_1/web/service/phonehome',
        'delphixpy/v1_5_1/web/service/security',
        'delphixpy/v1_5_1/web/service/dns',
        'delphixpy/v1_5_1/web/service/schema',
        'delphixpy/v1_5_1/web/service/locale',
        'delphixpy/v1_5_1/web/service/proxy',
        'delphixpy/v1_5_1/web/service/certificate',
        'delphixpy/v1_5_1/web/service/time',
        'delphixpy/v1_5_1/web/service/syslog',
        'delphixpy/v1_5_1/web/service/support',
        'delphixpy/v1_5_1/web/service/support/access',
        'delphixpy/v1_5_1/web/service/support/bundle',
        'delphixpy/v1_5_1/web/system',
        'delphixpy/v1_5_1/web/system/version',
        'delphixpy/v1_5_1/web/network',
        'delphixpy/v1_5_1/web/network/route',
        'delphixpy/v1_5_1/web/network/test',
        'delphixpy/v1_5_1/web/network/test/latency',
        'delphixpy/v1_5_1/web/network/test/throughput',
        'delphixpy/v1_5_1/web/network/test/dsp',
        'delphixpy/v1_5_1/web/network/interface',
        'delphixpy/v1_5_1/web/session',
        'delphixpy/v1_11_22',
        'delphixpy/v1_11_22/web',
        'delphixpy/v1_11_22/web/authorization',
        'delphixpy/v1_11_22/web/authorization/configuration',
        'delphixpy/v1_11_22/web/permission',
        'delphixpy/v1_11_22/web/passwordPolicy',
        'delphixpy/v1_11_22/web/role',
        'delphixpy/v1_11_22/web/toolkit',
        'delphixpy/v1_11_22/web/environment',
        'delphixpy/v1_11_22/web/environment/user',
        'delphixpy/v1_11_22/web/environment/oracle',
        'delphixpy/v1_11_22/web/environment/oracle/listener',
        'delphixpy/v1_11_22/web/environment/oracle/clusternode',
        'delphixpy/v1_11_22/web/environment/windows',
        'delphixpy/v1_11_22/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_22/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_22/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_22/web/environment/windows/clusternode',
        'delphixpy/v1_11_22/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_22/web/capacity',
        'delphixpy/v1_11_22/web/capacity/heldspace',
        'delphixpy/v1_11_22/web/capacity/group',
        'delphixpy/v1_11_22/web/capacity/group/historical',
        'delphixpy/v1_11_22/web/capacity/consumer',
        'delphixpy/v1_11_22/web/capacity/consumer/historical',
        'delphixpy/v1_11_22/web/capacity/snapshot',
        'delphixpy/v1_11_22/web/capacity/system',
        'delphixpy/v1_11_22/web/capacity/system/historical',
        'delphixpy/v1_11_22/web/database',
        'delphixpy/v1_11_22/web/database/performanceHistory',
        'delphixpy/v1_11_22/web/database/template',
        'delphixpy/v1_11_22/web/registration',
        'delphixpy/v1_11_22/web/registration/status',
        'delphixpy/v1_11_22/web/host',
        'delphixpy/v1_11_22/web/host/privilegeElevation',
        'delphixpy/v1_11_22/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_22/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_22/web/theme',
        'delphixpy/v1_11_22/web/repave',
        'delphixpy/v1_11_22/web/osadmin',
        'delphixpy/v1_11_22/web/osadmin/engineStatus',
        'delphixpy/v1_11_22/web/data',
        'delphixpy/v1_11_22/web/transformation',
        'delphixpy/v1_11_22/web/repository',
        'delphixpy/v1_11_22/web/repository/template',
        'delphixpy/v1_11_22/web/policy',
        'delphixpy/v1_11_22/web/user',
        'delphixpy/v1_11_22/web/superuser',
        'delphixpy/v1_11_22/web/superuser/session',
        'delphixpy/v1_11_22/web/alert',
        'delphixpy/v1_11_22/web/alert/profile',
        'delphixpy/v1_11_22/web/objects',
        'delphixpy/v1_11_22/web/maskingjob',
        'delphixpy/v1_11_22/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_22/web/timezone',
        'delphixpy/v1_11_22/web/fault',
        'delphixpy/v1_11_22/web/fault/effect',
        'delphixpy/v1_11_22/web/group',
        'delphixpy/v1_11_22/web/license',
        'delphixpy/v1_11_22/web/connectivity',
        'delphixpy/v1_11_22/web/notification',
        'delphixpy/v1_11_22/web/delphix',
        'delphixpy/v1_11_22/web/job',
        'delphixpy/v1_11_22/web/job/retention',
        'delphixpy/v1_11_22/web/usage',
        'delphixpy/v1_11_22/web/about',
        'delphixpy/v1_11_22/web/timeflow',
        'delphixpy/v1_11_22/web/timeflow/bookmark',
        'delphixpy/v1_11_22/web/timeflow/oracle',
        'delphixpy/v1_11_22/web/timeflow/oracle/log',
        'delphixpy/v1_11_22/web/action',
        'delphixpy/v1_11_22/web/storage',
        'delphixpy/v1_11_22/web/storage/objectStorage',
        'delphixpy/v1_11_22/web/storage/remove',
        'delphixpy/v1_11_22/web/storage/iscsi',
        'delphixpy/v1_11_22/web/storage/iscsi/target',
        'delphixpy/v1_11_22/web/storage/iscsi/initiator',
        'delphixpy/v1_11_22/web/storage/test',
        'delphixpy/v1_11_22/web/storage/device',
        'delphixpy/v1_11_22/web/storage/scrub',
        'delphixpy/v1_11_22/web/domain',
        'delphixpy/v1_11_22/web/analytics',
        'delphixpy/v1_11_22/web/analytics/statistic',
        'delphixpy/v1_11_22/web/selfservice',
        'delphixpy/v1_11_22/web/selfservice/branch',
        'delphixpy/v1_11_22/web/selfservice/container',
        'delphixpy/v1_11_22/web/selfservice/usagedata',
        'delphixpy/v1_11_22/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_22/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_22/web/selfservice/bookmark',
        'delphixpy/v1_11_22/web/selfservice/datasource',
        'delphixpy/v1_11_22/web/selfservice/operation',
        'delphixpy/v1_11_22/web/selfservice/template',
        'delphixpy/v1_11_22/web/selfservice/usage',
        'delphixpy/v1_11_22/web/selfservice/usage/branch',
        'delphixpy/v1_11_22/web/selfservice/usage/user',
        'delphixpy/v1_11_22/web/selfservice/usage/container',
        'delphixpy/v1_11_22/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_22/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_22/web/selfservice/usage/template',
        'delphixpy/v1_11_22/web/selfservice/config',
        'delphixpy/v1_11_22/web/snapshot',
        'delphixpy/v1_11_22/web/sourceconfig',
        'delphixpy/v1_11_22/web/namespace',
        'delphixpy/v1_11_22/web/replication',
        'delphixpy/v1_11_22/web/replication/spec',
        'delphixpy/v1_11_22/web/replication/targetstate',
        'delphixpy/v1_11_22/web/replication/sourcestate',
        'delphixpy/v1_11_22/web/replication/serializationpoint',
        'delphixpy/v1_11_22/web/source',
        'delphixpy/v1_11_22/web/source/operationTemplate',
        'delphixpy/v1_11_22/web/service',
        'delphixpy/v1_11_22/web/service/smtp',
        'delphixpy/v1_11_22/web/service/ldap',
        'delphixpy/v1_11_22/web/service/ldap/server',
        'delphixpy/v1_11_22/web/service/nfs',
        'delphixpy/v1_11_22/web/service/host',
        'delphixpy/v1_11_22/web/service/host/address',
        'delphixpy/v1_11_22/web/service/snmp',
        'delphixpy/v1_11_22/web/service/snmp/v3',
        'delphixpy/v1_11_22/web/service/snmp/v3/manager',
        'delphixpy/v1_11_22/web/service/snmp/v3/usm',
        'delphixpy/v1_11_22/web/service/snmp/v2',
        'delphixpy/v1_11_22/web/service/snmp/v2/manager',
        'delphixpy/v1_11_22/web/service/userInterface',
        'delphixpy/v1_11_22/web/service/linkingsettings',
        'delphixpy/v1_11_22/web/service/phonehome',
        'delphixpy/v1_11_22/web/service/events',
        'delphixpy/v1_11_22/web/service/fluentd',
        'delphixpy/v1_11_22/web/service/fluentd/plugins',
        'delphixpy/v1_11_22/web/service/fluentd/configuration',
        'delphixpy/v1_11_22/web/service/httpConnector',
        'delphixpy/v1_11_22/web/service/userPaths',
        'delphixpy/v1_11_22/web/service/security',
        'delphixpy/v1_11_22/web/service/dns',
        'delphixpy/v1_11_22/web/service/kerberos',
        'delphixpy/v1_11_22/web/service/schema',
        'delphixpy/v1_11_22/web/service/tls',
        'delphixpy/v1_11_22/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_22/web/service/tls/csr',
        'delphixpy/v1_11_22/web/service/tls/cipherSuite',
        'delphixpy/v1_11_22/web/service/tls/caCertificate',
        'delphixpy/v1_11_22/web/service/insight',
        'delphixpy/v1_11_22/web/service/insight/splunkHec',
        'delphixpy/v1_11_22/web/service/locale',
        'delphixpy/v1_11_22/web/service/cloud',
        'delphixpy/v1_11_22/web/service/proxy',
        'delphixpy/v1_11_22/web/service/time',
        'delphixpy/v1_11_22/web/service/syslog',
        'delphixpy/v1_11_22/web/service/passwordReset',
        'delphixpy/v1_11_22/web/service/support',
        'delphixpy/v1_11_22/web/service/support/access',
        'delphixpy/v1_11_22/web/service/support/bundle',
        'delphixpy/v1_11_22/web/service/minimalPhonehome',
        'delphixpy/v1_11_22/web/service/passwordVault',
        'delphixpy/v1_11_22/web/service/oauth2',
        'delphixpy/v1_11_22/web/service/sso',
        'delphixpy/v1_11_22/web/system',
        'delphixpy/v1_11_22/web/system/verification',
        'delphixpy/v1_11_22/web/system/verification/reports',
        'delphixpy/v1_11_22/web/system/verification/reports/steps',
        'delphixpy/v1_11_22/web/system/advancedSettings',
        'delphixpy/v1_11_22/web/system/upgradeCheckResult',
        'delphixpy/v1_11_22/web/system/status',
        'delphixpy/v1_11_22/web/system/version',
        'delphixpy/v1_11_22/web/network',
        'delphixpy/v1_11_22/web/network/route',
        'delphixpy/v1_11_22/web/network/test',
        'delphixpy/v1_11_22/web/network/test/latency',
        'delphixpy/v1_11_22/web/network/test/throughput',
        'delphixpy/v1_11_22/web/network/test/dsp',
        'delphixpy/v1_11_22/web/network/interface',
        'delphixpy/v1_11_22/web/network/dsp',
        'delphixpy/v1_11_22/web/network/dsp/autotune',
        'delphixpy/v1_11_22/web/session',
        'delphixpy/v1_10_5',
        'delphixpy/v1_10_5/web',
        'delphixpy/v1_10_5/web/authorization',
        'delphixpy/v1_10_5/web/authorization/configuration',
        'delphixpy/v1_10_5/web/permission',
        'delphixpy/v1_10_5/web/passwordPolicy',
        'delphixpy/v1_10_5/web/role',
        'delphixpy/v1_10_5/web/toolkit',
        'delphixpy/v1_10_5/web/environment',
        'delphixpy/v1_10_5/web/environment/user',
        'delphixpy/v1_10_5/web/environment/oracle',
        'delphixpy/v1_10_5/web/environment/oracle/listener',
        'delphixpy/v1_10_5/web/environment/oracle/clusternode',
        'delphixpy/v1_10_5/web/environment/windows',
        'delphixpy/v1_10_5/web/environment/windows/clusterinstance',
        'delphixpy/v1_10_5/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_10_5/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_10_5/web/environment/windows/clusternode',
        'delphixpy/v1_10_5/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_10_5/web/capacity',
        'delphixpy/v1_10_5/web/capacity/group',
        'delphixpy/v1_10_5/web/capacity/group/historical',
        'delphixpy/v1_10_5/web/capacity/consumer',
        'delphixpy/v1_10_5/web/capacity/consumer/historical',
        'delphixpy/v1_10_5/web/capacity/snapshot',
        'delphixpy/v1_10_5/web/capacity/system',
        'delphixpy/v1_10_5/web/capacity/system/historical',
        'delphixpy/v1_10_5/web/database',
        'delphixpy/v1_10_5/web/database/performanceHistory',
        'delphixpy/v1_10_5/web/database/template',
        'delphixpy/v1_10_5/web/registration',
        'delphixpy/v1_10_5/web/registration/status',
        'delphixpy/v1_10_5/web/host',
        'delphixpy/v1_10_5/web/host/privilegeElevation',
        'delphixpy/v1_10_5/web/host/privilegeElevation/profile',
        'delphixpy/v1_10_5/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_10_5/web/data',
        'delphixpy/v1_10_5/web/transformation',
        'delphixpy/v1_10_5/web/repository',
        'delphixpy/v1_10_5/web/repository/template',
        'delphixpy/v1_10_5/web/policy',
        'delphixpy/v1_10_5/web/user',
        'delphixpy/v1_10_5/web/alert',
        'delphixpy/v1_10_5/web/alert/profile',
        'delphixpy/v1_10_5/web/objects',
        'delphixpy/v1_10_5/web/maskingjob',
        'delphixpy/v1_10_5/web/maskingjob/serviceconfig',
        'delphixpy/v1_10_5/web/timezone',
        'delphixpy/v1_10_5/web/fault',
        'delphixpy/v1_10_5/web/fault/effect',
        'delphixpy/v1_10_5/web/group',
        'delphixpy/v1_10_5/web/connectivity',
        'delphixpy/v1_10_5/web/notification',
        'delphixpy/v1_10_5/web/delphix',
        'delphixpy/v1_10_5/web/job',
        'delphixpy/v1_10_5/web/usage',
        'delphixpy/v1_10_5/web/about',
        'delphixpy/v1_10_5/web/timeflow',
        'delphixpy/v1_10_5/web/timeflow/bookmark',
        'delphixpy/v1_10_5/web/timeflow/oracle',
        'delphixpy/v1_10_5/web/timeflow/oracle/log',
        'delphixpy/v1_10_5/web/action',
        'delphixpy/v1_10_5/web/storage',
        'delphixpy/v1_10_5/web/storage/remove',
        'delphixpy/v1_10_5/web/storage/test',
        'delphixpy/v1_10_5/web/storage/device',
        'delphixpy/v1_10_5/web/storage/scrub',
        'delphixpy/v1_10_5/web/domain',
        'delphixpy/v1_10_5/web/analytics',
        'delphixpy/v1_10_5/web/analytics/statistic',
        'delphixpy/v1_10_5/web/selfservice',
        'delphixpy/v1_10_5/web/selfservice/branch',
        'delphixpy/v1_10_5/web/selfservice/container',
        'delphixpy/v1_10_5/web/selfservice/usagedata',
        'delphixpy/v1_10_5/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_10_5/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_10_5/web/selfservice/bookmark',
        'delphixpy/v1_10_5/web/selfservice/datasource',
        'delphixpy/v1_10_5/web/selfservice/operation',
        'delphixpy/v1_10_5/web/selfservice/template',
        'delphixpy/v1_10_5/web/selfservice/usage',
        'delphixpy/v1_10_5/web/selfservice/usage/branch',
        'delphixpy/v1_10_5/web/selfservice/usage/user',
        'delphixpy/v1_10_5/web/selfservice/usage/container',
        'delphixpy/v1_10_5/web/selfservice/usage/bookmark',
        'delphixpy/v1_10_5/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_10_5/web/selfservice/usage/template',
        'delphixpy/v1_10_5/web/selfservice/config',
        'delphixpy/v1_10_5/web/snapshot',
        'delphixpy/v1_10_5/web/sourceconfig',
        'delphixpy/v1_10_5/web/namespace',
        'delphixpy/v1_10_5/web/replication',
        'delphixpy/v1_10_5/web/replication/spec',
        'delphixpy/v1_10_5/web/replication/targetstate',
        'delphixpy/v1_10_5/web/replication/sourcestate',
        'delphixpy/v1_10_5/web/replication/serializationpoint',
        'delphixpy/v1_10_5/web/source',
        'delphixpy/v1_10_5/web/source/operationTemplate',
        'delphixpy/v1_10_5/web/service',
        'delphixpy/v1_10_5/web/service/smtp',
        'delphixpy/v1_10_5/web/service/ldap',
        'delphixpy/v1_10_5/web/service/ldap/server',
        'delphixpy/v1_10_5/web/service/snmp',
        'delphixpy/v1_10_5/web/service/snmp/manager',
        'delphixpy/v1_10_5/web/service/userInterface',
        'delphixpy/v1_10_5/web/service/linkingsettings',
        'delphixpy/v1_10_5/web/service/phonehome',
        'delphixpy/v1_10_5/web/service/httpConnector',
        'delphixpy/v1_10_5/web/service/security',
        'delphixpy/v1_10_5/web/service/dns',
        'delphixpy/v1_10_5/web/service/kerberos',
        'delphixpy/v1_10_5/web/service/schema',
        'delphixpy/v1_10_5/web/service/tls',
        'delphixpy/v1_10_5/web/service/tls/endEntityCertificate',
        'delphixpy/v1_10_5/web/service/tls/csr',
        'delphixpy/v1_10_5/web/service/tls/cipherSuite',
        'delphixpy/v1_10_5/web/service/tls/caCertificate',
        'delphixpy/v1_10_5/web/service/insight',
        'delphixpy/v1_10_5/web/service/insight/splunkHec',
        'delphixpy/v1_10_5/web/service/saml',
        'delphixpy/v1_10_5/web/service/saml/serviceprovider',
        'delphixpy/v1_10_5/web/service/locale',
        'delphixpy/v1_10_5/web/service/cloud',
        'delphixpy/v1_10_5/web/service/proxy',
        'delphixpy/v1_10_5/web/service/certificate',
        'delphixpy/v1_10_5/web/service/time',
        'delphixpy/v1_10_5/web/service/syslog',
        'delphixpy/v1_10_5/web/service/support',
        'delphixpy/v1_10_5/web/service/support/access',
        'delphixpy/v1_10_5/web/service/support/bundle',
        'delphixpy/v1_10_5/web/service/sso',
        'delphixpy/v1_10_5/web/system',
        'delphixpy/v1_10_5/web/system/upgradeCheckResult',
        'delphixpy/v1_10_5/web/system/status',
        'delphixpy/v1_10_5/web/system/version',
        'delphixpy/v1_10_5/web/system/package',
        'delphixpy/v1_10_5/web/network',
        'delphixpy/v1_10_5/web/network/route',
        'delphixpy/v1_10_5/web/network/test',
        'delphixpy/v1_10_5/web/network/test/latency',
        'delphixpy/v1_10_5/web/network/test/throughput',
        'delphixpy/v1_10_5/web/network/test/dsp',
        'delphixpy/v1_10_5/web/network/interface',
        'delphixpy/v1_10_5/web/network/dsp',
        'delphixpy/v1_10_5/web/network/dsp/autotune',
        'delphixpy/v1_10_5/web/session',
        'delphixpy/v1_8_1',
        'delphixpy/v1_8_1/web',
        'delphixpy/v1_8_1/web/authorization',
        'delphixpy/v1_8_1/web/permission',
        'delphixpy/v1_8_1/web/role',
        'delphixpy/v1_8_1/web/toolkit',
        'delphixpy/v1_8_1/web/environment',
        'delphixpy/v1_8_1/web/environment/user',
        'delphixpy/v1_8_1/web/environment/oracle',
        'delphixpy/v1_8_1/web/environment/oracle/listener',
        'delphixpy/v1_8_1/web/environment/oracle/clusternode',
        'delphixpy/v1_8_1/web/environment/windows',
        'delphixpy/v1_8_1/web/environment/windows/clusterinstance',
        'delphixpy/v1_8_1/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_8_1/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_8_1/web/environment/windows/clusternode',
        'delphixpy/v1_8_1/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_8_1/web/capacity',
        'delphixpy/v1_8_1/web/capacity/group',
        'delphixpy/v1_8_1/web/capacity/group/historical',
        'delphixpy/v1_8_1/web/capacity/consumer',
        'delphixpy/v1_8_1/web/capacity/consumer/historical',
        'delphixpy/v1_8_1/web/capacity/snapshot',
        'delphixpy/v1_8_1/web/capacity/system',
        'delphixpy/v1_8_1/web/capacity/system/historical',
        'delphixpy/v1_8_1/web/database',
        'delphixpy/v1_8_1/web/database/template',
        'delphixpy/v1_8_1/web/registration',
        'delphixpy/v1_8_1/web/registration/status',
        'delphixpy/v1_8_1/web/host',
        'delphixpy/v1_8_1/web/host/privilegeElevation',
        'delphixpy/v1_8_1/web/host/privilegeElevation/profile',
        'delphixpy/v1_8_1/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_8_1/web/data',
        'delphixpy/v1_8_1/web/transformation',
        'delphixpy/v1_8_1/web/repository',
        'delphixpy/v1_8_1/web/repository/template',
        'delphixpy/v1_8_1/web/policy',
        'delphixpy/v1_8_1/web/user',
        'delphixpy/v1_8_1/web/alert',
        'delphixpy/v1_8_1/web/alert/profile',
        'delphixpy/v1_8_1/web/objects',
        'delphixpy/v1_8_1/web/maskingjob',
        'delphixpy/v1_8_1/web/maskingjob/serviceconfig',
        'delphixpy/v1_8_1/web/timezone',
        'delphixpy/v1_8_1/web/fault',
        'delphixpy/v1_8_1/web/fault/effect',
        'delphixpy/v1_8_1/web/group',
        'delphixpy/v1_8_1/web/connectivity',
        'delphixpy/v1_8_1/web/notification',
        'delphixpy/v1_8_1/web/delphix',
        'delphixpy/v1_8_1/web/job',
        'delphixpy/v1_8_1/web/about',
        'delphixpy/v1_8_1/web/timeflow',
        'delphixpy/v1_8_1/web/timeflow/bookmark',
        'delphixpy/v1_8_1/web/timeflow/oracle',
        'delphixpy/v1_8_1/web/timeflow/oracle/log',
        'delphixpy/v1_8_1/web/action',
        'delphixpy/v1_8_1/web/jetstream',
        'delphixpy/v1_8_1/web/jetstream/branch',
        'delphixpy/v1_8_1/web/jetstream/container',
        'delphixpy/v1_8_1/web/jetstream/usagedata',
        'delphixpy/v1_8_1/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_8_1/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_8_1/web/jetstream/bookmark',
        'delphixpy/v1_8_1/web/jetstream/datasource',
        'delphixpy/v1_8_1/web/jetstream/operation',
        'delphixpy/v1_8_1/web/jetstream/template',
        'delphixpy/v1_8_1/web/jetstream/usage',
        'delphixpy/v1_8_1/web/jetstream/usage/branch',
        'delphixpy/v1_8_1/web/jetstream/usage/user',
        'delphixpy/v1_8_1/web/jetstream/usage/container',
        'delphixpy/v1_8_1/web/jetstream/usage/bookmark',
        'delphixpy/v1_8_1/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_8_1/web/jetstream/usage/template',
        'delphixpy/v1_8_1/web/storage',
        'delphixpy/v1_8_1/web/storage/remove',
        'delphixpy/v1_8_1/web/storage/test',
        'delphixpy/v1_8_1/web/storage/device',
        'delphixpy/v1_8_1/web/storage/scrub',
        'delphixpy/v1_8_1/web/domain',
        'delphixpy/v1_8_1/web/analytics',
        'delphixpy/v1_8_1/web/analytics/statistic',
        'delphixpy/v1_8_1/web/snapshot',
        'delphixpy/v1_8_1/web/sourceconfig',
        'delphixpy/v1_8_1/web/sourceconfig/oracle',
        'delphixpy/v1_8_1/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_8_1/web/namespace',
        'delphixpy/v1_8_1/web/replication',
        'delphixpy/v1_8_1/web/replication/spec',
        'delphixpy/v1_8_1/web/replication/targetstate',
        'delphixpy/v1_8_1/web/replication/sourcestate',
        'delphixpy/v1_8_1/web/replication/serializationpoint',
        'delphixpy/v1_8_1/web/source',
        'delphixpy/v1_8_1/web/source/operationTemplate',
        'delphixpy/v1_8_1/web/service',
        'delphixpy/v1_8_1/web/service/smtp',
        'delphixpy/v1_8_1/web/service/ldap',
        'delphixpy/v1_8_1/web/service/ldap/server',
        'delphixpy/v1_8_1/web/service/snmp',
        'delphixpy/v1_8_1/web/service/snmp/manager',
        'delphixpy/v1_8_1/web/service/linkingsettings',
        'delphixpy/v1_8_1/web/service/phonehome',
        'delphixpy/v1_8_1/web/service/security',
        'delphixpy/v1_8_1/web/service/dns',
        'delphixpy/v1_8_1/web/service/schema',
        'delphixpy/v1_8_1/web/service/saml',
        'delphixpy/v1_8_1/web/service/saml/serviceprovider',
        'delphixpy/v1_8_1/web/service/locale',
        'delphixpy/v1_8_1/web/service/proxy',
        'delphixpy/v1_8_1/web/service/certificate',
        'delphixpy/v1_8_1/web/service/time',
        'delphixpy/v1_8_1/web/service/syslog',
        'delphixpy/v1_8_1/web/service/support',
        'delphixpy/v1_8_1/web/service/support/access',
        'delphixpy/v1_8_1/web/service/support/bundle',
        'delphixpy/v1_8_1/web/system',
        'delphixpy/v1_8_1/web/system/version',
        'delphixpy/v1_8_1/web/network',
        'delphixpy/v1_8_1/web/network/route',
        'delphixpy/v1_8_1/web/network/test',
        'delphixpy/v1_8_1/web/network/test/latency',
        'delphixpy/v1_8_1/web/network/test/throughput',
        'delphixpy/v1_8_1/web/network/test/dsp',
        'delphixpy/v1_8_1/web/network/interface',
        'delphixpy/v1_8_1/web/session',
        'delphixpy/v1_6_0',
        'delphixpy/v1_6_0/web',
        'delphixpy/v1_6_0/web/authorization',
        'delphixpy/v1_6_0/web/permission',
        'delphixpy/v1_6_0/web/role',
        'delphixpy/v1_6_0/web/toolkit',
        'delphixpy/v1_6_0/web/environment',
        'delphixpy/v1_6_0/web/environment/user',
        'delphixpy/v1_6_0/web/environment/oracle',
        'delphixpy/v1_6_0/web/environment/oracle/listener',
        'delphixpy/v1_6_0/web/environment/oracle/clusternode',
        'delphixpy/v1_6_0/web/environment/windows',
        'delphixpy/v1_6_0/web/environment/windows/clusterinstance',
        'delphixpy/v1_6_0/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_6_0/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_6_0/web/environment/windows/clusternode',
        'delphixpy/v1_6_0/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_6_0/web/capacity',
        'delphixpy/v1_6_0/web/capacity/group',
        'delphixpy/v1_6_0/web/capacity/group/historical',
        'delphixpy/v1_6_0/web/capacity/consumer',
        'delphixpy/v1_6_0/web/capacity/consumer/historical',
        'delphixpy/v1_6_0/web/capacity/snapshot',
        'delphixpy/v1_6_0/web/capacity/system',
        'delphixpy/v1_6_0/web/capacity/system/historical',
        'delphixpy/v1_6_0/web/database',
        'delphixpy/v1_6_0/web/database/template',
        'delphixpy/v1_6_0/web/registration',
        'delphixpy/v1_6_0/web/registration/status',
        'delphixpy/v1_6_0/web/host',
        'delphixpy/v1_6_0/web/host/privilegeElevation',
        'delphixpy/v1_6_0/web/host/privilegeElevation/profile',
        'delphixpy/v1_6_0/web/data',
        'delphixpy/v1_6_0/web/repository',
        'delphixpy/v1_6_0/web/repository/template',
        'delphixpy/v1_6_0/web/policy',
        'delphixpy/v1_6_0/web/user',
        'delphixpy/v1_6_0/web/alert',
        'delphixpy/v1_6_0/web/alert/profile',
        'delphixpy/v1_6_0/web/objects',
        'delphixpy/v1_6_0/web/fault',
        'delphixpy/v1_6_0/web/fault/effect',
        'delphixpy/v1_6_0/web/group',
        'delphixpy/v1_6_0/web/connectivity',
        'delphixpy/v1_6_0/web/notification',
        'delphixpy/v1_6_0/web/delphix',
        'delphixpy/v1_6_0/web/job',
        'delphixpy/v1_6_0/web/about',
        'delphixpy/v1_6_0/web/timeflow',
        'delphixpy/v1_6_0/web/timeflow/bookmark',
        'delphixpy/v1_6_0/web/timeflow/oracle',
        'delphixpy/v1_6_0/web/timeflow/oracle/log',
        'delphixpy/v1_6_0/web/action',
        'delphixpy/v1_6_0/web/jetstream',
        'delphixpy/v1_6_0/web/jetstream/branch',
        'delphixpy/v1_6_0/web/jetstream/container',
        'delphixpy/v1_6_0/web/jetstream/usagedata',
        'delphixpy/v1_6_0/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_6_0/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_6_0/web/jetstream/bookmark',
        'delphixpy/v1_6_0/web/jetstream/datasource',
        'delphixpy/v1_6_0/web/jetstream/operation',
        'delphixpy/v1_6_0/web/jetstream/template',
        'delphixpy/v1_6_0/web/jetstream/usage',
        'delphixpy/v1_6_0/web/jetstream/usage/branch',
        'delphixpy/v1_6_0/web/jetstream/usage/user',
        'delphixpy/v1_6_0/web/jetstream/usage/container',
        'delphixpy/v1_6_0/web/jetstream/usage/bookmark',
        'delphixpy/v1_6_0/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_6_0/web/jetstream/usage/template',
        'delphixpy/v1_6_0/web/storage',
        'delphixpy/v1_6_0/web/storage/remove',
        'delphixpy/v1_6_0/web/storage/test',
        'delphixpy/v1_6_0/web/storage/device',
        'delphixpy/v1_6_0/web/storage/scrub',
        'delphixpy/v1_6_0/web/domain',
        'delphixpy/v1_6_0/web/analytics',
        'delphixpy/v1_6_0/web/analytics/statistic',
        'delphixpy/v1_6_0/web/snapshot',
        'delphixpy/v1_6_0/web/sourceconfig',
        'delphixpy/v1_6_0/web/sourceconfig/oracle',
        'delphixpy/v1_6_0/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_6_0/web/namespace',
        'delphixpy/v1_6_0/web/replication',
        'delphixpy/v1_6_0/web/replication/spec',
        'delphixpy/v1_6_0/web/replication/targetstate',
        'delphixpy/v1_6_0/web/replication/sourcestate',
        'delphixpy/v1_6_0/web/replication/serializationpoint',
        'delphixpy/v1_6_0/web/source',
        'delphixpy/v1_6_0/web/source/operationTemplate',
        'delphixpy/v1_6_0/web/service',
        'delphixpy/v1_6_0/web/service/smtp',
        'delphixpy/v1_6_0/web/service/ldap',
        'delphixpy/v1_6_0/web/service/ldap/server',
        'delphixpy/v1_6_0/web/service/snmp',
        'delphixpy/v1_6_0/web/service/snmp/manager',
        'delphixpy/v1_6_0/web/service/linkingsettings',
        'delphixpy/v1_6_0/web/service/phonehome',
        'delphixpy/v1_6_0/web/service/security',
        'delphixpy/v1_6_0/web/service/dns',
        'delphixpy/v1_6_0/web/service/schema',
        'delphixpy/v1_6_0/web/service/locale',
        'delphixpy/v1_6_0/web/service/proxy',
        'delphixpy/v1_6_0/web/service/certificate',
        'delphixpy/v1_6_0/web/service/time',
        'delphixpy/v1_6_0/web/service/syslog',
        'delphixpy/v1_6_0/web/service/support',
        'delphixpy/v1_6_0/web/service/support/access',
        'delphixpy/v1_6_0/web/service/support/bundle',
        'delphixpy/v1_6_0/web/system',
        'delphixpy/v1_6_0/web/system/version',
        'delphixpy/v1_6_0/web/network',
        'delphixpy/v1_6_0/web/network/route',
        'delphixpy/v1_6_0/web/network/test',
        'delphixpy/v1_6_0/web/network/test/latency',
        'delphixpy/v1_6_0/web/network/test/throughput',
        'delphixpy/v1_6_0/web/network/test/dsp',
        'delphixpy/v1_6_0/web/network/interface',
        'delphixpy/v1_6_0/web/session',
        'delphixpy/v1_11_11',
        'delphixpy/v1_11_11/web',
        'delphixpy/v1_11_11/web/authorization',
        'delphixpy/v1_11_11/web/authorization/configuration',
        'delphixpy/v1_11_11/web/permission',
        'delphixpy/v1_11_11/web/passwordPolicy',
        'delphixpy/v1_11_11/web/role',
        'delphixpy/v1_11_11/web/toolkit',
        'delphixpy/v1_11_11/web/environment',
        'delphixpy/v1_11_11/web/environment/user',
        'delphixpy/v1_11_11/web/environment/oracle',
        'delphixpy/v1_11_11/web/environment/oracle/listener',
        'delphixpy/v1_11_11/web/environment/oracle/clusternode',
        'delphixpy/v1_11_11/web/environment/windows',
        'delphixpy/v1_11_11/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_11/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_11/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_11/web/environment/windows/clusternode',
        'delphixpy/v1_11_11/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_11/web/capacity',
        'delphixpy/v1_11_11/web/capacity/heldspace',
        'delphixpy/v1_11_11/web/capacity/group',
        'delphixpy/v1_11_11/web/capacity/group/historical',
        'delphixpy/v1_11_11/web/capacity/consumer',
        'delphixpy/v1_11_11/web/capacity/consumer/historical',
        'delphixpy/v1_11_11/web/capacity/snapshot',
        'delphixpy/v1_11_11/web/capacity/system',
        'delphixpy/v1_11_11/web/capacity/system/historical',
        'delphixpy/v1_11_11/web/database',
        'delphixpy/v1_11_11/web/database/performanceHistory',
        'delphixpy/v1_11_11/web/database/template',
        'delphixpy/v1_11_11/web/registration',
        'delphixpy/v1_11_11/web/registration/status',
        'delphixpy/v1_11_11/web/host',
        'delphixpy/v1_11_11/web/host/privilegeElevation',
        'delphixpy/v1_11_11/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_11/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_11/web/theme',
        'delphixpy/v1_11_11/web/osadmin',
        'delphixpy/v1_11_11/web/osadmin/engineStatus',
        'delphixpy/v1_11_11/web/data',
        'delphixpy/v1_11_11/web/transformation',
        'delphixpy/v1_11_11/web/repository',
        'delphixpy/v1_11_11/web/repository/template',
        'delphixpy/v1_11_11/web/policy',
        'delphixpy/v1_11_11/web/user',
        'delphixpy/v1_11_11/web/alert',
        'delphixpy/v1_11_11/web/alert/profile',
        'delphixpy/v1_11_11/web/objects',
        'delphixpy/v1_11_11/web/maskingjob',
        'delphixpy/v1_11_11/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_11/web/timezone',
        'delphixpy/v1_11_11/web/fault',
        'delphixpy/v1_11_11/web/fault/effect',
        'delphixpy/v1_11_11/web/group',
        'delphixpy/v1_11_11/web/license',
        'delphixpy/v1_11_11/web/connectivity',
        'delphixpy/v1_11_11/web/notification',
        'delphixpy/v1_11_11/web/delphix',
        'delphixpy/v1_11_11/web/job',
        'delphixpy/v1_11_11/web/usage',
        'delphixpy/v1_11_11/web/about',
        'delphixpy/v1_11_11/web/timeflow',
        'delphixpy/v1_11_11/web/timeflow/bookmark',
        'delphixpy/v1_11_11/web/timeflow/oracle',
        'delphixpy/v1_11_11/web/timeflow/oracle/log',
        'delphixpy/v1_11_11/web/action',
        'delphixpy/v1_11_11/web/storage',
        'delphixpy/v1_11_11/web/storage/objectStorage',
        'delphixpy/v1_11_11/web/storage/remove',
        'delphixpy/v1_11_11/web/storage/iscsi',
        'delphixpy/v1_11_11/web/storage/iscsi/target',
        'delphixpy/v1_11_11/web/storage/iscsi/initiator',
        'delphixpy/v1_11_11/web/storage/test',
        'delphixpy/v1_11_11/web/storage/device',
        'delphixpy/v1_11_11/web/storage/scrub',
        'delphixpy/v1_11_11/web/domain',
        'delphixpy/v1_11_11/web/analytics',
        'delphixpy/v1_11_11/web/analytics/statistic',
        'delphixpy/v1_11_11/web/selfservice',
        'delphixpy/v1_11_11/web/selfservice/branch',
        'delphixpy/v1_11_11/web/selfservice/container',
        'delphixpy/v1_11_11/web/selfservice/usagedata',
        'delphixpy/v1_11_11/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_11/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_11/web/selfservice/bookmark',
        'delphixpy/v1_11_11/web/selfservice/datasource',
        'delphixpy/v1_11_11/web/selfservice/operation',
        'delphixpy/v1_11_11/web/selfservice/template',
        'delphixpy/v1_11_11/web/selfservice/usage',
        'delphixpy/v1_11_11/web/selfservice/usage/branch',
        'delphixpy/v1_11_11/web/selfservice/usage/user',
        'delphixpy/v1_11_11/web/selfservice/usage/container',
        'delphixpy/v1_11_11/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_11/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_11/web/selfservice/usage/template',
        'delphixpy/v1_11_11/web/selfservice/config',
        'delphixpy/v1_11_11/web/snapshot',
        'delphixpy/v1_11_11/web/sourceconfig',
        'delphixpy/v1_11_11/web/namespace',
        'delphixpy/v1_11_11/web/replication',
        'delphixpy/v1_11_11/web/replication/spec',
        'delphixpy/v1_11_11/web/replication/targetstate',
        'delphixpy/v1_11_11/web/replication/sourcestate',
        'delphixpy/v1_11_11/web/replication/serializationpoint',
        'delphixpy/v1_11_11/web/source',
        'delphixpy/v1_11_11/web/source/operationTemplate',
        'delphixpy/v1_11_11/web/service',
        'delphixpy/v1_11_11/web/service/smtp',
        'delphixpy/v1_11_11/web/service/ldap',
        'delphixpy/v1_11_11/web/service/ldap/server',
        'delphixpy/v1_11_11/web/service/nfs',
        'delphixpy/v1_11_11/web/service/host',
        'delphixpy/v1_11_11/web/service/host/address',
        'delphixpy/v1_11_11/web/service/snmp',
        'delphixpy/v1_11_11/web/service/snmp/v3',
        'delphixpy/v1_11_11/web/service/snmp/v3/manager',
        'delphixpy/v1_11_11/web/service/snmp/v3/usm',
        'delphixpy/v1_11_11/web/service/snmp/v2',
        'delphixpy/v1_11_11/web/service/snmp/v2/manager',
        'delphixpy/v1_11_11/web/service/userInterface',
        'delphixpy/v1_11_11/web/service/linkingsettings',
        'delphixpy/v1_11_11/web/service/phonehome',
        'delphixpy/v1_11_11/web/service/httpConnector',
        'delphixpy/v1_11_11/web/service/userPaths',
        'delphixpy/v1_11_11/web/service/security',
        'delphixpy/v1_11_11/web/service/dns',
        'delphixpy/v1_11_11/web/service/kerberos',
        'delphixpy/v1_11_11/web/service/schema',
        'delphixpy/v1_11_11/web/service/tls',
        'delphixpy/v1_11_11/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_11/web/service/tls/csr',
        'delphixpy/v1_11_11/web/service/tls/cipherSuite',
        'delphixpy/v1_11_11/web/service/tls/caCertificate',
        'delphixpy/v1_11_11/web/service/insight',
        'delphixpy/v1_11_11/web/service/insight/splunkHec',
        'delphixpy/v1_11_11/web/service/locale',
        'delphixpy/v1_11_11/web/service/cloud',
        'delphixpy/v1_11_11/web/service/proxy',
        'delphixpy/v1_11_11/web/service/time',
        'delphixpy/v1_11_11/web/service/syslog',
        'delphixpy/v1_11_11/web/service/support',
        'delphixpy/v1_11_11/web/service/support/access',
        'delphixpy/v1_11_11/web/service/support/bundle',
        'delphixpy/v1_11_11/web/service/minimalPhonehome',
        'delphixpy/v1_11_11/web/service/passwordVault',
        'delphixpy/v1_11_11/web/service/oauth2',
        'delphixpy/v1_11_11/web/service/sso',
        'delphixpy/v1_11_11/web/system',
        'delphixpy/v1_11_11/web/system/verification',
        'delphixpy/v1_11_11/web/system/verification/reports',
        'delphixpy/v1_11_11/web/system/verification/reports/steps',
        'delphixpy/v1_11_11/web/system/advancedSettings',
        'delphixpy/v1_11_11/web/system/upgradeCheckResult',
        'delphixpy/v1_11_11/web/system/status',
        'delphixpy/v1_11_11/web/system/version',
        'delphixpy/v1_11_11/web/system/package',
        'delphixpy/v1_11_11/web/network',
        'delphixpy/v1_11_11/web/network/route',
        'delphixpy/v1_11_11/web/network/test',
        'delphixpy/v1_11_11/web/network/test/latency',
        'delphixpy/v1_11_11/web/network/test/throughput',
        'delphixpy/v1_11_11/web/network/test/dsp',
        'delphixpy/v1_11_11/web/network/interface',
        'delphixpy/v1_11_11/web/network/dsp',
        'delphixpy/v1_11_11/web/network/dsp/autotune',
        'delphixpy/v1_11_11/web/session',
        'delphixpy/v1_9_3',
        'delphixpy/v1_9_3/web',
        'delphixpy/v1_9_3/web/authorization',
        'delphixpy/v1_9_3/web/permission',
        'delphixpy/v1_9_3/web/passwordPolicy',
        'delphixpy/v1_9_3/web/role',
        'delphixpy/v1_9_3/web/toolkit',
        'delphixpy/v1_9_3/web/environment',
        'delphixpy/v1_9_3/web/environment/user',
        'delphixpy/v1_9_3/web/environment/oracle',
        'delphixpy/v1_9_3/web/environment/oracle/listener',
        'delphixpy/v1_9_3/web/environment/oracle/clusternode',
        'delphixpy/v1_9_3/web/environment/windows',
        'delphixpy/v1_9_3/web/environment/windows/clusterinstance',
        'delphixpy/v1_9_3/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_9_3/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_9_3/web/environment/windows/clusternode',
        'delphixpy/v1_9_3/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_9_3/web/capacity',
        'delphixpy/v1_9_3/web/capacity/group',
        'delphixpy/v1_9_3/web/capacity/group/historical',
        'delphixpy/v1_9_3/web/capacity/consumer',
        'delphixpy/v1_9_3/web/capacity/consumer/historical',
        'delphixpy/v1_9_3/web/capacity/snapshot',
        'delphixpy/v1_9_3/web/capacity/system',
        'delphixpy/v1_9_3/web/capacity/system/historical',
        'delphixpy/v1_9_3/web/database',
        'delphixpy/v1_9_3/web/database/performanceHistory',
        'delphixpy/v1_9_3/web/database/template',
        'delphixpy/v1_9_3/web/registration',
        'delphixpy/v1_9_3/web/registration/status',
        'delphixpy/v1_9_3/web/host',
        'delphixpy/v1_9_3/web/host/privilegeElevation',
        'delphixpy/v1_9_3/web/host/privilegeElevation/profile',
        'delphixpy/v1_9_3/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_9_3/web/data',
        'delphixpy/v1_9_3/web/transformation',
        'delphixpy/v1_9_3/web/repository',
        'delphixpy/v1_9_3/web/repository/template',
        'delphixpy/v1_9_3/web/policy',
        'delphixpy/v1_9_3/web/user',
        'delphixpy/v1_9_3/web/alert',
        'delphixpy/v1_9_3/web/alert/profile',
        'delphixpy/v1_9_3/web/objects',
        'delphixpy/v1_9_3/web/maskingjob',
        'delphixpy/v1_9_3/web/maskingjob/serviceconfig',
        'delphixpy/v1_9_3/web/timezone',
        'delphixpy/v1_9_3/web/fault',
        'delphixpy/v1_9_3/web/fault/effect',
        'delphixpy/v1_9_3/web/group',
        'delphixpy/v1_9_3/web/connectivity',
        'delphixpy/v1_9_3/web/notification',
        'delphixpy/v1_9_3/web/delphix',
        'delphixpy/v1_9_3/web/job',
        'delphixpy/v1_9_3/web/about',
        'delphixpy/v1_9_3/web/timeflow',
        'delphixpy/v1_9_3/web/timeflow/bookmark',
        'delphixpy/v1_9_3/web/timeflow/oracle',
        'delphixpy/v1_9_3/web/timeflow/oracle/log',
        'delphixpy/v1_9_3/web/action',
        'delphixpy/v1_9_3/web/jetstream',
        'delphixpy/v1_9_3/web/jetstream/branch',
        'delphixpy/v1_9_3/web/jetstream/container',
        'delphixpy/v1_9_3/web/jetstream/usagedata',
        'delphixpy/v1_9_3/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_9_3/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_9_3/web/jetstream/bookmark',
        'delphixpy/v1_9_3/web/jetstream/datasource',
        'delphixpy/v1_9_3/web/jetstream/operation',
        'delphixpy/v1_9_3/web/jetstream/template',
        'delphixpy/v1_9_3/web/jetstream/usage',
        'delphixpy/v1_9_3/web/jetstream/usage/branch',
        'delphixpy/v1_9_3/web/jetstream/usage/user',
        'delphixpy/v1_9_3/web/jetstream/usage/container',
        'delphixpy/v1_9_3/web/jetstream/usage/bookmark',
        'delphixpy/v1_9_3/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_9_3/web/jetstream/usage/template',
        'delphixpy/v1_9_3/web/jetstream/config',
        'delphixpy/v1_9_3/web/storage',
        'delphixpy/v1_9_3/web/storage/remove',
        'delphixpy/v1_9_3/web/storage/test',
        'delphixpy/v1_9_3/web/storage/device',
        'delphixpy/v1_9_3/web/storage/scrub',
        'delphixpy/v1_9_3/web/domain',
        'delphixpy/v1_9_3/web/analytics',
        'delphixpy/v1_9_3/web/analytics/statistic',
        'delphixpy/v1_9_3/web/snapshot',
        'delphixpy/v1_9_3/web/sourceconfig',
        'delphixpy/v1_9_3/web/namespace',
        'delphixpy/v1_9_3/web/replication',
        'delphixpy/v1_9_3/web/replication/spec',
        'delphixpy/v1_9_3/web/replication/targetstate',
        'delphixpy/v1_9_3/web/replication/sourcestate',
        'delphixpy/v1_9_3/web/replication/serializationpoint',
        'delphixpy/v1_9_3/web/source',
        'delphixpy/v1_9_3/web/source/operationTemplate',
        'delphixpy/v1_9_3/web/service',
        'delphixpy/v1_9_3/web/service/smtp',
        'delphixpy/v1_9_3/web/service/ldap',
        'delphixpy/v1_9_3/web/service/ldap/server',
        'delphixpy/v1_9_3/web/service/snmp',
        'delphixpy/v1_9_3/web/service/snmp/manager',
        'delphixpy/v1_9_3/web/service/userInterface',
        'delphixpy/v1_9_3/web/service/linkingsettings',
        'delphixpy/v1_9_3/web/service/phonehome',
        'delphixpy/v1_9_3/web/service/httpConnector',
        'delphixpy/v1_9_3/web/service/security',
        'delphixpy/v1_9_3/web/service/dns',
        'delphixpy/v1_9_3/web/service/kerberos',
        'delphixpy/v1_9_3/web/service/schema',
        'delphixpy/v1_9_3/web/service/tls',
        'delphixpy/v1_9_3/web/service/tls/endEntityCertificate',
        'delphixpy/v1_9_3/web/service/tls/csr',
        'delphixpy/v1_9_3/web/service/tls/caCertificate',
        'delphixpy/v1_9_3/web/service/saml',
        'delphixpy/v1_9_3/web/service/saml/serviceprovider',
        'delphixpy/v1_9_3/web/service/locale',
        'delphixpy/v1_9_3/web/service/proxy',
        'delphixpy/v1_9_3/web/service/certificate',
        'delphixpy/v1_9_3/web/service/time',
        'delphixpy/v1_9_3/web/service/syslog',
        'delphixpy/v1_9_3/web/service/support',
        'delphixpy/v1_9_3/web/service/support/access',
        'delphixpy/v1_9_3/web/service/support/bundle',
        'delphixpy/v1_9_3/web/system',
        'delphixpy/v1_9_3/web/system/upgradeCheckResult',
        'delphixpy/v1_9_3/web/system/version',
        'delphixpy/v1_9_3/web/system/package',
        'delphixpy/v1_9_3/web/network',
        'delphixpy/v1_9_3/web/network/route',
        'delphixpy/v1_9_3/web/network/test',
        'delphixpy/v1_9_3/web/network/test/latency',
        'delphixpy/v1_9_3/web/network/test/throughput',
        'delphixpy/v1_9_3/web/network/test/dsp',
        'delphixpy/v1_9_3/web/network/interface',
        'delphixpy/v1_9_3/web/network/dsp',
        'delphixpy/v1_9_3/web/network/dsp/autotune',
        'delphixpy/v1_9_3/web/session',
        'delphixpy/v1_7_1',
        'delphixpy/v1_7_1/web',
        'delphixpy/v1_7_1/web/authorization',
        'delphixpy/v1_7_1/web/permission',
        'delphixpy/v1_7_1/web/role',
        'delphixpy/v1_7_1/web/toolkit',
        'delphixpy/v1_7_1/web/environment',
        'delphixpy/v1_7_1/web/environment/user',
        'delphixpy/v1_7_1/web/environment/oracle',
        'delphixpy/v1_7_1/web/environment/oracle/listener',
        'delphixpy/v1_7_1/web/environment/oracle/clusternode',
        'delphixpy/v1_7_1/web/environment/windows',
        'delphixpy/v1_7_1/web/environment/windows/clusterinstance',
        'delphixpy/v1_7_1/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_7_1/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_7_1/web/environment/windows/clusternode',
        'delphixpy/v1_7_1/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_7_1/web/capacity',
        'delphixpy/v1_7_1/web/capacity/group',
        'delphixpy/v1_7_1/web/capacity/group/historical',
        'delphixpy/v1_7_1/web/capacity/consumer',
        'delphixpy/v1_7_1/web/capacity/consumer/historical',
        'delphixpy/v1_7_1/web/capacity/snapshot',
        'delphixpy/v1_7_1/web/capacity/system',
        'delphixpy/v1_7_1/web/capacity/system/historical',
        'delphixpy/v1_7_1/web/database',
        'delphixpy/v1_7_1/web/database/template',
        'delphixpy/v1_7_1/web/registration',
        'delphixpy/v1_7_1/web/registration/status',
        'delphixpy/v1_7_1/web/host',
        'delphixpy/v1_7_1/web/host/privilegeElevation',
        'delphixpy/v1_7_1/web/host/privilegeElevation/profile',
        'delphixpy/v1_7_1/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_7_1/web/data',
        'delphixpy/v1_7_1/web/transformation',
        'delphixpy/v1_7_1/web/repository',
        'delphixpy/v1_7_1/web/repository/template',
        'delphixpy/v1_7_1/web/policy',
        'delphixpy/v1_7_1/web/user',
        'delphixpy/v1_7_1/web/alert',
        'delphixpy/v1_7_1/web/alert/profile',
        'delphixpy/v1_7_1/web/objects',
        'delphixpy/v1_7_1/web/maskingjob',
        'delphixpy/v1_7_1/web/maskingjob/serviceconfig',
        'delphixpy/v1_7_1/web/timezone',
        'delphixpy/v1_7_1/web/fault',
        'delphixpy/v1_7_1/web/fault/effect',
        'delphixpy/v1_7_1/web/group',
        'delphixpy/v1_7_1/web/connectivity',
        'delphixpy/v1_7_1/web/notification',
        'delphixpy/v1_7_1/web/delphix',
        'delphixpy/v1_7_1/web/job',
        'delphixpy/v1_7_1/web/about',
        'delphixpy/v1_7_1/web/timeflow',
        'delphixpy/v1_7_1/web/timeflow/bookmark',
        'delphixpy/v1_7_1/web/timeflow/oracle',
        'delphixpy/v1_7_1/web/timeflow/oracle/log',
        'delphixpy/v1_7_1/web/action',
        'delphixpy/v1_7_1/web/jetstream',
        'delphixpy/v1_7_1/web/jetstream/branch',
        'delphixpy/v1_7_1/web/jetstream/container',
        'delphixpy/v1_7_1/web/jetstream/usagedata',
        'delphixpy/v1_7_1/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_7_1/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_7_1/web/jetstream/bookmark',
        'delphixpy/v1_7_1/web/jetstream/datasource',
        'delphixpy/v1_7_1/web/jetstream/operation',
        'delphixpy/v1_7_1/web/jetstream/template',
        'delphixpy/v1_7_1/web/jetstream/usage',
        'delphixpy/v1_7_1/web/jetstream/usage/branch',
        'delphixpy/v1_7_1/web/jetstream/usage/user',
        'delphixpy/v1_7_1/web/jetstream/usage/container',
        'delphixpy/v1_7_1/web/jetstream/usage/bookmark',
        'delphixpy/v1_7_1/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_7_1/web/jetstream/usage/template',
        'delphixpy/v1_7_1/web/storage',
        'delphixpy/v1_7_1/web/storage/remove',
        'delphixpy/v1_7_1/web/storage/test',
        'delphixpy/v1_7_1/web/storage/device',
        'delphixpy/v1_7_1/web/storage/scrub',
        'delphixpy/v1_7_1/web/domain',
        'delphixpy/v1_7_1/web/analytics',
        'delphixpy/v1_7_1/web/analytics/statistic',
        'delphixpy/v1_7_1/web/snapshot',
        'delphixpy/v1_7_1/web/sourceconfig',
        'delphixpy/v1_7_1/web/sourceconfig/oracle',
        'delphixpy/v1_7_1/web/sourceconfig/oracle/pdb',
        'delphixpy/v1_7_1/web/namespace',
        'delphixpy/v1_7_1/web/replication',
        'delphixpy/v1_7_1/web/replication/spec',
        'delphixpy/v1_7_1/web/replication/targetstate',
        'delphixpy/v1_7_1/web/replication/sourcestate',
        'delphixpy/v1_7_1/web/replication/serializationpoint',
        'delphixpy/v1_7_1/web/source',
        'delphixpy/v1_7_1/web/source/operationTemplate',
        'delphixpy/v1_7_1/web/service',
        'delphixpy/v1_7_1/web/service/smtp',
        'delphixpy/v1_7_1/web/service/ldap',
        'delphixpy/v1_7_1/web/service/ldap/server',
        'delphixpy/v1_7_1/web/service/snmp',
        'delphixpy/v1_7_1/web/service/snmp/manager',
        'delphixpy/v1_7_1/web/service/linkingsettings',
        'delphixpy/v1_7_1/web/service/phonehome',
        'delphixpy/v1_7_1/web/service/security',
        'delphixpy/v1_7_1/web/service/dns',
        'delphixpy/v1_7_1/web/service/schema',
        'delphixpy/v1_7_1/web/service/locale',
        'delphixpy/v1_7_1/web/service/proxy',
        'delphixpy/v1_7_1/web/service/certificate',
        'delphixpy/v1_7_1/web/service/time',
        'delphixpy/v1_7_1/web/service/syslog',
        'delphixpy/v1_7_1/web/service/support',
        'delphixpy/v1_7_1/web/service/support/access',
        'delphixpy/v1_7_1/web/service/support/bundle',
        'delphixpy/v1_7_1/web/system',
        'delphixpy/v1_7_1/web/system/version',
        'delphixpy/v1_7_1/web/network',
        'delphixpy/v1_7_1/web/network/route',
        'delphixpy/v1_7_1/web/network/test',
        'delphixpy/v1_7_1/web/network/test/latency',
        'delphixpy/v1_7_1/web/network/test/throughput',
        'delphixpy/v1_7_1/web/network/test/dsp',
        'delphixpy/v1_7_1/web/network/interface',
        'delphixpy/v1_7_1/web/session',
        'delphixpy/v1_11_25',
        'delphixpy/v1_11_25/web',
        'delphixpy/v1_11_25/web/authorization',
        'delphixpy/v1_11_25/web/authorization/configuration',
        'delphixpy/v1_11_25/web/permission',
        'delphixpy/v1_11_25/web/passwordPolicy',
        'delphixpy/v1_11_25/web/role',
        'delphixpy/v1_11_25/web/toolkit',
        'delphixpy/v1_11_25/web/environment',
        'delphixpy/v1_11_25/web/environment/user',
        'delphixpy/v1_11_25/web/environment/oracle',
        'delphixpy/v1_11_25/web/environment/oracle/listener',
        'delphixpy/v1_11_25/web/environment/oracle/clusternode',
        'delphixpy/v1_11_25/web/environment/windows',
        'delphixpy/v1_11_25/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_25/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_25/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_25/web/environment/windows/clusternode',
        'delphixpy/v1_11_25/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_25/web/capacity',
        'delphixpy/v1_11_25/web/capacity/heldspace',
        'delphixpy/v1_11_25/web/capacity/group',
        'delphixpy/v1_11_25/web/capacity/group/historical',
        'delphixpy/v1_11_25/web/capacity/consumer',
        'delphixpy/v1_11_25/web/capacity/consumer/historical',
        'delphixpy/v1_11_25/web/capacity/snapshot',
        'delphixpy/v1_11_25/web/capacity/system',
        'delphixpy/v1_11_25/web/capacity/system/historical',
        'delphixpy/v1_11_25/web/database',
        'delphixpy/v1_11_25/web/database/performanceHistory',
        'delphixpy/v1_11_25/web/database/template',
        'delphixpy/v1_11_25/web/registration',
        'delphixpy/v1_11_25/web/registration/status',
        'delphixpy/v1_11_25/web/host',
        'delphixpy/v1_11_25/web/host/privilegeElevation',
        'delphixpy/v1_11_25/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_25/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_25/web/theme',
        'delphixpy/v1_11_25/web/repave',
        'delphixpy/v1_11_25/web/osadmin',
        'delphixpy/v1_11_25/web/osadmin/engineStatus',
        'delphixpy/v1_11_25/web/data',
        'delphixpy/v1_11_25/web/transformation',
        'delphixpy/v1_11_25/web/repository',
        'delphixpy/v1_11_25/web/repository/template',
        'delphixpy/v1_11_25/web/policy',
        'delphixpy/v1_11_25/web/user',
        'delphixpy/v1_11_25/web/superuser',
        'delphixpy/v1_11_25/web/superuser/session',
        'delphixpy/v1_11_25/web/alert',
        'delphixpy/v1_11_25/web/alert/profile',
        'delphixpy/v1_11_25/web/objects',
        'delphixpy/v1_11_25/web/maskingjob',
        'delphixpy/v1_11_25/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_25/web/timezone',
        'delphixpy/v1_11_25/web/fault',
        'delphixpy/v1_11_25/web/fault/effect',
        'delphixpy/v1_11_25/web/group',
        'delphixpy/v1_11_25/web/license',
        'delphixpy/v1_11_25/web/connectivity',
        'delphixpy/v1_11_25/web/notification',
        'delphixpy/v1_11_25/web/delphix',
        'delphixpy/v1_11_25/web/job',
        'delphixpy/v1_11_25/web/job/retention',
        'delphixpy/v1_11_25/web/usage',
        'delphixpy/v1_11_25/web/about',
        'delphixpy/v1_11_25/web/timeflow',
        'delphixpy/v1_11_25/web/timeflow/bookmark',
        'delphixpy/v1_11_25/web/timeflow/oracle',
        'delphixpy/v1_11_25/web/timeflow/oracle/log',
        'delphixpy/v1_11_25/web/action',
        'delphixpy/v1_11_25/web/storage',
        'delphixpy/v1_11_25/web/storage/objectStorage',
        'delphixpy/v1_11_25/web/storage/remove',
        'delphixpy/v1_11_25/web/storage/iscsi',
        'delphixpy/v1_11_25/web/storage/iscsi/target',
        'delphixpy/v1_11_25/web/storage/iscsi/initiator',
        'delphixpy/v1_11_25/web/storage/migrate',
        'delphixpy/v1_11_25/web/storage/test',
        'delphixpy/v1_11_25/web/storage/device',
        'delphixpy/v1_11_25/web/storage/scrub',
        'delphixpy/v1_11_25/web/domain',
        'delphixpy/v1_11_25/web/analytics',
        'delphixpy/v1_11_25/web/analytics/statistic',
        'delphixpy/v1_11_25/web/selfservice',
        'delphixpy/v1_11_25/web/selfservice/branch',
        'delphixpy/v1_11_25/web/selfservice/container',
        'delphixpy/v1_11_25/web/selfservice/usagedata',
        'delphixpy/v1_11_25/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_25/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_25/web/selfservice/bookmark',
        'delphixpy/v1_11_25/web/selfservice/datasource',
        'delphixpy/v1_11_25/web/selfservice/operation',
        'delphixpy/v1_11_25/web/selfservice/template',
        'delphixpy/v1_11_25/web/selfservice/usage',
        'delphixpy/v1_11_25/web/selfservice/usage/branch',
        'delphixpy/v1_11_25/web/selfservice/usage/user',
        'delphixpy/v1_11_25/web/selfservice/usage/container',
        'delphixpy/v1_11_25/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_25/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_25/web/selfservice/usage/template',
        'delphixpy/v1_11_25/web/selfservice/config',
        'delphixpy/v1_11_25/web/snapshot',
        'delphixpy/v1_11_25/web/sourceconfig',
        'delphixpy/v1_11_25/web/namespace',
        'delphixpy/v1_11_25/web/replication',
        'delphixpy/v1_11_25/web/replication/spec',
        'delphixpy/v1_11_25/web/replication/targetstate',
        'delphixpy/v1_11_25/web/replication/sourcestate',
        'delphixpy/v1_11_25/web/replication/serializationpoint',
        'delphixpy/v1_11_25/web/source',
        'delphixpy/v1_11_25/web/source/operationTemplate',
        'delphixpy/v1_11_25/web/service',
        'delphixpy/v1_11_25/web/service/smtp',
        'delphixpy/v1_11_25/web/service/ldap',
        'delphixpy/v1_11_25/web/service/ldap/server',
        'delphixpy/v1_11_25/web/service/nfs',
        'delphixpy/v1_11_25/web/service/host',
        'delphixpy/v1_11_25/web/service/host/address',
        'delphixpy/v1_11_25/web/service/snmp',
        'delphixpy/v1_11_25/web/service/snmp/v3',
        'delphixpy/v1_11_25/web/service/snmp/v3/manager',
        'delphixpy/v1_11_25/web/service/snmp/v3/usm',
        'delphixpy/v1_11_25/web/service/snmp/v2',
        'delphixpy/v1_11_25/web/service/snmp/v2/manager',
        'delphixpy/v1_11_25/web/service/userInterface',
        'delphixpy/v1_11_25/web/service/linkingsettings',
        'delphixpy/v1_11_25/web/service/phonehome',
        'delphixpy/v1_11_25/web/service/events',
        'delphixpy/v1_11_25/web/service/fluentd',
        'delphixpy/v1_11_25/web/service/fluentd/plugins',
        'delphixpy/v1_11_25/web/service/fluentd/configuration',
        'delphixpy/v1_11_25/web/service/httpConnector',
        'delphixpy/v1_11_25/web/service/userPaths',
        'delphixpy/v1_11_25/web/service/security',
        'delphixpy/v1_11_25/web/service/dns',
        'delphixpy/v1_11_25/web/service/kerberos',
        'delphixpy/v1_11_25/web/service/schema',
        'delphixpy/v1_11_25/web/service/tls',
        'delphixpy/v1_11_25/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_25/web/service/tls/csr',
        'delphixpy/v1_11_25/web/service/tls/cipherSuite',
        'delphixpy/v1_11_25/web/service/tls/caCertificate',
        'delphixpy/v1_11_25/web/service/insight',
        'delphixpy/v1_11_25/web/service/insight/splunkHec',
        'delphixpy/v1_11_25/web/service/locale',
        'delphixpy/v1_11_25/web/service/cloud',
        'delphixpy/v1_11_25/web/service/proxy',
        'delphixpy/v1_11_25/web/service/time',
        'delphixpy/v1_11_25/web/service/syslog',
        'delphixpy/v1_11_25/web/service/passwordReset',
        'delphixpy/v1_11_25/web/service/support',
        'delphixpy/v1_11_25/web/service/support/access',
        'delphixpy/v1_11_25/web/service/support/bundle',
        'delphixpy/v1_11_25/web/service/minimalPhonehome',
        'delphixpy/v1_11_25/web/service/passwordVault',
        'delphixpy/v1_11_25/web/service/oauth2',
        'delphixpy/v1_11_25/web/service/sso',
        'delphixpy/v1_11_25/web/system',
        'delphixpy/v1_11_25/web/system/verification',
        'delphixpy/v1_11_25/web/system/verification/reports',
        'delphixpy/v1_11_25/web/system/verification/reports/steps',
        'delphixpy/v1_11_25/web/system/advancedSettings',
        'delphixpy/v1_11_25/web/system/upgradeCheckResult',
        'delphixpy/v1_11_25/web/system/status',
        'delphixpy/v1_11_25/web/system/version',
        'delphixpy/v1_11_25/web/network',
        'delphixpy/v1_11_25/web/network/route',
        'delphixpy/v1_11_25/web/network/test',
        'delphixpy/v1_11_25/web/network/test/latency',
        'delphixpy/v1_11_25/web/network/test/throughput',
        'delphixpy/v1_11_25/web/network/test/dsp',
        'delphixpy/v1_11_25/web/network/interface',
        'delphixpy/v1_11_25/web/network/dsp',
        'delphixpy/v1_11_25/web/network/dsp/autotune',
        'delphixpy/v1_11_25/web/session',
        'delphixpy/web',
        'delphixpy/web/authorization',
        'delphixpy/web/authorization/configuration',
        'delphixpy/web/permission',
        'delphixpy/web/passwordPolicy',
        'delphixpy/web/role',
        'delphixpy/web/toolkit',
        'delphixpy/web/environment',
        'delphixpy/web/environment/user',
        'delphixpy/web/environment/oracle',
        'delphixpy/web/environment/oracle/listener',
        'delphixpy/web/environment/oracle/clusternode',
        'delphixpy/web/environment/windows',
        'delphixpy/web/environment/windows/clusterinstance',
        'delphixpy/web/environment/windows/availabilitygrouplistener',
        'delphixpy/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/web/environment/windows/clusternode',
        'delphixpy/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/web/capacity',
        'delphixpy/web/capacity/heldspace',
        'delphixpy/web/capacity/group',
        'delphixpy/web/capacity/group/historical',
        'delphixpy/web/capacity/consumer',
        'delphixpy/web/capacity/consumer/historical',
        'delphixpy/web/capacity/snapshot',
        'delphixpy/web/capacity/system',
        'delphixpy/web/capacity/system/historical',
        'delphixpy/web/database',
        'delphixpy/web/database/performanceHistory',
        'delphixpy/web/database/template',
        'delphixpy/web/registration',
        'delphixpy/web/registration/status',
        'delphixpy/web/host',
        'delphixpy/web/host/privilegeElevation',
        'delphixpy/web/host/privilegeElevation/profile',
        'delphixpy/web/host/privilegeElevation/profileScript',
        'delphixpy/web/theme',
        'delphixpy/web/repave',
        'delphixpy/web/osadmin',
        'delphixpy/web/osadmin/engineStatus',
        'delphixpy/web/data',
        'delphixpy/web/transformation',
        'delphixpy/web/repository',
        'delphixpy/web/repository/template',
        'delphixpy/web/policy',
        'delphixpy/web/user',
        'delphixpy/web/superuser',
        'delphixpy/web/superuser/session',
        'delphixpy/web/alert',
        'delphixpy/web/alert/profile',
        'delphixpy/web/objects',
        'delphixpy/web/maskingjob',
        'delphixpy/web/maskingjob/serviceconfig',
        'delphixpy/web/timezone',
        'delphixpy/web/fault',
        'delphixpy/web/fault/effect',
        'delphixpy/web/group',
        'delphixpy/web/license',
        'delphixpy/web/connectivity',
        'delphixpy/web/notification',
        'delphixpy/web/delphix',
        'delphixpy/web/job',
        'delphixpy/web/job/retention',
        'delphixpy/web/usage',
        'delphixpy/web/about',
        'delphixpy/web/timeflow',
        'delphixpy/web/timeflow/bookmark',
        'delphixpy/web/timeflow/oracle',
        'delphixpy/web/timeflow/oracle/log',
        'delphixpy/web/action',
        'delphixpy/web/storage',
        'delphixpy/web/storage/objectStorage',
        'delphixpy/web/storage/remove',
        'delphixpy/web/storage/iscsi',
        'delphixpy/web/storage/iscsi/target',
        'delphixpy/web/storage/iscsi/initiator',
        'delphixpy/web/storage/migrate',
        'delphixpy/web/storage/test',
        'delphixpy/web/storage/device',
        'delphixpy/web/storage/scrub',
        'delphixpy/web/domain',
        'delphixpy/web/analytics',
        'delphixpy/web/analytics/statistic',
        'delphixpy/web/selfservice',
        'delphixpy/web/selfservice/branch',
        'delphixpy/web/selfservice/container',
        'delphixpy/web/selfservice/usagedata',
        'delphixpy/web/selfservice/usagedata/operationduration',
        'delphixpy/web/selfservice/usagedata/operationcount',
        'delphixpy/web/selfservice/bookmark',
        'delphixpy/web/selfservice/datasource',
        'delphixpy/web/selfservice/operation',
        'delphixpy/web/selfservice/template',
        'delphixpy/web/selfservice/usage',
        'delphixpy/web/selfservice/usage/branch',
        'delphixpy/web/selfservice/usage/user',
        'delphixpy/web/selfservice/usage/container',
        'delphixpy/web/selfservice/usage/bookmark',
        'delphixpy/web/selfservice/usage/bookmark/tag',
        'delphixpy/web/selfservice/usage/template',
        'delphixpy/web/selfservice/config',
        'delphixpy/web/snapshot',
        'delphixpy/web/sourceconfig',
        'delphixpy/web/namespace',
        'delphixpy/web/replication',
        'delphixpy/web/replication/spec',
        'delphixpy/web/replication/targetstate',
        'delphixpy/web/replication/sourcestate',
        'delphixpy/web/replication/serializationpoint',
        'delphixpy/web/source',
        'delphixpy/web/source/operationTemplate',
        'delphixpy/web/service',
        'delphixpy/web/service/smtp',
        'delphixpy/web/service/ldap',
        'delphixpy/web/service/ldap/server',
        'delphixpy/web/service/nfs',
        'delphixpy/web/service/nfs/encryption',
        'delphixpy/web/service/host',
        'delphixpy/web/service/host/address',
        'delphixpy/web/service/snmp',
        'delphixpy/web/service/snmp/v3',
        'delphixpy/web/service/snmp/v3/manager',
        'delphixpy/web/service/snmp/v3/usm',
        'delphixpy/web/service/snmp/v2',
        'delphixpy/web/service/snmp/v2/manager',
        'delphixpy/web/service/userInterface',
        'delphixpy/web/service/linkingsettings',
        'delphixpy/web/service/phonehome',
        'delphixpy/web/service/events',
        'delphixpy/web/service/fluentd',
        'delphixpy/web/service/fluentd/plugins',
        'delphixpy/web/service/fluentd/configuration',
        'delphixpy/web/service/httpConnector',
        'delphixpy/web/service/userPaths',
        'delphixpy/web/service/security',
        'delphixpy/web/service/dns',
        'delphixpy/web/service/kerberos',
        'delphixpy/web/service/schema',
        'delphixpy/web/service/tls',
        'delphixpy/web/service/tls/endEntityCertificate',
        'delphixpy/web/service/tls/csr',
        'delphixpy/web/service/tls/cipherSuite',
        'delphixpy/web/service/tls/caCertificate',
        'delphixpy/web/service/insight',
        'delphixpy/web/service/insight/splunkHec',
        'delphixpy/web/service/locale',
        'delphixpy/web/service/cloud',
        'delphixpy/web/service/proxy',
        'delphixpy/web/service/time',
        'delphixpy/web/service/syslog',
        'delphixpy/web/service/passwordReset',
        'delphixpy/web/service/support',
        'delphixpy/web/service/support/access',
        'delphixpy/web/service/support/bundle',
        'delphixpy/web/service/minimalPhonehome',
        'delphixpy/web/service/passwordVault',
        'delphixpy/web/service/oauth2',
        'delphixpy/web/service/sso',
        'delphixpy/web/system',
        'delphixpy/web/system/verification',
        'delphixpy/web/system/verification/reports',
        'delphixpy/web/system/verification/reports/steps',
        'delphixpy/web/system/advancedSettings',
        'delphixpy/web/system/upgradeCheckResult',
        'delphixpy/web/system/status',
        'delphixpy/web/system/version',
        'delphixpy/web/network',
        'delphixpy/web/network/route',
        'delphixpy/web/network/test',
        'delphixpy/web/network/test/latency',
        'delphixpy/web/network/test/throughput',
        'delphixpy/web/network/test/dsp',
        'delphixpy/web/network/interface',
        'delphixpy/web/network/dsp',
        'delphixpy/web/network/dsp/autotune',
        'delphixpy/web/session',
        'delphixpy/v1_9_1',
        'delphixpy/v1_9_1/web',
        'delphixpy/v1_9_1/web/authorization',
        'delphixpy/v1_9_1/web/permission',
        'delphixpy/v1_9_1/web/passwordPolicy',
        'delphixpy/v1_9_1/web/role',
        'delphixpy/v1_9_1/web/toolkit',
        'delphixpy/v1_9_1/web/environment',
        'delphixpy/v1_9_1/web/environment/user',
        'delphixpy/v1_9_1/web/environment/oracle',
        'delphixpy/v1_9_1/web/environment/oracle/listener',
        'delphixpy/v1_9_1/web/environment/oracle/clusternode',
        'delphixpy/v1_9_1/web/environment/windows',
        'delphixpy/v1_9_1/web/environment/windows/clusterinstance',
        'delphixpy/v1_9_1/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_9_1/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_9_1/web/environment/windows/clusternode',
        'delphixpy/v1_9_1/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_9_1/web/capacity',
        'delphixpy/v1_9_1/web/capacity/group',
        'delphixpy/v1_9_1/web/capacity/group/historical',
        'delphixpy/v1_9_1/web/capacity/consumer',
        'delphixpy/v1_9_1/web/capacity/consumer/historical',
        'delphixpy/v1_9_1/web/capacity/snapshot',
        'delphixpy/v1_9_1/web/capacity/system',
        'delphixpy/v1_9_1/web/capacity/system/historical',
        'delphixpy/v1_9_1/web/database',
        'delphixpy/v1_9_1/web/database/performanceHistory',
        'delphixpy/v1_9_1/web/database/template',
        'delphixpy/v1_9_1/web/registration',
        'delphixpy/v1_9_1/web/registration/status',
        'delphixpy/v1_9_1/web/host',
        'delphixpy/v1_9_1/web/host/privilegeElevation',
        'delphixpy/v1_9_1/web/host/privilegeElevation/profile',
        'delphixpy/v1_9_1/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_9_1/web/data',
        'delphixpy/v1_9_1/web/transformation',
        'delphixpy/v1_9_1/web/repository',
        'delphixpy/v1_9_1/web/repository/template',
        'delphixpy/v1_9_1/web/policy',
        'delphixpy/v1_9_1/web/user',
        'delphixpy/v1_9_1/web/alert',
        'delphixpy/v1_9_1/web/alert/profile',
        'delphixpy/v1_9_1/web/objects',
        'delphixpy/v1_9_1/web/maskingjob',
        'delphixpy/v1_9_1/web/maskingjob/serviceconfig',
        'delphixpy/v1_9_1/web/timezone',
        'delphixpy/v1_9_1/web/fault',
        'delphixpy/v1_9_1/web/fault/effect',
        'delphixpy/v1_9_1/web/group',
        'delphixpy/v1_9_1/web/connectivity',
        'delphixpy/v1_9_1/web/notification',
        'delphixpy/v1_9_1/web/delphix',
        'delphixpy/v1_9_1/web/job',
        'delphixpy/v1_9_1/web/about',
        'delphixpy/v1_9_1/web/timeflow',
        'delphixpy/v1_9_1/web/timeflow/bookmark',
        'delphixpy/v1_9_1/web/timeflow/oracle',
        'delphixpy/v1_9_1/web/timeflow/oracle/log',
        'delphixpy/v1_9_1/web/action',
        'delphixpy/v1_9_1/web/jetstream',
        'delphixpy/v1_9_1/web/jetstream/branch',
        'delphixpy/v1_9_1/web/jetstream/container',
        'delphixpy/v1_9_1/web/jetstream/usagedata',
        'delphixpy/v1_9_1/web/jetstream/usagedata/operationduration',
        'delphixpy/v1_9_1/web/jetstream/usagedata/operationcount',
        'delphixpy/v1_9_1/web/jetstream/bookmark',
        'delphixpy/v1_9_1/web/jetstream/datasource',
        'delphixpy/v1_9_1/web/jetstream/operation',
        'delphixpy/v1_9_1/web/jetstream/template',
        'delphixpy/v1_9_1/web/jetstream/usage',
        'delphixpy/v1_9_1/web/jetstream/usage/branch',
        'delphixpy/v1_9_1/web/jetstream/usage/user',
        'delphixpy/v1_9_1/web/jetstream/usage/container',
        'delphixpy/v1_9_1/web/jetstream/usage/bookmark',
        'delphixpy/v1_9_1/web/jetstream/usage/bookmark/tag',
        'delphixpy/v1_9_1/web/jetstream/usage/template',
        'delphixpy/v1_9_1/web/jetstream/config',
        'delphixpy/v1_9_1/web/storage',
        'delphixpy/v1_9_1/web/storage/remove',
        'delphixpy/v1_9_1/web/storage/test',
        'delphixpy/v1_9_1/web/storage/device',
        'delphixpy/v1_9_1/web/storage/scrub',
        'delphixpy/v1_9_1/web/domain',
        'delphixpy/v1_9_1/web/analytics',
        'delphixpy/v1_9_1/web/analytics/statistic',
        'delphixpy/v1_9_1/web/snapshot',
        'delphixpy/v1_9_1/web/sourceconfig',
        'delphixpy/v1_9_1/web/namespace',
        'delphixpy/v1_9_1/web/replication',
        'delphixpy/v1_9_1/web/replication/spec',
        'delphixpy/v1_9_1/web/replication/targetstate',
        'delphixpy/v1_9_1/web/replication/sourcestate',
        'delphixpy/v1_9_1/web/replication/serializationpoint',
        'delphixpy/v1_9_1/web/source',
        'delphixpy/v1_9_1/web/source/operationTemplate',
        'delphixpy/v1_9_1/web/service',
        'delphixpy/v1_9_1/web/service/smtp',
        'delphixpy/v1_9_1/web/service/ldap',
        'delphixpy/v1_9_1/web/service/ldap/server',
        'delphixpy/v1_9_1/web/service/snmp',
        'delphixpy/v1_9_1/web/service/snmp/manager',
        'delphixpy/v1_9_1/web/service/linkingsettings',
        'delphixpy/v1_9_1/web/service/phonehome',
        'delphixpy/v1_9_1/web/service/httpConnector',
        'delphixpy/v1_9_1/web/service/security',
        'delphixpy/v1_9_1/web/service/dns',
        'delphixpy/v1_9_1/web/service/kerberos',
        'delphixpy/v1_9_1/web/service/schema',
        'delphixpy/v1_9_1/web/service/tls',
        'delphixpy/v1_9_1/web/service/tls/cacert',
        'delphixpy/v1_9_1/web/service/saml',
        'delphixpy/v1_9_1/web/service/saml/serviceprovider',
        'delphixpy/v1_9_1/web/service/locale',
        'delphixpy/v1_9_1/web/service/proxy',
        'delphixpy/v1_9_1/web/service/certificate',
        'delphixpy/v1_9_1/web/service/time',
        'delphixpy/v1_9_1/web/service/syslog',
        'delphixpy/v1_9_1/web/service/support',
        'delphixpy/v1_9_1/web/service/support/access',
        'delphixpy/v1_9_1/web/service/support/bundle',
        'delphixpy/v1_9_1/web/system',
        'delphixpy/v1_9_1/web/system/upgradeCheckResult',
        'delphixpy/v1_9_1/web/system/version',
        'delphixpy/v1_9_1/web/system/package',
        'delphixpy/v1_9_1/web/network',
        'delphixpy/v1_9_1/web/network/route',
        'delphixpy/v1_9_1/web/network/test',
        'delphixpy/v1_9_1/web/network/test/latency',
        'delphixpy/v1_9_1/web/network/test/throughput',
        'delphixpy/v1_9_1/web/network/test/dsp',
        'delphixpy/v1_9_1/web/network/interface',
        'delphixpy/v1_9_1/web/network/dsp',
        'delphixpy/v1_9_1/web/network/dsp/autotune',
        'delphixpy/v1_9_1/web/session',
        'delphixpy/v1_10_3',
        'delphixpy/v1_10_3/web',
        'delphixpy/v1_10_3/web/authorization',
        'delphixpy/v1_10_3/web/authorization/configuration',
        'delphixpy/v1_10_3/web/permission',
        'delphixpy/v1_10_3/web/passwordPolicy',
        'delphixpy/v1_10_3/web/role',
        'delphixpy/v1_10_3/web/toolkit',
        'delphixpy/v1_10_3/web/environment',
        'delphixpy/v1_10_3/web/environment/user',
        'delphixpy/v1_10_3/web/environment/oracle',
        'delphixpy/v1_10_3/web/environment/oracle/listener',
        'delphixpy/v1_10_3/web/environment/oracle/clusternode',
        'delphixpy/v1_10_3/web/environment/windows',
        'delphixpy/v1_10_3/web/environment/windows/clusterinstance',
        'delphixpy/v1_10_3/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_10_3/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_10_3/web/environment/windows/clusternode',
        'delphixpy/v1_10_3/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_10_3/web/capacity',
        'delphixpy/v1_10_3/web/capacity/group',
        'delphixpy/v1_10_3/web/capacity/group/historical',
        'delphixpy/v1_10_3/web/capacity/consumer',
        'delphixpy/v1_10_3/web/capacity/consumer/historical',
        'delphixpy/v1_10_3/web/capacity/snapshot',
        'delphixpy/v1_10_3/web/capacity/system',
        'delphixpy/v1_10_3/web/capacity/system/historical',
        'delphixpy/v1_10_3/web/database',
        'delphixpy/v1_10_3/web/database/performanceHistory',
        'delphixpy/v1_10_3/web/database/template',
        'delphixpy/v1_10_3/web/registration',
        'delphixpy/v1_10_3/web/registration/status',
        'delphixpy/v1_10_3/web/host',
        'delphixpy/v1_10_3/web/host/privilegeElevation',
        'delphixpy/v1_10_3/web/host/privilegeElevation/profile',
        'delphixpy/v1_10_3/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_10_3/web/data',
        'delphixpy/v1_10_3/web/transformation',
        'delphixpy/v1_10_3/web/repository',
        'delphixpy/v1_10_3/web/repository/template',
        'delphixpy/v1_10_3/web/policy',
        'delphixpy/v1_10_3/web/user',
        'delphixpy/v1_10_3/web/alert',
        'delphixpy/v1_10_3/web/alert/profile',
        'delphixpy/v1_10_3/web/objects',
        'delphixpy/v1_10_3/web/maskingjob',
        'delphixpy/v1_10_3/web/maskingjob/serviceconfig',
        'delphixpy/v1_10_3/web/timezone',
        'delphixpy/v1_10_3/web/fault',
        'delphixpy/v1_10_3/web/fault/effect',
        'delphixpy/v1_10_3/web/group',
        'delphixpy/v1_10_3/web/connectivity',
        'delphixpy/v1_10_3/web/notification',
        'delphixpy/v1_10_3/web/delphix',
        'delphixpy/v1_10_3/web/job',
        'delphixpy/v1_10_3/web/usage',
        'delphixpy/v1_10_3/web/about',
        'delphixpy/v1_10_3/web/timeflow',
        'delphixpy/v1_10_3/web/timeflow/bookmark',
        'delphixpy/v1_10_3/web/timeflow/oracle',
        'delphixpy/v1_10_3/web/timeflow/oracle/log',
        'delphixpy/v1_10_3/web/action',
        'delphixpy/v1_10_3/web/storage',
        'delphixpy/v1_10_3/web/storage/remove',
        'delphixpy/v1_10_3/web/storage/test',
        'delphixpy/v1_10_3/web/storage/device',
        'delphixpy/v1_10_3/web/storage/scrub',
        'delphixpy/v1_10_3/web/domain',
        'delphixpy/v1_10_3/web/analytics',
        'delphixpy/v1_10_3/web/analytics/statistic',
        'delphixpy/v1_10_3/web/selfservice',
        'delphixpy/v1_10_3/web/selfservice/branch',
        'delphixpy/v1_10_3/web/selfservice/container',
        'delphixpy/v1_10_3/web/selfservice/usagedata',
        'delphixpy/v1_10_3/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_10_3/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_10_3/web/selfservice/bookmark',
        'delphixpy/v1_10_3/web/selfservice/datasource',
        'delphixpy/v1_10_3/web/selfservice/operation',
        'delphixpy/v1_10_3/web/selfservice/template',
        'delphixpy/v1_10_3/web/selfservice/usage',
        'delphixpy/v1_10_3/web/selfservice/usage/branch',
        'delphixpy/v1_10_3/web/selfservice/usage/user',
        'delphixpy/v1_10_3/web/selfservice/usage/container',
        'delphixpy/v1_10_3/web/selfservice/usage/bookmark',
        'delphixpy/v1_10_3/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_10_3/web/selfservice/usage/template',
        'delphixpy/v1_10_3/web/selfservice/config',
        'delphixpy/v1_10_3/web/snapshot',
        'delphixpy/v1_10_3/web/sourceconfig',
        'delphixpy/v1_10_3/web/namespace',
        'delphixpy/v1_10_3/web/replication',
        'delphixpy/v1_10_3/web/replication/spec',
        'delphixpy/v1_10_3/web/replication/targetstate',
        'delphixpy/v1_10_3/web/replication/sourcestate',
        'delphixpy/v1_10_3/web/replication/serializationpoint',
        'delphixpy/v1_10_3/web/source',
        'delphixpy/v1_10_3/web/source/operationTemplate',
        'delphixpy/v1_10_3/web/service',
        'delphixpy/v1_10_3/web/service/smtp',
        'delphixpy/v1_10_3/web/service/ldap',
        'delphixpy/v1_10_3/web/service/ldap/server',
        'delphixpy/v1_10_3/web/service/snmp',
        'delphixpy/v1_10_3/web/service/snmp/manager',
        'delphixpy/v1_10_3/web/service/userInterface',
        'delphixpy/v1_10_3/web/service/linkingsettings',
        'delphixpy/v1_10_3/web/service/phonehome',
        'delphixpy/v1_10_3/web/service/httpConnector',
        'delphixpy/v1_10_3/web/service/security',
        'delphixpy/v1_10_3/web/service/dns',
        'delphixpy/v1_10_3/web/service/kerberos',
        'delphixpy/v1_10_3/web/service/schema',
        'delphixpy/v1_10_3/web/service/tls',
        'delphixpy/v1_10_3/web/service/tls/endEntityCertificate',
        'delphixpy/v1_10_3/web/service/tls/csr',
        'delphixpy/v1_10_3/web/service/tls/cipherSuite',
        'delphixpy/v1_10_3/web/service/tls/caCertificate',
        'delphixpy/v1_10_3/web/service/insight',
        'delphixpy/v1_10_3/web/service/insight/splunkHec',
        'delphixpy/v1_10_3/web/service/saml',
        'delphixpy/v1_10_3/web/service/saml/serviceprovider',
        'delphixpy/v1_10_3/web/service/locale',
        'delphixpy/v1_10_3/web/service/cloud',
        'delphixpy/v1_10_3/web/service/proxy',
        'delphixpy/v1_10_3/web/service/certificate',
        'delphixpy/v1_10_3/web/service/time',
        'delphixpy/v1_10_3/web/service/syslog',
        'delphixpy/v1_10_3/web/service/support',
        'delphixpy/v1_10_3/web/service/support/access',
        'delphixpy/v1_10_3/web/service/support/bundle',
        'delphixpy/v1_10_3/web/service/sso',
        'delphixpy/v1_10_3/web/system',
        'delphixpy/v1_10_3/web/system/upgradeCheckResult',
        'delphixpy/v1_10_3/web/system/status',
        'delphixpy/v1_10_3/web/system/version',
        'delphixpy/v1_10_3/web/system/package',
        'delphixpy/v1_10_3/web/network',
        'delphixpy/v1_10_3/web/network/route',
        'delphixpy/v1_10_3/web/network/test',
        'delphixpy/v1_10_3/web/network/test/latency',
        'delphixpy/v1_10_3/web/network/test/throughput',
        'delphixpy/v1_10_3/web/network/test/dsp',
        'delphixpy/v1_10_3/web/network/interface',
        'delphixpy/v1_10_3/web/network/dsp',
        'delphixpy/v1_10_3/web/network/dsp/autotune',
        'delphixpy/v1_10_3/web/session',
        'delphixpy/v1_11_21',
        'delphixpy/v1_11_21/web',
        'delphixpy/v1_11_21/web/authorization',
        'delphixpy/v1_11_21/web/authorization/configuration',
        'delphixpy/v1_11_21/web/permission',
        'delphixpy/v1_11_21/web/passwordPolicy',
        'delphixpy/v1_11_21/web/role',
        'delphixpy/v1_11_21/web/toolkit',
        'delphixpy/v1_11_21/web/environment',
        'delphixpy/v1_11_21/web/environment/user',
        'delphixpy/v1_11_21/web/environment/oracle',
        'delphixpy/v1_11_21/web/environment/oracle/listener',
        'delphixpy/v1_11_21/web/environment/oracle/clusternode',
        'delphixpy/v1_11_21/web/environment/windows',
        'delphixpy/v1_11_21/web/environment/windows/clusterinstance',
        'delphixpy/v1_11_21/web/environment/windows/availabilitygrouplistener',
        'delphixpy/v1_11_21/web/environment/windows/failoverclusterrepositoryinstance',
        'delphixpy/v1_11_21/web/environment/windows/clusternode',
        'delphixpy/v1_11_21/web/environment/windows/failoverclusterrepositorylistener',
        'delphixpy/v1_11_21/web/capacity',
        'delphixpy/v1_11_21/web/capacity/heldspace',
        'delphixpy/v1_11_21/web/capacity/group',
        'delphixpy/v1_11_21/web/capacity/group/historical',
        'delphixpy/v1_11_21/web/capacity/consumer',
        'delphixpy/v1_11_21/web/capacity/consumer/historical',
        'delphixpy/v1_11_21/web/capacity/snapshot',
        'delphixpy/v1_11_21/web/capacity/system',
        'delphixpy/v1_11_21/web/capacity/system/historical',
        'delphixpy/v1_11_21/web/database',
        'delphixpy/v1_11_21/web/database/performanceHistory',
        'delphixpy/v1_11_21/web/database/template',
        'delphixpy/v1_11_21/web/registration',
        'delphixpy/v1_11_21/web/registration/status',
        'delphixpy/v1_11_21/web/host',
        'delphixpy/v1_11_21/web/host/privilegeElevation',
        'delphixpy/v1_11_21/web/host/privilegeElevation/profile',
        'delphixpy/v1_11_21/web/host/privilegeElevation/profileScript',
        'delphixpy/v1_11_21/web/theme',
        'delphixpy/v1_11_21/web/repave',
        'delphixpy/v1_11_21/web/osadmin',
        'delphixpy/v1_11_21/web/osadmin/engineStatus',
        'delphixpy/v1_11_21/web/data',
        'delphixpy/v1_11_21/web/transformation',
        'delphixpy/v1_11_21/web/repository',
        'delphixpy/v1_11_21/web/repository/template',
        'delphixpy/v1_11_21/web/policy',
        'delphixpy/v1_11_21/web/user',
        'delphixpy/v1_11_21/web/alert',
        'delphixpy/v1_11_21/web/alert/profile',
        'delphixpy/v1_11_21/web/objects',
        'delphixpy/v1_11_21/web/maskingjob',
        'delphixpy/v1_11_21/web/maskingjob/serviceconfig',
        'delphixpy/v1_11_21/web/timezone',
        'delphixpy/v1_11_21/web/fault',
        'delphixpy/v1_11_21/web/fault/effect',
        'delphixpy/v1_11_21/web/group',
        'delphixpy/v1_11_21/web/license',
        'delphixpy/v1_11_21/web/connectivity',
        'delphixpy/v1_11_21/web/notification',
        'delphixpy/v1_11_21/web/delphix',
        'delphixpy/v1_11_21/web/job',
        'delphixpy/v1_11_21/web/job/retention',
        'delphixpy/v1_11_21/web/usage',
        'delphixpy/v1_11_21/web/about',
        'delphixpy/v1_11_21/web/timeflow',
        'delphixpy/v1_11_21/web/timeflow/bookmark',
        'delphixpy/v1_11_21/web/timeflow/oracle',
        'delphixpy/v1_11_21/web/timeflow/oracle/log',
        'delphixpy/v1_11_21/web/action',
        'delphixpy/v1_11_21/web/storage',
        'delphixpy/v1_11_21/web/storage/objectStorage',
        'delphixpy/v1_11_21/web/storage/remove',
        'delphixpy/v1_11_21/web/storage/iscsi',
        'delphixpy/v1_11_21/web/storage/iscsi/target',
        'delphixpy/v1_11_21/web/storage/iscsi/initiator',
        'delphixpy/v1_11_21/web/storage/test',
        'delphixpy/v1_11_21/web/storage/device',
        'delphixpy/v1_11_21/web/storage/scrub',
        'delphixpy/v1_11_21/web/domain',
        'delphixpy/v1_11_21/web/analytics',
        'delphixpy/v1_11_21/web/analytics/statistic',
        'delphixpy/v1_11_21/web/selfservice',
        'delphixpy/v1_11_21/web/selfservice/branch',
        'delphixpy/v1_11_21/web/selfservice/container',
        'delphixpy/v1_11_21/web/selfservice/usagedata',
        'delphixpy/v1_11_21/web/selfservice/usagedata/operationduration',
        'delphixpy/v1_11_21/web/selfservice/usagedata/operationcount',
        'delphixpy/v1_11_21/web/selfservice/bookmark',
        'delphixpy/v1_11_21/web/selfservice/datasource',
        'delphixpy/v1_11_21/web/selfservice/operation',
        'delphixpy/v1_11_21/web/selfservice/template',
        'delphixpy/v1_11_21/web/selfservice/usage',
        'delphixpy/v1_11_21/web/selfservice/usage/branch',
        'delphixpy/v1_11_21/web/selfservice/usage/user',
        'delphixpy/v1_11_21/web/selfservice/usage/container',
        'delphixpy/v1_11_21/web/selfservice/usage/bookmark',
        'delphixpy/v1_11_21/web/selfservice/usage/bookmark/tag',
        'delphixpy/v1_11_21/web/selfservice/usage/template',
        'delphixpy/v1_11_21/web/selfservice/config',
        'delphixpy/v1_11_21/web/snapshot',
        'delphixpy/v1_11_21/web/sourceconfig',
        'delphixpy/v1_11_21/web/namespace',
        'delphixpy/v1_11_21/web/replication',
        'delphixpy/v1_11_21/web/replication/spec',
        'delphixpy/v1_11_21/web/replication/targetstate',
        'delphixpy/v1_11_21/web/replication/sourcestate',
        'delphixpy/v1_11_21/web/replication/serializationpoint',
        'delphixpy/v1_11_21/web/source',
        'delphixpy/v1_11_21/web/source/operationTemplate',
        'delphixpy/v1_11_21/web/service',
        'delphixpy/v1_11_21/web/service/smtp',
        'delphixpy/v1_11_21/web/service/ldap',
        'delphixpy/v1_11_21/web/service/ldap/server',
        'delphixpy/v1_11_21/web/service/nfs',
        'delphixpy/v1_11_21/web/service/host',
        'delphixpy/v1_11_21/web/service/host/address',
        'delphixpy/v1_11_21/web/service/snmp',
        'delphixpy/v1_11_21/web/service/snmp/v3',
        'delphixpy/v1_11_21/web/service/snmp/v3/manager',
        'delphixpy/v1_11_21/web/service/snmp/v3/usm',
        'delphixpy/v1_11_21/web/service/snmp/v2',
        'delphixpy/v1_11_21/web/service/snmp/v2/manager',
        'delphixpy/v1_11_21/web/service/userInterface',
        'delphixpy/v1_11_21/web/service/linkingsettings',
        'delphixpy/v1_11_21/web/service/phonehome',
        'delphixpy/v1_11_21/web/service/events',
        'delphixpy/v1_11_21/web/service/fluentd',
        'delphixpy/v1_11_21/web/service/fluentd/plugins',
        'delphixpy/v1_11_21/web/service/fluentd/configuration',
        'delphixpy/v1_11_21/web/service/httpConnector',
        'delphixpy/v1_11_21/web/service/userPaths',
        'delphixpy/v1_11_21/web/service/security',
        'delphixpy/v1_11_21/web/service/dns',
        'delphixpy/v1_11_21/web/service/kerberos',
        'delphixpy/v1_11_21/web/service/schema',
        'delphixpy/v1_11_21/web/service/tls',
        'delphixpy/v1_11_21/web/service/tls/endEntityCertificate',
        'delphixpy/v1_11_21/web/service/tls/csr',
        'delphixpy/v1_11_21/web/service/tls/cipherSuite',
        'delphixpy/v1_11_21/web/service/tls/caCertificate',
        'delphixpy/v1_11_21/web/service/insight',
        'delphixpy/v1_11_21/web/service/insight/splunkHec',
        'delphixpy/v1_11_21/web/service/locale',
        'delphixpy/v1_11_21/web/service/cloud',
        'delphixpy/v1_11_21/web/service/proxy',
        'delphixpy/v1_11_21/web/service/time',
        'delphixpy/v1_11_21/web/service/syslog',
        'delphixpy/v1_11_21/web/service/passwordReset',
        'delphixpy/v1_11_21/web/service/support',
        'delphixpy/v1_11_21/web/service/support/access',
        'delphixpy/v1_11_21/web/service/support/bundle',
        'delphixpy/v1_11_21/web/service/minimalPhonehome',
        'delphixpy/v1_11_21/web/service/passwordVault',
        'delphixpy/v1_11_21/web/service/oauth2',
        'delphixpy/v1_11_21/web/service/sso',
        'delphixpy/v1_11_21/web/system',
        'delphixpy/v1_11_21/web/system/verification',
        'delphixpy/v1_11_21/web/system/verification/reports',
        'delphixpy/v1_11_21/web/system/verification/reports/steps',
        'delphixpy/v1_11_21/web/system/advancedSettings',
        'delphixpy/v1_11_21/web/system/upgradeCheckResult',
        'delphixpy/v1_11_21/web/system/status',
        'delphixpy/v1_11_21/web/system/version',
        'delphixpy/v1_11_21/web/network',
        'delphixpy/v1_11_21/web/network/route',
        'delphixpy/v1_11_21/web/network/test',
        'delphixpy/v1_11_21/web/network/test/latency',
        'delphixpy/v1_11_21/web/network/test/throughput',
        'delphixpy/v1_11_21/web/network/test/dsp',
        'delphixpy/v1_11_21/web/network/interface',
        'delphixpy/v1_11_21/web/network/dsp',
        'delphixpy/v1_11_21/web/network/dsp/autotune',
        'delphixpy/v1_11_21/web/session'
    ]
)