# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..types.upserted_user import UpsertedUser
from ..core.request_options import RequestOptions
from ..types.event_response import EventResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.pydantic_utilities import parse_obj_as
from ..errors.bad_request_error import BadRequestError
from ..types.error_body import ErrorBody
from ..errors.unauthorized_error import UnauthorizedError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MetricsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def event(
        self,
        key: str,
        *,
        user: UpsertedUser,
        value: float,
        idempotency_key: typing.Optional[str] = None,
        attributes: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventResponse:
        """
        Increment or decrement the value of a metric for a user.

        Parameters
        ----------
        key : str
            Unique reference of the metric as set when created.

        user : UpsertedUser
            The user that triggered the event.

        value : float
            The value to add to the user's current total for the given metric.

        idempotency_key : typing.Optional[str]
            The idempotency key for the event.

        attributes : typing.Optional[typing.Dict[str, str]]
            Event attributes as key-value pairs. Keys must match existing event attributes set up in the Trophy dashboard.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventResponse
            Created event

        Examples
        --------
        from trophy import TrophyApi, UpsertedUser

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.metrics.event(
            key="words-written",
            idempotency_key="e4296e4b-8493-4bd1-9c30-5a1a9ac4d78f",
            user=UpsertedUser(
                email="user@example.com",
                tz="Europe/London",
                attributes={"department": "engineering", "role": "developer"},
                id="18",
            ),
            value=750.0,
            attributes={"category": "writing", "source": "mobile-app"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"metrics/{jsonable_encoder(key)}/event",
            method="POST",
            json={
                "user": convert_and_respect_annotation_metadata(
                    object_=user, annotation=UpsertedUser, direction="write"
                ),
                "value": value,
                "attributes": attributes,
            },
            headers={
                "content-type": "application/json",
                "Idempotency-Key": str(idempotency_key)
                if idempotency_key is not None
                else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EventResponse,
                    parse_obj_as(
                        type_=EventResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncMetricsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def event(
        self,
        key: str,
        *,
        user: UpsertedUser,
        value: float,
        idempotency_key: typing.Optional[str] = None,
        attributes: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EventResponse:
        """
        Increment or decrement the value of a metric for a user.

        Parameters
        ----------
        key : str
            Unique reference of the metric as set when created.

        user : UpsertedUser
            The user that triggered the event.

        value : float
            The value to add to the user's current total for the given metric.

        idempotency_key : typing.Optional[str]
            The idempotency key for the event.

        attributes : typing.Optional[typing.Dict[str, str]]
            Event attributes as key-value pairs. Keys must match existing event attributes set up in the Trophy dashboard.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EventResponse
            Created event

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi, UpsertedUser

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.metrics.event(
                key="words-written",
                idempotency_key="e4296e4b-8493-4bd1-9c30-5a1a9ac4d78f",
                user=UpsertedUser(
                    email="user@example.com",
                    tz="Europe/London",
                    attributes={"department": "engineering", "role": "developer"},
                    id="18",
                ),
                value=750.0,
                attributes={"category": "writing", "source": "mobile-app"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"metrics/{jsonable_encoder(key)}/event",
            method="POST",
            json={
                "user": convert_and_respect_annotation_metadata(
                    object_=user, annotation=UpsertedUser, direction="write"
                ),
                "value": value,
                "attributes": attributes,
            },
            headers={
                "content-type": "application/json",
                "Idempotency-Key": str(idempotency_key)
                if idempotency_key is not None
                else None,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EventResponse,
                    parse_obj_as(
                        type_=EventResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
