# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from ..core.request_options import RequestOptions
from ..types.points_summary_response import PointsSummaryResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..errors.unauthorized_error import UnauthorizedError
from ..types.error_body import ErrorBody
from ..errors.not_found_error import NotFoundError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.points_system_response import PointsSystemResponse
from ..core.client_wrapper import AsyncClientWrapper


class PointsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def summary(
        self,
        key: str,
        *,
        user_attributes: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PointsSummaryResponse:
        """
        Get a breakdown of the number of users with points in each range.

        Parameters
        ----------
        key : str
            Key of the points system.

        user_attributes : typing.Optional[str]
            Optional colon-delimited user attribute filters in the format attributeKey:value,attributeKey:value. Only users matching ALL specified attributes will be included in the points breakdown.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PointsSummaryResponse
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.points.summary(
            key="points-system-key",
            user_attributes="plan-type:premium,region:us-east",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"points/{jsonable_encoder(key)}/summary",
            method="GET",
            params={
                "userAttributes": user_attributes,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PointsSummaryResponse,
                    parse_obj_as(
                        type_=PointsSummaryResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def system(
        self, key: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PointsSystemResponse:
        """
        Get a points system with all its triggers.

        Parameters
        ----------
        key : str
            Key of the points system.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PointsSystemResponse
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.points.system(
            key="points-system-key",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"points/{jsonable_encoder(key)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PointsSystemResponse,
                    parse_obj_as(
                        type_=PointsSystemResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncPointsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def summary(
        self,
        key: str,
        *,
        user_attributes: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PointsSummaryResponse:
        """
        Get a breakdown of the number of users with points in each range.

        Parameters
        ----------
        key : str
            Key of the points system.

        user_attributes : typing.Optional[str]
            Optional colon-delimited user attribute filters in the format attributeKey:value,attributeKey:value. Only users matching ALL specified attributes will be included in the points breakdown.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PointsSummaryResponse
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.points.summary(
                key="points-system-key",
                user_attributes="plan-type:premium,region:us-east",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"points/{jsonable_encoder(key)}/summary",
            method="GET",
            params={
                "userAttributes": user_attributes,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PointsSummaryResponse,
                    parse_obj_as(
                        type_=PointsSummaryResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def system(
        self, key: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PointsSystemResponse:
        """
        Get a points system with all its triggers.

        Parameters
        ----------
        key : str
            Key of the points system.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PointsSystemResponse
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.points.system(
                key="points-system-key",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"points/{jsonable_encoder(key)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PointsSystemResponse,
                    parse_obj_as(
                        type_=PointsSystemResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
