# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from ..core.request_options import RequestOptions
from ..types.bulk_streak_response import BulkStreakResponse
from ..core.pydantic_utilities import parse_obj_as
from ..errors.unauthorized_error import UnauthorizedError
from ..types.error_body import ErrorBody
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from .types.streaks_rankings_request_type import StreaksRankingsRequestType
from ..types.streak_ranking_user import StreakRankingUser
from ..core.client_wrapper import AsyncClientWrapper


class StreaksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        user_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkStreakResponse:
        """
        Get the streak lengths of a list of users, ranked by streak length from longest to shortest.

        Parameters
        ----------
        user_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of up to 100 user IDs.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkStreakResponse
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.streaks.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "streaks",
            method="GET",
            params={
                "userIds": user_ids,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    BulkStreakResponse,
                    parse_obj_as(
                        type_=BulkStreakResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def rankings(
        self,
        *,
        limit: typing.Optional[int] = None,
        type: typing.Optional[StreaksRankingsRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[StreakRankingUser]:
        """
        Get the top users by streak length (active or longest).

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of users to return. Must be between 1 and 100.

        type : typing.Optional[StreaksRankingsRequestType]
            Whether to rank users by active streaks or longest streaks ever achieved.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[StreakRankingUser]
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.streaks.rankings()
        """
        _response = self._client_wrapper.httpx_client.request(
            "streaks/rankings",
            method="GET",
            params={
                "limit": limit,
                "type": type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[StreakRankingUser],
                    parse_obj_as(
                        type_=typing.List[StreakRankingUser],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncStreaksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        user_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BulkStreakResponse:
        """
        Get the streak lengths of a list of users, ranked by streak length from longest to shortest.

        Parameters
        ----------
        user_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of up to 100 user IDs.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BulkStreakResponse
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.streaks.list()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "streaks",
            method="GET",
            params={
                "userIds": user_ids,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    BulkStreakResponse,
                    parse_obj_as(
                        type_=BulkStreakResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def rankings(
        self,
        *,
        limit: typing.Optional[int] = None,
        type: typing.Optional[StreaksRankingsRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[StreakRankingUser]:
        """
        Get the top users by streak length (active or longest).

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of users to return. Must be between 1 and 100.

        type : typing.Optional[StreaksRankingsRequestType]
            Whether to rank users by active streaks or longest streaks ever achieved.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[StreakRankingUser]
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.streaks.rankings()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "streaks/rankings",
            method="GET",
            params={
                "limit": limit,
                "type": type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[StreakRankingUser],
                    parse_obj_as(
                        type_=typing.List[StreakRankingUser],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
