# This file was auto-generated by Fern from our API Definition.

from .achievement_response import AchievementResponse
import typing
import pydantic
import typing_extensions
from .achievement_with_stats_response_user_attributes_item import (
    AchievementWithStatsResponseUserAttributesItem,
)
from ..core.serialization import FieldMetadata
from .achievement_with_stats_response_event_attribute import (
    AchievementWithStatsResponseEventAttribute,
)
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class AchievementWithStatsResponse(AchievementResponse):
    completions: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of users who have completed this achievement.
    """

    rarity: typing.Optional[float] = pydantic.Field(default=None)
    """
    The percentage of all users who have completed this achievement.
    """

    user_attributes: typing_extensions.Annotated[
        typing.Optional[typing.List[AchievementWithStatsResponseUserAttributesItem]],
        FieldMetadata(alias="userAttributes"),
    ] = pydantic.Field(default=None)
    """
    User attribute filters that must be met for this achievement to be completed. Only present if the achievement has user attribute filters configured.
    """

    event_attribute: typing_extensions.Annotated[
        typing.Optional[AchievementWithStatsResponseEventAttribute],
        FieldMetadata(alias="eventAttribute"),
    ] = pydantic.Field(default=None)
    """
    Event attribute filter that must be met for this achievement to be completed. Only present if the achievement has an event filter configured.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
