# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
from .metric_status import MetricStatus
import typing
from .completed_achievement_response import CompletedAchievementResponse
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class MetricResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The unique ID of the metric.
    """

    key: str = pydantic.Field()
    """
    The unique key of the metric.
    """

    name: str = pydantic.Field()
    """
    The name of the metric.
    """

    status: MetricStatus = pydantic.Field()
    """
    The status of the metric.
    """

    current: float = pydantic.Field()
    """
    The user's current total for the metric.
    """

    achievements: typing.List[CompletedAchievementResponse] = pydantic.Field()
    """
    A list of the metric's achievements and the user's progress towards each.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
