# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
import typing_extensions
from ..core.serialization import FieldMetadata
from .points_trigger_response import PointsTriggerResponse
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class PointsSystemResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The unique ID of the points system.
    """

    name: str = pydantic.Field()
    """
    The name of the points system.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the points system.
    """

    badge_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="badgeUrl")
    ] = pydantic.Field(default=None)
    """
    The URL of the badge image for the points system, if one has been uploaded.
    """

    triggers: typing.List[PointsTriggerResponse] = pydantic.Field()
    """
    Array of active triggers for this points system.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
