# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .points_trigger_type import PointsTriggerType
import typing_extensions
from ..core.serialization import FieldMetadata
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class PointsTrigger(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the trigger
    """

    type: typing.Optional[PointsTriggerType] = pydantic.Field(default=None)
    """
    The type of trigger
    """

    points: typing.Optional[float] = pydantic.Field(default=None)
    """
    The points awarded by this trigger.
    """

    metric_name: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="metricName")
    ] = pydantic.Field(default=None)
    """
    If the trigger has type 'metric', the name of the metric
    """

    metric_threshold: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="metricThreshold")
    ] = pydantic.Field(default=None)
    """
    If the trigger has type 'metric', the threshold of the metric that triggers the points
    """

    streak_length_threshold: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="streakLengthThreshold")
    ] = pydantic.Field(default=None)
    """
    If the trigger has type 'streak', the threshold of the streak that triggers the points
    """

    achievement_name: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="achievementName")
    ] = pydantic.Field(default=None)
    """
    If the trigger has type 'achievement', the name of the achievement
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
