# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing_extensions
from ..core.serialization import FieldMetadata
import pydantic
import typing
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class StreakRankingUser(UniversalBaseModel):
    """
    A user with their streak length in the rankings.
    """

    user_id: typing_extensions.Annotated[str, FieldMetadata(alias="userId")] = (
        pydantic.Field()
    )
    """
    The ID of the user.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the user. May be null if no name is set.
    """

    streak_length: typing_extensions.Annotated[
        int, FieldMetadata(alias="streakLength")
    ] = pydantic.Field()
    """
    The user's streak length (active or longest depending on query parameter).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
