# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
import typing_extensions
from ..core.serialization import FieldMetadata
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class UpdatedUser(UniversalBaseModel):
    """
    An object with editable user fields.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user's email address. Required if subscribeToEmails is true.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name to refer to the user by in emails.
    """

    tz: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user's timezone (used for email scheduling).
    """

    device_tokens: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="deviceTokens")
    ] = pydantic.Field(default=None)
    """
    The user's device tokens, used for push notifications.
    """

    subscribe_to_emails: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="subscribeToEmails")
    ] = pydantic.Field(default=None)
    """
    Whether the user should receive Trophy-powered emails. If false, Trophy will not store the user's email address.
    """

    attributes: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    User attributes as key-value pairs. Keys must match existing user attributes set up in the Trophy dashboard.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
