# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.user import User
from ..core.pydantic_utilities import parse_obj_as
from ..errors.bad_request_error import BadRequestError
from ..types.error_body import ErrorBody
from ..errors.unauthorized_error import UnauthorizedError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.jsonable_encoder import jsonable_encoder
from ..errors.not_found_error import NotFoundError
from ..types.metric_response import MetricResponse
from .types.users_metric_event_summary_request_aggregation import (
    UsersMetricEventSummaryRequestAggregation,
)
from .types.users_metric_event_summary_response_item import (
    UsersMetricEventSummaryResponseItem,
)
from ..types.completed_achievement_response import CompletedAchievementResponse
from ..types.streak_response import StreakResponse
from ..types.get_user_points_response import GetUserPointsResponse
from .types.users_points_event_summary_request_aggregation import (
    UsersPointsEventSummaryRequestAggregation,
)
from .types.users_points_event_summary_response_item import (
    UsersPointsEventSummaryResponseItem,
)
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        id: str,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tz: typing.Optional[str] = OMIT,
        device_tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        subscribe_to_emails: typing.Optional[bool] = OMIT,
        attributes: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Create a new user.

        Parameters
        ----------
        id : str
            The ID of the user in your database. Must be a string.

        email : typing.Optional[str]
            The user's email address. Required if subscribeToEmails is true.

        name : typing.Optional[str]
            The name to refer to the user by in emails.

        tz : typing.Optional[str]
            The user's timezone (used for email scheduling).

        device_tokens : typing.Optional[typing.Sequence[str]]
            The user's device tokens, used for push notifications.

        subscribe_to_emails : typing.Optional[bool]
            Whether the user should receive Trophy-powered emails. If false, Trophy will not store the user's email address.

        attributes : typing.Optional[typing.Dict[str, str]]
            User attributes as key-value pairs. Keys must match existing user attributes set up in the Trophy dashboard.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Identified user

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.create(
            id="user-id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "users",
            method="POST",
            json={
                "id": id,
                "email": email,
                "name": name,
                "tz": tz,
                "deviceTokens": device_tokens,
                "subscribeToEmails": subscribe_to_emails,
                "attributes": attributes,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> User:
        """
        Get a single user.

        Parameters
        ----------
        id : str
            ID of the user to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Found user

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.get(
            id="userId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def identify(
        self,
        id: str,
        *,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tz: typing.Optional[str] = OMIT,
        device_tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        subscribe_to_emails: typing.Optional[bool] = OMIT,
        attributes: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Identify a user.

        Parameters
        ----------
        id : str
            ID of the user to identify.

        email : typing.Optional[str]
            The user's email address. Required if subscribeToEmails is true.

        name : typing.Optional[str]
            The name to refer to the user by in emails.

        tz : typing.Optional[str]
            The user's timezone (used for email scheduling).

        device_tokens : typing.Optional[typing.Sequence[str]]
            The user's device tokens, used for push notifications.

        subscribe_to_emails : typing.Optional[bool]
            Whether the user should receive Trophy-powered emails. If false, Trophy will not store the user's email address.

        attributes : typing.Optional[typing.Dict[str, str]]
            User attributes as key-value pairs. Keys must match existing user attributes set up in the Trophy dashboard.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Upserted user

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.identify(
            id="id",
            email="user@example.com",
            tz="Europe/London",
            attributes={"department": "engineering", "role": "developer"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "email": email,
                "name": name,
                "tz": tz,
                "deviceTokens": device_tokens,
                "subscribeToEmails": subscribe_to_emails,
                "attributes": attributes,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        id: str,
        *,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tz: typing.Optional[str] = OMIT,
        device_tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        subscribe_to_emails: typing.Optional[bool] = OMIT,
        attributes: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Update a user.

        Parameters
        ----------
        id : str
            ID of the user to update.

        email : typing.Optional[str]
            The user's email address. Required if subscribeToEmails is true.

        name : typing.Optional[str]
            The name to refer to the user by in emails.

        tz : typing.Optional[str]
            The user's timezone (used for email scheduling).

        device_tokens : typing.Optional[typing.Sequence[str]]
            The user's device tokens, used for push notifications.

        subscribe_to_emails : typing.Optional[bool]
            Whether the user should receive Trophy-powered emails. If false, Trophy will not store the user's email address.

        attributes : typing.Optional[typing.Dict[str, str]]
            User attributes as key-value pairs. Keys must match existing user attributes set up in the Trophy dashboard.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Updated user

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.update(
            id="id",
            email="user@example.com",
            tz="Europe/London",
            attributes={"department": "engineering", "role": "developer"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "email": email,
                "name": name,
                "tz": tz,
                "deviceTokens": device_tokens,
                "subscribeToEmails": subscribe_to_emails,
                "attributes": attributes,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def all_metrics(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[MetricResponse]:
        """
        Get a single user's progress against all active metrics.

        Parameters
        ----------
        id : str
            ID of the user

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[MetricResponse]
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.all_metrics(
            id="userId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/metrics",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[MetricResponse],
                    parse_obj_as(
                        type_=typing.List[MetricResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def single_metric(
        self,
        id: str,
        key: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetricResponse:
        """
        Get a user's progress against a single active metric.

        Parameters
        ----------
        id : str
            ID of the user.

        key : str
            Unique key of the metric.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricResponse
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.single_metric(
            id="userId",
            key="key",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/metrics/{jsonable_encoder(key)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    MetricResponse,
                    parse_obj_as(
                        type_=MetricResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def metric_event_summary(
        self,
        id: str,
        key: str,
        *,
        aggregation: UsersMetricEventSummaryRequestAggregation,
        start_date: str,
        end_date: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[UsersMetricEventSummaryResponseItem]:
        """
        Get a summary of metric events over time for a user.

        Parameters
        ----------
        id : str
            ID of the user.

        key : str
            Unique key of the metric.

        aggregation : UsersMetricEventSummaryRequestAggregation
            The time period over which to aggregate the event data.

        start_date : str
            The start date for the data range in YYYY-MM-DD format. The startDate must be before the endDate, and the date range must not exceed 400 days.

        end_date : str
            The end date for the data range in YYYY-MM-DD format. The endDate must be after the startDate, and the date range must not exceed 400 days.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[UsersMetricEventSummaryResponseItem]
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.metric_event_summary(
            id="userId",
            key="words-written",
            aggregation="daily",
            start_date="2024-01-01",
            end_date="2024-01-31",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/metrics/{jsonable_encoder(key)}/event-summary",
            method="GET",
            params={
                "aggregation": aggregation,
                "startDate": start_date,
                "endDate": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[UsersMetricEventSummaryResponseItem],
                    parse_obj_as(
                        type_=typing.List[UsersMetricEventSummaryResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def achievements(
        self,
        id: str,
        *,
        include_incomplete: typing.Optional[typing.Literal["true"]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[CompletedAchievementResponse]:
        """
        Get a user's achievements.

        Parameters
        ----------
        id : str
            ID of the user.

        include_incomplete : typing.Optional[typing.Literal["true"]]
            When set to 'true', returns both completed and incomplete achievements for the user. When omitted or set to any other value, returns only completed achievements.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[CompletedAchievementResponse]
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.achievements(
            id="userId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/achievements",
            method="GET",
            params={
                "includeIncomplete": include_incomplete,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[CompletedAchievementResponse],
                    parse_obj_as(
                        type_=typing.List[CompletedAchievementResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def streak(
        self,
        id: str,
        *,
        history_periods: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StreakResponse:
        """
        Get a user's streak data.

        Parameters
        ----------
        id : str
            ID of the user.

        history_periods : typing.Optional[int]
            The number of past streak periods to include in the streakHistory field of the  response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StreakResponse
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.streak(
            id="userId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/streak",
            method="GET",
            params={
                "historyPeriods": history_periods,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    StreakResponse,
                    parse_obj_as(
                        type_=StreakResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def points(
        self,
        id: str,
        key: str,
        *,
        awards: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetUserPointsResponse:
        """
        Get a user's points for a specific points system.

        Parameters
        ----------
        id : str
            ID of the user.

        key : str
            Key of the points system.

        awards : typing.Optional[int]
            The number of recent point awards to return.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserPointsResponse
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.points(
            id="userId",
            key="points-system-key",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/points/{jsonable_encoder(key)}",
            method="GET",
            params={
                "awards": awards,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetUserPointsResponse,
                    parse_obj_as(
                        type_=GetUserPointsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def points_event_summary(
        self,
        id: str,
        key: str,
        *,
        aggregation: UsersPointsEventSummaryRequestAggregation,
        start_date: str,
        end_date: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[UsersPointsEventSummaryResponseItem]:
        """
        Get a summary of points awards over time for a user for a specific points system.

        Parameters
        ----------
        id : str
            ID of the user.

        key : str
            Key of the points system.

        aggregation : UsersPointsEventSummaryRequestAggregation
            The time period over which to aggregate the event data.

        start_date : str
            The start date for the data range in YYYY-MM-DD format. The startDate must be before the endDate, and the date range must not exceed 400 days.

        end_date : str
            The end date for the data range in YYYY-MM-DD format. The endDate must be after the startDate, and the date range must not exceed 400 days.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[UsersPointsEventSummaryResponseItem]
            Successful operation

        Examples
        --------
        from trophy import TrophyApi

        client = TrophyApi(
            api_key="YOUR_API_KEY",
        )
        client.users.points_event_summary(
            id="userId",
            key="points-system-key",
            aggregation="daily",
            start_date="2024-01-01",
            end_date="2024-01-31",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/points/{jsonable_encoder(key)}/event-summary",
            method="GET",
            params={
                "aggregation": aggregation,
                "startDate": start_date,
                "endDate": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[UsersPointsEventSummaryResponseItem],
                    parse_obj_as(
                        type_=typing.List[UsersPointsEventSummaryResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncUsersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        id: str,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tz: typing.Optional[str] = OMIT,
        device_tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        subscribe_to_emails: typing.Optional[bool] = OMIT,
        attributes: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Create a new user.

        Parameters
        ----------
        id : str
            The ID of the user in your database. Must be a string.

        email : typing.Optional[str]
            The user's email address. Required if subscribeToEmails is true.

        name : typing.Optional[str]
            The name to refer to the user by in emails.

        tz : typing.Optional[str]
            The user's timezone (used for email scheduling).

        device_tokens : typing.Optional[typing.Sequence[str]]
            The user's device tokens, used for push notifications.

        subscribe_to_emails : typing.Optional[bool]
            Whether the user should receive Trophy-powered emails. If false, Trophy will not store the user's email address.

        attributes : typing.Optional[typing.Dict[str, str]]
            User attributes as key-value pairs. Keys must match existing user attributes set up in the Trophy dashboard.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Identified user

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.create(
                id="user-id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "users",
            method="POST",
            json={
                "id": id,
                "email": email,
                "name": name,
                "tz": tz,
                "deviceTokens": device_tokens,
                "subscribeToEmails": subscribe_to_emails,
                "attributes": attributes,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> User:
        """
        Get a single user.

        Parameters
        ----------
        id : str
            ID of the user to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Found user

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.get(
                id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def identify(
        self,
        id: str,
        *,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tz: typing.Optional[str] = OMIT,
        device_tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        subscribe_to_emails: typing.Optional[bool] = OMIT,
        attributes: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Identify a user.

        Parameters
        ----------
        id : str
            ID of the user to identify.

        email : typing.Optional[str]
            The user's email address. Required if subscribeToEmails is true.

        name : typing.Optional[str]
            The name to refer to the user by in emails.

        tz : typing.Optional[str]
            The user's timezone (used for email scheduling).

        device_tokens : typing.Optional[typing.Sequence[str]]
            The user's device tokens, used for push notifications.

        subscribe_to_emails : typing.Optional[bool]
            Whether the user should receive Trophy-powered emails. If false, Trophy will not store the user's email address.

        attributes : typing.Optional[typing.Dict[str, str]]
            User attributes as key-value pairs. Keys must match existing user attributes set up in the Trophy dashboard.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Upserted user

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.identify(
                id="id",
                email="user@example.com",
                tz="Europe/London",
                attributes={"department": "engineering", "role": "developer"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "email": email,
                "name": name,
                "tz": tz,
                "deviceTokens": device_tokens,
                "subscribeToEmails": subscribe_to_emails,
                "attributes": attributes,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        id: str,
        *,
        email: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        tz: typing.Optional[str] = OMIT,
        device_tokens: typing.Optional[typing.Sequence[str]] = OMIT,
        subscribe_to_emails: typing.Optional[bool] = OMIT,
        attributes: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Update a user.

        Parameters
        ----------
        id : str
            ID of the user to update.

        email : typing.Optional[str]
            The user's email address. Required if subscribeToEmails is true.

        name : typing.Optional[str]
            The name to refer to the user by in emails.

        tz : typing.Optional[str]
            The user's timezone (used for email scheduling).

        device_tokens : typing.Optional[typing.Sequence[str]]
            The user's device tokens, used for push notifications.

        subscribe_to_emails : typing.Optional[bool]
            Whether the user should receive Trophy-powered emails. If false, Trophy will not store the user's email address.

        attributes : typing.Optional[typing.Dict[str, str]]
            User attributes as key-value pairs. Keys must match existing user attributes set up in the Trophy dashboard.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            Updated user

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.update(
                id="id",
                email="user@example.com",
                tz="Europe/London",
                attributes={"department": "engineering", "role": "developer"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "email": email,
                "name": name,
                "tz": tz,
                "deviceTokens": device_tokens,
                "subscribeToEmails": subscribe_to_emails,
                "attributes": attributes,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    User,
                    parse_obj_as(
                        type_=User,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def all_metrics(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[MetricResponse]:
        """
        Get a single user's progress against all active metrics.

        Parameters
        ----------
        id : str
            ID of the user

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[MetricResponse]
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.all_metrics(
                id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/metrics",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[MetricResponse],
                    parse_obj_as(
                        type_=typing.List[MetricResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def single_metric(
        self,
        id: str,
        key: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetricResponse:
        """
        Get a user's progress against a single active metric.

        Parameters
        ----------
        id : str
            ID of the user.

        key : str
            Unique key of the metric.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricResponse
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.single_metric(
                id="userId",
                key="key",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/metrics/{jsonable_encoder(key)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    MetricResponse,
                    parse_obj_as(
                        type_=MetricResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def metric_event_summary(
        self,
        id: str,
        key: str,
        *,
        aggregation: UsersMetricEventSummaryRequestAggregation,
        start_date: str,
        end_date: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[UsersMetricEventSummaryResponseItem]:
        """
        Get a summary of metric events over time for a user.

        Parameters
        ----------
        id : str
            ID of the user.

        key : str
            Unique key of the metric.

        aggregation : UsersMetricEventSummaryRequestAggregation
            The time period over which to aggregate the event data.

        start_date : str
            The start date for the data range in YYYY-MM-DD format. The startDate must be before the endDate, and the date range must not exceed 400 days.

        end_date : str
            The end date for the data range in YYYY-MM-DD format. The endDate must be after the startDate, and the date range must not exceed 400 days.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[UsersMetricEventSummaryResponseItem]
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.metric_event_summary(
                id="userId",
                key="words-written",
                aggregation="daily",
                start_date="2024-01-01",
                end_date="2024-01-31",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/metrics/{jsonable_encoder(key)}/event-summary",
            method="GET",
            params={
                "aggregation": aggregation,
                "startDate": start_date,
                "endDate": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[UsersMetricEventSummaryResponseItem],
                    parse_obj_as(
                        type_=typing.List[UsersMetricEventSummaryResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def achievements(
        self,
        id: str,
        *,
        include_incomplete: typing.Optional[typing.Literal["true"]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[CompletedAchievementResponse]:
        """
        Get a user's achievements.

        Parameters
        ----------
        id : str
            ID of the user.

        include_incomplete : typing.Optional[typing.Literal["true"]]
            When set to 'true', returns both completed and incomplete achievements for the user. When omitted or set to any other value, returns only completed achievements.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[CompletedAchievementResponse]
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.achievements(
                id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/achievements",
            method="GET",
            params={
                "includeIncomplete": include_incomplete,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[CompletedAchievementResponse],
                    parse_obj_as(
                        type_=typing.List[CompletedAchievementResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def streak(
        self,
        id: str,
        *,
        history_periods: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StreakResponse:
        """
        Get a user's streak data.

        Parameters
        ----------
        id : str
            ID of the user.

        history_periods : typing.Optional[int]
            The number of past streak periods to include in the streakHistory field of the  response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StreakResponse
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.streak(
                id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/streak",
            method="GET",
            params={
                "historyPeriods": history_periods,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    StreakResponse,
                    parse_obj_as(
                        type_=StreakResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def points(
        self,
        id: str,
        key: str,
        *,
        awards: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetUserPointsResponse:
        """
        Get a user's points for a specific points system.

        Parameters
        ----------
        id : str
            ID of the user.

        key : str
            Key of the points system.

        awards : typing.Optional[int]
            The number of recent point awards to return.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserPointsResponse
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.points(
                id="userId",
                key="points-system-key",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/points/{jsonable_encoder(key)}",
            method="GET",
            params={
                "awards": awards,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetUserPointsResponse,
                    parse_obj_as(
                        type_=GetUserPointsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def points_event_summary(
        self,
        id: str,
        key: str,
        *,
        aggregation: UsersPointsEventSummaryRequestAggregation,
        start_date: str,
        end_date: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[UsersPointsEventSummaryResponseItem]:
        """
        Get a summary of points awards over time for a user for a specific points system.

        Parameters
        ----------
        id : str
            ID of the user.

        key : str
            Key of the points system.

        aggregation : UsersPointsEventSummaryRequestAggregation
            The time period over which to aggregate the event data.

        start_date : str
            The start date for the data range in YYYY-MM-DD format. The startDate must be before the endDate, and the date range must not exceed 400 days.

        end_date : str
            The end date for the data range in YYYY-MM-DD format. The endDate must be after the startDate, and the date range must not exceed 400 days.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[UsersPointsEventSummaryResponseItem]
            Successful operation

        Examples
        --------
        import asyncio

        from trophy import AsyncTrophyApi

        client = AsyncTrophyApi(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.users.points_event_summary(
                id="userId",
                key="points-system-key",
                aggregation="daily",
                start_date="2024-01-01",
                end_date="2024-01-31",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"users/{jsonable_encoder(id)}/points/{jsonable_encoder(key)}/event-summary",
            method="GET",
            params={
                "aggregation": aggregation,
                "startDate": start_date,
                "endDate": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[UsersPointsEventSummaryResponseItem],
                    parse_obj_as(
                        type_=typing.List[UsersPointsEventSummaryResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        ErrorBody,
                        parse_obj_as(
                            type_=ErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
