import os
import mimetypes

class InputFile:
    @classmethod
    def from_path(cls, path):
        instance = cls()
        instance.path = path
        instance.filename = os.path.basename(path)
        instance.mime_type = mimetypes.guess_type(path)
        instance.source_type = 'path'
        return instance

    @classmethod
    def from_bytes(cls, bytes, filename, mime_type = None):
        instance = cls()
        instance.data = bytes
        instance.filename = filename
        instance.mime_type = mime_type
        instance.source_type = 'bytes'
        return instance