"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaArmFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
class LambdaArmFunction extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.runtime === lambda.Runtime.NODEJS_12_X) {
            cdk.Annotations.of(this).addWarning('You are using Node.js 12.x at ARM');
        }
        else if (props.runtime === lambda.Runtime.NODEJS_14_X) {
            cdk.Annotations.of(this).addWarning('You are using Node.js 14.x at ARM');
        }
        else if (props.runtime === lambda.Runtime.PYTHON_3_8) {
            cdk.Annotations.of(this).addWarning('You are using Python 3.8 at ARM');
        }
        else if (props.runtime === lambda.Runtime.PYTHON_3_9) {
            cdk.Annotations.of(this).addWarning('You are using Python 3.9 at ARM');
        }
        else if (props.runtime === lambda.Runtime.JAVA_8_CORRETTO) {
            cdk.Annotations.of(this).addWarning('You are using Java 8 on al2 at ARM');
        }
        else if (props.runtime === lambda.Runtime.JAVA_11) {
            cdk.Annotations.of(this).addWarning('You are using Java 11 at ARM');
        }
        else if (props.runtime === lambda.Runtime.DOTNET_CORE_3_1) {
            cdk.Annotations.of(this).addWarning('You are using DOTNET CORE 3.1 at ARM');
        }
        else if (props.runtime === lambda.Runtime.RUBY_2_7) {
            cdk.Annotations.of(this).addWarning('You are using RUBY 2.7 at ARM');
        }
        else {
            throw new Error(`Invalid Runtime ${props.runtime} at ARM, See https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html?icmpid=docs_lambda_rss`);
        }
        this.lambdaFunction = new lambda.Function(this, 'LambdaFunction', { architecture: lambda.Architecture.ARM_64, ...props });
    }
}
exports.LambdaArmFunction = LambdaArmFunction;
_a = JSII_RTTI_SYMBOL_1;
LambdaArmFunction[_a] = { fqn: "cdk-common.LambdaArmFunction", version: "2.0.1017" };
//# sourceMappingURL=data:application/json;base64,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