"use strict";
/*
 * Invoked as part of the "build" script of this package,
 * this script takes all specification fragments in the
 * `spec-source` folder and generates a unified specification
 * document at `spec/specification.json`.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const md5 = require("md5");
const massage_spec_1 = require("./massage-spec");
;
const patch_set_1 = require("./patch-set");
async function main() {
    const inputDir = path.join(process.cwd(), 'spec-source');
    const outDir = path.join(process.cwd(), 'spec');
    await generateResourceSpecification(inputDir, path.join(outDir, 'specification.json'));
    await patch_set_1.applyAndWrite(path.join(outDir, 'cfn-lint.json'), path.join(inputDir, 'cfn-lint'));
    await patch_set_1.applyAndWrite(path.join(outDir, 'cfn-docs.json'), path.join(inputDir, 'cfn-docs'));
}
/**
 * Generate CloudFormation resource specification from sources and patches
 */
async function generateResourceSpecification(inputDir, outFile) {
    const spec = { PropertyTypes: {}, ResourceTypes: {}, Fingerprint: '' };
    Object.assign(spec, await patch_set_1.applyPatchSet(path.join(inputDir, 'specification')));
    massage_spec_1.massageSpec(spec);
    spec.Fingerprint = md5(JSON.stringify(massage_spec_1.normalize(spec)));
    await patch_set_1.writeSorted(outFile, spec);
}
main()
    .catch(e => {
    // eslint-disable-next-line no-console
    console.error(e.stack);
    process.exit(-1);
});
//# sourceMappingURL=data:application/json;base64,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