"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isResourceScrutinyType = exports.ResourceScrutinyType = exports.SpecialRefKind = exports.isPrimitiveMapAttribute = exports.isComplexListAttribute = exports.isPrimitiveListAttribute = exports.isMapAttribute = exports.isListAttribute = exports.isPrimitiveAttribute = exports.isTaggableResource = void 0;
const property_1 = require("./property");
/**
 * Determine if the resource supports tags
 *
 * This function combined with isTagProperty determines if the `cdk.TagManager`
 * and `cdk.TaggableResource` can process these tags. If not, standard code
 * generation of properties will be used.
 */
function isTaggableResource(spec) {
    if (spec.Properties === undefined) {
        return false;
    }
    for (const key of Object.keys(spec.Properties)) {
        if (property_1.isTagPropertyName(key) && property_1.isTagProperty(spec.Properties[key])) {
            return true;
        }
    }
    return false;
}
exports.isTaggableResource = isTaggableResource;
function isPrimitiveAttribute(spec) {
    return !!spec.PrimitiveType;
}
exports.isPrimitiveAttribute = isPrimitiveAttribute;
function isListAttribute(spec) {
    return spec.Type === 'List';
}
exports.isListAttribute = isListAttribute;
function isMapAttribute(spec) {
    return spec.Type === 'Map';
}
exports.isMapAttribute = isMapAttribute;
function isPrimitiveListAttribute(spec) {
    return isListAttribute(spec) && !!spec.PrimitiveItemType;
}
exports.isPrimitiveListAttribute = isPrimitiveListAttribute;
function isComplexListAttribute(spec) {
    return isListAttribute(spec) && !!spec.ItemType;
}
exports.isComplexListAttribute = isComplexListAttribute;
function isPrimitiveMapAttribute(spec) {
    return isMapAttribute(spec) && !!spec.PrimitiveItemType;
}
exports.isPrimitiveMapAttribute = isPrimitiveMapAttribute;
/**
 * Type declaration for special values of the "Ref" attribute represents.
 *
 * The attribute can take on more values than these, but these are treated specially.
 */
var SpecialRefKind;
(function (SpecialRefKind) {
    /**
     * No '.ref' member is generated for this type, because it doesn't have a meaningful value.
     */
    SpecialRefKind["None"] = "None";
    /**
     * The generated class will inherit from the built-in 'Arn' type.
     */
    SpecialRefKind["Arn"] = "Arn";
})(SpecialRefKind = exports.SpecialRefKind || (exports.SpecialRefKind = {}));
var ResourceScrutinyType;
(function (ResourceScrutinyType) {
    /**
     * No additional scrutiny
     */
    ResourceScrutinyType["None"] = "None";
    /**
     * An externally attached policy document to a resource
     *
     * (Common for SQS, SNS, S3, ...)
     */
    ResourceScrutinyType["ResourcePolicyResource"] = "ResourcePolicyResource";
    /**
     * This is an IAM policy on an identity resource
     *
     * (Basically saying: this is AWS::IAM::Policy)
     */
    ResourceScrutinyType["IdentityPolicyResource"] = "IdentityPolicyResource";
    /**
     * This is a Lambda Permission policy
     */
    ResourceScrutinyType["LambdaPermission"] = "LambdaPermission";
    /**
     * An ingress rule object
     */
    ResourceScrutinyType["IngressRuleResource"] = "IngressRuleResource";
    /**
     * A set of egress rules
     */
    ResourceScrutinyType["EgressRuleResource"] = "EgressRuleResource";
})(ResourceScrutinyType = exports.ResourceScrutinyType || (exports.ResourceScrutinyType = {}));
function isResourceScrutinyType(str) {
    return ResourceScrutinyType[str] !== undefined;
}
exports.isResourceScrutinyType = isResourceScrutinyType;
//# sourceMappingURL=data:application/json;base64,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