# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceBlockDeviceArgs',
    'InstanceBlockDeviceArgsDict',
    'InstanceNetworkArgs',
    'InstanceNetworkArgsDict',
    'InstancePersonalityArgs',
    'InstancePersonalityArgsDict',
    'InstanceSchedulerHintArgs',
    'InstanceSchedulerHintArgsDict',
    'InstanceVendorOptionsArgs',
    'InstanceVendorOptionsArgsDict',
    'ServerGroupRulesArgs',
    'ServerGroupRulesArgsDict',
    'VolumeAttachVendorOptionsArgs',
    'VolumeAttachVendorOptionsArgsDict',
    'GetInstanceV2NetworkArgs',
    'GetInstanceV2NetworkArgsDict',
]

MYPY = False

if not MYPY:
    class InstanceBlockDeviceArgsDict(TypedDict):
        source_type: pulumi.Input[_builtins.str]
        """
        The source type of the device. Must be one of
        "blank", "image", "volume", or "snapshot". Changing this creates a new
        server.
        """
        boot_index: NotRequired[pulumi.Input[_builtins.int]]
        """
        The boot index of the volume. It defaults to 0.
        Changing this creates a new server.
        """
        delete_on_termination: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Delete the volume / block device upon
        termination of the instance. Defaults to false. Changing this creates a
        new server.
        """
        destination_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type that gets created. Possible values
        are "volume" and "local". Changing this creates a new server.
        """
        device_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The low-level device type that will be used. Most
        common thing is to leave this empty. Changing this creates a new server.
        """
        disk_bus: NotRequired[pulumi.Input[_builtins.str]]
        """
        The low-level disk bus that will be used. Most common
        thing is to leave this empty. Changing this creates a new server.
        """
        guest_format: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the guest server disk file system format,
        such as `ext2`, `ext3`, `ext4`, `xfs` or `swap`. Swap block device mappings
        have the following restrictions: source_type must be blank and destination_type
        must be local and only one swap disk per server and the size of the swap disk
        must be less than or equal to the swap size of the flavor. Changing this
        creates a new server.
        """
        multiattach: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable the attachment of multiattach-capable
        volumes.
        """
        uuid: NotRequired[pulumi.Input[_builtins.str]]
        """
        The UUID of
        the image, volume, or snapshot. Changing this creates a new server.
        """
        volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        The size of the volume to create (in gigabytes). Required
        in the following combinations: source=image and destination=volume,
        source=blank and destination=local, and source=blank and destination=volume.
        Changing this creates a new server.
        """
        volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The volume type that will be used, for example SSD
        or HDD storage. The available options depend on how your specific OpenStack
        cloud is configured and what classes of storage are provided. Changing this
        creates a new server.
        """
elif False:
    InstanceBlockDeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceBlockDeviceArgs:
    def __init__(__self__, *,
                 source_type: pulumi.Input[_builtins.str],
                 boot_index: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 destination_type: Optional[pulumi.Input[_builtins.str]] = None,
                 device_type: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_bus: Optional[pulumi.Input[_builtins.str]] = None,
                 guest_format: Optional[pulumi.Input[_builtins.str]] = None,
                 multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] source_type: The source type of the device. Must be one of
               "blank", "image", "volume", or "snapshot". Changing this creates a new
               server.
        :param pulumi.Input[_builtins.int] boot_index: The boot index of the volume. It defaults to 0.
               Changing this creates a new server.
        :param pulumi.Input[_builtins.bool] delete_on_termination: Delete the volume / block device upon
               termination of the instance. Defaults to false. Changing this creates a
               new server.
        :param pulumi.Input[_builtins.str] destination_type: The type that gets created. Possible values
               are "volume" and "local". Changing this creates a new server.
        :param pulumi.Input[_builtins.str] device_type: The low-level device type that will be used. Most
               common thing is to leave this empty. Changing this creates a new server.
        :param pulumi.Input[_builtins.str] disk_bus: The low-level disk bus that will be used. Most common
               thing is to leave this empty. Changing this creates a new server.
        :param pulumi.Input[_builtins.str] guest_format: Specifies the guest server disk file system format,
               such as `ext2`, `ext3`, `ext4`, `xfs` or `swap`. Swap block device mappings
               have the following restrictions: source_type must be blank and destination_type
               must be local and only one swap disk per server and the size of the swap disk
               must be less than or equal to the swap size of the flavor. Changing this
               creates a new server.
        :param pulumi.Input[_builtins.bool] multiattach: Enable the attachment of multiattach-capable
               volumes.
        :param pulumi.Input[_builtins.str] uuid: The UUID of
               the image, volume, or snapshot. Changing this creates a new server.
        :param pulumi.Input[_builtins.int] volume_size: The size of the volume to create (in gigabytes). Required
               in the following combinations: source=image and destination=volume,
               source=blank and destination=local, and source=blank and destination=volume.
               Changing this creates a new server.
        :param pulumi.Input[_builtins.str] volume_type: The volume type that will be used, for example SSD
               or HDD storage. The available options depend on how your specific OpenStack
               cloud is configured and what classes of storage are provided. Changing this
               creates a new server.
        """
        pulumi.set(__self__, "source_type", source_type)
        if boot_index is not None:
            pulumi.set(__self__, "boot_index", boot_index)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if disk_bus is not None:
            pulumi.set(__self__, "disk_bus", disk_bus)
        if guest_format is not None:
            pulumi.set(__self__, "guest_format", guest_format)
        if multiattach is not None:
            pulumi.set(__self__, "multiattach", multiattach)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The source type of the device. Must be one of
        "blank", "image", "volume", or "snapshot". Changing this creates a new
        server.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The boot index of the volume. It defaults to 0.
        Changing this creates a new server.
        """
        return pulumi.get(self, "boot_index")

    @boot_index.setter
    def boot_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "boot_index", value)

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Delete the volume / block device upon
        termination of the instance. Defaults to false. Changing this creates a
        new server.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type that gets created. Possible values
        are "volume" and "local". Changing this creates a new server.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_type", value)

    @_builtins.property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The low-level device type that will be used. Most
        common thing is to leave this empty. Changing this creates a new server.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_type", value)

    @_builtins.property
    @pulumi.getter(name="diskBus")
    def disk_bus(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The low-level disk bus that will be used. Most common
        thing is to leave this empty. Changing this creates a new server.
        """
        return pulumi.get(self, "disk_bus")

    @disk_bus.setter
    def disk_bus(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_bus", value)

    @_builtins.property
    @pulumi.getter(name="guestFormat")
    def guest_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the guest server disk file system format,
        such as `ext2`, `ext3`, `ext4`, `xfs` or `swap`. Swap block device mappings
        have the following restrictions: source_type must be blank and destination_type
        must be local and only one swap disk per server and the size of the swap disk
        must be less than or equal to the swap size of the flavor. Changing this
        creates a new server.
        """
        return pulumi.get(self, "guest_format")

    @guest_format.setter
    def guest_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guest_format", value)

    @_builtins.property
    @pulumi.getter
    def multiattach(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the attachment of multiattach-capable
        volumes.
        """
        return pulumi.get(self, "multiattach")

    @multiattach.setter
    def multiattach(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multiattach", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of
        the image, volume, or snapshot. Changing this creates a new server.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the volume to create (in gigabytes). Required
        in the following combinations: source=image and destination=volume,
        source=blank and destination=local, and source=blank and destination=volume.
        Changing this creates a new server.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "volume_size", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The volume type that will be used, for example SSD
        or HDD storage. The available options depend on how your specific OpenStack
        cloud is configured and what classes of storage are provided. Changing this
        creates a new server.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class InstanceNetworkArgsDict(TypedDict):
        access_network: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies if this network should be used for
        provisioning access. Accepts true or false. Defaults to false.
        """
        fixed_ip_v4: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies a fixed IPv4 address to be used on this
        network. Changing this creates a new server.
        """
        fixed_ip_v6: NotRequired[pulumi.Input[_builtins.str]]
        mac: NotRequired[pulumi.Input[_builtins.str]]
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The human-readable
        name of the network. Changing this creates a new server.
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        The port UUID of a
        network to attach to the server. Changing this creates a new server.
        """
        uuid: NotRequired[pulumi.Input[_builtins.str]]
        """
        The network UUID to
        attach to the server. Changing this creates a new server.
        """
elif False:
    InstanceNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNetworkArgs:
    def __init__(__self__, *,
                 access_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 fixed_ip_v4: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 mac: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] access_network: Specifies if this network should be used for
               provisioning access. Accepts true or false. Defaults to false.
        :param pulumi.Input[_builtins.str] fixed_ip_v4: Specifies a fixed IPv4 address to be used on this
               network. Changing this creates a new server.
        :param pulumi.Input[_builtins.str] name: The human-readable
               name of the network. Changing this creates a new server.
        :param pulumi.Input[_builtins.str] port: The port UUID of a
               network to attach to the server. Changing this creates a new server.
        :param pulumi.Input[_builtins.str] uuid: The network UUID to
               attach to the server. Changing this creates a new server.
        """
        if access_network is not None:
            pulumi.set(__self__, "access_network", access_network)
        if fixed_ip_v4 is not None:
            pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        if fixed_ip_v6 is not None:
            pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="accessNetwork")
    def access_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if this network should be used for
        provisioning access. Accepts true or false. Defaults to false.
        """
        return pulumi.get(self, "access_network")

    @access_network.setter
    def access_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "access_network", value)

    @_builtins.property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a fixed IPv4 address to be used on this
        network. Changing this creates a new server.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @fixed_ip_v4.setter
    def fixed_ip_v4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip_v4", value)

    @_builtins.property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fixed_ip_v6")

    @fixed_ip_v6.setter
    def fixed_ip_v6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip_v6", value)

    @_builtins.property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable
        name of the network. Changing this creates a new server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port UUID of a
        network to attach to the server. Changing this creates a new server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network UUID to
        attach to the server. Changing this creates a new server.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


if not MYPY:
    class InstancePersonalityArgsDict(TypedDict):
        content: pulumi.Input[_builtins.str]
        """
        The contents of the file. Limited to 255 bytes.
        """
        file: pulumi.Input[_builtins.str]
        """
        The absolute path of the destination file.
        """
elif False:
    InstancePersonalityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePersonalityArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[_builtins.str],
                 file: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] content: The contents of the file. Limited to 255 bytes.
        :param pulumi.Input[_builtins.str] file: The absolute path of the destination file.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "file", file)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        The contents of the file. Limited to 255 bytes.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def file(self) -> pulumi.Input[_builtins.str]:
        """
        The absolute path of the destination file.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file", value)


if not MYPY:
    class InstanceSchedulerHintArgsDict(TypedDict):
        additional_properties: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Arbitrary key/value pairs of additional
        properties to pass to the scheduler.
        """
        build_near_host_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        An IP Address in CIDR form. The instance
        will be placed on a compute node that is in the same subnet.
        """
        different_cells: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The names of cells where not to build the instance.
        """
        different_hosts: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of instance UUIDs. The instance will
        be scheduled on a different host than all other instances.
        """
        group: NotRequired[pulumi.Input[_builtins.str]]
        """
        A UUID of a Server Group. The instance will be placed
        into that group. See reference
        for details on managing servergroup resources
        """
        queries: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A conditional query that a compute node must pass in
        order to host an instance. The query must use the `JsonFilter` syntax
        which is described
        [here](https://docs.openstack.org/nova/latest/admin/configuration/schedulers.html#jsonfilter).
        At this time, only simple queries are supported. Compound queries using
        `and`, `or`, or `not` are not supported. An example of a simple query is:

        ```
        [">=", "$free_ram_mb", "1024"]
        ```
        """
        same_hosts: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of instance UUIDs. The instance will be
        scheduled on the same host of those specified.
        """
        target_cell: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of a cell to host the instance.
        """
elif False:
    InstanceSchedulerHintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceSchedulerHintArgs:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 build_near_host_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 different_cells: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 different_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 same_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_cell: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: Arbitrary key/value pairs of additional
               properties to pass to the scheduler.
        :param pulumi.Input[_builtins.str] build_near_host_ip: An IP Address in CIDR form. The instance
               will be placed on a compute node that is in the same subnet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] different_cells: The names of cells where not to build the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] different_hosts: A list of instance UUIDs. The instance will
               be scheduled on a different host than all other instances.
        :param pulumi.Input[_builtins.str] group: A UUID of a Server Group. The instance will be placed
               into that group. See reference
               for details on managing servergroup resources
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] queries: A conditional query that a compute node must pass in
               order to host an instance. The query must use the `JsonFilter` syntax
               which is described
               [here](https://docs.openstack.org/nova/latest/admin/configuration/schedulers.html#jsonfilter).
               At this time, only simple queries are supported. Compound queries using
               `and`, `or`, or `not` are not supported. An example of a simple query is:
               
               ```
               [">=", "$free_ram_mb", "1024"]
               ```
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] same_hosts: A list of instance UUIDs. The instance will be
               scheduled on the same host of those specified.
        :param pulumi.Input[_builtins.str] target_cell: The name of a cell to host the instance.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if build_near_host_ip is not None:
            pulumi.set(__self__, "build_near_host_ip", build_near_host_ip)
        if different_cells is not None:
            pulumi.set(__self__, "different_cells", different_cells)
        if different_hosts is not None:
            pulumi.set(__self__, "different_hosts", different_hosts)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if same_hosts is not None:
            pulumi.set(__self__, "same_hosts", same_hosts)
        if target_cell is not None:
            pulumi.set(__self__, "target_cell", target_cell)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Arbitrary key/value pairs of additional
        properties to pass to the scheduler.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter(name="buildNearHostIp")
    def build_near_host_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An IP Address in CIDR form. The instance
        will be placed on a compute node that is in the same subnet.
        """
        return pulumi.get(self, "build_near_host_ip")

    @build_near_host_ip.setter
    def build_near_host_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_near_host_ip", value)

    @_builtins.property
    @pulumi.getter(name="differentCells")
    def different_cells(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The names of cells where not to build the instance.
        """
        return pulumi.get(self, "different_cells")

    @different_cells.setter
    def different_cells(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "different_cells", value)

    @_builtins.property
    @pulumi.getter(name="differentHosts")
    def different_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of instance UUIDs. The instance will
        be scheduled on a different host than all other instances.
        """
        return pulumi.get(self, "different_hosts")

    @different_hosts.setter
    def different_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "different_hosts", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A UUID of a Server Group. The instance will be placed
        into that group. See reference
        for details on managing servergroup resources
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A conditional query that a compute node must pass in
        order to host an instance. The query must use the `JsonFilter` syntax
        which is described
        [here](https://docs.openstack.org/nova/latest/admin/configuration/schedulers.html#jsonfilter).
        At this time, only simple queries are supported. Compound queries using
        `and`, `or`, or `not` are not supported. An example of a simple query is:

        ```
        [">=", "$free_ram_mb", "1024"]
        ```
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "queries", value)

    @_builtins.property
    @pulumi.getter(name="sameHosts")
    def same_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of instance UUIDs. The instance will be
        scheduled on the same host of those specified.
        """
        return pulumi.get(self, "same_hosts")

    @same_hosts.setter
    def same_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "same_hosts", value)

    @_builtins.property
    @pulumi.getter(name="targetCell")
    def target_cell(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a cell to host the instance.
        """
        return pulumi.get(self, "target_cell")

    @target_cell.setter
    def target_cell(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_cell", value)


if not MYPY:
    class InstanceVendorOptionsArgsDict(TypedDict):
        detach_ports_before_destroy: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to try to detach all attached
        ports to the vm before destroying it to make sure the port state is correct
        after the vm destruction. This is helpful when the port is not deleted.
        """
        ignore_resize_confirmation: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean to control whether
        to ignore manual confirmation of the instance resizing. This can be helpful
        to work with some OpenStack clouds which automatically confirm resizing of
        instances after some timeout.
        """
elif False:
    InstanceVendorOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceVendorOptionsArgs:
    def __init__(__self__, *,
                 detach_ports_before_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_resize_confirmation: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] detach_ports_before_destroy: Whether to try to detach all attached
               ports to the vm before destroying it to make sure the port state is correct
               after the vm destruction. This is helpful when the port is not deleted.
        :param pulumi.Input[_builtins.bool] ignore_resize_confirmation: Boolean to control whether
               to ignore manual confirmation of the instance resizing. This can be helpful
               to work with some OpenStack clouds which automatically confirm resizing of
               instances after some timeout.
        """
        if detach_ports_before_destroy is not None:
            pulumi.set(__self__, "detach_ports_before_destroy", detach_ports_before_destroy)
        if ignore_resize_confirmation is not None:
            pulumi.set(__self__, "ignore_resize_confirmation", ignore_resize_confirmation)

    @_builtins.property
    @pulumi.getter(name="detachPortsBeforeDestroy")
    def detach_ports_before_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to try to detach all attached
        ports to the vm before destroying it to make sure the port state is correct
        after the vm destruction. This is helpful when the port is not deleted.
        """
        return pulumi.get(self, "detach_ports_before_destroy")

    @detach_ports_before_destroy.setter
    def detach_ports_before_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "detach_ports_before_destroy", value)

    @_builtins.property
    @pulumi.getter(name="ignoreResizeConfirmation")
    def ignore_resize_confirmation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean to control whether
        to ignore manual confirmation of the instance resizing. This can be helpful
        to work with some OpenStack clouds which automatically confirm resizing of
        instances after some timeout.
        """
        return pulumi.get(self, "ignore_resize_confirmation")

    @ignore_resize_confirmation.setter
    def ignore_resize_confirmation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_resize_confirmation", value)


if not MYPY:
    class ServerGroupRulesArgsDict(TypedDict):
        max_server_per_host: NotRequired[pulumi.Input[_builtins.int]]
elif False:
    ServerGroupRulesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerGroupRulesArgs:
    def __init__(__self__, *,
                 max_server_per_host: Optional[pulumi.Input[_builtins.int]] = None):
        if max_server_per_host is not None:
            pulumi.set(__self__, "max_server_per_host", max_server_per_host)

    @_builtins.property
    @pulumi.getter(name="maxServerPerHost")
    def max_server_per_host(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_server_per_host")

    @max_server_per_host.setter
    def max_server_per_host(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_server_per_host", value)


if not MYPY:
    class VolumeAttachVendorOptionsArgsDict(TypedDict):
        ignore_volume_confirmation: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean to control whether
        to ignore volume status confirmation of the attached volume. This can be helpful
        to work with some OpenStack clouds which don't have the Block Storage V3 API available.
        """
elif False:
    VolumeAttachVendorOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachVendorOptionsArgs:
    def __init__(__self__, *,
                 ignore_volume_confirmation: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] ignore_volume_confirmation: Boolean to control whether
               to ignore volume status confirmation of the attached volume. This can be helpful
               to work with some OpenStack clouds which don't have the Block Storage V3 API available.
        """
        if ignore_volume_confirmation is not None:
            pulumi.set(__self__, "ignore_volume_confirmation", ignore_volume_confirmation)

    @_builtins.property
    @pulumi.getter(name="ignoreVolumeConfirmation")
    def ignore_volume_confirmation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean to control whether
        to ignore volume status confirmation of the attached volume. This can be helpful
        to work with some OpenStack clouds which don't have the Block Storage V3 API available.
        """
        return pulumi.get(self, "ignore_volume_confirmation")

    @ignore_volume_confirmation.setter
    def ignore_volume_confirmation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_volume_confirmation", value)


if not MYPY:
    class GetInstanceV2NetworkArgsDict(TypedDict):
        fixed_ip_v4: _builtins.str
        """
        The IPv4 address assigned to this network port.
        """
        fixed_ip_v6: _builtins.str
        """
        The IPv6 address assigned to this network port.
        """
        mac: _builtins.str
        """
        The MAC address assigned to this network interface.
        """
        name: _builtins.str
        """
        The name of the network
        """
        port: _builtins.str
        """
        The port UUID for this network
        """
        uuid: _builtins.str
        """
        The UUID of the network
        """
elif False:
    GetInstanceV2NetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInstanceV2NetworkArgs:
    def __init__(__self__, *,
                 fixed_ip_v4: _builtins.str,
                 fixed_ip_v6: _builtins.str,
                 mac: _builtins.str,
                 name: _builtins.str,
                 port: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str fixed_ip_v4: The IPv4 address assigned to this network port.
        :param _builtins.str fixed_ip_v6: The IPv6 address assigned to this network port.
        :param _builtins.str mac: The MAC address assigned to this network interface.
        :param _builtins.str name: The name of the network
        :param _builtins.str port: The port UUID for this network
        :param _builtins.str uuid: The UUID of the network
        """
        pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> _builtins.str:
        """
        The IPv4 address assigned to this network port.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @fixed_ip_v4.setter
    def fixed_ip_v4(self, value: _builtins.str):
        pulumi.set(self, "fixed_ip_v4", value)

    @_builtins.property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> _builtins.str:
        """
        The IPv6 address assigned to this network port.
        """
        return pulumi.get(self, "fixed_ip_v6")

    @fixed_ip_v6.setter
    def fixed_ip_v6(self, value: _builtins.str):
        pulumi.set(self, "fixed_ip_v6", value)

    @_builtins.property
    @pulumi.getter
    def mac(self) -> _builtins.str:
        """
        The MAC address assigned to this network interface.
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: _builtins.str):
        pulumi.set(self, "mac", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the network
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: _builtins.str):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The port UUID for this network
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: _builtins.str):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID of the network
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: _builtins.str):
        pulumi.set(self, "uuid", value)


