# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeAttachArgs', 'VolumeAttach']

@pulumi.input_type
class VolumeAttachArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 volume_id: pulumi.Input[_builtins.str],
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor_options: Optional[pulumi.Input['VolumeAttachVendorOptionsArgs']] = None):
        """
        The set of arguments for constructing a VolumeAttach resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Instance to attach the Volume to.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the Volume to attach to an Instance.
        :param pulumi.Input[_builtins.bool] multiattach: Enable attachment of multiattach-capable volumes.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Compute client.
               A Compute client is needed to create a volume attachment. If omitted, the
               `region` argument of the provider is used. Changing this creates a
               new volume attachment.
        :param pulumi.Input[_builtins.str] tag: Add a device role tag that is applied to the volume when
               attaching it to the VM. Changing this creates a new volume attachment with
               the new tag. Requires microversion >= 2.49.
        :param pulumi.Input['VolumeAttachVendorOptionsArgs'] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "volume_id", volume_id)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if multiattach is not None:
            pulumi.set(__self__, "multiattach", multiattach)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if vendor_options is not None:
            pulumi.set(__self__, "vendor_options", vendor_options)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Instance to attach the Volume to.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Volume to attach to an Instance.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter
    def multiattach(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable attachment of multiattach-capable volumes.
        """
        return pulumi.get(self, "multiattach")

    @multiattach.setter
    def multiattach(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multiattach", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Compute client.
        A Compute client is needed to create a volume attachment. If omitted, the
        `region` argument of the provider is used. Changing this creates a
        new volume attachment.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add a device role tag that is applied to the volume when
        attaching it to the VM. Changing this creates a new volume attachment with
        the new tag. Requires microversion >= 2.49.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> Optional[pulumi.Input['VolumeAttachVendorOptionsArgs']]:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

    @vendor_options.setter
    def vendor_options(self, value: Optional[pulumi.Input['VolumeAttachVendorOptionsArgs']]):
        pulumi.set(self, "vendor_options", value)


@pulumi.input_type
class _VolumeAttachState:
    def __init__(__self__, *,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor_options: Optional[pulumi.Input['VolumeAttachVendorOptionsArgs']] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeAttach resources.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Instance to attach the Volume to.
        :param pulumi.Input[_builtins.bool] multiattach: Enable attachment of multiattach-capable volumes.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Compute client.
               A Compute client is needed to create a volume attachment. If omitted, the
               `region` argument of the provider is used. Changing this creates a
               new volume attachment.
        :param pulumi.Input[_builtins.str] tag: Add a device role tag that is applied to the volume when
               attaching it to the VM. Changing this creates a new volume attachment with
               the new tag. Requires microversion >= 2.49.
        :param pulumi.Input['VolumeAttachVendorOptionsArgs'] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the Volume to attach to an Instance.
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if multiattach is not None:
            pulumi.set(__self__, "multiattach", multiattach)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if vendor_options is not None:
            pulumi.set(__self__, "vendor_options", vendor_options)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Instance to attach the Volume to.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def multiattach(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable attachment of multiattach-capable volumes.
        """
        return pulumi.get(self, "multiattach")

    @multiattach.setter
    def multiattach(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multiattach", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Compute client.
        A Compute client is needed to create a volume attachment. If omitted, the
        `region` argument of the provider is used. Changing this creates a
        new volume attachment.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add a device role tag that is applied to the volume when
        attaching it to the VM. Changing this creates a new volume attachment with
        the new tag. Requires microversion >= 2.49.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> Optional[pulumi.Input['VolumeAttachVendorOptionsArgs']]:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

    @vendor_options.setter
    def vendor_options(self, value: Optional[pulumi.Input['VolumeAttachVendorOptionsArgs']]):
        pulumi.set(self, "vendor_options", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Volume to attach to an Instance.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)


@pulumi.type_token("openstack:compute/volumeAttach:VolumeAttach")
class VolumeAttach(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor_options: Optional[pulumi.Input[Union['VolumeAttachVendorOptionsArgs', 'VolumeAttachVendorOptionsArgsDict']]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Attaches a Block Storage Volume to an Instance using the OpenStack
        Compute (Nova) v2 API.

        ## Example Usage

        ### Basic attachment of a single volume to a single instance

        ```python
        import pulumi
        import pulumi_openstack as openstack

        volume1 = openstack.blockstorage.Volume("volume_1",
            name="volume_1",
            size=1)
        instance1 = openstack.compute.Instance("instance_1",
            name="instance_1",
            security_groups=["default"])
        va1 = openstack.compute.VolumeAttach("va_1",
            instance_id=instance1.id,
            volume_id=volume1.id)
        ```

        ### Attaching multiple volumes to a single instance

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        volumes = []
        for range in [{"value": i} for i in range(0, 2)]:
            volumes.append(openstack.blockstorage.Volume(f"volumes-{range['value']}",
                name=std.format(input="vol-%02d",
                    args=[range["value"] + 1]).result,
                size=1))
        instance1 = openstack.compute.Instance("instance_1",
            name="instance_1",
            security_groups=["default"])
        attachments = []
        for range in [{"value": i} for i in range(0, 2)]:
            attachments.append(openstack.compute.VolumeAttach(f"attachments-{range['value']}",
                instance_id=instance1.id,
                volume_id=volumes[range["value"]].id))
        pulumi.export("volumeDevices", [__item.device for __item in attachments])
        ```

        Note that the above example will not guarantee that the volumes are attached in
        a deterministic manner. The volumes will be attached in a seemingly random
        order.

        If you want to ensure that the volumes are attached in a given order, create
        explicit dependencies between the volumes, such as:

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        volumes = []
        for range in [{"value": i} for i in range(0, 2)]:
            volumes.append(openstack.blockstorage.Volume(f"volumes-{range['value']}",
                name=std.format(input="vol-%02d",
                    args=[range["value"] + 1]).result,
                size=1))
        instance1 = openstack.compute.Instance("instance_1",
            name="instance_1",
            security_groups=["default"])
        attach1 = openstack.compute.VolumeAttach("attach_1",
            instance_id=instance1.id,
            volume_id=volumes[0].id)
        attach2 = openstack.compute.VolumeAttach("attach_2",
            instance_id=instance1.id,
            volume_id=volumes[1].id,
            opts = pulumi.ResourceOptions(depends_on=[attach1]))
        pulumi.export("volumeDevices", [__item["device"] for __item in attachments])
        ```

        ### Using Multiattach-enabled volumes

        Multiattach Volumes are dependent upon your OpenStack cloud and not all
        clouds support multiattach. Multiattach volumes require a volume_type that has [multiattach enabled](https://docs.openstack.org/cinder/latest/admin/volume-multiattach.html#multiattach-volume-type).

        ```python
        import pulumi
        import pulumi_openstack as openstack

        volume1 = openstack.blockstorage.Volume("volume_1",
            name="volume_1",
            size=1,
            volume_type="multiattach")
        instance1 = openstack.compute.Instance("instance_1",
            name="instance_1",
            security_groups=["default"])
        instance2 = openstack.compute.Instance("instance_2",
            name="instance_2",
            security_groups=["default"])
        va1 = openstack.compute.VolumeAttach("va_1",
            instance_id=instance1.id,
            volume_id=volume1.id,
            multiattach=True)
        va2 = openstack.compute.VolumeAttach("va_2",
            instance_id=instance2.id,
            volume_id=volume1.id,
            multiattach=True,
            opts = pulumi.ResourceOptions(depends_on=[va1]))
        ```

        It is recommended to use `depends_on` for the attach resources
        to enforce the volume attachments to happen one at a time.

        ## Import

        Volume Attachments can be imported using the Instance ID and Volume ID
        separated by a slash, e.g.

        ```sh
        $ pulumi import openstack:compute/volumeAttach:VolumeAttach va_1 89c60255-9bd6-460c-822a-e2b959ede9d2/45670584-225f-46c3-b33e-6707b589b666
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Instance to attach the Volume to.
        :param pulumi.Input[_builtins.bool] multiattach: Enable attachment of multiattach-capable volumes.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Compute client.
               A Compute client is needed to create a volume attachment. If omitted, the
               `region` argument of the provider is used. Changing this creates a
               new volume attachment.
        :param pulumi.Input[_builtins.str] tag: Add a device role tag that is applied to the volume when
               attaching it to the VM. Changing this creates a new volume attachment with
               the new tag. Requires microversion >= 2.49.
        :param pulumi.Input[Union['VolumeAttachVendorOptionsArgs', 'VolumeAttachVendorOptionsArgsDict']] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the Volume to attach to an Instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeAttachArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches a Block Storage Volume to an Instance using the OpenStack
        Compute (Nova) v2 API.

        ## Example Usage

        ### Basic attachment of a single volume to a single instance

        ```python
        import pulumi
        import pulumi_openstack as openstack

        volume1 = openstack.blockstorage.Volume("volume_1",
            name="volume_1",
            size=1)
        instance1 = openstack.compute.Instance("instance_1",
            name="instance_1",
            security_groups=["default"])
        va1 = openstack.compute.VolumeAttach("va_1",
            instance_id=instance1.id,
            volume_id=volume1.id)
        ```

        ### Attaching multiple volumes to a single instance

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        volumes = []
        for range in [{"value": i} for i in range(0, 2)]:
            volumes.append(openstack.blockstorage.Volume(f"volumes-{range['value']}",
                name=std.format(input="vol-%02d",
                    args=[range["value"] + 1]).result,
                size=1))
        instance1 = openstack.compute.Instance("instance_1",
            name="instance_1",
            security_groups=["default"])
        attachments = []
        for range in [{"value": i} for i in range(0, 2)]:
            attachments.append(openstack.compute.VolumeAttach(f"attachments-{range['value']}",
                instance_id=instance1.id,
                volume_id=volumes[range["value"]].id))
        pulumi.export("volumeDevices", [__item.device for __item in attachments])
        ```

        Note that the above example will not guarantee that the volumes are attached in
        a deterministic manner. The volumes will be attached in a seemingly random
        order.

        If you want to ensure that the volumes are attached in a given order, create
        explicit dependencies between the volumes, such as:

        ```python
        import pulumi
        import pulumi_openstack as openstack
        import pulumi_std as std

        volumes = []
        for range in [{"value": i} for i in range(0, 2)]:
            volumes.append(openstack.blockstorage.Volume(f"volumes-{range['value']}",
                name=std.format(input="vol-%02d",
                    args=[range["value"] + 1]).result,
                size=1))
        instance1 = openstack.compute.Instance("instance_1",
            name="instance_1",
            security_groups=["default"])
        attach1 = openstack.compute.VolumeAttach("attach_1",
            instance_id=instance1.id,
            volume_id=volumes[0].id)
        attach2 = openstack.compute.VolumeAttach("attach_2",
            instance_id=instance1.id,
            volume_id=volumes[1].id,
            opts = pulumi.ResourceOptions(depends_on=[attach1]))
        pulumi.export("volumeDevices", [__item["device"] for __item in attachments])
        ```

        ### Using Multiattach-enabled volumes

        Multiattach Volumes are dependent upon your OpenStack cloud and not all
        clouds support multiattach. Multiattach volumes require a volume_type that has [multiattach enabled](https://docs.openstack.org/cinder/latest/admin/volume-multiattach.html#multiattach-volume-type).

        ```python
        import pulumi
        import pulumi_openstack as openstack

        volume1 = openstack.blockstorage.Volume("volume_1",
            name="volume_1",
            size=1,
            volume_type="multiattach")
        instance1 = openstack.compute.Instance("instance_1",
            name="instance_1",
            security_groups=["default"])
        instance2 = openstack.compute.Instance("instance_2",
            name="instance_2",
            security_groups=["default"])
        va1 = openstack.compute.VolumeAttach("va_1",
            instance_id=instance1.id,
            volume_id=volume1.id,
            multiattach=True)
        va2 = openstack.compute.VolumeAttach("va_2",
            instance_id=instance2.id,
            volume_id=volume1.id,
            multiattach=True,
            opts = pulumi.ResourceOptions(depends_on=[va1]))
        ```

        It is recommended to use `depends_on` for the attach resources
        to enforce the volume attachments to happen one at a time.

        ## Import

        Volume Attachments can be imported using the Instance ID and Volume ID
        separated by a slash, e.g.

        ```sh
        $ pulumi import openstack:compute/volumeAttach:VolumeAttach va_1 89c60255-9bd6-460c-822a-e2b959ede9d2/45670584-225f-46c3-b33e-6707b589b666
        ```

        :param str resource_name: The name of the resource.
        :param VolumeAttachArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeAttachArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor_options: Optional[pulumi.Input[Union['VolumeAttachVendorOptionsArgs', 'VolumeAttachVendorOptionsArgsDict']]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeAttachArgs.__new__(VolumeAttachArgs)

            __props__.__dict__["device"] = device
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["multiattach"] = multiattach
            __props__.__dict__["region"] = region
            __props__.__dict__["tag"] = tag
            __props__.__dict__["vendor_options"] = vendor_options
            if volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_id'")
            __props__.__dict__["volume_id"] = volume_id
        super(VolumeAttach, __self__).__init__(
            'openstack:compute/volumeAttach:VolumeAttach',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            device: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            multiattach: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tag: Optional[pulumi.Input[_builtins.str]] = None,
            vendor_options: Optional[pulumi.Input[Union['VolumeAttachVendorOptionsArgs', 'VolumeAttachVendorOptionsArgsDict']]] = None,
            volume_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VolumeAttach':
        """
        Get an existing VolumeAttach resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Instance to attach the Volume to.
        :param pulumi.Input[_builtins.bool] multiattach: Enable attachment of multiattach-capable volumes.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Compute client.
               A Compute client is needed to create a volume attachment. If omitted, the
               `region` argument of the provider is used. Changing this creates a
               new volume attachment.
        :param pulumi.Input[_builtins.str] tag: Add a device role tag that is applied to the volume when
               attaching it to the VM. Changing this creates a new volume attachment with
               the new tag. Requires microversion >= 2.49.
        :param pulumi.Input[Union['VolumeAttachVendorOptionsArgs', 'VolumeAttachVendorOptionsArgsDict']] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        :param pulumi.Input[_builtins.str] volume_id: The ID of the Volume to attach to an Instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeAttachState.__new__(_VolumeAttachState)

        __props__.__dict__["device"] = device
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["multiattach"] = multiattach
        __props__.__dict__["region"] = region
        __props__.__dict__["tag"] = tag
        __props__.__dict__["vendor_options"] = vendor_options
        __props__.__dict__["volume_id"] = volume_id
        return VolumeAttach(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def device(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Instance to attach the Volume to.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def multiattach(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable attachment of multiattach-capable volumes.
        """
        return pulumi.get(self, "multiattach")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Compute client.
        A Compute client is needed to create a volume attachment. If omitted, the
        `region` argument of the provider is used. Changing this creates a
        new volume attachment.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Add a device role tag that is applied to the volume when
        attaching it to the VM. Changing this creates a new volume attachment with
        the new tag. Requires microversion >= 2.49.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> pulumi.Output[Optional['outputs.VolumeAttachVendorOptions']]:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Volume to attach to an Instance.
        """
        return pulumi.get(self, "volume_id")

