# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProjectIdsV3Result',
    'AwaitableGetProjectIdsV3Result',
    'get_project_ids_v3',
    'get_project_ids_v3_output',
]

@pulumi.output_type
class GetProjectIdsV3Result:
    """
    A collection of values returned by getProjectIdsV3.
    """
    def __init__(__self__, description=None, domain_id=None, enabled=None, id=None, ids=None, is_domain=None, name=None, name_regex=None, parent_id=None, region=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if is_domain and not isinstance(is_domain, bool):
            raise TypeError("Expected argument 'is_domain' to be a bool")
        pulumi.set(__self__, "is_domain", is_domain)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> _builtins.str:
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="isDomain")
    def is_domain(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_domain")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetProjectIdsV3Result(GetProjectIdsV3Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectIdsV3Result(
            description=self.description,
            domain_id=self.domain_id,
            enabled=self.enabled,
            id=self.id,
            ids=self.ids,
            is_domain=self.is_domain,
            name=self.name,
            name_regex=self.name_regex,
            parent_id=self.parent_id,
            region=self.region,
            tags=self.tags)


def get_project_ids_v3(domain_id: Optional[_builtins.str] = None,
                       enabled: Optional[_builtins.bool] = None,
                       is_domain: Optional[_builtins.bool] = None,
                       name: Optional[_builtins.str] = None,
                       name_regex: Optional[_builtins.str] = None,
                       parent_id: Optional[_builtins.str] = None,
                       region: Optional[_builtins.str] = None,
                       tags: Optional[Sequence[_builtins.str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectIdsV3Result:
    """
    Use this data source to get a list of OpenStack Project IDs matching the
    specified criteria.

    > **Note:** You _must_ have domain admin or cloud admin privileges in your OpenStack cloud to use
    this datasource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    projects = openstack.identity.get_project_ids_v3(name_regex="^prod.*")
    ```


    :param _builtins.str domain_id: The domain projects belongs to.
    :param _builtins.bool enabled: Whether the project is enabled or disabled. Valid
           values are `true` and `false`. Default is `true`.
    :param _builtins.str name: The name of the project.
    :param _builtins.str name_regex: The regular expression of the name of the project.
           Cannot be used simultaneously with `name`. Unlike filtering by `name` the
           `name_regex` filtering does by client on the result of OpenStack search
           query.
    :param _builtins.str parent_id: The parent of the project.
    :param _builtins.str region: The region in which to obtain the V3 Keystone client.
           If omitted, the `region` argument of the provider is used.
    :param Sequence[_builtins.str] tags: Tags for the project.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['enabled'] = enabled
    __args__['isDomain'] = is_domain
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['parentId'] = parent_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:identity/getProjectIdsV3:getProjectIdsV3', __args__, opts=opts, typ=GetProjectIdsV3Result).value

    return AwaitableGetProjectIdsV3Result(
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        is_domain=pulumi.get(__ret__, 'is_domain'),
        name=pulumi.get(__ret__, 'name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_project_ids_v3_output(domain_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              is_domain: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              parent_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectIdsV3Result]:
    """
    Use this data source to get a list of OpenStack Project IDs matching the
    specified criteria.

    > **Note:** You _must_ have domain admin or cloud admin privileges in your OpenStack cloud to use
    this datasource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    projects = openstack.identity.get_project_ids_v3(name_regex="^prod.*")
    ```


    :param _builtins.str domain_id: The domain projects belongs to.
    :param _builtins.bool enabled: Whether the project is enabled or disabled. Valid
           values are `true` and `false`. Default is `true`.
    :param _builtins.str name: The name of the project.
    :param _builtins.str name_regex: The regular expression of the name of the project.
           Cannot be used simultaneously with `name`. Unlike filtering by `name` the
           `name_regex` filtering does by client on the result of OpenStack search
           query.
    :param _builtins.str parent_id: The parent of the project.
    :param _builtins.str region: The region in which to obtain the V3 Keystone client.
           If omitted, the `region` argument of the provider is used.
    :param Sequence[_builtins.str] tags: Tags for the project.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['enabled'] = enabled
    __args__['isDomain'] = is_domain
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['parentId'] = parent_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:identity/getProjectIdsV3:getProjectIdsV3', __args__, opts=opts, typ=GetProjectIdsV3Result)
    return __ret__.apply(lambda __response__: GetProjectIdsV3Result(
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        is_domain=pulumi.get(__response__, 'is_domain'),
        name=pulumi.get(__response__, 'name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
