# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LimitV3Args', 'LimitV3']

@pulumi.input_type
class LimitV3Args:
    def __init__(__self__, *,
                 resource_limit: pulumi.Input[_builtins.int],
                 resource_name: pulumi.Input[_builtins.str],
                 service_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LimitV3 resource.
        :param pulumi.Input[_builtins.int] resource_limit: Integer for the actual limit.
        :param pulumi.Input[_builtins.str] resource_name: The resource that the limit applies to. Changing
               this creates a new Limit.
        :param pulumi.Input[_builtins.str] service_id: The service the limit applies to. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.str] description: Description of the limit.
        :param pulumi.Input[_builtins.str] domain_id: The domain the limit applies to. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.str] project_id: The project the limit applies to. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new Limit.
        """
        pulumi.set(__self__, "resource_limit", resource_limit)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "service_id", service_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="resourceLimit")
    def resource_limit(self) -> pulumi.Input[_builtins.int]:
        """
        Integer for the actual limit.
        """
        return pulumi.get(self, "resource_limit")

    @resource_limit.setter
    def resource_limit(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "resource_limit", value)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[_builtins.str]:
        """
        The resource that the limit applies to. Changing
        this creates a new Limit.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The service the limit applies to. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the limit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain the limit applies to. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project the limit applies to. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V3 Keystone client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _LimitV3State:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LimitV3 resources.
        :param pulumi.Input[_builtins.str] description: Description of the limit.
        :param pulumi.Input[_builtins.str] domain_id: The domain the limit applies to. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.str] project_id: The project the limit applies to. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.int] resource_limit: Integer for the actual limit.
        :param pulumi.Input[_builtins.str] resource_name: The resource that the limit applies to. Changing
               this creates a new Limit.
        :param pulumi.Input[_builtins.str] service_id: The service the limit applies to. Changing this
               creates a new Limit.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_limit is not None:
            pulumi.set(__self__, "resource_limit", resource_limit)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the limit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain the limit applies to. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project the limit applies to. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V3 Keystone client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceLimit")
    def resource_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Integer for the actual limit.
        """
        return pulumi.get(self, "resource_limit")

    @resource_limit.setter
    def resource_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_limit", value)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource that the limit applies to. Changing
        this creates a new Limit.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service the limit applies to. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)


@pulumi.type_token("openstack:identity/limitV3:LimitV3")
class LimitV3(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a V3 Limit resource within OpenStack Keystone.

        > **Note:** You _must_ have admin privileges in your OpenStack cloud to use
        this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        glance = openstack.identity.get_service(name="glance")
        project1 = openstack.identity.Project("project_1", name="project_1")
        limit1 = openstack.identity.LimitV3("limit_1",
            project_id=project1.id,
            service_id=glance.id,
            resource_name_="image_count_total",
            resource_limit=10,
            description="foo")
        ```

        ## Import

        Limits can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:identity/limitV3:LimitV3 limit_1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the limit.
        :param pulumi.Input[_builtins.str] domain_id: The domain the limit applies to. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.str] project_id: The project the limit applies to. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.int] resource_limit: Integer for the actual limit.
        :param pulumi.Input[_builtins.str] resource_name_: The resource that the limit applies to. Changing
               this creates a new Limit.
        :param pulumi.Input[_builtins.str] service_id: The service the limit applies to. Changing this
               creates a new Limit.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LimitV3Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V3 Limit resource within OpenStack Keystone.

        > **Note:** You _must_ have admin privileges in your OpenStack cloud to use
        this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        glance = openstack.identity.get_service(name="glance")
        project1 = openstack.identity.Project("project_1", name="project_1")
        limit1 = openstack.identity.LimitV3("limit_1",
            project_id=project1.id,
            service_id=glance.id,
            resource_name_="image_count_total",
            resource_limit=10,
            description="foo")
        ```

        ## Import

        Limits can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:identity/limitV3:LimitV3 limit_1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        :param str resource_name: The name of the resource.
        :param LimitV3Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LimitV3Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LimitV3Args.__new__(LimitV3Args)

            __props__.__dict__["description"] = description
            __props__.__dict__["domain_id"] = domain_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if resource_limit is None and not opts.urn:
                raise TypeError("Missing required property 'resource_limit'")
            __props__.__dict__["resource_limit"] = resource_limit
            if resource_name_ is None and not opts.urn:
                raise TypeError("Missing required property 'resource_name_'")
            __props__.__dict__["resource_name"] = resource_name_
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(LimitV3, __self__).__init__(
            'openstack:identity/limitV3:LimitV3',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_limit: Optional[pulumi.Input[_builtins.int]] = None,
            resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
            service_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LimitV3':
        """
        Get an existing LimitV3 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the limit.
        :param pulumi.Input[_builtins.str] domain_id: The domain the limit applies to. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.str] project_id: The project the limit applies to. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new Limit.
        :param pulumi.Input[_builtins.int] resource_limit: Integer for the actual limit.
        :param pulumi.Input[_builtins.str] resource_name_: The resource that the limit applies to. Changing
               this creates a new Limit.
        :param pulumi.Input[_builtins.str] service_id: The service the limit applies to. Changing this
               creates a new Limit.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LimitV3State.__new__(_LimitV3State)

        __props__.__dict__["description"] = description
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_limit"] = resource_limit
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["service_id"] = service_id
        return LimitV3(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the limit.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        The domain the limit applies to. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project the limit applies to. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V3 Keystone client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceLimit")
    def resource_limit(self) -> pulumi.Output[_builtins.int]:
        """
        Integer for the actual limit.
        """
        return pulumi.get(self, "resource_limit")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource that the limit applies to. Changing
        this creates a new Limit.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The service the limit applies to. Changing this
        creates a new Limit.
        """
        return pulumi.get(self, "service_id")

