# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetListenerV2Result',
    'AwaitableGetListenerV2Result',
    'get_listener_v2',
    'get_listener_v2_output',
]

@pulumi.output_type
class GetListenerV2Result:
    """
    A collection of values returned by getListenerV2.
    """
    def __init__(__self__, admin_state_up=None, allowed_cidrs=None, alpn_protocols=None, client_authentication=None, client_ca_tls_container_ref=None, client_crl_container_ref=None, connection_limit=None, default_pool=None, default_pool_id=None, default_tls_container_ref=None, description=None, hsts_include_subdomains=None, hsts_max_age=None, hsts_preload=None, id=None, insert_headers=None, l7policies=None, listener_id=None, loadbalancer_id=None, loadbalancers=None, name=None, operating_status=None, pools=None, project_id=None, protocol=None, protocol_port=None, provisioning_status=None, region=None, sni_container_refs=None, tags=None, timeout_client_data=None, timeout_member_connect=None, timeout_member_data=None, timeout_tcp_inspect=None, tls_ciphers=None, tls_versions=None):
        if admin_state_up and not isinstance(admin_state_up, bool):
            raise TypeError("Expected argument 'admin_state_up' to be a bool")
        pulumi.set(__self__, "admin_state_up", admin_state_up)
        if allowed_cidrs and not isinstance(allowed_cidrs, list):
            raise TypeError("Expected argument 'allowed_cidrs' to be a list")
        pulumi.set(__self__, "allowed_cidrs", allowed_cidrs)
        if alpn_protocols and not isinstance(alpn_protocols, list):
            raise TypeError("Expected argument 'alpn_protocols' to be a list")
        pulumi.set(__self__, "alpn_protocols", alpn_protocols)
        if client_authentication and not isinstance(client_authentication, str):
            raise TypeError("Expected argument 'client_authentication' to be a str")
        pulumi.set(__self__, "client_authentication", client_authentication)
        if client_ca_tls_container_ref and not isinstance(client_ca_tls_container_ref, str):
            raise TypeError("Expected argument 'client_ca_tls_container_ref' to be a str")
        pulumi.set(__self__, "client_ca_tls_container_ref", client_ca_tls_container_ref)
        if client_crl_container_ref and not isinstance(client_crl_container_ref, str):
            raise TypeError("Expected argument 'client_crl_container_ref' to be a str")
        pulumi.set(__self__, "client_crl_container_ref", client_crl_container_ref)
        if connection_limit and not isinstance(connection_limit, int):
            raise TypeError("Expected argument 'connection_limit' to be a int")
        pulumi.set(__self__, "connection_limit", connection_limit)
        if default_pool and not isinstance(default_pool, str):
            raise TypeError("Expected argument 'default_pool' to be a str")
        pulumi.set(__self__, "default_pool", default_pool)
        if default_pool_id and not isinstance(default_pool_id, str):
            raise TypeError("Expected argument 'default_pool_id' to be a str")
        pulumi.set(__self__, "default_pool_id", default_pool_id)
        if default_tls_container_ref and not isinstance(default_tls_container_ref, str):
            raise TypeError("Expected argument 'default_tls_container_ref' to be a str")
        pulumi.set(__self__, "default_tls_container_ref", default_tls_container_ref)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if hsts_include_subdomains and not isinstance(hsts_include_subdomains, bool):
            raise TypeError("Expected argument 'hsts_include_subdomains' to be a bool")
        pulumi.set(__self__, "hsts_include_subdomains", hsts_include_subdomains)
        if hsts_max_age and not isinstance(hsts_max_age, int):
            raise TypeError("Expected argument 'hsts_max_age' to be a int")
        pulumi.set(__self__, "hsts_max_age", hsts_max_age)
        if hsts_preload and not isinstance(hsts_preload, bool):
            raise TypeError("Expected argument 'hsts_preload' to be a bool")
        pulumi.set(__self__, "hsts_preload", hsts_preload)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if insert_headers and not isinstance(insert_headers, dict):
            raise TypeError("Expected argument 'insert_headers' to be a dict")
        pulumi.set(__self__, "insert_headers", insert_headers)
        if l7policies and not isinstance(l7policies, list):
            raise TypeError("Expected argument 'l7policies' to be a list")
        pulumi.set(__self__, "l7policies", l7policies)
        if listener_id and not isinstance(listener_id, str):
            raise TypeError("Expected argument 'listener_id' to be a str")
        pulumi.set(__self__, "listener_id", listener_id)
        if loadbalancer_id and not isinstance(loadbalancer_id, str):
            raise TypeError("Expected argument 'loadbalancer_id' to be a str")
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if loadbalancers and not isinstance(loadbalancers, list):
            raise TypeError("Expected argument 'loadbalancers' to be a list")
        pulumi.set(__self__, "loadbalancers", loadbalancers)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operating_status and not isinstance(operating_status, str):
            raise TypeError("Expected argument 'operating_status' to be a str")
        pulumi.set(__self__, "operating_status", operating_status)
        if pools and not isinstance(pools, list):
            raise TypeError("Expected argument 'pools' to be a list")
        pulumi.set(__self__, "pools", pools)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if protocol_port and not isinstance(protocol_port, int):
            raise TypeError("Expected argument 'protocol_port' to be a int")
        pulumi.set(__self__, "protocol_port", protocol_port)
        if provisioning_status and not isinstance(provisioning_status, str):
            raise TypeError("Expected argument 'provisioning_status' to be a str")
        pulumi.set(__self__, "provisioning_status", provisioning_status)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if sni_container_refs and not isinstance(sni_container_refs, list):
            raise TypeError("Expected argument 'sni_container_refs' to be a list")
        pulumi.set(__self__, "sni_container_refs", sni_container_refs)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if timeout_client_data and not isinstance(timeout_client_data, int):
            raise TypeError("Expected argument 'timeout_client_data' to be a int")
        pulumi.set(__self__, "timeout_client_data", timeout_client_data)
        if timeout_member_connect and not isinstance(timeout_member_connect, int):
            raise TypeError("Expected argument 'timeout_member_connect' to be a int")
        pulumi.set(__self__, "timeout_member_connect", timeout_member_connect)
        if timeout_member_data and not isinstance(timeout_member_data, int):
            raise TypeError("Expected argument 'timeout_member_data' to be a int")
        pulumi.set(__self__, "timeout_member_data", timeout_member_data)
        if timeout_tcp_inspect and not isinstance(timeout_tcp_inspect, int):
            raise TypeError("Expected argument 'timeout_tcp_inspect' to be a int")
        pulumi.set(__self__, "timeout_tcp_inspect", timeout_tcp_inspect)
        if tls_ciphers and not isinstance(tls_ciphers, str):
            raise TypeError("Expected argument 'tls_ciphers' to be a str")
        pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_versions and not isinstance(tls_versions, list):
            raise TypeError("Expected argument 'tls_versions' to be a list")
        pulumi.set(__self__, "tls_versions", tls_versions)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> _builtins.bool:
        """
        The administrative state of the Listener.
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter(name="allowedCidrs")
    def allowed_cidrs(self) -> Sequence[_builtins.str]:
        """
        A list of IPv4, IPv6 or mix of both CIDRs.
        """
        return pulumi.get(self, "allowed_cidrs")

    @_builtins.property
    @pulumi.getter(name="alpnProtocols")
    def alpn_protocols(self) -> Sequence[_builtins.str]:
        """
        A list of ALPN protocols.
        """
        return pulumi.get(self, "alpn_protocols")

    @_builtins.property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> _builtins.str:
        """
        The TLS client authentication mode.
        """
        return pulumi.get(self, "client_authentication")

    @_builtins.property
    @pulumi.getter(name="clientCaTlsContainerRef")
    def client_ca_tls_container_ref(self) -> _builtins.str:
        """
        The ref of the key manager service secret
        containing a PEM format client CA certificate bundle for TERMINATED_HTTPS listeners.
        """
        return pulumi.get(self, "client_ca_tls_container_ref")

    @_builtins.property
    @pulumi.getter(name="clientCrlContainerRef")
    def client_crl_container_ref(self) -> _builtins.str:
        """
        The URI of the key manager service secret
        containing a PEM format CA revocation list file for TERMINATED_HTTPS listeners.
        """
        return pulumi.get(self, "client_crl_container_ref")

    @_builtins.property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> _builtins.int:
        """
        The maximum number of connections allowed for the Loadbalancer.
        """
        return pulumi.get(self, "connection_limit")

    @_builtins.property
    @pulumi.getter(name="defaultPool")
    def default_pool(self) -> _builtins.str:
        """
        The default pool with which the Listener is associated.
        """
        return pulumi.get(self, "default_pool")

    @_builtins.property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> _builtins.str:
        """
        The UUID of default pool.
        """
        return pulumi.get(self, "default_pool_id")

    @_builtins.property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> _builtins.str:
        """
        A reference to a Barbican container of TLS secrets.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the listener.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hstsIncludeSubdomains")
    def hsts_include_subdomains(self) -> _builtins.bool:
        """
        Defines whether the includeSubDomains directive
        should be added to the Strict-Transport-Security HTTP response header.
        """
        return pulumi.get(self, "hsts_include_subdomains")

    @_builtins.property
    @pulumi.getter(name="hstsMaxAge")
    def hsts_max_age(self) -> _builtins.int:
        """
        The value of the max_age directive for the
        Strict-Transport-Security HTTP response header.
        """
        return pulumi.get(self, "hsts_max_age")

    @_builtins.property
    @pulumi.getter(name="hstsPreload")
    def hsts_preload(self) -> _builtins.bool:
        """
        Defines whether the preload directive should be added to the
        Strict-Transport-Security HTTP response header.
        """
        return pulumi.get(self, "hsts_preload")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> Mapping[str, _builtins.str]:
        """
        A dictionary of optional headers to insert into the request
        before it is sent to the backend member.
        """
        return pulumi.get(self, "insert_headers")

    @_builtins.property
    @pulumi.getter
    def l7policies(self) -> Sequence['outputs.GetListenerV2L7policyResult']:
        """
        L7policies are the L7 policies which are part of this listener.
        """
        return pulumi.get(self, "l7policies")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> _builtins.str:
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> _builtins.str:
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def loadbalancers(self) -> Sequence['outputs.GetListenerV2LoadbalancerResult']:
        """
        A list of load balancer IDs.
        """
        return pulumi.get(self, "loadbalancers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the listener.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> _builtins.str:
        """
        The operating status of the resource.
        """
        return pulumi.get(self, "operating_status")

    @_builtins.property
    @pulumi.getter
    def pools(self) -> Sequence['outputs.GetListenerV2PoolResult']:
        """
        Pools are the pools which are part of this listener.
        """
        return pulumi.get(self, "pools")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The owner (project/tenant) ID of the listener.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol to loadbalance.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> _builtins.int:
        """
        The port on which to listen to client traffic that is
        associated with the Loadbalancer.
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> _builtins.str:
        """
        The provisioning status of the Listener.
        """
        return pulumi.get(self, "provisioning_status")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> Sequence[_builtins.str]:
        """
        The list of references to TLS secrets.
        """
        return pulumi.get(self, "sni_container_refs")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags is a list of resource tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeoutClientData")
    def timeout_client_data(self) -> _builtins.int:
        """
        Frontend client inactivity timeout in milliseconds.
        """
        return pulumi.get(self, "timeout_client_data")

    @_builtins.property
    @pulumi.getter(name="timeoutMemberConnect")
    def timeout_member_connect(self) -> _builtins.int:
        """
        Backend member connection timeout in milliseconds.
        """
        return pulumi.get(self, "timeout_member_connect")

    @_builtins.property
    @pulumi.getter(name="timeoutMemberData")
    def timeout_member_data(self) -> _builtins.int:
        """
        Backend member inactivity timeout in milliseconds.
        """
        return pulumi.get(self, "timeout_member_data")

    @_builtins.property
    @pulumi.getter(name="timeoutTcpInspect")
    def timeout_tcp_inspect(self) -> _builtins.int:
        """
        Time, in milliseconds, to wait for additional TCP
        packets for content inspection.
        """
        return pulumi.get(self, "timeout_tcp_inspect")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> _builtins.str:
        """
        List of ciphers in OpenSSL format (colon-separated).
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Sequence[_builtins.str]:
        """
        A list of TLS protocol versions.
        """
        return pulumi.get(self, "tls_versions")


class AwaitableGetListenerV2Result(GetListenerV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenerV2Result(
            admin_state_up=self.admin_state_up,
            allowed_cidrs=self.allowed_cidrs,
            alpn_protocols=self.alpn_protocols,
            client_authentication=self.client_authentication,
            client_ca_tls_container_ref=self.client_ca_tls_container_ref,
            client_crl_container_ref=self.client_crl_container_ref,
            connection_limit=self.connection_limit,
            default_pool=self.default_pool,
            default_pool_id=self.default_pool_id,
            default_tls_container_ref=self.default_tls_container_ref,
            description=self.description,
            hsts_include_subdomains=self.hsts_include_subdomains,
            hsts_max_age=self.hsts_max_age,
            hsts_preload=self.hsts_preload,
            id=self.id,
            insert_headers=self.insert_headers,
            l7policies=self.l7policies,
            listener_id=self.listener_id,
            loadbalancer_id=self.loadbalancer_id,
            loadbalancers=self.loadbalancers,
            name=self.name,
            operating_status=self.operating_status,
            pools=self.pools,
            project_id=self.project_id,
            protocol=self.protocol,
            protocol_port=self.protocol_port,
            provisioning_status=self.provisioning_status,
            region=self.region,
            sni_container_refs=self.sni_container_refs,
            tags=self.tags,
            timeout_client_data=self.timeout_client_data,
            timeout_member_connect=self.timeout_member_connect,
            timeout_member_data=self.timeout_member_data,
            timeout_tcp_inspect=self.timeout_tcp_inspect,
            tls_ciphers=self.tls_ciphers,
            tls_versions=self.tls_versions)


def get_listener_v2(listener_id: Optional[_builtins.str] = None,
                    loadbalancer_id: Optional[_builtins.str] = None,
                    name: Optional[_builtins.str] = None,
                    protocol: Optional[_builtins.str] = None,
                    protocol_port: Optional[_builtins.int] = None,
                    region: Optional[_builtins.str] = None,
                    tags: Optional[Sequence[_builtins.str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenerV2Result:
    """
    Use this data source to get the ID of an OpenStack Load Balancer listener.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    listener1 = openstack.loadbalancer.get_listener_v2(name="listener_1")
    ```


    :param _builtins.str listener_id: The ID of the listener. Exactly one of `name`,
           `listener_id` is required to be set.
    :param _builtins.str loadbalancer_id: The ID of the load balancer associated with
           the requested listener.
    :param _builtins.str name: The name of the listener. Exactly one of `name`,
           `listener_id` is required to be set.
    :param _builtins.str protocol: The protocol of the requested listener.
    :param _builtins.int protocol_port: The port on which the requested listener accepts client traffic.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer client.
           If omitted, the `region` argument of the provider is used.
    :param Sequence[_builtins.str] tags: A set of tags applied to the loadbalancer's listener.
           The loadbalancer' listener will be returned if it has all of the specified tags.
    """
    __args__ = dict()
    __args__['listenerId'] = listener_id
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    __args__['protocol'] = protocol
    __args__['protocolPort'] = protocol_port
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:loadbalancer/getListenerV2:getListenerV2', __args__, opts=opts, typ=GetListenerV2Result).value

    return AwaitableGetListenerV2Result(
        admin_state_up=pulumi.get(__ret__, 'admin_state_up'),
        allowed_cidrs=pulumi.get(__ret__, 'allowed_cidrs'),
        alpn_protocols=pulumi.get(__ret__, 'alpn_protocols'),
        client_authentication=pulumi.get(__ret__, 'client_authentication'),
        client_ca_tls_container_ref=pulumi.get(__ret__, 'client_ca_tls_container_ref'),
        client_crl_container_ref=pulumi.get(__ret__, 'client_crl_container_ref'),
        connection_limit=pulumi.get(__ret__, 'connection_limit'),
        default_pool=pulumi.get(__ret__, 'default_pool'),
        default_pool_id=pulumi.get(__ret__, 'default_pool_id'),
        default_tls_container_ref=pulumi.get(__ret__, 'default_tls_container_ref'),
        description=pulumi.get(__ret__, 'description'),
        hsts_include_subdomains=pulumi.get(__ret__, 'hsts_include_subdomains'),
        hsts_max_age=pulumi.get(__ret__, 'hsts_max_age'),
        hsts_preload=pulumi.get(__ret__, 'hsts_preload'),
        id=pulumi.get(__ret__, 'id'),
        insert_headers=pulumi.get(__ret__, 'insert_headers'),
        l7policies=pulumi.get(__ret__, 'l7policies'),
        listener_id=pulumi.get(__ret__, 'listener_id'),
        loadbalancer_id=pulumi.get(__ret__, 'loadbalancer_id'),
        loadbalancers=pulumi.get(__ret__, 'loadbalancers'),
        name=pulumi.get(__ret__, 'name'),
        operating_status=pulumi.get(__ret__, 'operating_status'),
        pools=pulumi.get(__ret__, 'pools'),
        project_id=pulumi.get(__ret__, 'project_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        protocol_port=pulumi.get(__ret__, 'protocol_port'),
        provisioning_status=pulumi.get(__ret__, 'provisioning_status'),
        region=pulumi.get(__ret__, 'region'),
        sni_container_refs=pulumi.get(__ret__, 'sni_container_refs'),
        tags=pulumi.get(__ret__, 'tags'),
        timeout_client_data=pulumi.get(__ret__, 'timeout_client_data'),
        timeout_member_connect=pulumi.get(__ret__, 'timeout_member_connect'),
        timeout_member_data=pulumi.get(__ret__, 'timeout_member_data'),
        timeout_tcp_inspect=pulumi.get(__ret__, 'timeout_tcp_inspect'),
        tls_ciphers=pulumi.get(__ret__, 'tls_ciphers'),
        tls_versions=pulumi.get(__ret__, 'tls_versions'))
def get_listener_v2_output(listener_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           loadbalancer_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           protocol: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           protocol_port: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListenerV2Result]:
    """
    Use this data source to get the ID of an OpenStack Load Balancer listener.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    listener1 = openstack.loadbalancer.get_listener_v2(name="listener_1")
    ```


    :param _builtins.str listener_id: The ID of the listener. Exactly one of `name`,
           `listener_id` is required to be set.
    :param _builtins.str loadbalancer_id: The ID of the load balancer associated with
           the requested listener.
    :param _builtins.str name: The name of the listener. Exactly one of `name`,
           `listener_id` is required to be set.
    :param _builtins.str protocol: The protocol of the requested listener.
    :param _builtins.int protocol_port: The port on which the requested listener accepts client traffic.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer client.
           If omitted, the `region` argument of the provider is used.
    :param Sequence[_builtins.str] tags: A set of tags applied to the loadbalancer's listener.
           The loadbalancer' listener will be returned if it has all of the specified tags.
    """
    __args__ = dict()
    __args__['listenerId'] = listener_id
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    __args__['protocol'] = protocol
    __args__['protocolPort'] = protocol_port
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:loadbalancer/getListenerV2:getListenerV2', __args__, opts=opts, typ=GetListenerV2Result)
    return __ret__.apply(lambda __response__: GetListenerV2Result(
        admin_state_up=pulumi.get(__response__, 'admin_state_up'),
        allowed_cidrs=pulumi.get(__response__, 'allowed_cidrs'),
        alpn_protocols=pulumi.get(__response__, 'alpn_protocols'),
        client_authentication=pulumi.get(__response__, 'client_authentication'),
        client_ca_tls_container_ref=pulumi.get(__response__, 'client_ca_tls_container_ref'),
        client_crl_container_ref=pulumi.get(__response__, 'client_crl_container_ref'),
        connection_limit=pulumi.get(__response__, 'connection_limit'),
        default_pool=pulumi.get(__response__, 'default_pool'),
        default_pool_id=pulumi.get(__response__, 'default_pool_id'),
        default_tls_container_ref=pulumi.get(__response__, 'default_tls_container_ref'),
        description=pulumi.get(__response__, 'description'),
        hsts_include_subdomains=pulumi.get(__response__, 'hsts_include_subdomains'),
        hsts_max_age=pulumi.get(__response__, 'hsts_max_age'),
        hsts_preload=pulumi.get(__response__, 'hsts_preload'),
        id=pulumi.get(__response__, 'id'),
        insert_headers=pulumi.get(__response__, 'insert_headers'),
        l7policies=pulumi.get(__response__, 'l7policies'),
        listener_id=pulumi.get(__response__, 'listener_id'),
        loadbalancer_id=pulumi.get(__response__, 'loadbalancer_id'),
        loadbalancers=pulumi.get(__response__, 'loadbalancers'),
        name=pulumi.get(__response__, 'name'),
        operating_status=pulumi.get(__response__, 'operating_status'),
        pools=pulumi.get(__response__, 'pools'),
        project_id=pulumi.get(__response__, 'project_id'),
        protocol=pulumi.get(__response__, 'protocol'),
        protocol_port=pulumi.get(__response__, 'protocol_port'),
        provisioning_status=pulumi.get(__response__, 'provisioning_status'),
        region=pulumi.get(__response__, 'region'),
        sni_container_refs=pulumi.get(__response__, 'sni_container_refs'),
        tags=pulumi.get(__response__, 'tags'),
        timeout_client_data=pulumi.get(__response__, 'timeout_client_data'),
        timeout_member_connect=pulumi.get(__response__, 'timeout_member_connect'),
        timeout_member_data=pulumi.get(__response__, 'timeout_member_data'),
        timeout_tcp_inspect=pulumi.get(__response__, 'timeout_tcp_inspect'),
        tls_ciphers=pulumi.get(__response__, 'tls_ciphers'),
        tls_versions=pulumi.get(__response__, 'tls_versions')))
