# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLoadbalancerV2Result',
    'AwaitableGetLoadbalancerV2Result',
    'get_loadbalancer_v2',
    'get_loadbalancer_v2_output',
]

@pulumi.output_type
class GetLoadbalancerV2Result:
    """
    A collection of values returned by getLoadbalancerV2.
    """
    def __init__(__self__, additional_vips=None, admin_state_up=None, availability_zone=None, description=None, flavor_id=None, id=None, listeners=None, loadbalancer_id=None, loadbalancer_provider=None, name=None, operating_status=None, pools=None, project_id=None, provisioning_status=None, region=None, tags=None, tags_anies=None, tags_not_anies=None, tags_nots=None, vip_address=None, vip_network_id=None, vip_port_id=None, vip_qos_policy_id=None, vip_subnet_id=None):
        if additional_vips and not isinstance(additional_vips, list):
            raise TypeError("Expected argument 'additional_vips' to be a list")
        pulumi.set(__self__, "additional_vips", additional_vips)
        if admin_state_up and not isinstance(admin_state_up, bool):
            raise TypeError("Expected argument 'admin_state_up' to be a bool")
        pulumi.set(__self__, "admin_state_up", admin_state_up)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if loadbalancer_id and not isinstance(loadbalancer_id, str):
            raise TypeError("Expected argument 'loadbalancer_id' to be a str")
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if loadbalancer_provider and not isinstance(loadbalancer_provider, str):
            raise TypeError("Expected argument 'loadbalancer_provider' to be a str")
        pulumi.set(__self__, "loadbalancer_provider", loadbalancer_provider)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operating_status and not isinstance(operating_status, str):
            raise TypeError("Expected argument 'operating_status' to be a str")
        pulumi.set(__self__, "operating_status", operating_status)
        if pools and not isinstance(pools, list):
            raise TypeError("Expected argument 'pools' to be a list")
        pulumi.set(__self__, "pools", pools)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if provisioning_status and not isinstance(provisioning_status, str):
            raise TypeError("Expected argument 'provisioning_status' to be a str")
        pulumi.set(__self__, "provisioning_status", provisioning_status)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tags_anies and not isinstance(tags_anies, list):
            raise TypeError("Expected argument 'tags_anies' to be a list")
        pulumi.set(__self__, "tags_anies", tags_anies)
        if tags_not_anies and not isinstance(tags_not_anies, list):
            raise TypeError("Expected argument 'tags_not_anies' to be a list")
        pulumi.set(__self__, "tags_not_anies", tags_not_anies)
        if tags_nots and not isinstance(tags_nots, list):
            raise TypeError("Expected argument 'tags_nots' to be a list")
        pulumi.set(__self__, "tags_nots", tags_nots)
        if vip_address and not isinstance(vip_address, str):
            raise TypeError("Expected argument 'vip_address' to be a str")
        pulumi.set(__self__, "vip_address", vip_address)
        if vip_network_id and not isinstance(vip_network_id, str):
            raise TypeError("Expected argument 'vip_network_id' to be a str")
        pulumi.set(__self__, "vip_network_id", vip_network_id)
        if vip_port_id and not isinstance(vip_port_id, str):
            raise TypeError("Expected argument 'vip_port_id' to be a str")
        pulumi.set(__self__, "vip_port_id", vip_port_id)
        if vip_qos_policy_id and not isinstance(vip_qos_policy_id, str):
            raise TypeError("Expected argument 'vip_qos_policy_id' to be a str")
        pulumi.set(__self__, "vip_qos_policy_id", vip_qos_policy_id)
        if vip_subnet_id and not isinstance(vip_subnet_id, str):
            raise TypeError("Expected argument 'vip_subnet_id' to be a str")
        pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)

    @_builtins.property
    @pulumi.getter(name="additionalVips")
    def additional_vips(self) -> Sequence[_builtins.str]:
        """
        A list of additional VIP IP addresses associated with
        the loadbalancer.
        """
        return pulumi.get(self, "additional_vips")

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> _builtins.bool:
        """
        The administrative state of the loadbalancer (true/false).
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone of the loadbalancer.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the loadbalancer.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        The flavor ID used by the loadbalancer.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetLoadbalancerV2ListenerResult']:
        """
        A list of listener IDs (UUIDs) associated with the loadbalancer.
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> _builtins.str:
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> _builtins.str:
        """
        The loadbalancer driver/provider used by Octavia
        (for example, `amphora`).
        """
        return pulumi.get(self, "loadbalancer_provider")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the loadbalancer.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> _builtins.str:
        """
        The operating status of the loadbalancer.
        """
        return pulumi.get(self, "operating_status")

    @_builtins.property
    @pulumi.getter
    def pools(self) -> Sequence['outputs.GetLoadbalancerV2PoolResult']:
        """
        A list of pool IDs (UUIDs) associated with the loadbalancer.
        """
        return pulumi.get(self, "pools")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The owner (project/tenant) ID of the loadbalancer.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> _builtins.str:
        """
        The provisioning status of the loadbalancer.
        """
        return pulumi.get(self, "provisioning_status")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A set of tags applied to the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAnies")
    def tags_anies(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "tags_anies")

    @_builtins.property
    @pulumi.getter(name="tagsNotAnies")
    def tags_not_anies(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "tags_not_anies")

    @_builtins.property
    @pulumi.getter(name="tagsNots")
    def tags_nots(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "tags_nots")

    @_builtins.property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> _builtins.str:
        """
        The IP address of the loadbalancer’s virtual IP (VIP).
        """
        return pulumi.get(self, "vip_address")

    @_builtins.property
    @pulumi.getter(name="vipNetworkId")
    def vip_network_id(self) -> _builtins.str:
        """
        The network ID associated with the VIP.
        """
        return pulumi.get(self, "vip_network_id")

    @_builtins.property
    @pulumi.getter(name="vipPortId")
    def vip_port_id(self) -> _builtins.str:
        """
        The port ID associated with the VIP.
        """
        return pulumi.get(self, "vip_port_id")

    @_builtins.property
    @pulumi.getter(name="vipQosPolicyId")
    def vip_qos_policy_id(self) -> _builtins.str:
        """
        The QoS policy ID associated with the VIP, if any.
        """
        return pulumi.get(self, "vip_qos_policy_id")

    @_builtins.property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> _builtins.str:
        """
        The subnet ID associated with the VIP.
        """
        return pulumi.get(self, "vip_subnet_id")


class AwaitableGetLoadbalancerV2Result(GetLoadbalancerV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadbalancerV2Result(
            additional_vips=self.additional_vips,
            admin_state_up=self.admin_state_up,
            availability_zone=self.availability_zone,
            description=self.description,
            flavor_id=self.flavor_id,
            id=self.id,
            listeners=self.listeners,
            loadbalancer_id=self.loadbalancer_id,
            loadbalancer_provider=self.loadbalancer_provider,
            name=self.name,
            operating_status=self.operating_status,
            pools=self.pools,
            project_id=self.project_id,
            provisioning_status=self.provisioning_status,
            region=self.region,
            tags=self.tags,
            tags_anies=self.tags_anies,
            tags_not_anies=self.tags_not_anies,
            tags_nots=self.tags_nots,
            vip_address=self.vip_address,
            vip_network_id=self.vip_network_id,
            vip_port_id=self.vip_port_id,
            vip_qos_policy_id=self.vip_qos_policy_id,
            vip_subnet_id=self.vip_subnet_id)


def get_loadbalancer_v2(description: Optional[_builtins.str] = None,
                        loadbalancer_id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        region: Optional[_builtins.str] = None,
                        tags: Optional[Sequence[_builtins.str]] = None,
                        tags_anies: Optional[Sequence[_builtins.str]] = None,
                        tags_not_anies: Optional[Sequence[_builtins.str]] = None,
                        tags_nots: Optional[Sequence[_builtins.str]] = None,
                        vip_address: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadbalancerV2Result:
    """
    Use this data source to get the ID of an OpenStack Load Balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    loadbalancer1 = openstack.loadbalancer.get_loadbalancer_v2(name="loadbalancer_1")
    ```


    :param _builtins.str description: The human-readable description for the loadbalancer.
    :param _builtins.str loadbalancer_id: The ID of the loadbalancer. Exactly one of
           `name`, `loadbalancer_id` is required to be set.
    :param _builtins.str name: The name of the loadbalancer. Exactly one of `name`,
           `loadbalancer_id` is required to be set.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer client.
           If omitted, the `region` argument of the provider is used.
    :param Sequence[_builtins.str] tags: A set of tags applied to the loadbalancer. The load balancer
           will be returned if it has all of the specified tags.
    :param Sequence[_builtins.str] tags_anies: A set of tags. The load balancer will be returned if
           it has at least one of the specified tags.
    :param Sequence[_builtins.str] tags_not_anies: A set of tags. The load balancer will be returned
           if it does not have any of the specified tags.
    :param Sequence[_builtins.str] tags_nots: A set of tags. The load balancer will be returned if
           it does not have all of the specified tags.
    :param _builtins.str vip_address: The IP address of the loadbalancer's virtual IP (VIP).
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['tagsAnies'] = tags_anies
    __args__['tagsNotAnies'] = tags_not_anies
    __args__['tagsNots'] = tags_nots
    __args__['vipAddress'] = vip_address
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:loadbalancer/getLoadbalancerV2:getLoadbalancerV2', __args__, opts=opts, typ=GetLoadbalancerV2Result).value

    return AwaitableGetLoadbalancerV2Result(
        additional_vips=pulumi.get(__ret__, 'additional_vips'),
        admin_state_up=pulumi.get(__ret__, 'admin_state_up'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        description=pulumi.get(__ret__, 'description'),
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        id=pulumi.get(__ret__, 'id'),
        listeners=pulumi.get(__ret__, 'listeners'),
        loadbalancer_id=pulumi.get(__ret__, 'loadbalancer_id'),
        loadbalancer_provider=pulumi.get(__ret__, 'loadbalancer_provider'),
        name=pulumi.get(__ret__, 'name'),
        operating_status=pulumi.get(__ret__, 'operating_status'),
        pools=pulumi.get(__ret__, 'pools'),
        project_id=pulumi.get(__ret__, 'project_id'),
        provisioning_status=pulumi.get(__ret__, 'provisioning_status'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        tags_anies=pulumi.get(__ret__, 'tags_anies'),
        tags_not_anies=pulumi.get(__ret__, 'tags_not_anies'),
        tags_nots=pulumi.get(__ret__, 'tags_nots'),
        vip_address=pulumi.get(__ret__, 'vip_address'),
        vip_network_id=pulumi.get(__ret__, 'vip_network_id'),
        vip_port_id=pulumi.get(__ret__, 'vip_port_id'),
        vip_qos_policy_id=pulumi.get(__ret__, 'vip_qos_policy_id'),
        vip_subnet_id=pulumi.get(__ret__, 'vip_subnet_id'))
def get_loadbalancer_v2_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               loadbalancer_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               tags_anies: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               tags_not_anies: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               tags_nots: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               vip_address: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadbalancerV2Result]:
    """
    Use this data source to get the ID of an OpenStack Load Balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    loadbalancer1 = openstack.loadbalancer.get_loadbalancer_v2(name="loadbalancer_1")
    ```


    :param _builtins.str description: The human-readable description for the loadbalancer.
    :param _builtins.str loadbalancer_id: The ID of the loadbalancer. Exactly one of
           `name`, `loadbalancer_id` is required to be set.
    :param _builtins.str name: The name of the loadbalancer. Exactly one of `name`,
           `loadbalancer_id` is required to be set.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer client.
           If omitted, the `region` argument of the provider is used.
    :param Sequence[_builtins.str] tags: A set of tags applied to the loadbalancer. The load balancer
           will be returned if it has all of the specified tags.
    :param Sequence[_builtins.str] tags_anies: A set of tags. The load balancer will be returned if
           it has at least one of the specified tags.
    :param Sequence[_builtins.str] tags_not_anies: A set of tags. The load balancer will be returned
           if it does not have any of the specified tags.
    :param Sequence[_builtins.str] tags_nots: A set of tags. The load balancer will be returned if
           it does not have all of the specified tags.
    :param _builtins.str vip_address: The IP address of the loadbalancer's virtual IP (VIP).
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['tagsAnies'] = tags_anies
    __args__['tagsNotAnies'] = tags_not_anies
    __args__['tagsNots'] = tags_nots
    __args__['vipAddress'] = vip_address
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:loadbalancer/getLoadbalancerV2:getLoadbalancerV2', __args__, opts=opts, typ=GetLoadbalancerV2Result)
    return __ret__.apply(lambda __response__: GetLoadbalancerV2Result(
        additional_vips=pulumi.get(__response__, 'additional_vips'),
        admin_state_up=pulumi.get(__response__, 'admin_state_up'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        description=pulumi.get(__response__, 'description'),
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        id=pulumi.get(__response__, 'id'),
        listeners=pulumi.get(__response__, 'listeners'),
        loadbalancer_id=pulumi.get(__response__, 'loadbalancer_id'),
        loadbalancer_provider=pulumi.get(__response__, 'loadbalancer_provider'),
        name=pulumi.get(__response__, 'name'),
        operating_status=pulumi.get(__response__, 'operating_status'),
        pools=pulumi.get(__response__, 'pools'),
        project_id=pulumi.get(__response__, 'project_id'),
        provisioning_status=pulumi.get(__response__, 'provisioning_status'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        tags_anies=pulumi.get(__response__, 'tags_anies'),
        tags_not_anies=pulumi.get(__response__, 'tags_not_anies'),
        tags_nots=pulumi.get(__response__, 'tags_nots'),
        vip_address=pulumi.get(__response__, 'vip_address'),
        vip_network_id=pulumi.get(__response__, 'vip_network_id'),
        vip_port_id=pulumi.get(__response__, 'vip_port_id'),
        vip_qos_policy_id=pulumi.get(__response__, 'vip_qos_policy_id'),
        vip_subnet_id=pulumi.get(__response__, 'vip_subnet_id')))
