# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPoolV2Result',
    'AwaitableGetPoolV2Result',
    'get_pool_v2',
    'get_pool_v2_output',
]

@pulumi.output_type
class GetPoolV2Result:
    """
    A collection of values returned by getPoolV2.
    """
    def __init__(__self__, admin_state_up=None, alpn_protocols=None, ca_tls_container_ref=None, crl_container_ref=None, description=None, healthmonitor_id=None, id=None, lb_method=None, listeners=None, loadbalancer_id=None, loadbalancers=None, members=None, name=None, operating_status=None, pool_id=None, project_id=None, protocol=None, provisioning_status=None, region=None, session_persistences=None, tags=None, tls_ciphers=None, tls_container_ref=None, tls_enabled=None, tls_versions=None):
        if admin_state_up and not isinstance(admin_state_up, bool):
            raise TypeError("Expected argument 'admin_state_up' to be a bool")
        pulumi.set(__self__, "admin_state_up", admin_state_up)
        if alpn_protocols and not isinstance(alpn_protocols, list):
            raise TypeError("Expected argument 'alpn_protocols' to be a list")
        pulumi.set(__self__, "alpn_protocols", alpn_protocols)
        if ca_tls_container_ref and not isinstance(ca_tls_container_ref, str):
            raise TypeError("Expected argument 'ca_tls_container_ref' to be a str")
        pulumi.set(__self__, "ca_tls_container_ref", ca_tls_container_ref)
        if crl_container_ref and not isinstance(crl_container_ref, str):
            raise TypeError("Expected argument 'crl_container_ref' to be a str")
        pulumi.set(__self__, "crl_container_ref", crl_container_ref)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if healthmonitor_id and not isinstance(healthmonitor_id, str):
            raise TypeError("Expected argument 'healthmonitor_id' to be a str")
        pulumi.set(__self__, "healthmonitor_id", healthmonitor_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lb_method and not isinstance(lb_method, str):
            raise TypeError("Expected argument 'lb_method' to be a str")
        pulumi.set(__self__, "lb_method", lb_method)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if loadbalancer_id and not isinstance(loadbalancer_id, str):
            raise TypeError("Expected argument 'loadbalancer_id' to be a str")
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if loadbalancers and not isinstance(loadbalancers, list):
            raise TypeError("Expected argument 'loadbalancers' to be a list")
        pulumi.set(__self__, "loadbalancers", loadbalancers)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operating_status and not isinstance(operating_status, str):
            raise TypeError("Expected argument 'operating_status' to be a str")
        pulumi.set(__self__, "operating_status", operating_status)
        if pool_id and not isinstance(pool_id, str):
            raise TypeError("Expected argument 'pool_id' to be a str")
        pulumi.set(__self__, "pool_id", pool_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if provisioning_status and not isinstance(provisioning_status, str):
            raise TypeError("Expected argument 'provisioning_status' to be a str")
        pulumi.set(__self__, "provisioning_status", provisioning_status)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if session_persistences and not isinstance(session_persistences, list):
            raise TypeError("Expected argument 'session_persistences' to be a list")
        pulumi.set(__self__, "session_persistences", session_persistences)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tls_ciphers and not isinstance(tls_ciphers, str):
            raise TypeError("Expected argument 'tls_ciphers' to be a str")
        pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_container_ref and not isinstance(tls_container_ref, str):
            raise TypeError("Expected argument 'tls_container_ref' to be a str")
        pulumi.set(__self__, "tls_container_ref", tls_container_ref)
        if tls_enabled and not isinstance(tls_enabled, bool):
            raise TypeError("Expected argument 'tls_enabled' to be a bool")
        pulumi.set(__self__, "tls_enabled", tls_enabled)
        if tls_versions and not isinstance(tls_versions, list):
            raise TypeError("Expected argument 'tls_versions' to be a list")
        pulumi.set(__self__, "tls_versions", tls_versions)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> _builtins.bool:
        """
        The administrative state of the Pool, which is up (true)
        or down (false).
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter(name="alpnProtocols")
    def alpn_protocols(self) -> Sequence[_builtins.str]:
        """
        A list of ALPN protocols.
        """
        return pulumi.get(self, "alpn_protocols")

    @_builtins.property
    @pulumi.getter(name="caTlsContainerRef")
    def ca_tls_container_ref(self) -> _builtins.str:
        """
        The reference of the key manager service secret
        containing a PEM format CA certificate bundle for tls_enabled pools.
        """
        return pulumi.get(self, "ca_tls_container_ref")

    @_builtins.property
    @pulumi.getter(name="crlContainerRef")
    def crl_container_ref(self) -> _builtins.str:
        """
        The reference of the key manager service secret
        containing a PEM format CA revocation list file for tls_enabled pools.
        """
        return pulumi.get(self, "crl_container_ref")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="healthmonitorId")
    def healthmonitor_id(self) -> _builtins.str:
        """
        The ID of associated health monitor.
        """
        return pulumi.get(self, "healthmonitor_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> _builtins.str:
        """
        The load-balancer algorithm, which is round-robin,
        least-connections, and so on.
        """
        return pulumi.get(self, "lb_method")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetPoolV2ListenerResult']:
        """
        A list of listeners objects IDs.
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> _builtins.str:
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def loadbalancers(self) -> Sequence['outputs.GetPoolV2LoadbalancerResult']:
        """
        A list of load balancer objects IDs.
        """
        return pulumi.get(self, "loadbalancers")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetPoolV2MemberResult']:
        """
        A list of member objects IDs.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> _builtins.str:
        """
        The operating status of the pool.
        """
        return pulumi.get(self, "operating_status")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> _builtins.str:
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The owner (project/tenant) ID of the pool.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol to loadbalance.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> _builtins.str:
        """
        The provisioning status of the pool.
        """
        return pulumi.get(self, "provisioning_status")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sessionPersistences")
    def session_persistences(self) -> Sequence['outputs.GetPoolV2SessionPersistenceResult']:
        """
        Indicates whether connections in the same session
        will be processed by the same Pool member or not.
        """
        return pulumi.get(self, "session_persistences")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags is a list of resource tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> _builtins.str:
        """
        List of ciphers in OpenSSL format (colon-separated).
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="tlsContainerRef")
    def tls_container_ref(self) -> _builtins.str:
        """
        The reference to the key manager service secret
        containing a PKCS12 format certificate/key bundle for tls_enabled pools for
        TLS client authentication to the member servers.
        """
        return pulumi.get(self, "tls_container_ref")

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> _builtins.bool:
        """
        When true connections to backend member servers will use
        TLS encryption.
        """
        return pulumi.get(self, "tls_enabled")

    @_builtins.property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Sequence[_builtins.str]:
        """
        A list of TLS protocol versions.
        """
        return pulumi.get(self, "tls_versions")


class AwaitableGetPoolV2Result(GetPoolV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPoolV2Result(
            admin_state_up=self.admin_state_up,
            alpn_protocols=self.alpn_protocols,
            ca_tls_container_ref=self.ca_tls_container_ref,
            crl_container_ref=self.crl_container_ref,
            description=self.description,
            healthmonitor_id=self.healthmonitor_id,
            id=self.id,
            lb_method=self.lb_method,
            listeners=self.listeners,
            loadbalancer_id=self.loadbalancer_id,
            loadbalancers=self.loadbalancers,
            members=self.members,
            name=self.name,
            operating_status=self.operating_status,
            pool_id=self.pool_id,
            project_id=self.project_id,
            protocol=self.protocol,
            provisioning_status=self.provisioning_status,
            region=self.region,
            session_persistences=self.session_persistences,
            tags=self.tags,
            tls_ciphers=self.tls_ciphers,
            tls_container_ref=self.tls_container_ref,
            tls_enabled=self.tls_enabled,
            tls_versions=self.tls_versions)


def get_pool_v2(lb_method: Optional[_builtins.str] = None,
                loadbalancer_id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                pool_id: Optional[_builtins.str] = None,
                protocol: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                tags: Optional[Sequence[_builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPoolV2Result:
    """
    Use this data source to get the ID of an OpenStack Load Balancer pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    pool1 = openstack.loadbalancer.get_pool_v2(name="pool_1")
    ```


    :param _builtins.str lb_method: The load balancing algorithm to distribute traffic to the
           pool's members.
    :param _builtins.str loadbalancer_id: The ID of the load balancer associated with
           the requested pool.
    :param _builtins.str name: The name of the pool. Exactly one of `name`, `pool_id`
           is required to be set.
    :param _builtins.str pool_id: The ID of the pool. Exactly one of `name`, `pool_id`
           is required to be set.
    :param _builtins.str protocol: The protocol of the requested pool.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer
           client. If omitted, the `region` argument of the provider is used.
    :param Sequence[_builtins.str] tags: A set of tags applied to the loadbalancer's pool. The
           loadbalancer' pool will be returned if it has all of the specified tags.
    """
    __args__ = dict()
    __args__['lbMethod'] = lb_method
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    __args__['poolId'] = pool_id
    __args__['protocol'] = protocol
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:loadbalancer/getPoolV2:getPoolV2', __args__, opts=opts, typ=GetPoolV2Result).value

    return AwaitableGetPoolV2Result(
        admin_state_up=pulumi.get(__ret__, 'admin_state_up'),
        alpn_protocols=pulumi.get(__ret__, 'alpn_protocols'),
        ca_tls_container_ref=pulumi.get(__ret__, 'ca_tls_container_ref'),
        crl_container_ref=pulumi.get(__ret__, 'crl_container_ref'),
        description=pulumi.get(__ret__, 'description'),
        healthmonitor_id=pulumi.get(__ret__, 'healthmonitor_id'),
        id=pulumi.get(__ret__, 'id'),
        lb_method=pulumi.get(__ret__, 'lb_method'),
        listeners=pulumi.get(__ret__, 'listeners'),
        loadbalancer_id=pulumi.get(__ret__, 'loadbalancer_id'),
        loadbalancers=pulumi.get(__ret__, 'loadbalancers'),
        members=pulumi.get(__ret__, 'members'),
        name=pulumi.get(__ret__, 'name'),
        operating_status=pulumi.get(__ret__, 'operating_status'),
        pool_id=pulumi.get(__ret__, 'pool_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        provisioning_status=pulumi.get(__ret__, 'provisioning_status'),
        region=pulumi.get(__ret__, 'region'),
        session_persistences=pulumi.get(__ret__, 'session_persistences'),
        tags=pulumi.get(__ret__, 'tags'),
        tls_ciphers=pulumi.get(__ret__, 'tls_ciphers'),
        tls_container_ref=pulumi.get(__ret__, 'tls_container_ref'),
        tls_enabled=pulumi.get(__ret__, 'tls_enabled'),
        tls_versions=pulumi.get(__ret__, 'tls_versions'))
def get_pool_v2_output(lb_method: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       loadbalancer_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       pool_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       protocol: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPoolV2Result]:
    """
    Use this data source to get the ID of an OpenStack Load Balancer pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    pool1 = openstack.loadbalancer.get_pool_v2(name="pool_1")
    ```


    :param _builtins.str lb_method: The load balancing algorithm to distribute traffic to the
           pool's members.
    :param _builtins.str loadbalancer_id: The ID of the load balancer associated with
           the requested pool.
    :param _builtins.str name: The name of the pool. Exactly one of `name`, `pool_id`
           is required to be set.
    :param _builtins.str pool_id: The ID of the pool. Exactly one of `name`, `pool_id`
           is required to be set.
    :param _builtins.str protocol: The protocol of the requested pool.
    :param _builtins.str region: The region in which to obtain the V2 Load Balancer
           client. If omitted, the `region` argument of the provider is used.
    :param Sequence[_builtins.str] tags: A set of tags applied to the loadbalancer's pool. The
           loadbalancer' pool will be returned if it has all of the specified tags.
    """
    __args__ = dict()
    __args__['lbMethod'] = lb_method
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    __args__['poolId'] = pool_id
    __args__['protocol'] = protocol
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:loadbalancer/getPoolV2:getPoolV2', __args__, opts=opts, typ=GetPoolV2Result)
    return __ret__.apply(lambda __response__: GetPoolV2Result(
        admin_state_up=pulumi.get(__response__, 'admin_state_up'),
        alpn_protocols=pulumi.get(__response__, 'alpn_protocols'),
        ca_tls_container_ref=pulumi.get(__response__, 'ca_tls_container_ref'),
        crl_container_ref=pulumi.get(__response__, 'crl_container_ref'),
        description=pulumi.get(__response__, 'description'),
        healthmonitor_id=pulumi.get(__response__, 'healthmonitor_id'),
        id=pulumi.get(__response__, 'id'),
        lb_method=pulumi.get(__response__, 'lb_method'),
        listeners=pulumi.get(__response__, 'listeners'),
        loadbalancer_id=pulumi.get(__response__, 'loadbalancer_id'),
        loadbalancers=pulumi.get(__response__, 'loadbalancers'),
        members=pulumi.get(__response__, 'members'),
        name=pulumi.get(__response__, 'name'),
        operating_status=pulumi.get(__response__, 'operating_status'),
        pool_id=pulumi.get(__response__, 'pool_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        protocol=pulumi.get(__response__, 'protocol'),
        provisioning_status=pulumi.get(__response__, 'provisioning_status'),
        region=pulumi.get(__response__, 'region'),
        session_persistences=pulumi.get(__response__, 'session_persistences'),
        tags=pulumi.get(__response__, 'tags'),
        tls_ciphers=pulumi.get(__response__, 'tls_ciphers'),
        tls_container_ref=pulumi.get(__response__, 'tls_container_ref'),
        tls_enabled=pulumi.get(__response__, 'tls_enabled'),
        tls_versions=pulumi.get(__response__, 'tls_versions')))
