# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'MembersMember',
    'PoolPersistence',
    'GetListenerV2L7policyResult',
    'GetListenerV2LoadbalancerResult',
    'GetListenerV2PoolResult',
    'GetLoadbalancerV2ListenerResult',
    'GetLoadbalancerV2PoolResult',
    'GetPoolV2ListenerResult',
    'GetPoolV2LoadbalancerResult',
    'GetPoolV2MemberResult',
    'GetPoolV2SessionPersistenceResult',
]

@pulumi.output_type
class MembersMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolPort":
            suggest = "protocol_port"
        elif key == "adminStateUp":
            suggest = "admin_state_up"
        elif key == "monitorAddress":
            suggest = "monitor_address"
        elif key == "monitorPort":
            suggest = "monitor_port"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MembersMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MembersMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MembersMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 protocol_port: _builtins.int,
                 admin_state_up: Optional[_builtins.bool] = None,
                 backup: Optional[_builtins.bool] = None,
                 id: Optional[_builtins.str] = None,
                 monitor_address: Optional[_builtins.str] = None,
                 monitor_port: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str address: The IP address of the members to receive traffic from
               the load balancer.
        :param _builtins.int protocol_port: The port on which to listen for client traffic.
        :param _builtins.bool admin_state_up: The administrative state of the member.
               A valid value is true (UP) or false (DOWN). Defaults to true.
        :param _builtins.bool backup: A bool that indicates whether the member is
               backup. **Requires octavia minor version 2.1 or later**.
        :param _builtins.str id: The unique ID for the members.
        :param _builtins.str monitor_address: An alternate IP address used for health 
               monitoring a backend member.
        :param _builtins.int monitor_port: An alternate protocol port used for health 
               monitoring a backend member.
        :param _builtins.str name: Human-readable name for the member.
        :param _builtins.str subnet_id: The subnet in which to access the member.
        :param _builtins.int weight: A positive integer value that indicates the relative
               portion of traffic that this members should receive from the pool. For
               example, a member with a weight of 10 receives five times as much traffic
               as a member with a weight of 2. Defaults to 1.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "protocol_port", protocol_port)
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if monitor_address is not None:
            pulumi.set(__self__, "monitor_address", monitor_address)
        if monitor_port is not None:
            pulumi.set(__self__, "monitor_port", monitor_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The IP address of the members to receive traffic from
        the load balancer.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> _builtins.int:
        """
        The port on which to listen for client traffic.
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[_builtins.bool]:
        """
        The administrative state of the member.
        A valid value is true (UP) or false (DOWN). Defaults to true.
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter
    def backup(self) -> Optional[_builtins.bool]:
        """
        A bool that indicates whether the member is
        backup. **Requires octavia minor version 2.1 or later**.
        """
        return pulumi.get(self, "backup")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The unique ID for the members.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="monitorAddress")
    def monitor_address(self) -> Optional[_builtins.str]:
        """
        An alternate IP address used for health 
        monitoring a backend member.
        """
        return pulumi.get(self, "monitor_address")

    @_builtins.property
    @pulumi.getter(name="monitorPort")
    def monitor_port(self) -> Optional[_builtins.int]:
        """
        An alternate protocol port used for health 
        monitoring a backend member.
        """
        return pulumi.get(self, "monitor_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Human-readable name for the member.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The subnet in which to access the member.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        A positive integer value that indicates the relative
        portion of traffic that this members should receive from the pool. For
        example, a member with a weight of 10 receives five times as much traffic
        as a member with a weight of 2. Defaults to 1.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class PoolPersistence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPersistence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPersistence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPersistence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 cookie_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of persistence mode. The current specification
               supports SOURCE_IP, HTTP_COOKIE, and APP_COOKIE.
        :param _builtins.str cookie_name: The name of the cookie if persistence mode is set
               appropriately. Required if `type = APP_COOKIE`.
        """
        pulumi.set(__self__, "type", type)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of persistence mode. The current specification
        supports SOURCE_IP, HTTP_COOKIE, and APP_COOKIE.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[_builtins.str]:
        """
        The name of the cookie if persistence mode is set
        appropriately. Required if `type = APP_COOKIE`.
        """
        return pulumi.get(self, "cookie_name")


@pulumi.output_type
class GetListenerV2L7policyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")


@pulumi.output_type
class GetListenerV2LoadbalancerResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")


@pulumi.output_type
class GetListenerV2PoolResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")


@pulumi.output_type
class GetLoadbalancerV2ListenerResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")


@pulumi.output_type
class GetLoadbalancerV2PoolResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolV2ListenerResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolV2LoadbalancerResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPoolV2MemberResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 admin_state_up: _builtins.bool,
                 backup: _builtins.bool,
                 id: _builtins.str,
                 monitor_address: _builtins.str,
                 monitor_port: _builtins.int,
                 name: _builtins.str,
                 operating_status: _builtins.str,
                 pool_id: _builtins.str,
                 project_id: _builtins.str,
                 protocol_port: _builtins.int,
                 provisioning_status: _builtins.str,
                 subnet_id: _builtins.str,
                 tags: Sequence[_builtins.str],
                 weight: _builtins.int):
        """
        :param _builtins.bool admin_state_up: The administrative state of the Pool, which is up (true)
               or down (false).
        :param _builtins.str name: The name of the pool. Exactly one of `name`, `pool_id`
               is required to be set.
        :param _builtins.str operating_status: The operating status of the pool.
        :param _builtins.str pool_id: The ID of the pool. Exactly one of `name`, `pool_id`
               is required to be set.
        :param _builtins.str project_id: The owner (project/tenant) ID of the pool.
        :param _builtins.str provisioning_status: The provisioning status of the pool.
        :param Sequence[_builtins.str] tags: A set of tags applied to the loadbalancer's pool. The
               loadbalancer' pool will be returned if it has all of the specified tags.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "admin_state_up", admin_state_up)
        pulumi.set(__self__, "backup", backup)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "monitor_address", monitor_address)
        pulumi.set(__self__, "monitor_port", monitor_port)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operating_status", operating_status)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "protocol_port", protocol_port)
        pulumi.set(__self__, "provisioning_status", provisioning_status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> _builtins.bool:
        """
        The administrative state of the Pool, which is up (true)
        or down (false).
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter
    def backup(self) -> _builtins.bool:
        return pulumi.get(self, "backup")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="monitorAddress")
    def monitor_address(self) -> _builtins.str:
        return pulumi.get(self, "monitor_address")

    @_builtins.property
    @pulumi.getter(name="monitorPort")
    def monitor_port(self) -> _builtins.int:
        return pulumi.get(self, "monitor_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the pool. Exactly one of `name`, `pool_id`
        is required to be set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operatingStatus")
    def operating_status(self) -> _builtins.str:
        """
        The operating status of the pool.
        """
        return pulumi.get(self, "operating_status")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> _builtins.str:
        """
        The ID of the pool. Exactly one of `name`, `pool_id`
        is required to be set.
        """
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The owner (project/tenant) ID of the pool.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> _builtins.int:
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> _builtins.str:
        """
        The provisioning status of the pool.
        """
        return pulumi.get(self, "provisioning_status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A set of tags applied to the loadbalancer's pool. The
        loadbalancer' pool will be returned if it has all of the specified tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetPoolV2SessionPersistenceResult(dict):
    def __init__(__self__, *,
                 cookie_name: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> _builtins.str:
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


