# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TaasTapMirrorV2Args', 'TaasTapMirrorV2']

@pulumi.input_type
class TaasTapMirrorV2Args:
    def __init__(__self__, *,
                 directions: pulumi.Input['TaasTapMirrorV2DirectionsArgs'],
                 mirror_type: pulumi.Input[_builtins.str],
                 port_id: pulumi.Input[_builtins.str],
                 remote_ip: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TaasTapMirrorV2 resource.
        :param pulumi.Input['TaasTapMirrorV2DirectionsArgs'] directions: A block declaring the directions to be mirrored and their
               identifiers. One block has to be declared with at least one direction. Changing
               this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] mirror_type: The type of the mirroring, can be `gre` or `erspanv1`.
               Changing this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] port_id: The Port ID of the Tap Mirror, this will be the source of
               the mirrored traffic, and this traffic will be tunneled into the GRE or ERSPAN
               v1 tunnel. The tunnel itself is not starting from this port. Changing this
               creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] remote_ip: The remote IP of the Tap Mirror, this will be the remote
               end of the GRE or ERSPAN v1 tunnel. Changing this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] description: The human-readable description for the Tap Mirror.
               Changing this updates the description of the existing Tap Mirror.
        :param pulumi.Input[_builtins.str] name: The name of the Tap Mirror. Changing this updates the name of
               the existing Tap Mirror.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an endpoint group. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               group.
        :param pulumi.Input[_builtins.str] tenant_id: The owner of the Tap Mirror. Required if admin wants to
               create a Tap Mirror for another project. Changing this creates a new Tap Mirror.
        """
        pulumi.set(__self__, "directions", directions)
        pulumi.set(__self__, "mirror_type", mirror_type)
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "remote_ip", remote_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def directions(self) -> pulumi.Input['TaasTapMirrorV2DirectionsArgs']:
        """
        A block declaring the directions to be mirrored and their
        identifiers. One block has to be declared with at least one direction. Changing
        this creates a new Tap Mirror.
        """
        return pulumi.get(self, "directions")

    @directions.setter
    def directions(self, value: pulumi.Input['TaasTapMirrorV2DirectionsArgs']):
        pulumi.set(self, "directions", value)

    @_builtins.property
    @pulumi.getter(name="mirrorType")
    def mirror_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the mirroring, can be `gre` or `erspanv1`.
        Changing this creates a new Tap Mirror.
        """
        return pulumi.get(self, "mirror_type")

    @mirror_type.setter
    def mirror_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mirror_type", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Port ID of the Tap Mirror, this will be the source of
        the mirrored traffic, and this traffic will be tunneled into the GRE or ERSPAN
        v1 tunnel. The tunnel itself is not starting from this port. Changing this
        creates a new Tap Mirror.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="remoteIp")
    def remote_ip(self) -> pulumi.Input[_builtins.str]:
        """
        The remote IP of the Tap Mirror, this will be the remote
        end of the GRE or ERSPAN v1 tunnel. Changing this creates a new Tap Mirror.
        """
        return pulumi.get(self, "remote_ip")

    @remote_ip.setter
    def remote_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_ip", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable description for the Tap Mirror.
        Changing this updates the description of the existing Tap Mirror.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Tap Mirror. Changing this updates the name of
        the existing Tap Mirror.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an endpoint group. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owner of the Tap Mirror. Required if admin wants to
        create a Tap Mirror for another project. Changing this creates a new Tap Mirror.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _TaasTapMirrorV2State:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 directions: Optional[pulumi.Input['TaasTapMirrorV2DirectionsArgs']] = None,
                 mirror_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TaasTapMirrorV2 resources.
        :param pulumi.Input[_builtins.str] description: The human-readable description for the Tap Mirror.
               Changing this updates the description of the existing Tap Mirror.
        :param pulumi.Input['TaasTapMirrorV2DirectionsArgs'] directions: A block declaring the directions to be mirrored and their
               identifiers. One block has to be declared with at least one direction. Changing
               this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] mirror_type: The type of the mirroring, can be `gre` or `erspanv1`.
               Changing this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] name: The name of the Tap Mirror. Changing this updates the name of
               the existing Tap Mirror.
        :param pulumi.Input[_builtins.str] port_id: The Port ID of the Tap Mirror, this will be the source of
               the mirrored traffic, and this traffic will be tunneled into the GRE or ERSPAN
               v1 tunnel. The tunnel itself is not starting from this port. Changing this
               creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] project_id: Id of the OpenStack project.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an endpoint group. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               group.
        :param pulumi.Input[_builtins.str] remote_ip: The remote IP of the Tap Mirror, this will be the remote
               end of the GRE or ERSPAN v1 tunnel. Changing this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] tenant_id: The owner of the Tap Mirror. Required if admin wants to
               create a Tap Mirror for another project. Changing this creates a new Tap Mirror.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directions is not None:
            pulumi.set(__self__, "directions", directions)
        if mirror_type is not None:
            pulumi.set(__self__, "mirror_type", mirror_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_ip is not None:
            pulumi.set(__self__, "remote_ip", remote_ip)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable description for the Tap Mirror.
        Changing this updates the description of the existing Tap Mirror.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def directions(self) -> Optional[pulumi.Input['TaasTapMirrorV2DirectionsArgs']]:
        """
        A block declaring the directions to be mirrored and their
        identifiers. One block has to be declared with at least one direction. Changing
        this creates a new Tap Mirror.
        """
        return pulumi.get(self, "directions")

    @directions.setter
    def directions(self, value: Optional[pulumi.Input['TaasTapMirrorV2DirectionsArgs']]):
        pulumi.set(self, "directions", value)

    @_builtins.property
    @pulumi.getter(name="mirrorType")
    def mirror_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the mirroring, can be `gre` or `erspanv1`.
        Changing this creates a new Tap Mirror.
        """
        return pulumi.get(self, "mirror_type")

    @mirror_type.setter
    def mirror_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mirror_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Tap Mirror. Changing this updates the name of
        the existing Tap Mirror.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Port ID of the Tap Mirror, this will be the source of
        the mirrored traffic, and this traffic will be tunneled into the GRE or ERSPAN
        v1 tunnel. The tunnel itself is not starting from this port. Changing this
        creates a new Tap Mirror.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the OpenStack project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an endpoint group. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="remoteIp")
    def remote_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remote IP of the Tap Mirror, this will be the remote
        end of the GRE or ERSPAN v1 tunnel. Changing this creates a new Tap Mirror.
        """
        return pulumi.get(self, "remote_ip")

    @remote_ip.setter
    def remote_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_ip", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owner of the Tap Mirror. Required if admin wants to
        create a Tap Mirror for another project. Changing this creates a new Tap Mirror.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("openstack:index/taasTapMirrorV2:TaasTapMirrorV2")
class TaasTapMirrorV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 directions: Optional[pulumi.Input[Union['TaasTapMirrorV2DirectionsArgs', 'TaasTapMirrorV2DirectionsArgsDict']]] = None,
                 mirror_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a V2 Neutron Tap Mirror resource within OpenStack tap-as-a-service extension.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        tap_mirror1 = openstack.TaasTapMirrorV2("tap_mirror_1",
            mirror_type="erspanv1",
            port_id="a25290e9-1a54-4c26-a5b3-34458d122acc",
            remote_ip="172.18.1.15",
            directions={
                "in_": 1000,
                "out": 1001,
            })
        ```

        ## Import

        Tap Mirrors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:index/taasTapMirrorV2:TaasTapMirrorV2 tap_mirror_1 0837b488-f0e2-4689-99b3-e3ed531f9b10
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The human-readable description for the Tap Mirror.
               Changing this updates the description of the existing Tap Mirror.
        :param pulumi.Input[Union['TaasTapMirrorV2DirectionsArgs', 'TaasTapMirrorV2DirectionsArgsDict']] directions: A block declaring the directions to be mirrored and their
               identifiers. One block has to be declared with at least one direction. Changing
               this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] mirror_type: The type of the mirroring, can be `gre` or `erspanv1`.
               Changing this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] name: The name of the Tap Mirror. Changing this updates the name of
               the existing Tap Mirror.
        :param pulumi.Input[_builtins.str] port_id: The Port ID of the Tap Mirror, this will be the source of
               the mirrored traffic, and this traffic will be tunneled into the GRE or ERSPAN
               v1 tunnel. The tunnel itself is not starting from this port. Changing this
               creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an endpoint group. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               group.
        :param pulumi.Input[_builtins.str] remote_ip: The remote IP of the Tap Mirror, this will be the remote
               end of the GRE or ERSPAN v1 tunnel. Changing this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] tenant_id: The owner of the Tap Mirror. Required if admin wants to
               create a Tap Mirror for another project. Changing this creates a new Tap Mirror.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaasTapMirrorV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 Neutron Tap Mirror resource within OpenStack tap-as-a-service extension.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        tap_mirror1 = openstack.TaasTapMirrorV2("tap_mirror_1",
            mirror_type="erspanv1",
            port_id="a25290e9-1a54-4c26-a5b3-34458d122acc",
            remote_ip="172.18.1.15",
            directions={
                "in_": 1000,
                "out": 1001,
            })
        ```

        ## Import

        Tap Mirrors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:index/taasTapMirrorV2:TaasTapMirrorV2 tap_mirror_1 0837b488-f0e2-4689-99b3-e3ed531f9b10
        ```

        :param str resource_name: The name of the resource.
        :param TaasTapMirrorV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaasTapMirrorV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 directions: Optional[pulumi.Input[Union['TaasTapMirrorV2DirectionsArgs', 'TaasTapMirrorV2DirectionsArgsDict']]] = None,
                 mirror_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaasTapMirrorV2Args.__new__(TaasTapMirrorV2Args)

            __props__.__dict__["description"] = description
            if directions is None and not opts.urn:
                raise TypeError("Missing required property 'directions'")
            __props__.__dict__["directions"] = directions
            if mirror_type is None and not opts.urn:
                raise TypeError("Missing required property 'mirror_type'")
            __props__.__dict__["mirror_type"] = mirror_type
            __props__.__dict__["name"] = name
            if port_id is None and not opts.urn:
                raise TypeError("Missing required property 'port_id'")
            __props__.__dict__["port_id"] = port_id
            __props__.__dict__["region"] = region
            if remote_ip is None and not opts.urn:
                raise TypeError("Missing required property 'remote_ip'")
            __props__.__dict__["remote_ip"] = remote_ip
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["project_id"] = None
        super(TaasTapMirrorV2, __self__).__init__(
            'openstack:index/taasTapMirrorV2:TaasTapMirrorV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            directions: Optional[pulumi.Input[Union['TaasTapMirrorV2DirectionsArgs', 'TaasTapMirrorV2DirectionsArgsDict']]] = None,
            mirror_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            port_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            remote_ip: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TaasTapMirrorV2':
        """
        Get an existing TaasTapMirrorV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The human-readable description for the Tap Mirror.
               Changing this updates the description of the existing Tap Mirror.
        :param pulumi.Input[Union['TaasTapMirrorV2DirectionsArgs', 'TaasTapMirrorV2DirectionsArgsDict']] directions: A block declaring the directions to be mirrored and their
               identifiers. One block has to be declared with at least one direction. Changing
               this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] mirror_type: The type of the mirroring, can be `gre` or `erspanv1`.
               Changing this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] name: The name of the Tap Mirror. Changing this updates the name of
               the existing Tap Mirror.
        :param pulumi.Input[_builtins.str] port_id: The Port ID of the Tap Mirror, this will be the source of
               the mirrored traffic, and this traffic will be tunneled into the GRE or ERSPAN
               v1 tunnel. The tunnel itself is not starting from this port. Changing this
               creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] project_id: Id of the OpenStack project.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an endpoint group. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               group.
        :param pulumi.Input[_builtins.str] remote_ip: The remote IP of the Tap Mirror, this will be the remote
               end of the GRE or ERSPAN v1 tunnel. Changing this creates a new Tap Mirror.
        :param pulumi.Input[_builtins.str] tenant_id: The owner of the Tap Mirror. Required if admin wants to
               create a Tap Mirror for another project. Changing this creates a new Tap Mirror.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TaasTapMirrorV2State.__new__(_TaasTapMirrorV2State)

        __props__.__dict__["description"] = description
        __props__.__dict__["directions"] = directions
        __props__.__dict__["mirror_type"] = mirror_type
        __props__.__dict__["name"] = name
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["remote_ip"] = remote_ip
        __props__.__dict__["tenant_id"] = tenant_id
        return TaasTapMirrorV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The human-readable description for the Tap Mirror.
        Changing this updates the description of the existing Tap Mirror.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def directions(self) -> pulumi.Output['outputs.TaasTapMirrorV2Directions']:
        """
        A block declaring the directions to be mirrored and their
        identifiers. One block has to be declared with at least one direction. Changing
        this creates a new Tap Mirror.
        """
        return pulumi.get(self, "directions")

    @_builtins.property
    @pulumi.getter(name="mirrorType")
    def mirror_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the mirroring, can be `gre` or `erspanv1`.
        Changing this creates a new Tap Mirror.
        """
        return pulumi.get(self, "mirror_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Tap Mirror. Changing this updates the name of
        the existing Tap Mirror.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Port ID of the Tap Mirror, this will be the source of
        the mirrored traffic, and this traffic will be tunneled into the GRE or ERSPAN
        v1 tunnel. The tunnel itself is not starting from this port. Changing this
        creates a new Tap Mirror.
        """
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the OpenStack project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an endpoint group. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        group.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="remoteIp")
    def remote_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The remote IP of the Tap Mirror, this will be the remote
        end of the GRE or ERSPAN v1 tunnel. Changing this creates a new Tap Mirror.
        """
        return pulumi.get(self, "remote_ip")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The owner of the Tap Mirror. Required if admin wants to
        create a Tap Mirror for another project. Changing this creates a new Tap Mirror.
        """
        return pulumi.get(self, "tenant_id")

