# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.2, generator: @autorest/python@6.31.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any

from azure.core import PipelineClient
from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from typing_extensions import Self

from ._configuration import DyffV0APIConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    DatasetsOperations,
    EvaluationsOperations,
    FamiliesOperations,
    InferenceservicesOperations,
    InferencesessionsOperations,
    MeasurementsOperations,
    MethodsOperations,
    ModelsOperations,
    ModulesOperations,
    ReportsOperations,
    SafetycasesOperations,
    TokensOperations,
    UsecasesOperations,
)


class DyffV0API:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """DyffV0API.

    :ivar tokens: TokensOperations operations :vartype tokens:
    _generated.operations.TokensOperations :ivar datasets: DatasetsOperations operations
    :vartype datasets: _generated.operations.DatasetsOperations :ivar evaluations:
    EvaluationsOperations operations :vartype evaluations:
    _generated.operations.EvaluationsOperations :ivar families: FamiliesOperations
    operations :vartype families: _generated.operations.FamiliesOperations :ivar
    inferenceservices: InferenceservicesOperations operations :vartype
    inferenceservices: _generated.operations.InferenceservicesOperations :ivar
    inferencesessions: InferencesessionsOperations operations :vartype
    inferencesessions: _generated.operations.InferencesessionsOperations :ivar
    measurements: MeasurementsOperations operations :vartype measurements:
    _generated.operations.MeasurementsOperations :ivar methods: MethodsOperations
    operations :vartype methods: _generated.operations.MethodsOperations :ivar models:
    ModelsOperations operations :vartype models: _generated.operations.ModelsOperations
    :ivar modules: ModulesOperations operations :vartype modules:
    _generated.operations.ModulesOperations :ivar usecases: UsecasesOperations
    operations :vartype usecases: _generated.operations.UsecasesOperations :ivar
    reports: ReportsOperations operations :vartype reports:
    _generated.operations.ReportsOperations :ivar safetycases: SafetycasesOperations
    operations :vartype safetycases: _generated.operations.SafetycasesOperations
    :keyword endpoint: Service URL. Required. Default value is "".
    :paramtype endpoint: str
    """

    def __init__(  # pylint: disable=missing-client-constructor-parameter-credential
        self, *, endpoint: str = "", **kwargs: Any
    ) -> None:
        self._config = DyffV0APIConfiguration(**kwargs)
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                (
                    policies.SensitiveHeaderCleanupPolicy(**kwargs)
                    if self._config.redirect_policy
                    else None
                ),
                self._config.http_logging_policy,
            ]
        self._client: PipelineClient = PipelineClient(
            base_url=endpoint, policies=_policies, **kwargs
        )

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.tokens = TokensOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.datasets = DatasetsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.evaluations = EvaluationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.families = FamiliesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.inferenceservices = InferenceservicesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.inferencesessions = InferencesessionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.measurements = MeasurementsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.methods = MethodsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.models = ModelsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.modules = ModulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.usecases = UsecasesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.reports = ReportsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.safetycases = SafetycasesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client.send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
