# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.2, generator: @autorest/python@6.31.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from io import IOBase
from typing import (
    IO,
    Any,
    Callable,
    Dict,
    List,
    Optional,
    TypeVar,
    Union,
    cast,
    overload,
)

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ..._serialization import Deserializer, Serializer
from ...operations._operations import (
    build_datasets_create_request,
    build_datasets_delete_request,
    build_datasets_documentation_request,
    build_datasets_downlinks_request,
    build_datasets_edit_documentation_request,
    build_datasets_finalize_request,
    build_datasets_get_request,
    build_datasets_label_request,
    build_datasets_query_documentation_request,
    build_datasets_query_request,
    build_datasets_upload_request,
    build_evaluations_create_request,
    build_evaluations_delete_request,
    build_evaluations_downlinks_request,
    build_evaluations_get_request,
    build_evaluations_label_request,
    build_evaluations_query_request,
    build_families_create_request,
    build_families_delete_request,
    build_families_edit_documentation_request,
    build_families_edit_members_request,
    build_families_get_request,
    build_families_label_request,
    build_families_query_request,
    build_inferenceservices_create_request,
    build_inferenceservices_delete_request,
    build_inferenceservices_documentation_request,
    build_inferenceservices_edit_documentation_request,
    build_inferenceservices_get_request,
    build_inferenceservices_label_request,
    build_inferenceservices_query_request,
    build_inferencesessions_create_request,
    build_inferencesessions_delete_request,
    build_inferencesessions_get_request,
    build_inferencesessions_infer_request,
    build_inferencesessions_label_request,
    build_inferencesessions_query_request,
    build_inferencesessions_ready_request,
    build_inferencesessions_terminate_request,
    build_inferencesessions_token_request,
    build_measurements_create_request,
    build_measurements_delete_request,
    build_measurements_downlinks_request,
    build_measurements_get_request,
    build_measurements_label_request,
    build_measurements_logs_request,
    build_measurements_query_request,
    build_methods_create_request,
    build_methods_delete_request,
    build_methods_documentation_request,
    build_methods_edit_documentation_request,
    build_methods_get_request,
    build_methods_label_request,
    build_methods_query_request,
    build_models_create_request,
    build_models_delete_request,
    build_models_documentation_request,
    build_models_edit_documentation_request,
    build_models_get_request,
    build_models_label_request,
    build_models_query_request,
    build_modules_create_request,
    build_modules_delete_request,
    build_modules_documentation_request,
    build_modules_downlinks_request,
    build_modules_edit_documentation_request,
    build_modules_finalize_request,
    build_modules_get_request,
    build_modules_label_request,
    build_modules_query_request,
    build_modules_upload_request,
    build_reports_create_request,
    build_reports_delete_request,
    build_reports_downlinks_request,
    build_reports_get_request,
    build_reports_label_request,
    build_reports_logs_request,
    build_reports_query_request,
    build_safetycases_create_request,
    build_safetycases_delete_request,
    build_safetycases_downlinks_request,
    build_safetycases_get_request,
    build_safetycases_label_request,
    build_safetycases_logs_request,
    build_safetycases_query_request,
    build_safetycases_query_scores_request,
    build_safetycases_scores_request,
    build_tokens_current_request,
    build_usecases_create_request,
    build_usecases_delete_request,
    build_usecases_edit_documentation_request,
    build_usecases_get_request,
    build_usecases_label_request,
    build_usecases_query_request,
)
from .._configuration import DyffV0APIConfiguration

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]
]


class TokensOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`tokens` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace_async
    async def current(self, **kwargs: Any) -> JSON:
        """Verify the signature of the provied token and return its JSON body.

        Verify the signature of the provied token and return its JSON body.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "created": "2020-02-20 00:00:00",
                    "expires": "2020-02-20 00:00:00",
                    "id": "str",
                    "subject": "str",
                    "grants": [
                        {
                            "functions": [
                                "str"
                            ],
                            "resources": [
                                "str"
                            ],
                            "accounts": [
                                "str"
                            ],
                            "entities": [
                                "str"
                            ]
                        }
                    ],
                    "secret": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_tokens_current_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class DatasetsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`datasets` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Dataset.

        Update labels for an existing Dataset.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Dataset.

        Update labels for an existing Dataset.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing Dataset.

        Update labels for an existing Dataset.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_datasets_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all Datasets matching a query.

        Get all Datasets matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "artifacts": [
                            {
                                "path": "str",
                                "digest": {
                                    "md5": "str"
                                },
                                "kind": "str"
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "name": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "kind": "Dataset",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "schemaVersion": "0.1",
                        "views": [
                            {
                                "id": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "viewOf": "str",
                                "adapterPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            }
                        ]
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_datasets_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Dataset.

        Create a Dataset.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "schemaVersion": "0.1",
                    "views": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Dataset",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "views": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ]
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Dataset.

        Create a Dataset.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Dataset",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "views": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create a Dataset.

        Create a Dataset.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "schemaVersion": "0.1",
                    "views": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Dataset",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "views": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ]
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_datasets_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a Dataset by its key.

        Get a Dataset by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Dataset",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "views": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ]
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_datasets_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark a Dataset for deletion.

        Mark a Dataset for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_datasets_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def upload(self, id: str, artifact_path: str, **kwargs: Any) -> JSON:
        """Get a signed URL to which the given artifact can be uploaded.

        Get a signed URL to which the given artifact can be uploaded.

        :param id: Required.
        :type id: str
        :param artifact_path: Required.
        :type artifact_path: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "method": "str",
                    "url": "str",
                    "headers": {
                        "str": "str"
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_datasets_upload_request(
            id=id,
            artifact_path=artifact_path,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def finalize(self, id: str, **kwargs: Any) -> Any:
        """Indicate that all dataset artifacts have been uploaded.

        Indicate that all dataset artifacts have been uploaded.

        :param id: Required.
        :type id: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_datasets_finalize_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def downlinks(self, id: str, **kwargs: Any) -> List[JSON]:
        """Get a list of signed GET URLs from which Dataset artifacts can be downloaded.

        Get a list of signed GET URLs from which Dataset artifacts can be downloaded.

        :param id: Required.
        :type id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "artifact": {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        },
                        "signedURL": {
                            "method": "str",
                            "url": "str",
                            "headers": {
                                "str": "str"
                            }
                        }
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_datasets_downlinks_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace_async
    async def documentation(self, id: str, **kwargs: Any) -> JSON:
        """Get the documentation associated with a Dataset.

        Get the documentation associated with a Dataset.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_datasets_documentation_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with a Dataset.

        Edit the documentation associated with a Dataset.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with a Dataset.

        Edit the documentation associated with a Dataset.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @distributed_trace_async
    async def edit_documentation(
        self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        """Edit the documentation associated with a Dataset.

        Edit the documentation associated with a Dataset.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_datasets_edit_documentation_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def query_documentation(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all Documentation matching a query and that pertains to Datasets.

        Get all Documentation matching a query and that pertains to Datasets.

        Currently, only the ``.id`` field is queryable.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "entity": "str",
                        "fullPage": "str",
                        "schemaVersion": "0.1",
                        "summary": "str",
                        "title": "str"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_datasets_query_documentation_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore


class EvaluationsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`evaluations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Evaluation.

        Update labels for an existing Evaluation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Evaluation.

        Update labels for an existing Evaluation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing Evaluation.

        Update labels for an existing Evaluation.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_evaluations_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        dataset: Optional[str] = None,
        inference_service: Optional[str] = None,
        inference_service_name: Optional[str] = None,
        model: Optional[str] = None,
        model_name: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all Evaluations matching a query.

        Get all Evaluations matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword dataset: Default value is None.
        :paramtype dataset: str
        :keyword inference_service: Default value is None.
        :paramtype inference_service: str
        :keyword inference_service_name: Default value is None.
        :paramtype inference_service_name: str
        :keyword model: Default value is None.
        :paramtype model: str
        :keyword model_name: Default value is None.
        :paramtype model_name: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "dataset": "str",
                        "id": "str",
                        "inferenceSession": {
                            "inferenceService": {
                                "account": "str",
                                "id": "str",
                                "interface": {
                                    "endpoint": "str",
                                    "outputSchema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "inputPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ],
                                    "outputPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ]
                                },
                                "name": "str",
                                "builder": {
                                    "kind": "str",
                                    "args": [
                                        "str"
                                    ]
                                },
                                "model": {
                                    "account": "str",
                                    "artifact": {
                                        "kind": "str",
                                        "huggingFaceCache": {
                                            "repoID": "str",
                                            "revision": "str"
                                        }
                                    },
                                    "id": "str",
                                    "name": "str",
                                    "storage": {
                                        "medium": "str"
                                    }
                                },
                                "outputViews": [
                                    {
                                        "id": "str",
                                        "schema": {
                                            "arrowSchema": "str",
                                            "dyffSchema": {
                                                "components": [
                                                    "str"
                                                ],
                                                "schemaVersion":
                                                  "0.1"
                                            },
                                            "jsonSchema": {}
                                        },
                                        "viewOf": "str",
                                        "adapterPipeline": [
                                            {
                                                "kind": "str",
                                                "configuration": {}
                                            }
                                        ]
                                    }
                                ],
                                "runner": {
                                    "kind": "str",
                                    "resources": {
                                        "storage": "str",
                                        "memory": "str"
                                    },
                                    "accelerator": {
                                        "kind": "str",
                                        "gpu": {
                                            "hardwareTypes": [
                                                "str"
                                            ],
                                            "count": 1,
                                            "memory": "str"
                                        }
                                    },
                                    "args": [
                                        "str"
                                    ],
                                    "image": {
                                        "digest": "str",
                                        "host": "str",
                                        "name": "str",
                                        "tag": "str"
                                    },
                                    "nodes": 1
                                }
                            },
                            "accelerator": {
                                "kind": "str",
                                "gpu": {
                                    "hardwareTypes": [
                                        "str"
                                    ],
                                    "count": 1,
                                    "memory": "str"
                                }
                            },
                            "expires": "2020-02-20 00:00:00",
                            "replicas": 1,
                            "useSpotPods": True
                        },
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "client": {
                            "badRequestPolicy": "Abort",
                            "duplicateOutputPolicy": "Deduplicate",
                            "missingOutputPolicy": "Error",
                            "requestTimeoutSeconds": 30,
                            "transientErrorRetryDelaySeconds": 30,
                            "transientErrorRetryLimit": 120
                        },
                        "inferenceSessionReference": "str",
                        "kind": "Evaluation",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "replications": 1,
                        "schemaVersion": "0.1",
                        "workersPerReplica": 0
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_evaluations_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            dataset=dataset,
            inference_service=inference_service,
            inference_service_name=inference_service_name,
            model=model,
            model_name=model_name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create an Evaluation.

        Create an Evaluation.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "dataset": "str",
                    "client": {
                        "badRequestPolicy": "Abort",
                        "duplicateOutputPolicy": "Deduplicate",
                        "missingOutputPolicy": "Error",
                        "requestTimeoutSeconds": 30,
                        "transientErrorRetryDelaySeconds": 30,
                        "transientErrorRetryLimit": 120
                    },
                    "inferenceSession": {
                        "inferenceService": "str",
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "expires": "2020-02-20 00:00:00",
                        "replicas": 1,
                        "useSpotPods": True
                    },
                    "inferenceSessionReference": "str",
                    "replications": 1,
                    "schemaVersion": "0.1",
                    "workersPerReplica": 0
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "dataset": "str",
                    "id": "str",
                    "inferenceSession": {
                        "inferenceService": {
                            "account": "str",
                            "id": "str",
                            "interface": {
                                "endpoint": "str",
                                "outputSchema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            },
                            "name": "str",
                            "builder": {
                                "kind": "str",
                                "args": [
                                    "str"
                                ]
                            },
                            "model": {
                                "account": "str",
                                "artifact": {
                                    "kind": "str",
                                    "huggingFaceCache": {
                                        "repoID": "str",
                                        "revision": "str"
                                    }
                                },
                                "id": "str",
                                "name": "str",
                                "storage": {
                                    "medium": "str"
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "viewOf": "str",
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",
                                "resources": {
                                    "storage": "str",
                                    "memory": "str"
                                },
                                "accelerator": {
                                    "kind": "str",
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"
                                        ],
                                        "count": 1,
                                        "memory": "str"
                                    }
                                },
                                "args": [
                                    "str"
                                ],
                                "image": {
                                    "digest": "str",
                                    "host": "str",
                                    "name": "str",
                                    "tag": "str"
                                },
                                "nodes": 1
                            }
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "expires": "2020-02-20 00:00:00",
                        "replicas": 1,
                        "useSpotPods": True
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "client": {
                        "badRequestPolicy": "Abort",
                        "duplicateOutputPolicy": "Deduplicate",
                        "missingOutputPolicy": "Error",
                        "requestTimeoutSeconds": 30,
                        "transientErrorRetryDelaySeconds": 30,
                        "transientErrorRetryLimit": 120
                    },
                    "inferenceSessionReference": "str",
                    "kind": "Evaluation",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "replications": 1,
                    "schemaVersion": "0.1",
                    "workersPerReplica": 0
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create an Evaluation.

        Create an Evaluation.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "dataset": "str",
                    "id": "str",
                    "inferenceSession": {
                        "inferenceService": {
                            "account": "str",
                            "id": "str",
                            "interface": {
                                "endpoint": "str",
                                "outputSchema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            },
                            "name": "str",
                            "builder": {
                                "kind": "str",
                                "args": [
                                    "str"
                                ]
                            },
                            "model": {
                                "account": "str",
                                "artifact": {
                                    "kind": "str",
                                    "huggingFaceCache": {
                                        "repoID": "str",
                                        "revision": "str"
                                    }
                                },
                                "id": "str",
                                "name": "str",
                                "storage": {
                                    "medium": "str"
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "viewOf": "str",
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",
                                "resources": {
                                    "storage": "str",
                                    "memory": "str"
                                },
                                "accelerator": {
                                    "kind": "str",
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"
                                        ],
                                        "count": 1,
                                        "memory": "str"
                                    }
                                },
                                "args": [
                                    "str"
                                ],
                                "image": {
                                    "digest": "str",
                                    "host": "str",
                                    "name": "str",
                                    "tag": "str"
                                },
                                "nodes": 1
                            }
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "expires": "2020-02-20 00:00:00",
                        "replicas": 1,
                        "useSpotPods": True
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "client": {
                        "badRequestPolicy": "Abort",
                        "duplicateOutputPolicy": "Deduplicate",
                        "missingOutputPolicy": "Error",
                        "requestTimeoutSeconds": 30,
                        "transientErrorRetryDelaySeconds": 30,
                        "transientErrorRetryLimit": 120
                    },
                    "inferenceSessionReference": "str",
                    "kind": "Evaluation",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "replications": 1,
                    "schemaVersion": "0.1",
                    "workersPerReplica": 0
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create an Evaluation.

        Create an Evaluation.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "dataset": "str",
                    "client": {
                        "badRequestPolicy": "Abort",
                        "duplicateOutputPolicy": "Deduplicate",
                        "missingOutputPolicy": "Error",
                        "requestTimeoutSeconds": 30,
                        "transientErrorRetryDelaySeconds": 30,
                        "transientErrorRetryLimit": 120
                    },
                    "inferenceSession": {
                        "inferenceService": "str",
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "expires": "2020-02-20 00:00:00",
                        "replicas": 1,
                        "useSpotPods": True
                    },
                    "inferenceSessionReference": "str",
                    "replications": 1,
                    "schemaVersion": "0.1",
                    "workersPerReplica": 0
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "dataset": "str",
                    "id": "str",
                    "inferenceSession": {
                        "inferenceService": {
                            "account": "str",
                            "id": "str",
                            "interface": {
                                "endpoint": "str",
                                "outputSchema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            },
                            "name": "str",
                            "builder": {
                                "kind": "str",
                                "args": [
                                    "str"
                                ]
                            },
                            "model": {
                                "account": "str",
                                "artifact": {
                                    "kind": "str",
                                    "huggingFaceCache": {
                                        "repoID": "str",
                                        "revision": "str"
                                    }
                                },
                                "id": "str",
                                "name": "str",
                                "storage": {
                                    "medium": "str"
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "viewOf": "str",
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",
                                "resources": {
                                    "storage": "str",
                                    "memory": "str"
                                },
                                "accelerator": {
                                    "kind": "str",
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"
                                        ],
                                        "count": 1,
                                        "memory": "str"
                                    }
                                },
                                "args": [
                                    "str"
                                ],
                                "image": {
                                    "digest": "str",
                                    "host": "str",
                                    "name": "str",
                                    "tag": "str"
                                },
                                "nodes": 1
                            }
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "expires": "2020-02-20 00:00:00",
                        "replicas": 1,
                        "useSpotPods": True
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "client": {
                        "badRequestPolicy": "Abort",
                        "duplicateOutputPolicy": "Deduplicate",
                        "missingOutputPolicy": "Error",
                        "requestTimeoutSeconds": 30,
                        "transientErrorRetryDelaySeconds": 30,
                        "transientErrorRetryLimit": 120
                    },
                    "inferenceSessionReference": "str",
                    "kind": "Evaluation",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "replications": 1,
                    "schemaVersion": "0.1",
                    "workersPerReplica": 0
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_evaluations_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get an Evaluation by its key.

        Get an Evaluation by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "dataset": "str",
                    "id": "str",
                    "inferenceSession": {
                        "inferenceService": {
                            "account": "str",
                            "id": "str",
                            "interface": {
                                "endpoint": "str",
                                "outputSchema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            },
                            "name": "str",
                            "builder": {
                                "kind": "str",
                                "args": [
                                    "str"
                                ]
                            },
                            "model": {
                                "account": "str",
                                "artifact": {
                                    "kind": "str",
                                    "huggingFaceCache": {
                                        "repoID": "str",
                                        "revision": "str"
                                    }
                                },
                                "id": "str",
                                "name": "str",
                                "storage": {
                                    "medium": "str"
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "viewOf": "str",
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",
                                "resources": {
                                    "storage": "str",
                                    "memory": "str"
                                },
                                "accelerator": {
                                    "kind": "str",
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"
                                        ],
                                        "count": 1,
                                        "memory": "str"
                                    }
                                },
                                "args": [
                                    "str"
                                ],
                                "image": {
                                    "digest": "str",
                                    "host": "str",
                                    "name": "str",
                                    "tag": "str"
                                },
                                "nodes": 1
                            }
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "expires": "2020-02-20 00:00:00",
                        "replicas": 1,
                        "useSpotPods": True
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "client": {
                        "badRequestPolicy": "Abort",
                        "duplicateOutputPolicy": "Deduplicate",
                        "missingOutputPolicy": "Error",
                        "requestTimeoutSeconds": 30,
                        "transientErrorRetryDelaySeconds": 30,
                        "transientErrorRetryLimit": 120
                    },
                    "inferenceSessionReference": "str",
                    "kind": "Evaluation",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "replications": 1,
                    "schemaVersion": "0.1",
                    "workersPerReplica": 0
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_evaluations_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark an Evaluation for deletion.

        Mark an Evaluation for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_evaluations_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def downlinks(self, id: str, **kwargs: Any) -> List[JSON]:
        """Get a list of signed GET URLs from which Evaluation artifacts can be
        downloaded.

        Get a list of signed GET URLs from which Evaluation artifacts can be downloaded.

        :param id: Required.
        :type id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "artifact": {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        },
                        "signedURL": {
                            "method": "str",
                            "url": "str",
                            "headers": {
                                "str": "str"
                            }
                        }
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_evaluations_downlinks_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore


class FamiliesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`families` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing entity.

        Update labels for an existing entity.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing entity.

        Update labels for an existing entity.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing entity.

        Update labels for an existing entity.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_families_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all entities matching a query.

        Get all Families matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "memberKind": "str",
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "kind": "Family",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "members": {
                            "str": {
                                "family": "str",
                                "name": "str",
                                "resource": "str",
                                "creationTime": "2020-02-20 00:00:00",
                                "description": "str"
                            }
                        },
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "schemaVersion": "0.1"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_families_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Family.

        Create a Family.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "memberKind": "str",
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "memberKind": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Family",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "members": {
                        "str": {
                            "family": "str",
                            "name": "str",
                            "resource": "str",
                            "creationTime": "2020-02-20 00:00:00",
                            "description": "str"
                        }
                    },
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Family.

        Create a Family.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "memberKind": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Family",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "members": {
                        "str": {
                            "family": "str",
                            "name": "str",
                            "resource": "str",
                            "creationTime": "2020-02-20 00:00:00",
                            "description": "str"
                        }
                    },
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create a Family.

        Create a Family.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "memberKind": "str",
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "memberKind": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Family",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "members": {
                        "str": {
                            "family": "str",
                            "name": "str",
                            "resource": "str",
                            "creationTime": "2020-02-20 00:00:00",
                            "description": "str"
                        }
                    },
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_families_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a Family by its ID.

        Get a Family by its ID.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "memberKind": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Family",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "members": {
                        "str": {
                            "family": "str",
                            "name": "str",
                            "resource": "str",
                            "creationTime": "2020-02-20 00:00:00",
                            "description": "str"
                        }
                    },
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_families_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def edit_members(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Edit the members mapping of a Family.

        Edit the members mapping of a Family.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "members": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def edit_members(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Edit the members mapping of a Family.

        Edit the members mapping of a Family.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def edit_members(
        self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Any:
        """Edit the members mapping of a Family.

        Edit the members mapping of a Family.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "members": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_families_edit_members_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Edit the documentation associated with an entity.

        Edit the documentation associated with an entity.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Edit the documentation associated with an entity.

        Edit the documentation associated with an entity.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def edit_documentation(
        self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Any:
        """Edit the documentation associated with an entity.

        Edit the documentation associated with an entity.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_families_edit_documentation_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark a Family for deletion.

        Mark a Family for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_families_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class InferenceservicesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`inferenceservices` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing InferenceService.

        Update labels for an existing InferenceService.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing InferenceService.

        Update labels for an existing InferenceService.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing InferenceService.

        Update labels for an existing InferenceService.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferenceservices_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        model: Optional[str] = None,
        model_name: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all InferenceServices matching a query.

        Get all InferenceServices matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :keyword model: Default value is None.
        :paramtype model: str
        :keyword model_name: Default value is None.
        :paramtype model_name: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "interface": {
                            "endpoint": "str",
                            "outputSchema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "inputPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ],
                            "outputPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        },
                        "name": "str",
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "builder": {
                            "kind": "str",
                            "args": [
                                "str"
                            ]
                        },
                        "kind": "InferenceService",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "model": {
                            "account": "str",
                            "artifact": {
                                "kind": "str",
                                "huggingFaceCache": {
                                    "repoID": "str",
                                    "revision": "str"
                                }
                            },
                            "id": "str",
                            "name": "str",
                            "storage": {
                                "medium": "str"
                            }
                        },
                        "outputViews": [
                            {
                                "id": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "viewOf": "str",
                                "adapterPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            }
                        ],
                        "reason": "str",
                        "runner": {
                            "kind": "str",
                            "resources": {
                                "storage": "str",
                                "memory": "str"
                            },
                            "accelerator": {
                                "kind": "str",
                                "gpu": {
                                    "hardwareTypes": [
                                        "str"
                                    ],
                                    "count": 1,
                                    "memory": "str"
                                }
                            },
                            "args": [
                                "str"
                            ],
                            "image": {
                                "digest": "str",
                                "host": "str",
                                "name": "str",
                                "tag": "str"
                            },
                            "nodes": 1
                        },
                        "schemaVersion": "0.1"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_inferenceservices_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            model=model,
            model_name=model_name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create an InferenceService.

        Create an InferenceService.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "interface": {
                        "endpoint": "str",
                        "outputSchema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "name": "str",
                    "builder": {
                        "kind": "str",
                        "args": [
                            "str"
                        ]
                    },
                    "model": "str",
                    "outputViews": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ],
                    "runner": {
                        "kind": "str",
                        "resources": {
                            "storage": "str",
                            "memory": "str"
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "args": [
                            "str"
                        ],
                        "image": {
                            "digest": "str",
                            "host": "str",
                            "name": "str",
                            "tag": "str"
                        },
                        "nodes": 1
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "interface": {
                        "endpoint": "str",
                        "outputSchema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "builder": {
                        "kind": "str",
                        "args": [
                            "str"
                        ]
                    },
                    "kind": "InferenceService",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "model": {
                        "account": "str",
                        "artifact": {
                            "kind": "str",
                            "huggingFaceCache": {
                                "repoID": "str",
                                "revision": "str"
                            }
                        },
                        "id": "str",
                        "name": "str",
                        "storage": {
                            "medium": "str"
                        }
                    },
                    "outputViews": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ],
                    "reason": "str",
                    "runner": {
                        "kind": "str",
                        "resources": {
                            "storage": "str",
                            "memory": "str"
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "args": [
                            "str"
                        ],
                        "image": {
                            "digest": "str",
                            "host": "str",
                            "name": "str",
                            "tag": "str"
                        },
                        "nodes": 1
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create an InferenceService.

        Create an InferenceService.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "interface": {
                        "endpoint": "str",
                        "outputSchema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "builder": {
                        "kind": "str",
                        "args": [
                            "str"
                        ]
                    },
                    "kind": "InferenceService",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "model": {
                        "account": "str",
                        "artifact": {
                            "kind": "str",
                            "huggingFaceCache": {
                                "repoID": "str",
                                "revision": "str"
                            }
                        },
                        "id": "str",
                        "name": "str",
                        "storage": {
                            "medium": "str"
                        }
                    },
                    "outputViews": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ],
                    "reason": "str",
                    "runner": {
                        "kind": "str",
                        "resources": {
                            "storage": "str",
                            "memory": "str"
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "args": [
                            "str"
                        ],
                        "image": {
                            "digest": "str",
                            "host": "str",
                            "name": "str",
                            "tag": "str"
                        },
                        "nodes": 1
                    },
                    "schemaVersion": "0.1"
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create an InferenceService.

        Create an InferenceService.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "interface": {
                        "endpoint": "str",
                        "outputSchema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "name": "str",
                    "builder": {
                        "kind": "str",
                        "args": [
                            "str"
                        ]
                    },
                    "model": "str",
                    "outputViews": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ],
                    "runner": {
                        "kind": "str",
                        "resources": {
                            "storage": "str",
                            "memory": "str"
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "args": [
                            "str"
                        ],
                        "image": {
                            "digest": "str",
                            "host": "str",
                            "name": "str",
                            "tag": "str"
                        },
                        "nodes": 1
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "interface": {
                        "endpoint": "str",
                        "outputSchema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "builder": {
                        "kind": "str",
                        "args": [
                            "str"
                        ]
                    },
                    "kind": "InferenceService",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "model": {
                        "account": "str",
                        "artifact": {
                            "kind": "str",
                            "huggingFaceCache": {
                                "repoID": "str",
                                "revision": "str"
                            }
                        },
                        "id": "str",
                        "name": "str",
                        "storage": {
                            "medium": "str"
                        }
                    },
                    "outputViews": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ],
                    "reason": "str",
                    "runner": {
                        "kind": "str",
                        "resources": {
                            "storage": "str",
                            "memory": "str"
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "args": [
                            "str"
                        ],
                        "image": {
                            "digest": "str",
                            "host": "str",
                            "name": "str",
                            "tag": "str"
                        },
                        "nodes": 1
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferenceservices_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get an InferenceService by its key.

        Get an InferenceService by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "interface": {
                        "endpoint": "str",
                        "outputSchema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "inputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ],
                        "outputPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "builder": {
                        "kind": "str",
                        "args": [
                            "str"
                        ]
                    },
                    "kind": "InferenceService",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "model": {
                        "account": "str",
                        "artifact": {
                            "kind": "str",
                            "huggingFaceCache": {
                                "repoID": "str",
                                "revision": "str"
                            }
                        },
                        "id": "str",
                        "name": "str",
                        "storage": {
                            "medium": "str"
                        }
                    },
                    "outputViews": [
                        {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        }
                    ],
                    "reason": "str",
                    "runner": {
                        "kind": "str",
                        "resources": {
                            "storage": "str",
                            "memory": "str"
                        },
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "args": [
                            "str"
                        ],
                        "image": {
                            "digest": "str",
                            "host": "str",
                            "name": "str",
                            "tag": "str"
                        },
                        "nodes": 1
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferenceservices_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark an InferenceService for deletion.

        Mark an InferenceService for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferenceservices_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def documentation(self, id: str, **kwargs: Any) -> JSON:
        """Get the documentation associated with an InferenceService.

        Get the documentation associated with an InferenceService.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferenceservices_documentation_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with an InferenceService.

        Edit the documentation associated with an InferenceService.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with an InferenceService.

        Edit the documentation associated with an InferenceService.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @distributed_trace_async
    async def edit_documentation(
        self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        """Edit the documentation associated with an InferenceService.

        Edit the documentation associated with an InferenceService.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferenceservices_edit_documentation_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class InferencesessionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`inferencesessions` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing InferenceSession.

        Update labels for an existing InferenceSession.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing InferenceSession.

        Update labels for an existing InferenceSession.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing InferenceSession.

        Update labels for an existing InferenceSession.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferencesessions_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        inference_service: Optional[str] = None,
        inference_service_name: Optional[str] = None,
        model: Optional[str] = None,
        model_name: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all InferenceSessions matching a query.

        Get all InferenceSessions matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :keyword inference_service: Default value is None.
        :paramtype inference_service: str
        :keyword inference_service_name: Default value is None.
        :paramtype inference_service_name: str
        :keyword model: Default value is None.
        :paramtype model: str
        :keyword model_name: Default value is None.
        :paramtype model_name: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "inferenceService": {
                            "account": "str",
                            "id": "str",
                            "interface": {
                                "endpoint": "str",
                                "outputSchema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            },
                            "name": "str",
                            "builder": {
                                "kind": "str",
                                "args": [
                                    "str"
                                ]
                            },
                            "model": {
                                "account": "str",
                                "artifact": {
                                    "kind": "str",
                                    "huggingFaceCache": {
                                        "repoID": "str",
                                        "revision": "str"
                                    }
                                },
                                "id": "str",
                                "name": "str",
                                "storage": {
                                    "medium": "str"
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "viewOf": "str",
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",
                                "resources": {
                                    "storage": "str",
                                    "memory": "str"
                                },
                                "accelerator": {
                                    "kind": "str",
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"
                                        ],
                                        "count": 1,
                                        "memory": "str"
                                    }
                                },
                                "args": [
                                    "str"
                                ],
                                "image": {
                                    "digest": "str",
                                    "host": "str",
                                    "name": "str",
                                    "tag": "str"
                                },
                                "nodes": 1
                            }
                        },
                        "status": "str",
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "expires": "2020-02-20 00:00:00",
                        "kind": "InferenceSession",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "replicas": 1,
                        "schemaVersion": "0.1",
                        "useSpotPods": True
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_inferencesessions_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            inference_service=inference_service,
            inference_service_name=inference_service_name,
            model=model,
            model_name=model_name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create an InferenceSession.

        Create an InferenceSession.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "inferenceService": "str",
                    "accelerator": {
                        "kind": "str",
                        "gpu": {
                            "hardwareTypes": [
                                "str"
                            ],
                            "count": 1,
                            "memory": "str"
                        }
                    },
                    "expires": "2020-02-20 00:00:00",
                    "replicas": 1,
                    "schemaVersion": "0.1",
                    "useSpotPods": True
                }

                # response body for status code(s): 200
                response == {
                    "inferencesession": {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "inferenceService": {
                            "account": "str",
                            "id": "str",
                            "interface": {
                                "endpoint": "str",
                                "outputSchema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            },
                            "name": "str",
                            "builder": {
                                "kind": "str",
                                "args": [
                                    "str"
                                ]
                            },
                            "model": {
                                "account": "str",
                                "artifact": {
                                    "kind": "str",
                                    "huggingFaceCache": {
                                        "repoID": "str",
                                        "revision": "str"
                                    }
                                },
                                "id": "str",
                                "name": "str",
                                "storage": {
                                    "medium": "str"
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "viewOf": "str",
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",
                                "resources": {
                                    "storage": "str",
                                    "memory": "str"
                                },
                                "accelerator": {
                                    "kind": "str",
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"
                                        ],
                                        "count": 1,
                                        "memory": "str"
                                    }
                                },
                                "args": [
                                    "str"
                                ],
                                "image": {
                                    "digest": "str",
                                    "host": "str",
                                    "name": "str",
                                    "tag": "str"
                                },
                                "nodes": 1
                            }
                        },
                        "status": "str",
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "expires": "2020-02-20 00:00:00",
                        "kind": "InferenceSession",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "replicas": 1,
                        "schemaVersion": "0.1",
                        "useSpotPods": True
                    },
                    "token": "str"
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create an InferenceSession.

        Create an InferenceSession.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "inferencesession": {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "inferenceService": {
                            "account": "str",
                            "id": "str",
                            "interface": {
                                "endpoint": "str",
                                "outputSchema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            },
                            "name": "str",
                            "builder": {
                                "kind": "str",
                                "args": [
                                    "str"
                                ]
                            },
                            "model": {
                                "account": "str",
                                "artifact": {
                                    "kind": "str",
                                    "huggingFaceCache": {
                                        "repoID": "str",
                                        "revision": "str"
                                    }
                                },
                                "id": "str",
                                "name": "str",
                                "storage": {
                                    "medium": "str"
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "viewOf": "str",
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",
                                "resources": {
                                    "storage": "str",
                                    "memory": "str"
                                },
                                "accelerator": {
                                    "kind": "str",
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"
                                        ],
                                        "count": 1,
                                        "memory": "str"
                                    }
                                },
                                "args": [
                                    "str"
                                ],
                                "image": {
                                    "digest": "str",
                                    "host": "str",
                                    "name": "str",
                                    "tag": "str"
                                },
                                "nodes": 1
                            }
                        },
                        "status": "str",
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "expires": "2020-02-20 00:00:00",
                        "kind": "InferenceSession",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "replicas": 1,
                        "schemaVersion": "0.1",
                        "useSpotPods": True
                    },
                    "token": "str"
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create an InferenceSession.

        Create an InferenceSession.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "inferenceService": "str",
                    "accelerator": {
                        "kind": "str",
                        "gpu": {
                            "hardwareTypes": [
                                "str"
                            ],
                            "count": 1,
                            "memory": "str"
                        }
                    },
                    "expires": "2020-02-20 00:00:00",
                    "replicas": 1,
                    "schemaVersion": "0.1",
                    "useSpotPods": True
                }

                # response body for status code(s): 200
                response == {
                    "inferencesession": {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "inferenceService": {
                            "account": "str",
                            "id": "str",
                            "interface": {
                                "endpoint": "str",
                                "outputSchema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "inputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ],
                                "outputPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            },
                            "name": "str",
                            "builder": {
                                "kind": "str",
                                "args": [
                                    "str"
                                ]
                            },
                            "model": {
                                "account": "str",
                                "artifact": {
                                    "kind": "str",
                                    "huggingFaceCache": {
                                        "repoID": "str",
                                        "revision": "str"
                                    }
                                },
                                "id": "str",
                                "name": "str",
                                "storage": {
                                    "medium": "str"
                                }
                            },
                            "outputViews": [
                                {
                                    "id": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "viewOf": "str",
                                    "adapterPipeline": [
                                        {
                                            "kind": "str",
                                            "configuration": {}
                                        }
                                    ]
                                }
                            ],
                            "runner": {
                                "kind": "str",
                                "resources": {
                                    "storage": "str",
                                    "memory": "str"
                                },
                                "accelerator": {
                                    "kind": "str",
                                    "gpu": {
                                        "hardwareTypes": [
                                            "str"
                                        ],
                                        "count": 1,
                                        "memory": "str"
                                    }
                                },
                                "args": [
                                    "str"
                                ],
                                "image": {
                                    "digest": "str",
                                    "host": "str",
                                    "name": "str",
                                    "tag": "str"
                                },
                                "nodes": 1
                            }
                        },
                        "status": "str",
                        "accelerator": {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        },
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "expires": "2020-02-20 00:00:00",
                        "kind": "InferenceSession",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "replicas": 1,
                        "schemaVersion": "0.1",
                        "useSpotPods": True
                    },
                    "token": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferencesessions_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get an InferenceSession by its key.

        Get an InferenceSession by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "inferenceService": {
                        "account": "str",
                        "id": "str",
                        "interface": {
                            "endpoint": "str",
                            "outputSchema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "inputPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ],
                            "outputPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        },
                        "name": "str",
                        "builder": {
                            "kind": "str",
                            "args": [
                                "str"
                            ]
                        },
                        "model": {
                            "account": "str",
                            "artifact": {
                                "kind": "str",
                                "huggingFaceCache": {
                                    "repoID": "str",
                                    "revision": "str"
                                }
                            },
                            "id": "str",
                            "name": "str",
                            "storage": {
                                "medium": "str"
                            }
                        },
                        "outputViews": [
                            {
                                "id": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "viewOf": "str",
                                "adapterPipeline": [
                                    {
                                        "kind": "str",
                                        "configuration": {}
                                    }
                                ]
                            }
                        ],
                        "runner": {
                            "kind": "str",
                            "resources": {
                                "storage": "str",
                                "memory": "str"
                            },
                            "accelerator": {
                                "kind": "str",
                                "gpu": {
                                    "hardwareTypes": [
                                        "str"
                                    ],
                                    "count": 1,
                                    "memory": "str"
                                }
                            },
                            "args": [
                                "str"
                            ],
                            "image": {
                                "digest": "str",
                                "host": "str",
                                "name": "str",
                                "tag": "str"
                            },
                            "nodes": 1
                        }
                    },
                    "status": "str",
                    "accelerator": {
                        "kind": "str",
                        "gpu": {
                            "hardwareTypes": [
                                "str"
                            ],
                            "count": 1,
                            "memory": "str"
                        }
                    },
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "expires": "2020-02-20 00:00:00",
                    "kind": "InferenceSession",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "replicas": 1,
                    "schemaVersion": "0.1",
                    "useSpotPods": True
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferencesessions_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark an InferenceSession for deletion.

        Mark an InferenceSession for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferencesessions_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def terminate(self, id: str, **kwargs: Any) -> JSON:
        """Terminate an InferenceSession.

        Terminate an InferenceSession.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_inferencesessions_terminate_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def infer(self, id: str, inference_endpoint: str, **kwargs: Any) -> Any:
        """Create an InferenceSession.

        Create an InferenceSession.

        :param id: Required.
        :type id: str
        :param inference_endpoint: Required.
        :type inference_endpoint: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_inferencesessions_infer_request(
            id=id,
            inference_endpoint=inference_endpoint,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @overload
    async def token(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> str:
        """Get an access token for an existing InferenceSession.

        Get an access token for an existing InferenceSession.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: str
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "expires": "2020-02-20 00:00:00",
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def token(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> str:
        """Get an access token for an existing InferenceSession.

        Get an access token for an existing InferenceSession.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: str
        :rtype: str :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def token(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> str:
        """Get an access token for an existing InferenceSession.

        Get an access token for an existing InferenceSession.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: str
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "expires": "2020-02-20 00:00:00",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[str] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_inferencesessions_token_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(str, deserialized), {})  # type: ignore

        return cast(str, deserialized)  # type: ignore

    @distributed_trace_async
    async def ready(self, id: str, **kwargs: Any) -> Any:
        """Perform a readiness probe on the session.

        Check if an InferenceSession is ready. Returns status 200 if the session is
        ready. Raises a 503 (ServiceUnavailable) error if the session is not ready.

        Raises a 404 error if no session exists with the provided ID. Note that this may
        happen temporarily for session that were created recently, as it takes time for
        status information to propagate through the platform.

        :param id: Required.
        :type id: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_inferencesessions_ready_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore


class MeasurementsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`measurements` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Measurement.

        Update labels for an existing Measurement.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Measurement.

        Update labels for an existing Measurement.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing Measurement.

        Update labels for an existing Measurement.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_measurements_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        method: Optional[str] = None,
        method_name: Optional[str] = None,
        dataset: Optional[str] = None,
        evaluation: Optional[str] = None,
        inference_service: Optional[str] = None,
        model: Optional[str] = None,
        inputs: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all Measurements matching a query.

        Get all Measurements matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword method: Default value is None.
        :paramtype method: str
        :keyword method_name: Default value is None.
        :paramtype method_name: str
        :keyword dataset: Default value is None.
        :paramtype dataset: str
        :keyword evaluation: Default value is None.
        :paramtype evaluation: str
        :keyword inference_service: Default value is None.
        :paramtype inference_service: str
        :keyword model: Default value is None.
        :paramtype model: str
        :keyword inputs: Default value is None.
        :paramtype inputs: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "level": "str",
                        "method": {
                            "account": "str",
                            "id": "str",
                            "implementation": {
                                "kind": "str",
                                "jupyterNotebook": {
                                    "notebookModule": "str",
                                    "notebookPath": "str"
                                },
                                "pythonFunction": {
                                    "fullyQualifiedName": "str"
                                },
                                "pythonRubric": {
                                    "fullyQualifiedName": "str"
                                }
                            },
                            "name": "str",
                            "output": {
                                "kind": "str",
                                "measurement": {
                                    "level": "str",
                                    "name": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "description": "str"
                                },
                                "safetyCase": {
                                    "name": "str",
                                    "description": "str"
                                }
                            },
                            "scope": "str",
                            "description": "str",
                            "inputs": [
                                {
                                    "keyword": "str",
                                    "kind": "str",
                                    "description": "str"
                                }
                            ],
                            "modules": [
                                "str"
                            ],
                            "parameters": [
                                {
                                    "keyword": "str",
                                    "description": "str"
                                }
                            ],
                            "scores": [
                                {
                                    "name": "str",
                                    "summary": "str",
                                    "title": "str",
                                    "format": "{quantity:.1f}",
                                    "maximum": 0.0,
                                    "minimum": 0.0,
                                    "priority": "primary",
                                    "unit": "str",
                                    "valence": "neutral"
                                }
                            ]
                        },
                        "name": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "arguments": [
                            {
                                "keyword": "str",
                                "value": "str"
                            }
                        ],
                        "data": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "description": "str",
                        "inputs": [
                            {
                                "entity": "str",
                                "keyword": "str"
                            }
                        ],
                        "kind": "Measurement",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "schemaVersion": "0.1",
                        "scope": {
                            "dataset": "str",
                            "evaluation": "str",
                            "inferenceService": "str",
                            "model": "str"
                        }
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_measurements_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            method=method,
            method_name=method_name,
            dataset=dataset,
            evaluation=evaluation,
            inference_service=inference_service,
            model=model,
            inputs=inputs,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Measurement.

        Create a Measurement.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "method": "str",
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "level": "str",
                    "method": {
                        "account": "str",
                        "id": "str",
                        "implementation": {
                            "kind": "str",
                            "jupyterNotebook": {
                                "notebookModule": "str",
                                "notebookPath": "str"
                            },
                            "pythonFunction": {
                                "fullyQualifiedName": "str"
                            },
                            "pythonRubric": {
                                "fullyQualifiedName": "str"
                            }
                        },
                        "name": "str",
                        "output": {
                            "kind": "str",
                            "measurement": {
                                "level": "str",
                                "name": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "description": "str"
                            },
                            "safetyCase": {
                                "name": "str",
                                "description": "str"
                            }
                        },
                        "scope": "str",
                        "description": "str",
                        "inputs": [
                            {
                                "keyword": "str",
                                "kind": "str",
                                "description": "str"
                            }
                        ],
                        "modules": [
                            "str"
                        ],
                        "parameters": [
                            {
                                "keyword": "str",
                                "description": "str"
                            }
                        ],
                        "scores": [
                            {
                                "name": "str",
                                "summary": "str",
                                "title": "str",
                                "format": "{quantity:.1f}",
                                "maximum": 0.0,
                                "minimum": 0.0,
                                "priority": "primary",
                                "unit": "str",
                                "valence": "neutral"
                            }
                        ]
                    },
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "data": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "kind": "Measurement",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Measurement.

        Create a Measurement.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "level": "str",
                    "method": {
                        "account": "str",
                        "id": "str",
                        "implementation": {
                            "kind": "str",
                            "jupyterNotebook": {
                                "notebookModule": "str",
                                "notebookPath": "str"
                            },
                            "pythonFunction": {
                                "fullyQualifiedName": "str"
                            },
                            "pythonRubric": {
                                "fullyQualifiedName": "str"
                            }
                        },
                        "name": "str",
                        "output": {
                            "kind": "str",
                            "measurement": {
                                "level": "str",
                                "name": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "description": "str"
                            },
                            "safetyCase": {
                                "name": "str",
                                "description": "str"
                            }
                        },
                        "scope": "str",
                        "description": "str",
                        "inputs": [
                            {
                                "keyword": "str",
                                "kind": "str",
                                "description": "str"
                            }
                        ],
                        "modules": [
                            "str"
                        ],
                        "parameters": [
                            {
                                "keyword": "str",
                                "description": "str"
                            }
                        ],
                        "scores": [
                            {
                                "name": "str",
                                "summary": "str",
                                "title": "str",
                                "format": "{quantity:.1f}",
                                "maximum": 0.0,
                                "minimum": 0.0,
                                "priority": "primary",
                                "unit": "str",
                                "valence": "neutral"
                            }
                        ]
                    },
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "data": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "kind": "Measurement",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create a Measurement.

        Create a Measurement.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "method": "str",
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "level": "str",
                    "method": {
                        "account": "str",
                        "id": "str",
                        "implementation": {
                            "kind": "str",
                            "jupyterNotebook": {
                                "notebookModule": "str",
                                "notebookPath": "str"
                            },
                            "pythonFunction": {
                                "fullyQualifiedName": "str"
                            },
                            "pythonRubric": {
                                "fullyQualifiedName": "str"
                            }
                        },
                        "name": "str",
                        "output": {
                            "kind": "str",
                            "measurement": {
                                "level": "str",
                                "name": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "description": "str"
                            },
                            "safetyCase": {
                                "name": "str",
                                "description": "str"
                            }
                        },
                        "scope": "str",
                        "description": "str",
                        "inputs": [
                            {
                                "keyword": "str",
                                "kind": "str",
                                "description": "str"
                            }
                        ],
                        "modules": [
                            "str"
                        ],
                        "parameters": [
                            {
                                "keyword": "str",
                                "description": "str"
                            }
                        ],
                        "scores": [
                            {
                                "name": "str",
                                "summary": "str",
                                "title": "str",
                                "format": "{quantity:.1f}",
                                "maximum": 0.0,
                                "minimum": 0.0,
                                "priority": "primary",
                                "unit": "str",
                                "valence": "neutral"
                            }
                        ]
                    },
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "data": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "kind": "Measurement",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_measurements_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a Measurement by its key.

        Get a Measurement by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "level": "str",
                    "method": {
                        "account": "str",
                        "id": "str",
                        "implementation": {
                            "kind": "str",
                            "jupyterNotebook": {
                                "notebookModule": "str",
                                "notebookPath": "str"
                            },
                            "pythonFunction": {
                                "fullyQualifiedName": "str"
                            },
                            "pythonRubric": {
                                "fullyQualifiedName": "str"
                            }
                        },
                        "name": "str",
                        "output": {
                            "kind": "str",
                            "measurement": {
                                "level": "str",
                                "name": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "description": "str"
                            },
                            "safetyCase": {
                                "name": "str",
                                "description": "str"
                            }
                        },
                        "scope": "str",
                        "description": "str",
                        "inputs": [
                            {
                                "keyword": "str",
                                "kind": "str",
                                "description": "str"
                            }
                        ],
                        "modules": [
                            "str"
                        ],
                        "parameters": [
                            {
                                "keyword": "str",
                                "description": "str"
                            }
                        ],
                        "scores": [
                            {
                                "name": "str",
                                "summary": "str",
                                "title": "str",
                                "format": "{quantity:.1f}",
                                "maximum": 0.0,
                                "minimum": 0.0,
                                "priority": "primary",
                                "unit": "str",
                                "valence": "neutral"
                            }
                        ]
                    },
                    "name": "str",
                    "schema": {
                        "arrowSchema": "str",
                        "dyffSchema": {
                            "components": [
                                "str"
                            ],
                            "schemaVersion": "0.1"
                        },
                        "jsonSchema": {}
                    },
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "data": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "kind": "Measurement",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_measurements_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark a Measurement for deletion.

        Mark a Measurement for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_measurements_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def downlinks(self, id: str, **kwargs: Any) -> List[JSON]:
        """Get a list of signed GET URLs from which measurement artifacts can be
        downloaded.

        Get a list of signed GET URLs from which measurement artifacts can be downloaded.

        :param id: Required.
        :type id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "artifact": {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        },
                        "signedURL": {
                            "method": "str",
                            "url": "str",
                            "headers": {
                                "str": "str"
                            }
                        }
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_measurements_downlinks_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace_async
    async def logs(self, id: str, **kwargs: Any) -> JSON:
        """Get a signed GET URL from which the logs file for the measurement run can be
        downloaded.

        Get a signed GET URL from which the logs file for the measurement run can be downloaded.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "artifact": {
                        "path": "str",
                        "digest": {
                            "md5": "str"
                        },
                        "kind": "str"
                    },
                    "signedURL": {
                        "method": "str",
                        "url": "str",
                        "headers": {
                            "str": "str"
                        }
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_measurements_logs_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class MethodsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`methods` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Method.

        Update labels for an existing Method.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Method.

        Update labels for an existing Method.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing Method.

        Update labels for an existing Method.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_methods_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        output_kind: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all Methods matching a query.

        Get all Methods matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :keyword output_kind: Default value is None.
        :paramtype output_kind: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "implementation": {
                            "kind": "str",
                            "jupyterNotebook": {
                                "notebookModule": "str",
                                "notebookPath": "str"
                            },
                            "pythonFunction": {
                                "fullyQualifiedName": "str"
                            },
                            "pythonRubric": {
                                "fullyQualifiedName": "str"
                            }
                        },
                        "name": "str",
                        "output": {
                            "kind": "str",
                            "measurement": {
                                "level": "str",
                                "name": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "description": "str"
                            },
                            "safetyCase": {
                                "name": "str",
                                "description": "str"
                            }
                        },
                        "scope": "str",
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "description": "str",
                        "inputs": [
                            {
                                "keyword": "str",
                                "kind": "str",
                                "description": "str"
                            }
                        ],
                        "kind": "Method",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "modules": [
                            "str"
                        ],
                        "parameters": [
                            {
                                "keyword": "str",
                                "description": "str"
                            }
                        ],
                        "reason": "str",
                        "schemaVersion": "0.1",
                        "scores": [
                            {
                                "name": "str",
                                "summary": "str",
                                "title": "str",
                                "format": "{quantity:.1f}",
                                "maximum": 0.0,
                                "minimum": 0.0,
                                "priority": "primary",
                                "unit": "str",
                                "valence": "neutral"
                            }
                        ]
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_methods_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            output_kind=output_kind,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Method.

        Create a Method.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "implementation": {
                        "kind": "str",
                        "jupyterNotebook": {
                            "notebookModule": "str",
                            "notebookPath": "str"
                        },
                        "pythonFunction": {
                            "fullyQualifiedName": "str"
                        },
                        "pythonRubric": {
                            "fullyQualifiedName": "str"
                        }
                    },
                    "name": "str",
                    "output": {
                        "kind": "str",
                        "measurement": {
                            "level": "str",
                            "name": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "description": "str"
                        },
                        "safetyCase": {
                            "name": "str",
                            "description": "str"
                        }
                    },
                    "scope": "str",
                    "description": "str",
                    "inputs": [
                        {
                            "keyword": "str",
                            "kind": "str",
                            "description": "str"
                        }
                    ],
                    "modules": [
                        "str"
                    ],
                    "parameters": [
                        {
                            "keyword": "str",
                            "description": "str"
                        }
                    ],
                    "schemaVersion": "0.1",
                    "scores": [
                        {
                            "name": "str",
                            "summary": "str",
                            "title": "str",
                            "format": "{quantity:.1f}",
                            "maximum": 0.0,
                            "minimum": 0.0,
                            "priority": "primary",
                            "unit": "str",
                            "valence": "neutral"
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "implementation": {
                        "kind": "str",
                        "jupyterNotebook": {
                            "notebookModule": "str",
                            "notebookPath": "str"
                        },
                        "pythonFunction": {
                            "fullyQualifiedName": "str"
                        },
                        "pythonRubric": {
                            "fullyQualifiedName": "str"
                        }
                    },
                    "name": "str",
                    "output": {
                        "kind": "str",
                        "measurement": {
                            "level": "str",
                            "name": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "description": "str"
                        },
                        "safetyCase": {
                            "name": "str",
                            "description": "str"
                        }
                    },
                    "scope": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "keyword": "str",
                            "kind": "str",
                            "description": "str"
                        }
                    ],
                    "kind": "Method",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "modules": [
                        "str"
                    ],
                    "parameters": [
                        {
                            "keyword": "str",
                            "description": "str"
                        }
                    ],
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scores": [
                        {
                            "name": "str",
                            "summary": "str",
                            "title": "str",
                            "format": "{quantity:.1f}",
                            "maximum": 0.0,
                            "minimum": 0.0,
                            "priority": "primary",
                            "unit": "str",
                            "valence": "neutral"
                        }
                    ]
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Method.

        Create a Method.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "implementation": {
                        "kind": "str",
                        "jupyterNotebook": {
                            "notebookModule": "str",
                            "notebookPath": "str"
                        },
                        "pythonFunction": {
                            "fullyQualifiedName": "str"
                        },
                        "pythonRubric": {
                            "fullyQualifiedName": "str"
                        }
                    },
                    "name": "str",
                    "output": {
                        "kind": "str",
                        "measurement": {
                            "level": "str",
                            "name": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "description": "str"
                        },
                        "safetyCase": {
                            "name": "str",
                            "description": "str"
                        }
                    },
                    "scope": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "keyword": "str",
                            "kind": "str",
                            "description": "str"
                        }
                    ],
                    "kind": "Method",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "modules": [
                        "str"
                    ],
                    "parameters": [
                        {
                            "keyword": "str",
                            "description": "str"
                        }
                    ],
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scores": [
                        {
                            "name": "str",
                            "summary": "str",
                            "title": "str",
                            "format": "{quantity:.1f}",
                            "maximum": 0.0,
                            "minimum": 0.0,
                            "priority": "primary",
                            "unit": "str",
                            "valence": "neutral"
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create a Method.

        Create a Method.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "implementation": {
                        "kind": "str",
                        "jupyterNotebook": {
                            "notebookModule": "str",
                            "notebookPath": "str"
                        },
                        "pythonFunction": {
                            "fullyQualifiedName": "str"
                        },
                        "pythonRubric": {
                            "fullyQualifiedName": "str"
                        }
                    },
                    "name": "str",
                    "output": {
                        "kind": "str",
                        "measurement": {
                            "level": "str",
                            "name": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "description": "str"
                        },
                        "safetyCase": {
                            "name": "str",
                            "description": "str"
                        }
                    },
                    "scope": "str",
                    "description": "str",
                    "inputs": [
                        {
                            "keyword": "str",
                            "kind": "str",
                            "description": "str"
                        }
                    ],
                    "modules": [
                        "str"
                    ],
                    "parameters": [
                        {
                            "keyword": "str",
                            "description": "str"
                        }
                    ],
                    "schemaVersion": "0.1",
                    "scores": [
                        {
                            "name": "str",
                            "summary": "str",
                            "title": "str",
                            "format": "{quantity:.1f}",
                            "maximum": 0.0,
                            "minimum": 0.0,
                            "priority": "primary",
                            "unit": "str",
                            "valence": "neutral"
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "implementation": {
                        "kind": "str",
                        "jupyterNotebook": {
                            "notebookModule": "str",
                            "notebookPath": "str"
                        },
                        "pythonFunction": {
                            "fullyQualifiedName": "str"
                        },
                        "pythonRubric": {
                            "fullyQualifiedName": "str"
                        }
                    },
                    "name": "str",
                    "output": {
                        "kind": "str",
                        "measurement": {
                            "level": "str",
                            "name": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "description": "str"
                        },
                        "safetyCase": {
                            "name": "str",
                            "description": "str"
                        }
                    },
                    "scope": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "keyword": "str",
                            "kind": "str",
                            "description": "str"
                        }
                    ],
                    "kind": "Method",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "modules": [
                        "str"
                    ],
                    "parameters": [
                        {
                            "keyword": "str",
                            "description": "str"
                        }
                    ],
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scores": [
                        {
                            "name": "str",
                            "summary": "str",
                            "title": "str",
                            "format": "{quantity:.1f}",
                            "maximum": 0.0,
                            "minimum": 0.0,
                            "priority": "primary",
                            "unit": "str",
                            "valence": "neutral"
                        }
                    ]
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_methods_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a Method by its key.

        Get a Method by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "implementation": {
                        "kind": "str",
                        "jupyterNotebook": {
                            "notebookModule": "str",
                            "notebookPath": "str"
                        },
                        "pythonFunction": {
                            "fullyQualifiedName": "str"
                        },
                        "pythonRubric": {
                            "fullyQualifiedName": "str"
                        }
                    },
                    "name": "str",
                    "output": {
                        "kind": "str",
                        "measurement": {
                            "level": "str",
                            "name": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "description": "str"
                        },
                        "safetyCase": {
                            "name": "str",
                            "description": "str"
                        }
                    },
                    "scope": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "keyword": "str",
                            "kind": "str",
                            "description": "str"
                        }
                    ],
                    "kind": "Method",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "modules": [
                        "str"
                    ],
                    "parameters": [
                        {
                            "keyword": "str",
                            "description": "str"
                        }
                    ],
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scores": [
                        {
                            "name": "str",
                            "summary": "str",
                            "title": "str",
                            "format": "{quantity:.1f}",
                            "maximum": 0.0,
                            "minimum": 0.0,
                            "priority": "primary",
                            "unit": "str",
                            "valence": "neutral"
                        }
                    ]
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_methods_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark a Method for deletion.

        Mark a Method for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_methods_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def documentation(self, id: str, **kwargs: Any) -> JSON:
        """Get the documentation associated with a Method.

        Get the documentation associated with a Method.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_methods_documentation_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with a Method.

        Edit the documentation associated with a Method.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with a Method.

        Edit the documentation associated with a Method.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @distributed_trace_async
    async def edit_documentation(
        self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        """Edit the documentation associated with a Method.

        Edit the documentation associated with a Method.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_methods_edit_documentation_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class ModelsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`models` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Model.

        Update labels for an existing Model.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Model.

        Update labels for an existing Model.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing Model.

        Update labels for an existing Model.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_models_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all Models matching a query.

        Get all Models matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "artifact": {
                            "kind": "str",
                            "huggingFaceCache": {
                                "repoID": "str",
                                "revision": "str"
                            }
                        },
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "name": "str",
                        "resources": {
                            "storage": "str",
                            "memory": "str"
                        },
                        "source": {
                            "kind": "str",
                            "gitLFS": {
                                "url": "str"
                            },
                            "huggingFaceHub": {
                                "repoID": "str",
                                "revision": "str",
                                "allowPatterns": [
                                    "str"
                                ],
                                "ignorePatterns": [
                                    "str"
                                ]
                            },
                            "openLLM": {
                                "modelID": "str",
                                "modelKind": "str",
                                "modelVersion": "str"
                            }
                        },
                        "status": "str",
                        "storage": {
                            "medium": "str"
                        },
                        "accelerators": [
                            {
                                "kind": "str",
                                "gpu": {
                                    "hardwareTypes": [
                                        "str"
                                    ],
                                    "count": 1,
                                    "memory": "str"
                                }
                            }
                        ],
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "kind": "Model",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "schemaVersion": "0.1"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_models_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Model.

        Create a Model.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "artifact": {
                        "kind": "str",
                        "huggingFaceCache": {
                            "repoID": "str",
                            "revision": "str"
                        }
                    },
                    "name": "str",
                    "resources": {
                        "storage": "str",
                        "memory": "str"
                    },
                    "source": {
                        "kind": "str",
                        "gitLFS": {
                            "url": "str"
                        },
                        "huggingFaceHub": {
                            "repoID": "str",
                            "revision": "str",
                            "allowPatterns": [
                                "str"
                            ],
                            "ignorePatterns": [
                                "str"
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",
                            "modelKind": "str",
                            "modelVersion": "str"
                        }
                    },
                    "storage": {
                        "medium": "str"
                    },
                    "accelerators": [
                        {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        }
                    ],
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifact": {
                        "kind": "str",
                        "huggingFaceCache": {
                            "repoID": "str",
                            "revision": "str"
                        }
                    },
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "resources": {
                        "storage": "str",
                        "memory": "str"
                    },
                    "source": {
                        "kind": "str",
                        "gitLFS": {
                            "url": "str"
                        },
                        "huggingFaceHub": {
                            "repoID": "str",
                            "revision": "str",
                            "allowPatterns": [
                                "str"
                            ],
                            "ignorePatterns": [
                                "str"
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",
                            "modelKind": "str",
                            "modelVersion": "str"
                        }
                    },
                    "status": "str",
                    "storage": {
                        "medium": "str"
                    },
                    "accelerators": [
                        {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        }
                    ],
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Model",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Model.

        Create a Model.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifact": {
                        "kind": "str",
                        "huggingFaceCache": {
                            "repoID": "str",
                            "revision": "str"
                        }
                    },
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "resources": {
                        "storage": "str",
                        "memory": "str"
                    },
                    "source": {
                        "kind": "str",
                        "gitLFS": {
                            "url": "str"
                        },
                        "huggingFaceHub": {
                            "repoID": "str",
                            "revision": "str",
                            "allowPatterns": [
                                "str"
                            ],
                            "ignorePatterns": [
                                "str"
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",
                            "modelKind": "str",
                            "modelVersion": "str"
                        }
                    },
                    "status": "str",
                    "storage": {
                        "medium": "str"
                    },
                    "accelerators": [
                        {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        }
                    ],
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Model",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create a Model.

        Create a Model.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "artifact": {
                        "kind": "str",
                        "huggingFaceCache": {
                            "repoID": "str",
                            "revision": "str"
                        }
                    },
                    "name": "str",
                    "resources": {
                        "storage": "str",
                        "memory": "str"
                    },
                    "source": {
                        "kind": "str",
                        "gitLFS": {
                            "url": "str"
                        },
                        "huggingFaceHub": {
                            "repoID": "str",
                            "revision": "str",
                            "allowPatterns": [
                                "str"
                            ],
                            "ignorePatterns": [
                                "str"
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",
                            "modelKind": "str",
                            "modelVersion": "str"
                        }
                    },
                    "storage": {
                        "medium": "str"
                    },
                    "accelerators": [
                        {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        }
                    ],
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifact": {
                        "kind": "str",
                        "huggingFaceCache": {
                            "repoID": "str",
                            "revision": "str"
                        }
                    },
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "resources": {
                        "storage": "str",
                        "memory": "str"
                    },
                    "source": {
                        "kind": "str",
                        "gitLFS": {
                            "url": "str"
                        },
                        "huggingFaceHub": {
                            "repoID": "str",
                            "revision": "str",
                            "allowPatterns": [
                                "str"
                            ],
                            "ignorePatterns": [
                                "str"
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",
                            "modelKind": "str",
                            "modelVersion": "str"
                        }
                    },
                    "status": "str",
                    "storage": {
                        "medium": "str"
                    },
                    "accelerators": [
                        {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        }
                    ],
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Model",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_models_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a Model by its key.

        Get a Model by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifact": {
                        "kind": "str",
                        "huggingFaceCache": {
                            "repoID": "str",
                            "revision": "str"
                        }
                    },
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "resources": {
                        "storage": "str",
                        "memory": "str"
                    },
                    "source": {
                        "kind": "str",
                        "gitLFS": {
                            "url": "str"
                        },
                        "huggingFaceHub": {
                            "repoID": "str",
                            "revision": "str",
                            "allowPatterns": [
                                "str"
                            ],
                            "ignorePatterns": [
                                "str"
                            ]
                        },
                        "openLLM": {
                            "modelID": "str",
                            "modelKind": "str",
                            "modelVersion": "str"
                        }
                    },
                    "status": "str",
                    "storage": {
                        "medium": "str"
                    },
                    "accelerators": [
                        {
                            "kind": "str",
                            "gpu": {
                                "hardwareTypes": [
                                    "str"
                                ],
                                "count": 1,
                                "memory": "str"
                            }
                        }
                    ],
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Model",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_models_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark a Model for deletion.

        Mark a Model for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_models_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def documentation(self, id: str, **kwargs: Any) -> JSON:
        """Get the documentation associated with a Model.

        Get the documentation associated with a Model.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_models_documentation_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with a Model.

        Edit the documentation associated with a Model.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with a Model.

        Edit the documentation associated with a Model.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @distributed_trace_async
    async def edit_documentation(
        self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        """Edit the documentation associated with a Model.

        Edit the documentation associated with a Model.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_models_edit_documentation_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class ModulesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`modules` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Module.

        Update labels for an existing Module.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Module.

        Update labels for an existing Module.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing Module.

        Update labels for an existing Module.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_modules_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all Modules matching a query.

        Get all Modules matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword name: Default value is None.
        :paramtype name: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "artifacts": [
                            {
                                "path": "str",
                                "digest": {
                                    "md5": "str"
                                },
                                "kind": "str"
                            }
                        ],
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "name": "str",
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "kind": "Module",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "schemaVersion": "0.1"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_modules_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            name=name,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Module.

        Create a Module.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "name": "str",
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Module",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Module.

        Create a Module.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Module",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create a Module.

        Create a Module.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "name": "str",
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Module",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_modules_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a Module by its key.

        Get a Module by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "artifacts": [
                        {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        }
                    ],
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "kind": "Module",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_modules_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark a Module for deletion.

        Mark a Module for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_modules_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def upload(self, id: str, artifact_path: str, **kwargs: Any) -> JSON:
        """Get a signed URL to which the given artifact can be uploaded.

        Get a signed URL to which the given artifact can be uploaded.

        :param id: Required.
        :type id: str
        :param artifact_path: Required.
        :type artifact_path: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "method": "str",
                    "url": "str",
                    "headers": {
                        "str": "str"
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_modules_upload_request(
            id=id,
            artifact_path=artifact_path,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def finalize(self, id: str, **kwargs: Any) -> Any:
        """Indicate that all module artifacts have been uploaded.

        Indicate that all module artifacts have been uploaded.

        :param id: Required.
        :type id: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_modules_finalize_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def downlinks(self, id: str, **kwargs: Any) -> List[JSON]:
        """Get a list of signed GET URLs from which Module artifacts can be downloaded.

        Get a list of signed GET URLs from which Module artifacts can be downloaded.

        :param id: Required.
        :type id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "artifact": {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        },
                        "signedURL": {
                            "method": "str",
                            "url": "str",
                            "headers": {
                                "str": "str"
                            }
                        }
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_modules_downlinks_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace_async
    async def documentation(self, id: str, **kwargs: Any) -> JSON:
        """Get the documentation associated with a Module.

        Get the documentation associated with a Module.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_modules_documentation_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with a Module.

        Edit the documentation associated with a Module.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> JSON:
        """Edit the documentation associated with a Module.

        Edit the documentation associated with a Module.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """

    @distributed_trace_async
    async def edit_documentation(
        self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        """Edit the documentation associated with a Module.

        Edit the documentation associated with a Module.

        Raises a 404 error if no entity exists with that key. Returns the
        modified Documentation.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "entity": "str",
                    "fullPage": "str",
                    "schemaVersion": "0.1",
                    "summary": "str",
                    "title": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_modules_edit_documentation_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class UsecasesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`usecases` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a UseCase by its key.

        Get a UseCase by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "documentation": {
                        "fullPage": "str",
                        "summary": "str",
                        "title": "str"
                    },
                    "kind": "UseCase",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_usecases_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all UseCases matching a query.

        Get all UseCases matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "kind": "UseCase",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "schemaVersion": "0.1"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_usecases_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a UseCase.

        Create a UseCase.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "documentation": {
                        "fullPage": "str",
                        "summary": "str",
                        "title": "str"
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "documentation": {
                        "fullPage": "str",
                        "summary": "str",
                        "title": "str"
                    },
                    "kind": "UseCase",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a UseCase.

        Create a UseCase.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "documentation": {
                        "fullPage": "str",
                        "summary": "str",
                        "title": "str"
                    },
                    "kind": "UseCase",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create a UseCase.

        Create a UseCase.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "documentation": {
                        "fullPage": "str",
                        "summary": "str",
                        "title": "str"
                    },
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "documentation": {
                        "fullPage": "str",
                        "summary": "str",
                        "title": "str"
                    },
                    "kind": "UseCase",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_usecases_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing UseCase.

        Update labels for an existing UseCase.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing UseCase.

        Update labels for an existing UseCase.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing UseCase.

        Update labels for an existing UseCase.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_usecases_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Edit the documentation associated with a UseCase.

        Edit the documentation associated with a UseCase.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def edit_documentation(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Edit the documentation associated with a UseCase.

        Edit the documentation associated with a UseCase.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def edit_documentation(
        self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any
    ) -> Any:
        """Edit the documentation associated with a UseCase.

        Edit the documentation associated with a UseCase.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "documentation": {
                        "fullPage": {},
                        "summary": {},
                        "title": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_usecases_edit_documentation_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark a UseCase for deletion.

        Mark a UseCase for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_usecases_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class ReportsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`reports` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Report.

        Update labels for an existing Report.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing Report.

        Update labels for an existing Report.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing Report.

        Update labels for an existing Report.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_reports_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        report: Optional[str] = None,
        dataset: Optional[str] = None,
        evaluation: Optional[str] = None,
        inference_service: Optional[str] = None,
        model: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all Reports matching a query.

        Get all Reports matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword report: Default value is None.
        :paramtype report: str
        :keyword dataset: Default value is None.
        :paramtype dataset: str
        :keyword evaluation: Default value is None.
        :paramtype evaluation: str
        :keyword inference_service: Default value is None.
        :paramtype inference_service: str
        :keyword model: Default value is None.
        :paramtype model: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "dataset": "str",
                        "evaluation": "str",
                        "id": "str",
                        "inferenceService": "str",
                        "rubric": "str",
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "datasetView": {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        },
                        "evaluationView": {
                            "id": "str",
                            "schema": {
                                "arrowSchema": "str",
                                "dyffSchema": {
                                    "components": [
                                        "str"
                                    ],
                                    "schemaVersion": "0.1"
                                },
                                "jsonSchema": {}
                            },
                            "viewOf": "str",
                            "adapterPipeline": [
                                {
                                    "kind": "str",
                                    "configuration": {}
                                }
                            ]
                        },
                        "kind": "Report",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "model": "str",
                        "modules": [
                            "str"
                        ],
                        "reason": "str",
                        "schemaVersion": "0.1"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_reports_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            report=report,
            dataset=dataset,
            evaluation=evaluation,
            inference_service=inference_service,
            model=model,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Report.

        Create a Report.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "evaluation": "str",
                    "rubric": "str",
                    "datasetView": {},
                    "evaluationView": {},
                    "modules": [
                        "str"
                    ],
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "dataset": "str",
                    "evaluation": "str",
                    "id": "str",
                    "inferenceService": "str",
                    "rubric": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "datasetView": {
                        "id": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "viewOf": "str",
                        "adapterPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "evaluationView": {
                        "id": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "viewOf": "str",
                        "adapterPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "kind": "Report",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "model": "str",
                    "modules": [
                        "str"
                    ],
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a Report.

        Create a Report.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "dataset": "str",
                    "evaluation": "str",
                    "id": "str",
                    "inferenceService": "str",
                    "rubric": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "datasetView": {
                        "id": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "viewOf": "str",
                        "adapterPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "evaluationView": {
                        "id": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "viewOf": "str",
                        "adapterPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "kind": "Report",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "model": "str",
                    "modules": [
                        "str"
                    ],
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create a Report.

        Create a Report.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "evaluation": "str",
                    "rubric": "str",
                    "datasetView": {},
                    "evaluationView": {},
                    "modules": [
                        "str"
                    ],
                    "schemaVersion": "0.1"
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "dataset": "str",
                    "evaluation": "str",
                    "id": "str",
                    "inferenceService": "str",
                    "rubric": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "datasetView": {
                        "id": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "viewOf": "str",
                        "adapterPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "evaluationView": {
                        "id": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "viewOf": "str",
                        "adapterPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "kind": "Report",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "model": "str",
                    "modules": [
                        "str"
                    ],
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_reports_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a Report by its key.

        Get a Report by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "dataset": "str",
                    "evaluation": "str",
                    "id": "str",
                    "inferenceService": "str",
                    "rubric": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "datasetView": {
                        "id": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "viewOf": "str",
                        "adapterPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "evaluationView": {
                        "id": "str",
                        "schema": {
                            "arrowSchema": "str",
                            "dyffSchema": {
                                "components": [
                                    "str"
                                ],
                                "schemaVersion": "0.1"
                            },
                            "jsonSchema": {}
                        },
                        "viewOf": "str",
                        "adapterPipeline": [
                            {
                                "kind": "str",
                                "configuration": {}
                            }
                        ]
                    },
                    "kind": "Report",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "model": "str",
                    "modules": [
                        "str"
                    ],
                    "reason": "str",
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_reports_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark a Report for deletion.

        Mark a Report for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_reports_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def downlinks(self, id: str, **kwargs: Any) -> List[JSON]:
        """Get a list of signed GET URLs from which Report artifacts can be downloaded.

        Get a list of signed GET URLs from which Report artifacts can be downloaded.

        :param id: Required.
        :type id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "artifact": {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        },
                        "signedURL": {
                            "method": "str",
                            "url": "str",
                            "headers": {
                                "str": "str"
                            }
                        }
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_reports_downlinks_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace_async
    async def logs(self, id: str, **kwargs: Any) -> JSON:
        """Get a signed GET URL from which the logs file for the report run can be
        downloaded.

        Get a signed GET URL from which the logs file for the report run can be downloaded.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "artifact": {
                        "path": "str",
                        "digest": {
                            "md5": "str"
                        },
                        "kind": "str"
                    },
                    "signedURL": {
                        "method": "str",
                        "url": "str",
                        "headers": {
                            "str": "str"
                        }
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_reports_logs_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class SafetycasesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~_generated.aio.DyffV0API`'s
        :attr:`safetycases` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = (
            input_args.pop(0) if input_args else kwargs.pop("client")
        )
        self._config: DyffV0APIConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = (
            input_args.pop(0) if input_args else kwargs.pop("serializer")
        )
        self._deserialize: Deserializer = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace_async
    async def scores(self, id: str, **kwargs: Any) -> List[JSON]:
        """Get the Scores for a SafetyCase.

        Get the Scores for a SafetyCase.

        :param id: Required.
        :type id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "analysis": "str",
                        "id": "str",
                        "metadata": {
                            "refs": {
                                "method": "str",
                                "dataset": "str",
                                "evaluation": "str",
                                "inferenceService": "str",
                                "model": "str"
                            }
                        },
                        "name": "str",
                        "quantity": 0.0,
                        "quantityString": "str",
                        "summary": "str",
                        "text": "str",
                        "title": "str",
                        "format": "{quantity:.1f}",
                        "kind": "Score",
                        "maximum": 0.0,
                        "minimum": 0.0,
                        "priority": "primary",
                        "unit": "str",
                        "valence": "neutral"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_safetycases_scores_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace_async
    async def query_scores(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        method: Optional[str] = None,
        method_name: Optional[str] = None,
        dataset: Optional[str] = None,
        evaluation: Optional[str] = None,
        inference_service: Optional[str] = None,
        model: Optional[str] = None,
        inputs: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get the Scores for all SafetyCase entities matching a query.

        Get the Scores for all SafetyCase entities matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword method: Default value is None.
        :paramtype method: str
        :keyword method_name: Default value is None.
        :paramtype method_name: str
        :keyword dataset: Default value is None.
        :paramtype dataset: str
        :keyword evaluation: Default value is None.
        :paramtype evaluation: str
        :keyword inference_service: Default value is None.
        :paramtype inference_service: str
        :keyword model: Default value is None.
        :paramtype model: str
        :keyword inputs: Default value is None.
        :paramtype inputs: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "analysis": "str",
                        "id": "str",
                        "metadata": {
                            "refs": {
                                "method": "str",
                                "dataset": "str",
                                "evaluation": "str",
                                "inferenceService": "str",
                                "model": "str"
                            }
                        },
                        "name": "str",
                        "quantity": 0.0,
                        "quantityString": "str",
                        "summary": "str",
                        "text": "str",
                        "title": "str",
                        "format": "{quantity:.1f}",
                        "kind": "Score",
                        "maximum": 0.0,
                        "minimum": 0.0,
                        "priority": "primary",
                        "unit": "str",
                        "valence": "neutral"
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_safetycases_query_scores_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            method=method,
            method_name=method_name,
            dataset=dataset,
            evaluation=evaluation,
            inference_service=inference_service,
            model=model,
            inputs=inputs,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def label(
        self,
        id: str,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing SafetyCase.

        Update labels for an existing SafetyCase.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """

    @overload
    async def label(
        self,
        id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Update labels for an existing SafetyCase.

        Update labels for an existing SafetyCase.

        :param id: Required.
        :type id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for
            binary body. Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def label(self, id: str, body: Union[JSON, IO[bytes]], **kwargs: Any) -> Any:
        """Update labels for an existing SafetyCase.

        Update labels for an existing SafetyCase.

        :param id: Required.
        :type id: str
        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "labels": {
                        "str": {}
                    },
                    "schemaVersion": "0.1"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_safetycases_label_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Any, deserialized), {})  # type: ignore

        return cast(Any, deserialized)  # type: ignore

    @distributed_trace_async
    async def query(
        self,
        *,
        query: Optional[str] = None,
        id: Optional[str] = None,
        order: Optional[str] = None,
        order_by: Optional[str] = None,
        limit: Optional[int] = None,
        account: Optional[str] = None,
        status: Optional[str] = None,
        reason: Optional[str] = None,
        labels: Optional[str] = None,
        method: Optional[str] = None,
        method_name: Optional[str] = None,
        dataset: Optional[str] = None,
        evaluation: Optional[str] = None,
        inference_service: Optional[str] = None,
        model: Optional[str] = None,
        inputs: Optional[str] = None,
        **kwargs: Any,
    ) -> List[JSON]:
        """Get all SafetyCase entities matching a query.

        Get all SafetyCase entities matching a query.

        The query is a set of equality constraints specified as key-value
        pairs.

        :keyword query: Default value is None.
        :paramtype query: str
        :keyword id: Default value is None.
        :paramtype id: str
        :keyword order: Known values are: "ascending" and "descending". Default value is None.
        :paramtype order: str
        :keyword order_by: Default value is None.
        :paramtype order_by: str
        :keyword limit: Default value is None.
        :paramtype limit: int
        :keyword account: Default value is None.
        :paramtype account: str
        :keyword status: Default value is None.
        :paramtype status: str
        :keyword reason: Default value is None.
        :paramtype reason: str
        :keyword labels: Default value is None.
        :paramtype labels: str
        :keyword method: Default value is None.
        :paramtype method: str
        :keyword method_name: Default value is None.
        :paramtype method_name: str
        :keyword dataset: Default value is None.
        :paramtype dataset: str
        :keyword evaluation: Default value is None.
        :paramtype evaluation: str
        :keyword inference_service: Default value is None.
        :paramtype inference_service: str
        :keyword model: Default value is None.
        :paramtype model: str
        :keyword inputs: Default value is None.
        :paramtype inputs: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "account": "str",
                        "creationTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "method": {
                            "account": "str",
                            "id": "str",
                            "implementation": {
                                "kind": "str",
                                "jupyterNotebook": {
                                    "notebookModule": "str",
                                    "notebookPath": "str"
                                },
                                "pythonFunction": {
                                    "fullyQualifiedName": "str"
                                },
                                "pythonRubric": {
                                    "fullyQualifiedName": "str"
                                }
                            },
                            "name": "str",
                            "output": {
                                "kind": "str",
                                "measurement": {
                                    "level": "str",
                                    "name": "str",
                                    "schema": {
                                        "arrowSchema": "str",
                                        "dyffSchema": {
                                            "components": [
                                                "str"
                                            ],
                                            "schemaVersion": "0.1"
                                        },
                                        "jsonSchema": {}
                                    },
                                    "description": "str"
                                },
                                "safetyCase": {
                                    "name": "str",
                                    "description": "str"
                                }
                            },
                            "scope": "str",
                            "description": "str",
                            "inputs": [
                                {
                                    "keyword": "str",
                                    "kind": "str",
                                    "description": "str"
                                }
                            ],
                            "modules": [
                                "str"
                            ],
                            "parameters": [
                                {
                                    "keyword": "str",
                                    "description": "str"
                                }
                            ],
                            "scores": [
                                {
                                    "name": "str",
                                    "summary": "str",
                                    "title": "str",
                                    "format": "{quantity:.1f}",
                                    "maximum": 0.0,
                                    "minimum": 0.0,
                                    "priority": "primary",
                                    "unit": "str",
                                    "valence": "neutral"
                                }
                            ]
                        },
                        "name": "str",
                        "status": "str",
                        "annotations": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "arguments": [
                            {
                                "keyword": "str",
                                "value": "str"
                            }
                        ],
                        "data": [
                            {
                                "key": "str",
                                "value": "str"
                            }
                        ],
                        "description": "str",
                        "inputs": [
                            {
                                "entity": "str",
                                "keyword": "str"
                            }
                        ],
                        "kind": "SafetyCase",
                        "labels": {
                            "str": "str"
                        },
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "metadata": {
                            "documentation": {
                                "fullPage": "str",
                                "summary": "str",
                                "title": "str"
                            },
                            "revision": "str"
                        },
                        "reason": "str",
                        "schemaVersion": "0.1",
                        "scope": {
                            "dataset": "str",
                            "evaluation": "str",
                            "inferenceService": "str",
                            "model": "str"
                        }
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_safetycases_query_request(
            query=query,
            id=id,
            order=order,
            order_by=order_by,
            limit=limit,
            account=account,
            status=status,
            reason=reason,
            labels=labels,
            method=method,
            method_name=method_name,
            dataset=dataset,
            evaluation=evaluation,
            inference_service=inference_service,
            model=model,
            inputs=inputs,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a SafetyCase.

        Create a SafetyCase.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "method": "str",
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "method": {
                        "account": "str",
                        "id": "str",
                        "implementation": {
                            "kind": "str",
                            "jupyterNotebook": {
                                "notebookModule": "str",
                                "notebookPath": "str"
                            },
                            "pythonFunction": {
                                "fullyQualifiedName": "str"
                            },
                            "pythonRubric": {
                                "fullyQualifiedName": "str"
                            }
                        },
                        "name": "str",
                        "output": {
                            "kind": "str",
                            "measurement": {
                                "level": "str",
                                "name": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "description": "str"
                            },
                            "safetyCase": {
                                "name": "str",
                                "description": "str"
                            }
                        },
                        "scope": "str",
                        "description": "str",
                        "inputs": [
                            {
                                "keyword": "str",
                                "kind": "str",
                                "description": "str"
                            }
                        ],
                        "modules": [
                            "str"
                        ],
                        "parameters": [
                            {
                                "keyword": "str",
                                "description": "str"
                            }
                        ],
                        "scores": [
                            {
                                "name": "str",
                                "summary": "str",
                                "title": "str",
                                "format": "{quantity:.1f}",
                                "maximum": 0.0,
                                "minimum": 0.0,
                                "priority": "primary",
                                "unit": "str",
                                "valence": "neutral"
                            }
                        ]
                    },
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "data": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "kind": "SafetyCase",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a SafetyCase.

        Create a SafetyCase.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "method": {
                        "account": "str",
                        "id": "str",
                        "implementation": {
                            "kind": "str",
                            "jupyterNotebook": {
                                "notebookModule": "str",
                                "notebookPath": "str"
                            },
                            "pythonFunction": {
                                "fullyQualifiedName": "str"
                            },
                            "pythonRubric": {
                                "fullyQualifiedName": "str"
                            }
                        },
                        "name": "str",
                        "output": {
                            "kind": "str",
                            "measurement": {
                                "level": "str",
                                "name": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "description": "str"
                            },
                            "safetyCase": {
                                "name": "str",
                                "description": "str"
                            }
                        },
                        "scope": "str",
                        "description": "str",
                        "inputs": [
                            {
                                "keyword": "str",
                                "kind": "str",
                                "description": "str"
                            }
                        ],
                        "modules": [
                            "str"
                        ],
                        "parameters": [
                            {
                                "keyword": "str",
                                "description": "str"
                            }
                        ],
                        "scores": [
                            {
                                "name": "str",
                                "summary": "str",
                                "title": "str",
                                "format": "{quantity:.1f}",
                                "maximum": 0.0,
                                "minimum": 0.0,
                                "priority": "primary",
                                "unit": "str",
                                "valence": "neutral"
                            }
                        ]
                    },
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "data": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "kind": "SafetyCase",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Create a SafetyCase.

        Create a SafetyCase.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "account": "str",
                    "method": "str",
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "method": {
                        "account": "str",
                        "id": "str",
                        "implementation": {
                            "kind": "str",
                            "jupyterNotebook": {
                                "notebookModule": "str",
                                "notebookPath": "str"
                            },
                            "pythonFunction": {
                                "fullyQualifiedName": "str"
                            },
                            "pythonRubric": {
                                "fullyQualifiedName": "str"
                            }
                        },
                        "name": "str",
                        "output": {
                            "kind": "str",
                            "measurement": {
                                "level": "str",
                                "name": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "description": "str"
                            },
                            "safetyCase": {
                                "name": "str",
                                "description": "str"
                            }
                        },
                        "scope": "str",
                        "description": "str",
                        "inputs": [
                            {
                                "keyword": "str",
                                "kind": "str",
                                "description": "str"
                            }
                        ],
                        "modules": [
                            "str"
                        ],
                        "parameters": [
                            {
                                "keyword": "str",
                                "description": "str"
                            }
                        ],
                        "scores": [
                            {
                                "name": "str",
                                "summary": "str",
                                "title": "str",
                                "format": "{quantity:.1f}",
                                "maximum": 0.0,
                                "minimum": 0.0,
                                "priority": "primary",
                                "unit": "str",
                                "valence": "neutral"
                            }
                        ]
                    },
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "data": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "kind": "SafetyCase",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_safetycases_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a SafetyCase by its key.

        Get a SafetyCase by its key.

        Raises a 404 error if no entity exists with that key.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": "str",
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "method": {
                        "account": "str",
                        "id": "str",
                        "implementation": {
                            "kind": "str",
                            "jupyterNotebook": {
                                "notebookModule": "str",
                                "notebookPath": "str"
                            },
                            "pythonFunction": {
                                "fullyQualifiedName": "str"
                            },
                            "pythonRubric": {
                                "fullyQualifiedName": "str"
                            }
                        },
                        "name": "str",
                        "output": {
                            "kind": "str",
                            "measurement": {
                                "level": "str",
                                "name": "str",
                                "schema": {
                                    "arrowSchema": "str",
                                    "dyffSchema": {
                                        "components": [
                                            "str"
                                        ],
                                        "schemaVersion": "0.1"
                                    },
                                    "jsonSchema": {}
                                },
                                "description": "str"
                            },
                            "safetyCase": {
                                "name": "str",
                                "description": "str"
                            }
                        },
                        "scope": "str",
                        "description": "str",
                        "inputs": [
                            {
                                "keyword": "str",
                                "kind": "str",
                                "description": "str"
                            }
                        ],
                        "modules": [
                            "str"
                        ],
                        "parameters": [
                            {
                                "keyword": "str",
                                "description": "str"
                            }
                        ],
                        "scores": [
                            {
                                "name": "str",
                                "summary": "str",
                                "title": "str",
                                "format": "{quantity:.1f}",
                                "maximum": 0.0,
                                "minimum": 0.0,
                                "priority": "primary",
                                "unit": "str",
                                "valence": "neutral"
                            }
                        ]
                    },
                    "name": "str",
                    "status": "str",
                    "annotations": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "arguments": [
                        {
                            "keyword": "str",
                            "value": "str"
                        }
                    ],
                    "data": [
                        {
                            "key": "str",
                            "value": "str"
                        }
                    ],
                    "description": "str",
                    "inputs": [
                        {
                            "entity": "str",
                            "keyword": "str"
                        }
                    ],
                    "kind": "SafetyCase",
                    "labels": {
                        "str": "str"
                    },
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "metadata": {
                        "documentation": {
                            "fullPage": "str",
                            "summary": "str",
                            "title": "str"
                        },
                        "revision": "str"
                    },
                    "reason": "str",
                    "schemaVersion": "0.1",
                    "scope": {
                        "dataset": "str",
                        "evaluation": "str",
                        "inferenceService": "str",
                        "model": "str"
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_safetycases_get_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete(self, id: str, **kwargs: Any) -> JSON:
        """Mark a SafetyCase for deletion.

        Mark a SafetyCase for deletion.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "status": "str",
                    "reason": "str"
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_safetycases_delete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def downlinks(self, id: str, **kwargs: Any) -> List[JSON]:
        """Get a list of signed GET URLs from which safety case artifacts can be
        downloaded.

        Get a list of signed GET URLs from which safety case artifacts can be downloaded.

        :param id: Required.
        :type id: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "artifact": {
                            "path": "str",
                            "digest": {
                                "md5": "str"
                            },
                            "kind": "str"
                        },
                        "signedURL": {
                            "method": "str",
                            "url": "str",
                            "headers": {
                                "str": "str"
                            }
                        }
                    }
                ]
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_safetycases_downlinks_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace_async
    async def logs(self, id: str, **kwargs: Any) -> JSON:
        """Get a signed GET URL from which the logs file for the safety case run can be
        downloaded.

        Get a signed GET URL from which the logs file for the safety case run can be downloaded.

        :param id: Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "artifact": {
                        "path": "str",
                        "digest": {
                            "md5": "str"
                        },
                        "kind": "str"
                    },
                    "signedURL": {
                        "method": "str",
                        "url": "str",
                        "headers": {
                            "str": "str"
                        }
                    }
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_safetycases_logs_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore
