from abc import ABC, abstractmethod


class LoggerBase(ABC):
    @abstractmethod
    def __init__(self, trigger_id: str): pass

    @abstractmethod
    def log(self, log: str): pass

    def __enter__(self):
        return self

    @abstractmethod
    def __exit__(self, exc_type, exc_val, exc_tb): pass


class MockLogger(LoggerBase):
    def __init__(self, *args, **kwargs): pass

    def log(self, *args, **kwargs): pass

    def __enter__(self): return self

    def __exit__(self, exc_type, exc_val, exc_tb): pass



