import time
import datetime
from dataclasses import dataclass, field, asdict
from abc import ABC, abstractmethod


@dataclass
class Trigger:
    id: str
    cronevent_id: str
    pid: str
    module: str
    func: str
    args: str
    kwargs: str
    utc_time: datetime.datetime = field(default_factory=lambda: datetime.datetime.fromtimestamp(time.time(), tz=datetime.timezone.utc))

    def to_row(self):
        return asdict(self)


class TriggerDbBase(ABC):
    table_name: str = 'cronevents_triggers'

    @abstractmethod
    def insert(self, trigger: Trigger):
        pass

    @abstractmethod
    def upsert(self, trigger: Trigger):
        pass







