from cronevents.db.triggers.base import Trigger, TriggerDbBase
from cronevents.db.postgres import get_postgres_from_env, Postgres


class PostgresTriggerDb(TriggerDbBase):
    def __init__(self):
        self.db: Postgres = get_postgres_from_env()

    def insert(self, trigger: Trigger):
        self.upsert(trigger)

    def upsert(self, trigger: Trigger):
        self.db.upload_table(self.table_name, [trigger.to_row()], id_column='id')







