from cronevents.db.triggers.base import Trigger, TriggerDbBase
from cronevents.db.sqlite import Sqlite3


class Sqlite3TriggerDb(TriggerDbBase):
    def __init__(self):
        self.db: Sqlite3 = Sqlite3()

    def insert(self, trigger: Trigger):
        self.upsert(trigger)

    def upsert(self, trigger: Trigger):
        self.db.upload_table(self.table_name, [trigger.to_row()], id_column='id')

    def list(self) -> list[Trigger]:
        return [Trigger(**row) for row in self.db.download_table(self.table_name)]






