/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions;

import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.CompoundState;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.functions.transformation.joint.Identity;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.List;
import java.util.logging.Logger;

public interface ActivationFcn {
    public static final Logger LOG = Logger.getLogger(ActivationFcn.class.getName());

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    public ActivationFcn replaceWithSingleton();

    public State getState(boolean var1);

    default public Pair<Double, Double> getSaturationRange() {
        return null;
    }

    default public boolean isComplex() {
        return false;
    }

    public static class SimpleValueState
    implements State {
        protected Value embedding;
        Value currentGradient;

        public SimpleValueState(Value embedding) {
            this.embedding = embedding;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public Value evaluate() {
            LOG.warning("Calling evaluate on SimpleValueState");
            return this.embedding;
        }

        @Override
        public Value initEval(List<Value> inputValues) {
            if (inputValues.size() != 1) {
                LOG.severe("Setting up SimpleValueState with more than one Value.");
            }
            this.embedding = inputValues.get(0);
            return this.embedding;
        }

        @Override
        public void cumulate(Value value) {
        }

        @Override
        public void ingestTopGradient(Value topGradient) {
            this.currentGradient = topGradient;
        }

        @Override
        public Value nextInputGradient() {
            return this.currentGradient;
        }

        @Override
        public Combination getCombination() {
            return null;
        }

        @Override
        public Transformation getTransformation() {
            return null;
        }

        @Override
        public State changeTransformationState(Transformation transformation) {
            return this;
        }
    }

    public static interface State
    extends Exportable {
        public void invalidate();

        public Value evaluate();

        public Value initEval(List<Value> var1);

        public void cumulate(Value var1);

        public void ingestTopGradient(Value var1);

        public Value nextInputGradient();

        default public int[] getInputMask() {
            return null;
        }

        public Combination getCombination();

        public Transformation getTransformation();

        public State changeTransformationState(Transformation var1);

        public static State getState(Combination combination, Transformation transformation) {
            if (combination == null && transformation == null) {
                LOG.severe("Trying to create a fcn state with no combination or transformation fcn");
                return null;
            }
            if (combination == null) {
                return transformation.getState(true);
            }
            if (transformation == null || transformation instanceof Identity) {
                return combination.getState(false);
            }
            State combinationState = combination.getState(false);
            State transformationState = transformation.getState(true);
            return new CompoundState((Combination.State)combinationState, (Transformation.State)transformationState);
        }

        public static State getState(State fcnState, List<Value> inputValues) {
            if (inputValues.size() == 0) {
                LOG.severe("No neuron input values collected at initialization, cannot infer the State update.");
            }
            State transformationState = fcnState;
            if (inputValues.size() == 1 && !(fcnState instanceof Transformation.State)) {
                Transformation transformation = fcnState.getTransformation();
                Combination combination = fcnState.getCombination();
                if (transformation == null) {
                    transformationState = combination.singleInputVersion().getState(true);
                } else if (combination.singleInputVersion() instanceof Identity) {
                    transformationState = transformation.getState(true);
                } else {
                    return fcnState;
                }
            }
            return transformationState;
        }
    }
}

