/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions;

import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.functions.aggregation.Average;
import cz.cvut.fel.ida.algebra.functions.aggregation.Count;
import cz.cvut.fel.ida.algebra.functions.aggregation.Maximum;
import cz.cvut.fel.ida.algebra.functions.aggregation.Minimum;
import cz.cvut.fel.ida.algebra.functions.aggregation.Sum;
import cz.cvut.fel.ida.algebra.functions.combination.Concatenation;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.setup.Settings;
import java.util.List;
import java.util.logging.Logger;

public interface Aggregation
extends Combination,
Transformation {
    public static final Logger LOG = Logger.getLogger(Aggregation.class.getName());

    @Override
    default public boolean isPermutationInvariant() {
        return true;
    }

    default public boolean isSplittable() {
        return false;
    }

    default public int[] aggregableTerms() {
        return null;
    }

    public Value differentiate(List<Value> var1);

    public static Aggregation getFunction(Settings.CombinationFcn aggregationFcn) {
        switch (aggregationFcn) {
            case AVG: {
                return Singletons.average;
            }
            case MAX: {
                return Singletons.maximum;
            }
            case MIN: {
                return Singletons.minimum;
            }
            case SUM: {
                return Singletons.sum;
            }
            case COUNT: {
                return Singletons.count;
            }
            case CONCAT: {
                return Singletons.concat;
            }
        }
        return null;
    }

    public static abstract class State
    extends Combination.State {
        protected Value combinedInputs;
        protected Value processedGradient;

        public State(Combination combination) {
            super(combination);
        }

        @Override
        public Value initEval(List<Value> values) {
            this.combinedInputs = this.combination.evaluate(values);
            return this.combinedInputs;
        }
    }

    public static class Singletons {
        public static Average average = new Average();
        public static Maximum maximum = new Maximum();
        public static Minimum minimum = new Minimum();
        public static Sum sum = new Sum();
        public static Count count = new Count();
        public static Concatenation concat = new Concatenation();
    }
}

