/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions;

import cz.cvut.fel.ida.algebra.functions.ActivationFcn;
import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.functions.combination.Concatenation;
import cz.cvut.fel.ida.algebra.functions.combination.CosineSim;
import cz.cvut.fel.ida.algebra.functions.combination.CrossSum;
import cz.cvut.fel.ida.algebra.functions.combination.ElementProduct;
import cz.cvut.fel.ida.algebra.functions.combination.Product;
import cz.cvut.fel.ida.algebra.functions.combination.Softmax;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public interface Combination
extends ActivationFcn,
Exportable {
    public static final Logger LOG = Logger.getLogger(Combination.class.getName());

    public Value evaluate(List<Value> var1);

    public boolean isPermutationInvariant();

    default public Transformation singleInputVersion() {
        return Transformation.Singletons.identity;
    }

    public static Combination getFunction(Settings.CombinationFcn combinationFcn) {
        Aggregation function = Aggregation.getFunction(combinationFcn);
        if (function != null) {
            return function;
        }
        switch (combinationFcn) {
            case PRODUCT: {
                return Singletons.product;
            }
            case ELPRODUCT: {
                return Singletons.elementProduct;
            }
            case SOFTMAX: {
                return Transformation.Singletons.softmax;
            }
            case SPARSEMAX: {
                return Transformation.Singletons.sparsemax;
            }
            case CROSSSUM: {
                return Singletons.crossSum;
            }
            case CONCAT: {
                return Singletons.concatenation;
            }
            case COSSIM: {
                return Singletons.cosineSim;
            }
        }
        LOG.severe("Unimplemented combination function");
        return null;
    }

    public static abstract class InputArrayState
    extends State {
        protected Value processedGradient;
        protected ArrayList<Value> accumulatedInputs;
        protected int i;

        public InputArrayState(Combination combination) {
            super(combination);
        }

        @Override
        public void cumulate(Value value) {
            this.accumulatedInputs.add(value);
        }

        @Override
        public void invalidate() {
            this.accumulatedInputs.clear();
            this.i = 0;
        }

        @Override
        public Value initEval(List<Value> values) {
            this.accumulatedInputs = (ArrayList)values;
            this.accumulatedInputs.trimToSize();
            this.i = 0;
            return this.evaluate();
        }
    }

    public static abstract class State
    implements ActivationFcn.State {
        protected Combination combination;

        public State(Combination combination) {
            this.combination = combination;
        }

        @Override
        public Combination getCombination() {
            return this.combination;
        }

        @Override
        public Transformation getTransformation() {
            return null;
        }

        @Override
        public ActivationFcn.State changeTransformationState(Transformation transformation) {
            return this;
        }
    }

    public static class Singletons {
        public static Product product = new Product();
        public static ElementProduct elementProduct = new ElementProduct();
        public static CrossSum crossSum = new CrossSum();
        public static Concatenation concatenation = new Concatenation();
        public static CosineSim cosineSim = new CosineSim();
        public static Softmax softmax = new Softmax();
    }
}

