/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions;

import cz.cvut.fel.ida.algebra.functions.ActivationFcn;
import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.functions.transformation.joint.Identity;
import cz.cvut.fel.ida.algebra.values.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class CompoundState
implements ActivationFcn.State {
    private static final Logger LOG = Logger.getLogger(CompoundState.class.getName());
    @NotNull
    private final Combination.State combinationState;
    @NotNull
    private Transformation.State transformationState;

    public CompoundState(Combination.State combinationState, Transformation.State transformationState) {
        this.combinationState = combinationState;
        this.transformationState = transformationState;
    }

    @Override
    public void invalidate() {
        this.combinationState.invalidate();
        this.transformationState.invalidate();
    }

    @Override
    public Value initEval(List<Value> values) {
        Value value = this.combinationState.initEval(values);
        ArrayList<Value> vals = new ArrayList<Value>(1);
        vals.add(value);
        return this.transformationState.initEval(vals);
    }

    @Override
    public Value evaluate() {
        Value evaluate = this.combinationState.evaluate();
        this.transformationState.cumulate(evaluate);
        return this.transformationState.evaluate();
    }

    @Override
    public void cumulate(Value value) {
        this.combinationState.cumulate(value);
    }

    @Override
    public void ingestTopGradient(Value topGradient) {
        this.transformationState.ingestTopGradient(topGradient);
        Value transformationGradient = this.transformationState.nextInputGradient();
        this.combinationState.ingestTopGradient(transformationGradient);
    }

    @Override
    public Value nextInputGradient() {
        return this.combinationState.nextInputGradient();
    }

    @Override
    public int[] getInputMask() {
        return this.combinationState.getInputMask();
    }

    @Override
    public Combination getCombination() {
        return this.combinationState.getCombination();
    }

    @Override
    public Transformation getTransformation() {
        return this.transformationState.getTransformation();
    }

    @Override
    public ActivationFcn.State changeTransformationState(Transformation transformation) {
        if (transformation.getClass().equals(this.transformationState.transformation.getClass())) {
            return this;
        }
        if (transformation instanceof Identity) {
            return this.combinationState;
        }
        this.transformationState = (Transformation.State)transformation.getState(true);
        return this;
    }
}

