/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.aggregation;

import cz.cvut.fel.ida.algebra.functions.ActivationFcn;
import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.Value;
import java.util.List;
import java.util.logging.Logger;

public class Count
implements Aggregation {
    private static final Logger LOG = Logger.getLogger(Count.class.getName());

    @Override
    public Count replaceWithSingleton() {
        return Aggregation.Singletons.count;
    }

    @Override
    public Value evaluate(List<Value> inputs) {
        return new ScalarValue(inputs.size());
    }

    @Override
    public Value differentiate(List<Value> inputs) {
        LOG.warning("Propagating gradient through a COUNT fcn");
        return Value.ZERO;
    }

    @Override
    public Value evaluate(Value combinedInputs) {
        int len = 1;
        for (int i : combinedInputs.size()) {
            len *= i;
        }
        return new ScalarValue(len);
    }

    @Override
    public Value differentiate(Value summedInputs) {
        LOG.warning("Propagating gradient through a SIZE fcn");
        return Value.ZERO;
    }

    @Override
    public Transformation singleInputVersion() {
        return Transformation.Singletons.constantOne;
    }

    @Override
    public ActivationFcn.State getState(boolean singleInput) {
        if (singleInput) {
            return new TransformationState(Aggregation.Singletons.count);
        }
        return new AggregationState(Aggregation.Singletons.count);
    }

    public static class TransformationState
    extends Transformation.State {
        public TransformationState(Transformation transformation) {
            super(transformation);
        }

        @Override
        public void ingestTopGradient(Value topGradient) {
            this.processedGradient = Value.ZERO;
        }
    }

    public static class AggregationState
    extends Combination.State {
        int count = 0;

        public AggregationState(Combination combination) {
            super(combination);
        }

        @Override
        public void cumulate(Value value) {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public Value evaluate() {
            return new ScalarValue(this.count);
        }

        @Override
        public Value initEval(List<Value> inputValues) {
            this.count = inputValues.size();
            return this.evaluate();
        }

        @Override
        public void ingestTopGradient(Value topGradient) {
        }

        @Override
        public Value nextInputGradient() {
            return Value.ZERO;
        }
    }
}

