/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.aggregation;

import cz.cvut.fel.ida.algebra.functions.ActivationFcn;
import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.functions.Combination;
import cz.cvut.fel.ida.algebra.functions.Transformation;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.List;
import java.util.logging.Logger;

public class Maximum
implements Aggregation {
    private static final Logger LOG = Logger.getLogger(Maximum.class.getName());

    @Override
    public Maximum replaceWithSingleton() {
        return Aggregation.Singletons.maximum;
    }

    @Override
    public Value evaluate(List<Value> inputs) {
        Value max = inputs.get(0);
        for (int i = 1; i < inputs.size(); ++i) {
            Value value = inputs.get(i);
            if (!value.greaterThan(max)) continue;
            max = value;
        }
        return max;
    }

    @Override
    public Value differentiate(List<Value> inputs) {
        return Value.ONE;
    }

    @Override
    public Value evaluate(Value combinedInputs) {
        if (combinedInputs instanceof VectorValue) {
            double[] maxValue = (double[])this.getMaxValue((double[])((VectorValue)combinedInputs).values).s;
            return new VectorValue(maxValue);
        }
        LOG.severe("Cannot calculate Max from other than VectorValue");
        return null;
    }

    @Override
    public Value differentiate(Value combinedInputs) {
        Value oneHot = this.evaluate(combinedInputs).apply(x -> x > 0.0 ? 1.0 : 0.0);
        return oneHot;
    }

    public Pair<Integer, double[]> getMaxValue(double[] input) {
        double max = Double.MIN_VALUE;
        int max_index = -1;
        for (int i = 0; i < input.length; ++i) {
            if (!(input[i] > max)) continue;
            max = input[i];
            max_index = i;
        }
        double[] result = new double[input.length];
        result[max_index] = max;
        return new Pair<Integer, double[]>(max_index, result);
    }

    @Override
    public boolean isPermutationInvariant() {
        return true;
    }

    @Override
    public ActivationFcn.State getState(boolean singleInput) {
        if (singleInput) {
            return new TransformationState(Aggregation.Singletons.maximum);
        }
        return new AggregationState(Aggregation.Singletons.maximum);
    }

    public static class TransformationState
    extends Transformation.State {
        int maxIndex;

        public TransformationState(Transformation transformation) {
            super(transformation);
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.maxIndex = -1;
        }

        @Override
        public Value evaluate() {
            VectorValue inputVector = (VectorValue)this.input;
            Pair<Integer, double[]> maxValue = Aggregation.Singletons.maximum.getMaxValue(inputVector.values);
            this.maxIndex = (Integer)maxValue.r;
            return new VectorValue((double[])maxValue.s, inputVector.rowOrientation);
        }

        @Override
        public void ingestTopGradient(Value topGradient) {
            VectorValue gradient = ((VectorValue)this.input).getForm();
            gradient.set(this.maxIndex, topGradient.get(this.maxIndex));
            this.processedGradient = gradient;
        }
    }

    public static class AggregationState
    extends Aggregation.State {
        int maxIndex = -1;
        int currentIndex = 0;

        public AggregationState(Combination combination) {
            super(combination);
        }

        @Override
        public void cumulate(Value value) {
            if (this.combinedInputs == null || value.greaterThan(this.combinedInputs)) {
                this.combinedInputs = value;
                this.maxIndex = this.currentIndex;
            }
            ++this.currentIndex;
        }

        @Override
        public Value evaluate() {
            return this.combinedInputs;
        }

        @Override
        public void invalidate() {
            this.maxIndex = -1;
            this.currentIndex = 0;
            this.combinedInputs = null;
        }

        @Override
        public int[] getInputMask() {
            int[] inputs = new int[]{this.maxIndex};
            return inputs;
        }

        @Override
        public void ingestTopGradient(Value topGradient) {
            this.currentIndex = 0;
            this.processedGradient = topGradient;
        }

        @Override
        public Value nextInputGradient() {
            if (this.maxIndex == this.currentIndex++) {
                return this.processedGradient;
            }
            return Value.ZERO;
        }
    }
}

